package com.bizunited.platform.kuiper.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.user.common.vo.UserVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.Date;

/**
 * 数据迁移的导出导入
 * @author: yanwe
 * @date: 03/Sep/2019 14:33
 */
@ApiModel("迁入文件保存实体")
@Entity
@Table(name = "engine_form_migrate_import")
@org.hibernate.annotations.Table(appliesTo = "engine_form_migrate_import", comment = "核心模块数据的导出导入")
public class MigrateImportEntity extends UuidEntity {

  private static final long serialVersionUID = -4554392176318022485L;

  /**
   * 数据类型：1:编码规则，2：数据视图，3：全局参数，4：数据字典，5：远端服务源，6：表单模版，7：列表模版，8：全局函数
   */
  @Column(name = "data_type", nullable = false, columnDefinition = "int(11) COMMENT '1:编码规则，2：数据视图，3：全局参数，" +
      "4：数据字典，5：远端服务源，6：表单模版，7：列表模版，8：全局函数'")
  @ApiModelProperty("数据类型：1:编码规则，2：数据视图，3：全局参数，4：数据字典，5：远端服务源，6：表单模版，7：列表模版，8：全局函数")
  @SaturnColumn(description = "数据类型：1:编码规则，2：数据视图，3：全局参数，4：数据字典，5：远端服务源，6：表单模版，7：列表模版，8：全局函数")
  private Integer dataType;

  /** 文件在本地存储路径 */
  @Column(name = "relative_local", length = 255, nullable = false, columnDefinition = "varchar(255) COMMENT '文件在本地存储路径'")
  @ApiModelProperty(name = "relativeLocal", value = "文件在本地存储路径", required = true)
  @SaturnColumn(description = "文件在本地存储路径")
  private String relativeLocal;

  /** 重命名后的文件名字 */
  @ApiModelProperty(name = "fileName", value = "重命名后的文件名字", required = true)
  @Column(name = "file_name", nullable = false, unique = true, columnDefinition = "varchar(255) COMMENT '重命名后的文件名字'")
  @SaturnColumn(description = "重命名后的文件名字")
  private String fileName;

  /** 上传文件原名 */
  @Column(name = "original_file_name", length = 255, columnDefinition = "varchar(255) COMMENT '上传文件原名'")
  @ApiModelProperty(name = "originalFileName", value = "上传文件原名")
  @SaturnColumn(description = "上传文件原名")
  private String originalFileName;

  /** 上传人 */
  @Column(name = "creator", nullable = false, columnDefinition = "varchar(255) COMMENT '上传人'")
  @ApiModelProperty(name = "creator", value = "上传人", required = true)
  @SaturnColumn(description = "上传人")
  private String creator;

  /**
   * 上传人
   */
  @Transient
  @ApiModelProperty(name = "creator", value = "上传人", required = true)
  @SaturnColumn(description = "上传人")
  private UserVo createUser;

  /** 上传时间 */
  @Column(name = "create_time", nullable = false, columnDefinition = "datetime COMMENT '上传时间'")
  @ApiModelProperty(name = "createTime", value = "上传时间", required = true)
  @SaturnColumn(description = "上传时间")
  private Date createTime;

  /** 本次任务是否最终执行,true:已执行，false：未执行 */
  @Column(name = "executed", nullable = false, columnDefinition = "bit(1) COMMENT '本次任务是否最终执行,true:已执行，false：未执行'")
  @ApiModelProperty(name = "executed", value = "本次任务是否最终执行,true:已执行，false：未执行", required = true)
  @SaturnColumn(description = "本次任务是否最终执行,true:已执行，false：未执行")
  private Boolean executed;

  /** 任务执行人 */
  @Column(name = "executor", columnDefinition = "varchar(255) COMMENT '任务执行人'")
  @ApiModelProperty(name = "executor", value = "任务执行人")
  @SaturnColumn(description = "任务执行人")
  private String executor;

  /**
   * 任务执行人
   */
  @Transient
  @ApiModelProperty(name = "executor", value = "任务执行人")
  @SaturnColumn(description = "任务执行人")
  private UserVo executeUser;

  /** 执行时间 */
  @Column(name = "execute_time", columnDefinition = "datetime COMMENT '执行时间'")
  @ApiModelProperty(name = "executeTime", value = "执行时间")
  @SaturnColumn(description = "执行时间")
  private Date executeTime;

  /**
   * 执行结果，1：成功，0：失败
   */
  @ApiModelProperty("执行结果，1：成功，0：失败")
  @SaturnColumn(description = "执行结果，1：成功，0：失败")
  @Column(name = "execute_result", columnDefinition = "int(11) COMMENT '执行结果，1：成功，0：失败'")
  private Integer executeResult;

  /**
   * 导入明细
   */
  @OneToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "detail_id", columnDefinition = "varchar(255) COMMENT '导入明细'")
  @SaturnColumn(description = "导入明细")
  private MigrateImportDetailEntity detail;

  /**
   * 可能的项目名，不填写也行，毕竟目前来看只可能是一个项目
   */
  @ApiModelProperty(name="projectName" , value="项目名，不填写也行，毕竟目前来看只可能是一个项目" , required=false)
  @Column(name="project_name" ,  nullable=true)
  @SaturnColumn(description="项目名")
  private String projectName;

  public String getProjectName() {
    return projectName;
  }

  public void setProjectName(String projectName) {
    this.projectName = projectName;
  }

  public String getRelativeLocal() {
    return relativeLocal;
  }

  public void setRelativeLocal(String relativeLocal) {
    this.relativeLocal = relativeLocal;
  }

  public String getFileName() {
    return fileName;
  }

  public void setFileName(String fileName) {
    this.fileName = fileName;
  }

  public String getOriginalFileName() {
    return originalFileName;
  }

  public void setOriginalFileName(String originalFileName) {
    this.originalFileName = originalFileName;
  }


  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public Boolean getExecuted() {
    return executed;
  }

  public void setExecuted(Boolean executed) {
    this.executed = executed;
  }

  public String getCreator() {
    return creator;
  }

  public void setCreator(String creator) {
    this.creator = creator;
  }

  public String getExecutor() {
    return executor;
  }

  public void setExecutor(String executor) {
    this.executor = executor;
  }

  public Date getExecuteTime() {
    return executeTime;
  }

  public void setExecuteTime(Date executeTime) {
    this.executeTime = executeTime;
  }

  public Integer getDataType() {
    return dataType;
  }

  public void setDataType(Integer dataType) {
    this.dataType = dataType;
  }

  public UserVo getCreateUser() {
    return createUser;
  }

  public void setCreateUser(UserVo createUser) {
    this.createUser = createUser;
  }

  public UserVo getExecuteUser() {
    return executeUser;
  }

  public void setExecuteUser(UserVo executeUser) {
    this.executeUser = executeUser;
  }

  public MigrateImportDetailEntity getDetail() {
    return detail;
  }

  public void setDetail(MigrateImportDetailEntity detail) {
    this.detail = detail;
  }

  public Integer getExecuteResult() {
    return executeResult;
  }

  public void setExecuteResult(Integer executeResult) {
    this.executeResult = executeResult;
  }

}
