package com.bizunited.platform.kuiper.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import java.util.Set;

/**
 * 页面流页面数据层描述
 * @Author: Paul Chan
 * @Date: 2019-12-31 09:47
 */
@Entity
@ApiModel(value = "PageEntity" , description="页面流页面数据层描述")
@org.hibernate.annotations.Table(appliesTo = "engine_form_page" , comment = "页面流页面数据层描述")
@Table(name="engine_form_page", uniqueConstraints = {@UniqueConstraint(columnNames = {"page_flow_id", "code"})})
public class PageEntity extends UuidEntity {
  private static final long serialVersionUID = 2085952860857325509L;

  /**
   * 页面流实体描述
   */
  @ManyToOne(fetch = FetchType.LAZY)
  @SaturnColumn(description = "页面流实体描述")
  @ApiModelProperty(value = "页面流实体描述", required = true)
  @JoinColumn(name = "page_flow_id", nullable = false, columnDefinition = "varchar(255) COMMENT '页面流实体描述ID'")
  private PageFlowEntity pageFlow;

  /**
   * 页面流页面名称
   */
  @SaturnColumn(description = "页面流页面名称")
  @ApiModelProperty(value = "页面流页面名称", required = true)
  @Column(name = "name", nullable = false, columnDefinition = "varchar(255) COMMENT '页面流页面名称'")
  private String name;

  /**
   * 页面流页面编码
   */
  @SaturnColumn(description = "页面流页面编码")
  @ApiModelProperty(value = "页面流页面编码", required = true)
  @Column(name = "code", nullable = false, columnDefinition = "varchar(255) COMMENT '页面流页面编码'")
  private String code;

  /**
   * 页面流文件的相对目录
   */
  @ApiModelProperty(value = "页面流文件的相对目录", required = true)
  @Column(name = "relative_path", nullable = false, columnDefinition = "varchar(255) COMMENT '页面流文件的相对目录'")
  @SaturnColumn(description = "页面流文件的相对目录")
  private String relativePath;

  /**
   * 保存的页面流文件文件名
   */
  @ApiModelProperty(value = "保存的页面流文件文件名", required = true)
  @Column(name = "file_Name", nullable = false, columnDefinition = "varchar(255) COMMENT '保存的页面流文件文件名'")
  @SaturnColumn(description = "保存的页面流文件文件名")
  private String fileName;

  /**
   * 事件
   */
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "page")
  @ApiModelProperty("事件")
  @SaturnColumn(description = "事件")
  private Set<PageEventEntity> events;

  /**
   * 页面流页面文件内容
   */
  @Transient
  private String pageContent;
  /**
   * 当前项目名工程名
   */
  @ApiModelProperty("当前项目名工程名")
  @Column(name="project_name", nullable = false, columnDefinition = "varchar(255) default '' comment '工程名'")
  @SaturnColumn(description = "工程名")
  private String projectName;

  public String getProjectName() {
    return projectName;
  }

  public void setProjectName(String projectName) {
    this.projectName = projectName;
  }

  public PageFlowEntity getPageFlow() {
    return pageFlow;
  }

  public void setPageFlow(PageFlowEntity pageFlow) {
    this.pageFlow = pageFlow;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public String getRelativePath() {
    return relativePath;
  }

  public void setRelativePath(String relativePath) {
    this.relativePath = relativePath;
  }

  public String getFileName() {
    return fileName;
  }

  public void setFileName(String fileName) {
    this.fileName = fileName;
  }

  public String getPageContent() {
    return pageContent;
  }

  public void setPageContent(String pageContent) {
    this.pageContent = pageContent;
  }

  public Set<PageEventEntity> getEvents() {
    return events;
  }

  public void setEvents(Set<PageEventEntity> events) {
    this.events = events;
  }
}
