package com.bizunited.platform.kuiper.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;

/**
 * 页面事件数据层描述
 * @Author: Paul Chan
 * @Date: 2019-12-31 10:12
 */
@Entity
@ApiModel(value = "PageEventEntity" , description="页面事件数据层描述")
@org.hibernate.annotations.Table(appliesTo = "engine_form_page_event" , comment = "页面事件数据层描述")
@Table(name="engine_form_page_event", uniqueConstraints = {@UniqueConstraint(columnNames = {"page_id", "event_id"})})
public class PageEventEntity extends UuidEntity {
  private static final long serialVersionUID = 1569884525135838552L;

  /**
   * 页面流页面数据层描述
   */
  @ManyToOne(fetch = FetchType.LAZY)
  @SaturnColumn(description = "页面流页面数据层描述")
  @ApiModelProperty(value = "页面流页面数据层描述", required = true)
  @JoinColumn(name = "page_id", nullable = false, columnDefinition = "varchar(255) COMMENT '页面流页面数据层描述ID'")
  private PageEntity page;

  /**
   * 页面事件ID
   */
  @SaturnColumn(description = "页面事件ID")
  @ApiModelProperty(value = "页面事件ID", required = true)
  @Column(name = "event_id", nullable = false, columnDefinition = "varchar(255) COMMENT '页面事件ID'")
  private String eventId;

  /**
   * 页面流文件的相对目录
   */
  @ApiModelProperty(value = "页面流文件的相对目录", required = true)
  @Column(name = "relative_path", nullable = false, columnDefinition = "varchar(255) COMMENT '页面流文件的相对目录'")
  @SaturnColumn(description = "页面流文件的相对目录")
  private String relativePath;

  /**
   * 保存的页面流文件文件名
   */
  @ApiModelProperty(value = "保存的页面流文件文件名", required = true)
  @Column(name = "file_Name", nullable = false, columnDefinition = "varchar(255) COMMENT '保存的页面流文件文件名'")
  @SaturnColumn(description = "保存的页面流文件文件名")
  private String fileName;

  /**
   * 页面事件文件内容
   */
  @Transient
  private String eventContent;

  /**
   * 当前项目名工程名
   */
  @ApiModelProperty("当前项目名工程名")
  @Column(name="project_name", nullable = false, columnDefinition = "varchar(255) default '' comment '工程名'")
  @SaturnColumn(description = "工程名")
  private String projectName;

  public String getProjectName() {
    return projectName;
  }

  public void setProjectName(String projectName) {
    this.projectName = projectName;
  }

  public PageEntity getPage() {
    return page;
  }

  public void setPage(PageEntity page) {
    this.page = page;
  }

  public String getEventId() {
    return eventId;
  }

  public void setEventId(String eventId) {
    this.eventId = eventId;
  }

  public String getRelativePath() {
    return relativePath;
  }

  public void setRelativePath(String relativePath) {
    this.relativePath = relativePath;
  }

  public String getFileName() {
    return fileName;
  }

  public void setFileName(String fileName) {
    this.fileName = fileName;
  }

  public String getEventContent() {
    return eventContent;
  }

  public void setEventContent(String eventContent) {
    this.eventContent = eventContent;
  }
}
