package com.bizunited.platform.kuiper.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.user.common.vo.UserVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.Date;
import java.util.Set;

/**
 * 页面流实体描述
 * @Author: Paul Chan
 * @Date: 2019-12-30 16:48
 */
@Entity
@Table(name="engine_form_page_flow")
@ApiModel(value = "PageFlowEntity" , description="页面流实体描述")
@org.hibernate.annotations.Table(appliesTo = "engine_form_page_flow" , comment = "页面流实体描述")
public class PageFlowEntity extends UuidEntity {
  private static final long serialVersionUID = 716301443067890015L;

  /**
   * 页面流名称
   */
  @SaturnColumn(description = "页面流名称")
  @ApiModelProperty(value = "页面流名称", required = true)
  @Column(name = "name", nullable = false, unique = true, columnDefinition = "varchar(255) COMMENT '页面流名称'")
  private String name;

  /**
   * 页面流编码
   */
  @SaturnColumn(description = "页面流编码")
  @ApiModelProperty(value = "页面流编码", required = true)
  @Column(name = "code", nullable = false, unique = true, columnDefinition = "varchar(255) COMMENT '页面流编码'")
  private String code;

  /**
   * 页面流说明
   */
  @SaturnColumn(description = "页面流说明")
  @ApiModelProperty(value = "页面流说明")
  @Column(name = "comment", columnDefinition = "varchar(255) COMMENT '页面流说明'")
  private String comment;

  /**
   * 页面数
   */
  @SaturnColumn(description = "页面数")
  @ApiModelProperty(value = "页面数")
  @Column(name = "page_count", nullable = false, columnDefinition = "int(11) COMMENT '页面数'")
  private Integer pageCount;

  /**
   * 规则连线数
   */
  @SaturnColumn(description = "规则连线数")
  @ApiModelProperty(value = "规则连线数")
  @Column(name = "line_count", nullable = false, columnDefinition = "int(11) COMMENT '规则连线数'")
  private Integer lineCount;

  /**
   * 页面流文件的相对目录
   */
  @ApiModelProperty(value = "页面流文件的相对目录", required = true)
  @Column(name = "relative_path", nullable = false, columnDefinition = "varchar(255) COMMENT '页面流文件的相对目录'")
  @SaturnColumn(description = "页面流文件的相对目录")
  private String relativePath;

  /**
   * 保存的页面流文件文件名
   */
  @ApiModelProperty(value = "保存的页面流文件文件名", required = true)
  @Column(name = "file_Name", nullable = false, columnDefinition = "varchar(255) COMMENT '保存的页面流文件文件名'")
  @SaturnColumn(description = "保存的页面流文件文件名")
  private String fileName;

  /**
   * 创建人
   */
  @ApiModelProperty(value = "创建人", required = true)
  @Column(name = "creator", nullable = false, columnDefinition = "varchar(255) COMMENT '创建人'")
  @SaturnColumn(description = "创建人")
  private String creator;

  /**
   * 创建时间
   */
  @ApiModelProperty(value = "创建时间", required = true)
  @Column(name = "create_time", nullable = false, columnDefinition = "datetime(3) COMMENT '创建时间'")
  @SaturnColumn(description = "创建时间")
  private Date createTime;

  /**
   * 创建人
   */
  @Transient
  @SaturnColumn(description = "创建人")
  private UserVo createUser;

  /**
   * 最后更新人
   */
  @ApiModelProperty(value = "最后更新人", required = true)
  @Column(name = "modifier", nullable = false, columnDefinition = "varchar(255) COMMENT '最后更新人'")
  @SaturnColumn(description = "最后更新人")
  private String modifier;

  /**
   * 最后更新人
   */
  @Transient
  @ApiModelProperty(value = "最后更新人", required = true)
  @SaturnColumn(description = "最后更新人")
  private UserVo modifyUser;

  /**
   * 最后更新时间
   */
  @ApiModelProperty(value = "最后更新时间", required = true)
  @Column(name = "modify_time", nullable = false, columnDefinition = "datetime(3) COMMENT '最后更新时间'")
  @SaturnColumn(description = "最后更新时间")
  private Date modifyTime;

  /**
   * 页面信息
   */
  @ApiModelProperty(value = "页面信息")
  @SaturnColumn(description = "页面信息")
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "pageFlow")
  private Set<PageEntity> pages;

  /**
   * 页面流文件内容
   */
  @Transient
  private String pageFlowContent;
  /**
   * 当前项目名工程名
   */
  @ApiModelProperty("当前项目名工程名")
  @Column(name="project_name", nullable = false, columnDefinition = "varchar(255) default '' comment '工程名'")
  @SaturnColumn(description = "工程名")
  private String projectName;

  public String getProjectName() {
    return projectName;
  }

  public void setProjectName(String projectName) {
    this.projectName = projectName;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public String getComment() {
    return comment;
  }

  public void setComment(String comment) {
    this.comment = comment;
  }

  public Integer getPageCount() {
    return pageCount;
  }

  public void setPageCount(Integer pageCount) {
    this.pageCount = pageCount;
  }

  public Integer getLineCount() {
    return lineCount;
  }

  public void setLineCount(Integer lineCount) {
    this.lineCount = lineCount;
  }

  public String getRelativePath() {
    return relativePath;
  }

  public void setRelativePath(String relativePath) {
    this.relativePath = relativePath;
  }

  public String getFileName() {
    return fileName;
  }

  public void setFileName(String fileName) {
    this.fileName = fileName;
  }

  public String getCreator() {
    return creator;
  }

  public void setCreator(String creator) {
    this.creator = creator;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public UserVo getCreateUser() {
    return createUser;
  }

  public void setCreateUser(UserVo createUser) {
    this.createUser = createUser;
  }

  public String getModifier() {
    return modifier;
  }

  public void setModifier(String modifier) {
    this.modifier = modifier;
  }

  public UserVo getModifyUser() {
    return modifyUser;
  }

  public void setModifyUser(UserVo modifyUser) {
    this.modifyUser = modifyUser;
  }

  public Date getModifyTime() {
    return modifyTime;
  }

  public void setModifyTime(Date modifyTime) {
    this.modifyTime = modifyTime;
  }

  public Set<PageEntity> getPages() {
    return pages;
  }

  public void setPages(Set<PageEntity> pages) {
    this.pages = pages;
  }

  public String getPageFlowContent() {
    return pageFlowContent;
  }

  public void setPageFlowContent(String pageFlowContent) {
    this.pageFlowContent = pageFlowContent;
  }
}
