package com.bizunited.platform.kuiper.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.Date;

/**
 * 表单模板涉及的事件信息
 * @author yinwenjie
 */
@ApiModel(value = "TemplateEventEntity" , description="表单模板涉及的事件信息")
@Entity
@Table(name="engine_form_event" , indexes = {@Index(columnList="template_id,event_id,controller_id" , unique=true)})
@org.hibernate.annotations.Table(appliesTo = "engine_form_event" , comment = "表单模板涉及的事件信息")
public class TemplateEventEntity extends UuidEntity {
  /**
   *
   */
  private static final long serialVersionUID = -1293566468852936090L;
  /**
   * 当前表单模板事件对应的表单模板信息（表单模板编号）
   */
  @ApiModelProperty(name="template" , value="当前表单模板事件对应的表单模板信息（表单模板编号）" , required=true , hidden=true)
  @ManyToOne(fetch=FetchType.LAZY)
  @JoinColumn(name="template_id" , nullable=false, columnDefinition = "varchar(255) COMMENT '当前表单模板事件对应的表单模板信息（表单模板编号）'")
  @SaturnColumn(description="表单模板信息")
  private TemplateEntity template;
  /**
   * 需要设定或者前端生成的事件唯一编号
   */
  @ApiModelProperty(name="eventId" , value="需要设定或者前端生成的事件唯一编号" , required=true)
  @Column(name="event_id" , length=64 , nullable=false, columnDefinition = "varchar(64) COMMENT '需要设定或者前端生成的事件唯一编号'")
  @SaturnColumn(description="事件唯一编号")
  private String eventId;
  /**
   * 控件ID，由前端操作者设定或者由前端自动生成。
   */
  @ApiModelProperty(name="controllerId" , value="控件ID，由前端操作者设定或者由前端自动生成。" , required=true)
  @Column(name="controller_id" , length=255 , nullable=false, columnDefinition = "varchar(255) COMMENT '控件ID，由前端操作者设定或者由前端自动生成'")
  @SaturnColumn(description="控件ID")
  private String controllerId;
  /**
   * 控件类型，包括了目前表单页面上支持的所有属性控件以及所有按钮控件的类型
   */
  @ApiModelProperty(name="controllerType" , value="控件类型，包括了目前表单页面上支持的所有属性控件以及所有按钮控件的类型" , required=true)
  @Column(name="controller_type" , length=64 , nullable=false, columnDefinition = "varchar(64) COMMENT '控件类型，包括了目前表单页面上支持的所有属性控件以及所有按钮控件的类型'")
  @SaturnColumn(description="控件类型")
  private String controllerType;
  /**
   * 控件事件名:onClick 控件点击、onChange 控件值改变、onFocus 控件获得焦点、onBlur 控件失去焦点、onMouseOver 鼠标移到控件上、onMouseOut 鼠标从控件上移开
   */
  @ApiModelProperty(name="onEvent" , value="控件事件名:onClick 控件点击、onChange 控件值改变、onFocus 控件获得焦点、onBlur 控件失去焦点、onMouseOver 鼠标移到控件上、onMouseOut 鼠标从控件上移开" , required=true)
  @Column(name="on_event" , length=32 , nullable=false, columnDefinition = "varchar(32) COMMENT '控件事件名:onClick 控件点击、onChange 控件值改变、onFocus 控件获得焦点、onBlur 控件失去焦点、onMouseOver 鼠标移到控件上、onMouseOut 鼠标从控件上移开'")
  @SaturnColumn(description="控件事件名")
  private String onEvent;
  /**
   * 控件可能对应的模板属性名、这个属性名可能是一般属性、也可能是关联属性
   */
  @ApiModelProperty(name="attributeName" , value="控件可能对应的模板属性名、这个属性名可能是一般属性、也可能是关联属性" , required=true)
  @Column(name="attribute_name" , length=64 , nullable=false, columnDefinition = "varchar(64) COMMENT '控件可能对应的模板属性名、这个属性名可能是一般属性、也可能是关联属性'")
  @SaturnColumn(description="模板属性名")
  private String attributeName;
  /**
   * 事件类型：1：后端事件；2：前端事件
   */
  @ApiModelProperty(name="eventType" , value="事件类型：1：后端事件；2：前端事件" , required=true)
  @Column(name="event_type" , nullable=false, columnDefinition = "int(11) COMMENT '事件类型：1：后端事件；2：前端事件'")
  @SaturnColumn(description="事件类型")
  private Integer eventType = 2;
  /**
   * 事件说明，必须要有，限定100字以内
   */
  @ApiModelProperty(name="eventDesc" , value="事件说明，必须要有，限定100字以内" , required=true)
  @Column(name="event_desc", length=100 , nullable=false, columnDefinition = "varchar(100) COMMENT '事件说明，必须要有，限定100字以内'")
  @SaturnColumn(description="事件说明")
  private String eventDesc = "";
  /**
   * 目前后端事件只支持“服务源”，这里描述后端服务源的具体信息描述
   */
  @ApiModelProperty(name="serviceName" , value="目前后端事件只支持“服务源”，这里描述后端服务源的具体信息描述" , required=false)
  @Column(name="service_name", length=64 , nullable=true, columnDefinition = "varchar(64) COMMENT '目前后端事件只支持“服务源”，这里描述后端服务源的具体信息描述'")
  @SaturnColumn(description="“服务源”名称")
  private String serviceName;
  /**
   * “服务源”参数"
   */
  @ApiModelProperty(name="serviceParams" , value="“服务源”参数，如果在指定后端服务源时需要填入脚本参数，则在这里进行记录" , required=false)
  @Column(name="service_params", length=512 , nullable=true, columnDefinition = "varchar(512) COMMENT '“服务源”参数'")
  @SaturnColumn(description="“服务源”参数")
  private String serviceParams;
  /**
   * 创建时间
   */
  @ApiModelProperty(name="createTime" , value="创建时间" , required=false)
  @Column(name="create_time", nullable=true, columnDefinition = "datetime COMMENT '创建时间'")
  @SaturnColumn(description="创建时间")
  private Date createTime;
  /**
   * js脚本内容
   * 注：
   * 1.前端js事件代码提交的数据包含再此字段，后端接收到数据会把该字段的信息转存文件。
   * 2.后端会读取相应的js存储文件，然后赋值给该字段，最终前端通过该字段获取值
   * 该字段不对外序列化
   */
  @Transient
  private String javascriptDesc = "";
  /**
   * 后端用于存储js事件信息序列化以后的文档的目录
   */
  @Column(name="relative_path" , nullable=false, columnDefinition = "varchar(255) COMMENT '后端用于存储js事件信息序列化以后的文档的目录'")
  @SaturnColumn(description="样式文档的相对目录")
  private String relativePath;
  /**
   * 保存的js文件文件名(包括后缀)
   */
  @Column(name="file_Name" , nullable=false, columnDefinition = "varchar(255) COMMENT '保存的js文件文件名(包括后缀)'")
  @SaturnColumn(description="保存的样式文件文件名")
  private String fileName;

  /**
   * 当前项目名工程名
   */
  @ApiModelProperty("当前项目名工程名")
  @Column(name="project_name", nullable = false, columnDefinition = "varchar(255) default '' comment '工程名'")
  @SaturnColumn(description = "工程名")
  private String projectName;

  public String getProjectName() {
    return projectName;
  }

  public void setProjectName(String projectName) {
    this.projectName = projectName;
  }
  public TemplateEntity getTemplate() {
    return template;
  }
  public void setTemplate(TemplateEntity template) {
    this.template = template;
  }
  public String getEventId() {
    return eventId;
  }
  public void setEventId(String eventId) {
    this.eventId = eventId;
  }
  public String getControllerId() {
    return controllerId;
  }
  public void setControllerId(String controllerId) {
    this.controllerId = controllerId;
  }
  public String getControllerType() {
    return controllerType;
  }
  public void setControllerType(String controllerType) {
    this.controllerType = controllerType;
  }
  public String getOnEvent() {
    return onEvent;
  }
  public void setOnEvent(String onEvent) {
    this.onEvent = onEvent;
  }
  public String getAttributeName() {
    return attributeName;
  }
  public void setAttributeName(String attributeName) {
    this.attributeName = attributeName;
  }
  public Integer getEventType() {
    return eventType;
  }
  public void setEventType(Integer eventType) {
    this.eventType = eventType;
  }
  public String getEventDesc() {
    return eventDesc;
  }
  public void setEventDesc(String eventDesc) {
    this.eventDesc = eventDesc;
  }
  public String getJavascriptDesc() {
    return javascriptDesc;
  }
  public void setJavascriptDesc(String javascriptDesc) {
    this.javascriptDesc = javascriptDesc;
  }
  public String getServiceName() {
    return serviceName;
  }
  public void setServiceName(String serviceName) {
    this.serviceName = serviceName;
  }
  public Date getCreateTime() {
    return createTime;
  }
  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }
  public String getServiceParams() {
    return serviceParams;
  }
  public void setServiceParams(String serviceParams) {
    this.serviceParams = serviceParams;
  }
  public String getRelativePath() {
    return relativePath;
  }
  public void setRelativePath(String relativePath) {
    this.relativePath = relativePath;
  }

  public String getFileName() {
    return fileName;
  }

  public void setFileName(String fileName) {
    this.fileName = fileName;
  }
}