package com.bizunited.platform.kuiper.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;

/**
 * TemplateItemExcelEntity
 *
 * @description:
 * @author: yanwe
 * @date: 19/Aug/2019 15:35
 */
@ApiModel("表单明细关联EXCEL存储信息")
@Entity
@Table(name = "engine_form_template_item_excel")
@org.hibernate.annotations.Table(appliesTo = "engine_form_template_item_excel" , comment = "表单明细关联EXCEL存储信息")
public class TemplateItemExcelEntity extends UuidEntity {

  private static final long serialVersionUID = 5524541766607303802L;
  /** 表单模版Id  * */
  @ApiModelProperty(name = "templateId", value = "表单模版Id" , required = true)
  @Column(name = "template_id" , nullable = false, columnDefinition = "varchar(255) COMMENT '表单模版Id'")
  @SaturnColumn(description = "表单模版Id")
  private String templateId;

  /** 表单分组模版Id,（注意，如果明细在父模板下，此项可为空！）. * */
  @ApiModelProperty(name = "templateGroupId", value = "表单分组模版Id,（注意，如果明细在父模板下，此项可为空！）")
  @Column(name = "template_group_id", columnDefinition = "varchar(255) COMMENT '表单分组模版Id,（注意，如果明细在父模板下，此项可为空！）'")
  @SaturnColumn(description = "表单分组模版Id,（注意，如果明细在父模板下，此项可为空！）")
  private String templateGroupId;

  /** 表单分组模版在主模板中的属性名(可能为空). * */
  @ApiModelProperty(name = "groupPropertyName", value = "表单分组模版在主模板中的属性名")
  @Column(name = "group_property_name", columnDefinition = "varchar(255) COMMENT '表单分组模版在主模板中的属性名'")
  @SaturnColumn(description = "表单分组模版在主模板中的属性名")
  private String groupPropertyName;

  /** 表单明细模版Id. * */
  @ApiModelProperty(name = "templateItemId", value = "表单明细模版Id", required = true)
  @Column(name = "template_item_id", nullable = false, columnDefinition = "varchar(255) COMMENT '表单明细模版Id'")
  @SaturnColumn(description = "表单明细模版Id")
  private String templateItemId;

  /** 表单明细模版的属性名. * */
  @ApiModelProperty(name = "itemPropertyName", value = "表单明细模版的属性名",required = true)
  @Column(name = "item_property_name",nullable = false, columnDefinition = "varchar(255) COMMENT '表单明细模版的属性名'")
  @SaturnColumn(description = "表单明细模版的属性名")
  private String itemPropertyName;

  /** 上传文件名. * */
  @ApiModelProperty(name = "file_name", value = "上传文件名", required = true)
  @Column(name = "file_name", nullable = false, columnDefinition = "varchar(255) COMMENT '上传文件名'")
  @SaturnColumn(description = "上传文件名")
  private String fileName;

  /** 重命名前的文件名字. * */
  @ApiModelProperty(name = "originalFileName", value = "重命名前的文件名字", required = true)
  @Column(name = "original_file_name", nullable = false, columnDefinition = "varchar(255) COMMENT '重命名前的文件名字'")
  @SaturnColumn(description = "重命名前的文件名字")
  private String originalFileName;

  /** 上传文件相对路径. * */
  @ApiModelProperty(name = "filePath", value = "上传文件相对路径", required = true)
  @Column(name = "file_path", nullable = false, columnDefinition = "varchar(255) COMMENT '上传文件相对路径'")
  @SaturnColumn(description = "上传文件相对路径")
  private String filePath;

  /** 上传时间. * */
  @ApiModelProperty(name = "createDate", value = "上传时间", required = true)
  @Column(name = "create_date", nullable = false, columnDefinition = "datetime COMMENT '上传时间'")
  @SaturnColumn(description = "创建时间")
  private Date createDate = new Date();

  /**
   * 当前项目名工程名
   */
  @ApiModelProperty("当前项目名工程名")
  @Column(name="project_name", nullable = false, columnDefinition = "varchar(255) default '' comment '工程名'")
  @SaturnColumn(description = "工程名")
  private String projectName;

  public String getProjectName() {
    return projectName;
  }

  public void setProjectName(String projectName) {
    this.projectName = projectName;
  }

  public String getTemplateId() {
    return templateId;
  }

  public void setTemplateId(String templateId) {
    this.templateId = templateId;
  }

  public String getTemplateItemId() {
    return templateItemId;
  }

  public void setTemplateItemId(String templateItemId) {
    this.templateItemId = templateItemId;
  }

  public String getFileName() {
    return fileName;
  }

  public void setFileName(String fileName) {
    this.fileName = fileName;
  }

  public String getOriginalFileName() {
    return originalFileName;
  }

  public void setOriginalFileName(String originalFileName) {
    this.originalFileName = originalFileName;
  }

  public String getFilePath() {
    return filePath;
  }

  public void setFilePath(String filePath) {
    this.filePath = filePath;
  }

  public Date getCreateDate() {
    return createDate;
  }

  public void setCreateDate(Date createDate) {
    this.createDate = createDate;
  }

  public String getTemplateGroupId() {
    return templateGroupId;
  }

  public void setTemplateGroupId(String templateGroupId) {
    this.templateGroupId = templateGroupId;
  }

  public String getGroupPropertyName() {
    return groupPropertyName;
  }

  public void setGroupPropertyName(String groupPropertyName) {
    this.groupPropertyName = groupPropertyName;
  }

  public String getItemPropertyName() {
    return itemPropertyName;
  }

  public void setItemPropertyName(String itemPropertyName) {
    this.itemPropertyName = itemPropertyName;
  }
}
