package com.bizunited.platform.kuiper.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import java.util.Date;

@ApiModel(value = "TemplateOprtLogEntity" , description="表单引擎模板的更新操作日志记录")
@Entity
@Table(name="engine_form_template_oprt_log")
@org.hibernate.annotations.Table(appliesTo = "engine_form_template_oprt_log" , comment = "表单模板的更新操作日志记录")
public class TemplateOprtLogEntity extends UuidEntity {
  private static final long serialVersionUID = -4977185285121199621L;
  /**
   * 模板信息
   */
  @ApiModelProperty(name="template" , value="模板信息" , hidden=true , required=true)
  @ManyToOne(fetch=FetchType.LAZY)
  @JoinColumn(name="template_id" , nullable=false, columnDefinition = "varchar(255) COMMENT '模板信息'")
  @SaturnColumn(description="模板信息")
  private TemplateEntity template;
  /**
   * 模板操作日志的创建时间
   */
  @ApiModelProperty(name="createTime" , value="模板操作日志的创建时间" , required=true)
  @Column(name="create_time" , nullable=false, columnDefinition = "datetime COMMENT '模板操作日志的创建时间'")
  @SaturnColumn(description="创建时间")
  private Date createTime;
  /**
   * 操作人
   */
  @Column(name = "oprt_user", nullable = false, columnDefinition = "varchar(255) COMMENT '操作人'")
  @ApiModelProperty(name="oprtUser" , value="操作人" , hidden=true , required=true)
  @SaturnColumn(description="操作人")
  private String oprtUser;

  /**
   * 当前项目名工程名
   */
  @ApiModelProperty("当前项目名工程名")
  @Column(name="project_name", nullable = false, columnDefinition = "varchar(255) default '' comment '工程名'")
  @SaturnColumn(description = "工程名")
  private String projectName;

  public String getProjectName() {
    return projectName;
  }

  public void setProjectName(String projectName) {
    this.projectName = projectName;
  }

  public TemplateEntity getTemplate() {
    return template;
  }

  public void setTemplate(TemplateEntity template) {
    this.template = template;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public String getOprtUser() {
    return oprtUser;
  }

  public void setOprtUser(String oprtUser) {
    this.oprtUser = oprtUser;
  }
}
