package com.bizunited.platform.kuiper.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

/**
 * 表单模板中一般属性和关联属性的可见性设定在这里
 * @author yinwenjie
 */
@ApiModel(value = "TemplateVisibilityAttributesEntity" , description="表单模板中一般属性和关联属性的可见性设定在这里")
@Entity
@Table(name="engine_form_visibility_attributes" , indexes={@Index(columnList="visibility_id,controller_id,layout_type" , unique=true)})
@org.hibernate.annotations.Table(appliesTo = "engine_form_visibility_attributes" , comment = "表单模板中一般属性和关联属性的可见性设定在这里")
public class TemplateVisibilityAttributesEntity extends UuidEntity {
  /**
   * 
   */
  private static final long serialVersionUID = 5664174042944637112L;
  /**
   * 该属性可见性设定对应的可见性信息编号
   */
  @ApiModelProperty(name="templateVisibility" , value="该属性可见性设定对应的可见性信息编号" , hidden=true , required=true)
  @ManyToOne(fetch=FetchType.LAZY)
  @JoinColumn(name="visibility_id" , nullable=false, columnDefinition = "varchar(255) COMMENT '可见性信息编号'")
  @SaturnColumn(description="可见性信息编号")
  private TemplateVisibilityEntity templateVisibility;
  /**
   * 控件在该表单模板上的唯一编号
   */
  @ApiModelProperty(name="controllerId" , value="控件在该表单模板上的唯一编号" , required=true)
  @Column(name="controller_id" , length=255 , nullable=false, columnDefinition = "varchar(255) COMMENT '唯一编号'")
  @SaturnColumn(description="唯一编号")
  private String controllerId;
  /**
   * 控件可能对应的模板属性名：这个属性名可能是一般属性、也可能是关联属性
   */
  @ApiModelProperty(name="attributeName" , value="控件可能对应的模板属性名：这个属性名可能是一般属性、也可能是关联属性")
  @Column(name="attribute_name" , length=64, columnDefinition = "varchar(64) COMMENT '可能对应的模板属性名'")
  @SaturnColumn(description="可能对应的模板属性名")
  private String attributeName;
  /**
   * 该控件的可见性类型；1：只读、2：编辑、3：隐藏
   */
  @ApiModelProperty(name="visibilityType" , value="该控件的可见性类型；1：只读、2：编辑、3：隐藏" , required=true)
  @Column(name="visibility_type" , nullable=false, columnDefinition = "int(11) COMMENT '该控件的可见性类型；1：只读、2：编辑、3：隐藏'")
  @SaturnColumn(description="可见性类型")
  private Integer visibilityType;
  /**
   * 该控件在这个可见性定义下，是否可以不填写值（只会影响前端效果）；true：可以没有值；false：必须有值
   */
  @ApiModelProperty(name="nullable" , value="该控件在这个可见性定义下，是否可以不填写值（只会影响前端效果）；true：可以没有值；false：必须有值" , required=true)
  @Column(name="nullable" , nullable=false, columnDefinition = "bit(1) COMMENT '是否可以不填写值（只会影响前端效果'")
  @SaturnColumn(description="是否可以不填写值（只会影响前端效果）")
  private Boolean nullable;

  /**
   * 该控件的布局类型；1：PC、2：移动端、3：打印端
   */
  @ApiModelProperty(name="layoutType" , value="该控件的可见性类型；1：PC、2：移动端、3：打印端", required = true)
  @Column(name="layout_type", nullable = false, columnDefinition = "int(11) COMMENT '该控件的可见性类型；1：PC、2：移动端、3：打印端'")
  @SaturnColumn(description="布局类型")
  private Integer layoutType;

  /**
   * 当前项目名工程名
   */
  @ApiModelProperty("当前项目名工程名")
  @Column(name="project_name", nullable = false, columnDefinition = "varchar(255) default '' comment '工程名'")
  @SaturnColumn(description = "工程名")
  private String projectName;

  public String getProjectName() {
    return projectName;
  }

  public void setProjectName(String projectName) {
    this.projectName = projectName;
  }

  public TemplateVisibilityEntity getTemplateVisibility() {
    return templateVisibility;
  }
  public void setTemplateVisibility(TemplateVisibilityEntity templateVisibility) {
    this.templateVisibility = templateVisibility;
  }
  public String getControllerId() {
    return controllerId;
  }
  public void setControllerId(String controllerId) {
    this.controllerId = controllerId;
  }
  public String getAttributeName() {
    return attributeName;
  }
  public void setAttributeName(String attributeName) {
    this.attributeName = attributeName;
  }
  public Integer getVisibilityType() {
    return visibilityType;
  }
  public void setVisibilityType(Integer visibilityType) {
    this.visibilityType = visibilityType;
  }
  public Boolean getNullable() {
    return nullable;
  }
  public void setNullable(Boolean nullable) {
    this.nullable = nullable;
  }

  public Integer getLayoutType() {
    return layoutType;
  }

  public void setLayoutType(Integer layoutType) {
    this.layoutType = layoutType;
  }
}
