package com.bizunited.platform.kuiper.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import java.util.Date;
import java.util.Set;

/**
 * 表单模板可见性的定义说明
 * @author yinwenjie
 */
@ApiModel(value = "TemplateVisibilityEntity" , description="表单模板可见性的定义说明")
@Entity
@Table(name="engine_form_visibility" , indexes={@Index(columnList="template_id,visibility_name" , unique=true)})
@org.hibernate.annotations.Table(appliesTo = "engine_form_visibility" , comment = "表单模板可见性的定义说明")
public class TemplateVisibilityEntity extends UuidEntity {
  /**
   * 
   */
  private static final long serialVersionUID = 6058153958476353770L;
  /**
   * 当前表单可见性对应的表单模板信息（表单模板编号）
   */
  @ApiModelProperty(name="template" , value="当前表单可见性对应的表单模板信息（表单模板编号）" , required=true , hidden=true)
  @ManyToOne(fetch=FetchType.LAZY)
  @JoinColumn(name="template_id" , nullable=false, columnDefinition = "varchar(255) COMMENT '对应的表单模板信息'")
  @SaturnColumn(description="对应的表单模板信息")
  private TemplateEntity template;
  /**
   * 可见性名，这个名字是该表单模板中唯一的存在，作为标识信息，其中当可见性名字为create时，不能进行删除操作
   */
  @ApiModelProperty(name="visibilityName" , value="可见性名，这个名字是该表单模板中唯一的存在，作为标识信息，其中当可见性名字为create时，不能进行删除操作" , required=true)
  @Column(name="visibility_name" , length=64 , nullable=false, columnDefinition = "varchar(64) COMMENT '可见性名'")
  @SaturnColumn(description="可见性名")
  private String visibilityName;
  /**
   * 当前可见性定义是否能够删除，只有由操作者自己创建的，才能进行删除
   */
  @ApiModelProperty(name="canDelete" , value="当前可见性定义是否能够删除，只有由操作者自己创建的，才能进行删除" , required=true)
  @Column(name="can_delete" , nullable=false, columnDefinition = "bit(1) COMMENT '可见性定义是否能够删除'")
  @SaturnColumn(description="可见性定义是否能够删除")
  private Boolean canDelete = true;
  /**
   * 创建时间
   */
  @ApiModelProperty(name="createTime" , value="创建时间" , required=true)
  @Column(name="create_time" , nullable=false, columnDefinition = "datetime COMMENT '创建时间'")
  @SaturnColumn(description="创建时间")
  private Date createTime;
  /**
   * 当前可见性对应的一个或者多个属性可见性设定项
   */
  @ApiModelProperty(name="templateVisibilityAttributes" , value="当前可见性对应的一个或者多个属性可见性设定项" , hidden=true , required=false)
  @OneToMany(fetch=FetchType.LAZY , mappedBy="templateVisibility")
  @OrderBy("attributeName desc")
  @SaturnColumn(description="可见性设定项")
  private Set<TemplateVisibilityAttributesEntity> attributes;
  /**
   * 当前可见性对应的一个或者多个按钮属性可见性设定项
   */
  @ApiModelProperty(name="templateVisibilityButtons" , value="当前可见性对应的一个或者多个按钮属性可见性设定项" , hidden=true , required=false)
  @OneToMany(fetch=FetchType.LAZY , mappedBy="templateVisibility")
  @SaturnColumn(description="按钮可见性设定项")
  private Set<TemplateVisibilityButtonsEntity> buttons;
  /**
   * 当前项目名工程名
   */
  @ApiModelProperty("当前项目名工程名")
  @Column(name="project_name", nullable = false, columnDefinition = "varchar(255) default '' comment '工程名'")
  @SaturnColumn(description = "工程名")
  private String projectName;

  public String getProjectName() {
    return projectName;
  }

  public void setProjectName(String projectName) {
    this.projectName = projectName;
  }
  public TemplateEntity getTemplate() {
    return template;
  }
  public void setTemplate(TemplateEntity template) {
    this.template = template;
  }
  public String getVisibilityName() {
    return visibilityName;
  }
  public void setVisibilityName(String visibilityName) {
    this.visibilityName = visibilityName;
  }
  public Boolean getCanDelete() {
    return canDelete;
  }
  public void setCanDelete(Boolean canDelete) {
    this.canDelete = canDelete;
  }
  public Date getCreateTime() {
    return createTime;
  }
  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }
  public Set<TemplateVisibilityAttributesEntity> getAttributes() {
    return attributes;
  }
  public void setAttributes(Set<TemplateVisibilityAttributesEntity> attributes) {
    this.attributes = attributes;
  }
  public Set<TemplateVisibilityButtonsEntity> getButtons() {
    return buttons;
  }
  public void setButtons(Set<TemplateVisibilityButtonsEntity> buttons) {
    this.buttons = buttons;
  }
}
