package com.bizunited.platform.kuiper.service;

import java.security.Principal;

import com.bizunited.platform.kuiper.entity.TemplateEntity;

/**
 * 动态数据模板服务，用于初始化、修改、更新、数据入库相关动态数据模板定义
 * @author yinwenjie
 */
public interface DynamicTemplateService {
  /**
   * 初始化动态模板，包括动态模板中的一般属性、关联属性、明细编辑属性和分组属性，包括建立个主要数据表和明细、分组关联数据表
   * @param template 当前的模板信息
   * @return
   */
  public TemplateEntity initDynamicTemplate(TemplateEntity template , Principal principal, boolean isImport);

  /**
   * 动态模板数据结构升级功能（升级时只是升级数据结构，布局、事件、可见性都是参照原始模板进行复制）
   * @param templateId 当前升级所参考的原始动态模板id
   * @param newTemplate 新的模板信息对象，里面需要至少包括所有最新的数据结构描述
   * @param newVersion 新的版本 
   * @param principal 当前操作用户 
   * @return
   */
  public TemplateEntity upgrade(String templateId, TemplateEntity newTemplate, String newVersion, boolean updateInstance, Principal principal);

  /**
   * 对指定的动态表单模板进行升级处理时，需要获取原有模板的结构信息，同时过滤掉id，formInstanceId以及回溯关系等
   * @param templateId
   * @return
   */
  public TemplateEntity findStructByTemplateId(String templateId);
}