package com.bizunited.platform.kuiper.service;

import java.security.Principal;

import com.bizunited.platform.kuiper.entity.TemplateEntity;

public interface StaticTemplateService {
  
  /**
   * 该方法用于基于saturn扫描组件中已扫描确定的某一个静态模型（完整的静态模型类名），完成一个静态表单模板的初始化过程<p>
   * 这个过程一般发生在操作人员通过页面上的“创建静态表单模板”功能选定一个静态模型，并点击“创建”按钮时发生。
   * 通过这个方法，系统将返回这个静态模型的初始化信息。初始化信息包括静态模型本身的描述，还包括静态模型关联的一般属性、关联属性，以及关联属性中OneToMany性质关联的下一级属性等信息<p>
   * 以及根据静态模型关联情况初始化完成的“静态服务源”信息——当然也包括了直接关联的服务源和OneToMany关系中关联的服务源。<p>
   * 请注意，这里并不是返回PersistentClass对象的json结构，而是一个满足技术白皮书中静态模型结构定义的JSON结构。详细情况可参见《表单引擎技术白皮书V1.1》白皮书文档中的描述
   * @param template 新的表单模板信息，至少说明版本信息、模板类型、已经使用的静态类全名，其它不需要指定了
   * @param initVisibilities 标识是否初始化可见性，这是因为在“升级”的是否，可见性不需要初始化，而是来源于之前的可见性
   * @return 除了静态表单模板的基本信息以外，还包括mainModel、relationModels、mainSource、relationSources信息
   */
  public TemplateEntity initStaticTemplate(TemplateEntity template , Principal principal , boolean initVisibilities);
  
  /**
   * 对指定的表单模板进行升级处理(静态模板升级)，通过这个接口服务系统将自动保留templateId对应的模板的全部主要设定（包括模型、数据源、事件、可见性）<br>
   * 在只更改模板基本信息，版本信息的情况下，拷贝出一个新的模板
   * @param templateId 指定的表单模板升级时使用的参考模板
   * @param principal 当前操作者信息
   * @return 升级后新的表单模板信息将被返回
   */
  public TemplateEntity upgradeStaticTemplate(String templateId, String newVersion, boolean updateInstance, Principal principal);
  /**
   * 删除指定的模板信息，真删除——包括模板的可见性、模板的事件、模板的数据源等信息。注意：已经存在实例在运行的模板信息，是不允许进行删除的
   * @param templateId
   */
  public void deleteById(String templateId);

  /**
   * 对指定的不同版本，相同模型定义的两个表单模板进行合并处理，通过这个接口服务系统将自动生成一个新的表单模板。
   * 以其中一个模板为基准，另一个模板的信息会合并到基准模板中，从而生成一个新的模板
   * @param refTemplateId 基准模板id
   * @param templateId 待合并的模板id
   * @param name 定义合并的模板名称
   * @param version 定义合并的模板版本
   * @param principal 操作人
   */
  public TemplateEntity merge(String refTemplateId,String templateId,String name,String version,Principal principal);
}
