/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.configuration;

import com.bizunited.platform.kuiper.starter.service.KuiperToolkitService;
import com.bizunited.platform.saturn.context.SaturnContext;
import com.bizunited.platform.saturn.context.service.PersistentServiceFactory;
import com.bizunited.platform.saturn.context.service.simple.SimplePersistentServiceFactory;
import com.bizunited.platform.saturn.engine.SaturnEngine;
import com.bizunited.platform.saturn.scan.ClassScanner;
import com.bizunited.platform.saturn.scan.SimpleClassScanner;
import com.github.xiaoymin.swaggerbootstrapui.annotations.EnableSwaggerBootstrapUI;
import javax.servlet.MultipartConfigElement;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.web.servlet.MultipartConfigFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.unit.DataSize;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableAutoConfiguration
@ComponentScan(basePackages={"com.bizunited.platform.kuiper", "com.bizunited.platform.core"})
@EnableSwagger2
@EnableSwaggerBootstrapUI
public class KuiperServiceConfig {
    @Value(value="${kuiper.scanPackages}")
    private String[] kuiperScanPackages;
    @Value(value="${kuiper.file.maxFileSize}")
    private Integer maxFileSize = 1;

    @Bean
    public SaturnContext getSaturnContext() {
        String[] rootScanPackages = this.kuiperScanPackages;
        SimplePersistentServiceFactory persistentServiceFactory = new SimplePersistentServiceFactory();
        SaturnEngine.Builder builder = new SaturnEngine.Builder();
        SaturnEngine saturnEngine = builder.onlyScan(Boolean.valueOf(true)).setRootScanPackages(rootScanPackages).addClassScanners((ClassScanner)new SimpleClassScanner()).setPersistentServiceFactory((PersistentServiceFactory)persistentServiceFactory).build();
        try {
            saturnEngine.eve();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("kuiper\u8868\u5355\u5f15\u64ce\u521d\u59cb\u5316\u9519\u8bef\uff0c\u53ef\u80fd\u7531\u4e8esaturn\u9aa8\u67b6\u914d\u7f6e\u95ee\u9898\uff0c\u8bf7\u68c0\u67e5!!");
        }
        return saturnEngine.getSaturnContext();
    }

    @Bean
    public MultipartConfigElement multipartConfigElement() {
        MultipartConfigFactory factory = new MultipartConfigFactory();
        factory.setMaxFileSize(DataSize.ofMegabytes((long)this.maxFileSize.longValue()));
        factory.setMaxRequestSize(DataSize.ofMegabytes((long)((long)this.maxFileSize.intValue() * 5L)));
        return factory.createMultipartConfig();
    }

    @Bean(value={"KuiperToolkitService"})
    public KuiperToolkitService getKuiperToolkitService() {
        return new KuiperToolkitService();
    }
}

