/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.controller;

import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.kuiper.entity.InstanceEntity;
import com.bizunited.platform.kuiper.service.InstanceService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.security.Principal;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/kuiper/instances"})
public class InstanceController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstanceController.class);
    @Autowired
    private InstanceService instanceService;
    private static final String ACTIVITIES = "activities";
    private static final String TEMPLATE = "template";

    @ApiOperation(value="\u521b\u5efa\u4e00\u4e2a\u65b0\u7684\u8868\u5355\u5b9e\u4f8b\uff0c\u4ee5\u53ca\u8868\u5355\u5b9e\u4f8b\u4e2d\u7b2c\u4e00\u4e2a\u540d\u53ebcreate\u7684\u6d3b\u52a8\u5b9e\u4f8b\u3002\u5e76\u4e14\u8fd9\u4e2a\u540d\u53ebcreate\u7684\u6d3b\u52a8\u5b9e\u4f8b\u7684taskCode\u6309\u7167\u4f20\u5165\u7684taskCode\u4e3a\u51c6")
    @RequestMapping(value={""}, method={RequestMethod.POST})
    @CacheEvict(cacheNames={"instance"}, allEntries=true)
    public ResponseModel create(@ApiParam(name="instance", value="\u6307\u5b9a\u7684\u5b9e\u4f8b\u57fa\u672c\u4fe1\u606f\u2014\u2014\u4e3b\u8981\u8981\u6709\u5176\u4e2d\u5173\u8054\u7684\u6a21\u677f\u6570\u636e\u5c42\u7f16\u53f7\u4fe1\u606f") @RequestBody InstanceEntity instance, @ApiParam(name="taskCode", value="\u6307\u5b9a\u7684\u53ef\u80fd\u4f20\u5165\u7684\uff0c\u5c06\u8981\u521b\u5efa\u7684create\u540d\u79f0\u7684\u6d3b\u52a8\u5b9e\u4f8b\u7684\u552f\u4e00\u5916\u90e8\u4e1a\u52a1\u7f16\u53f7", required=false) @RequestParam(name="taskCode", required=false) String taskCode) {
        try {
            Principal principal = this.getPrincipal();
            InstanceEntity currentInstance = this.instanceService.create(instance, taskCode, principal);
            return this.buildHttpResultW(currentInstance, new String[]{TEMPLATE, ACTIVITIES});
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u53ea\u9700\u8981\u4f20\u5165\u4e00\u4e2a\u8868\u5355\u6a21\u677f\u7684\u4e1a\u52a1\u7f16\u53f7\uff08code\uff09\uff0c\u8868\u5355\u5f15\u64ce\u5c31\u53ef\u4ee5\u6839\u636e\u8fd9\u4e2acode\u5bfb\u627e\u5230\u76f8\u5173\u7684\u6700\u65b0\u7248\u672c\uff0c\u5e76\u57fa\u4e8e\u8fd9\u4e2a\u6700\u65b0\u7248\u672c\u7684\u6a21\u677f\u81ea\u52a8\u521b\u5efa\u8868\u5355\u5b9e\u4f8b")
    @RequestMapping(value={"/{code}"}, method={RequestMethod.POST})
    @CacheEvict(cacheNames={"instance"}, allEntries=true)
    public ResponseModel create(@ApiParam(name="code", value="\u6307\u5b9a\u7684\u5b9e\u4f8b\u57fa\u672c\u4fe1\u606f\u2014\u2014\u4e3b\u8981\u8981\u6709\u5176\u4e2d\u5173\u8054\u7684\u6a21\u677f\u4e1a\u52a1\u7f16\u53f7\u4fe1\u606f") @PathVariable(value="code") String templateCode, @ApiParam(name="taskCode", value="\u6307\u5b9a\u7684\u53ef\u80fd\u4f20\u5165\u7684\uff0c\u5c06\u8981\u521b\u5efa\u7684create\u540d\u79f0\u7684\u6d3b\u52a8\u5b9e\u4f8b\u7684\u552f\u4e00\u5916\u90e8\u4e1a\u52a1\u7f16\u53f7", required=false) @RequestParam(name="taskCode", required=false) String taskCode) {
        try {
            Principal principal = this.getPrincipal();
            InstanceEntity currentInstance = this.instanceService.create(templateCode, taskCode, principal);
            return this.buildHttpResultW(currentInstance, new String[]{TEMPLATE, ACTIVITIES});
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u8868\u5355\u5b9e\u4f8b\u7684\u6570\u636e\u5c42\u7f16\u53f7\uff0c\u67e5\u8be2\u8fd9\u4e2a\u5b9e\u4f8b\u7684\u8be6\u60c5\u2014\u2014\u5305\u62ec\u5b9e\u4f8b\u7684\u76f4\u63a5\u5173\u8054\u4fe1\u606f")
    @RequestMapping(value={"/findDetailsById"}, method={RequestMethod.GET})
    @Cacheable(cacheNames={"instance"}, key="'findDetailsById_' + #instanceId", sync=true)
    public ResponseModel findDetailsById(@ApiParam(name="instanceId", value="\u6307\u5b9a\u7684\u8868\u5355\u5b9e\u4f8b\u7f16\u53f7") String instanceId) {
        try {
            InstanceEntity instance = this.instanceService.findDetailsById(instanceId);
            return this.buildHttpResultW(instance, new String[]{TEMPLATE, ACTIVITIES, "creator"});
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u6761\u4ef6\u641c\u7d22\uff0c\u76ee\u524d\u652f\u6301\u8868\u5355\u6a21\u677f\u540d\u3001\u4e1a\u52a1\u57df\u540d\u548c\u9879\u76ee\u540d\u4e09\u4e2a\u6761\u4ef6\uff0c\u4e0d\u652f\u6301\u6a21\u7cca\u67e5\u8be2")
    @RequestMapping(value={"/findByConditions"}, method={RequestMethod.GET})
    public ResponseModel findByConditions(@ApiParam(name="code", value="\u5b9e\u4f8b\u5bf9\u5e94\u6a21\u677f\u7684\u6a21\u677f\u7f16\u53f7", required=false) @RequestParam(name="code", required=false) String code, @ApiParam(name="instanceId", value="\u5b9e\u4f8bID", required=false) @RequestParam(name="instanceId", required=false) String instanceId, @ApiParam(name="cversion", value="\u5b9e\u4f8b\u5bf9\u5e94\u6a21\u677f\u7684\u72b6\u6001", required=false) @RequestParam(name="cversion", required=false) String cversion, @ApiParam(name="domain", value="\u5b9e\u4f8b\u57df", required=false) @RequestParam(name="domain", required=false) String domain, @ApiParam(name="templateName", value="\u6a21\u677f\u540d", required=false) @RequestParam(name="templateName", required=false) String templateName, @ApiParam(name="porjectName", value="\u5b9e\u4f8b\u5de5\u7a0b\u540d", required=false) @RequestParam(name="projectName", required=false) String projectName, @ApiParam(name="beginCreateTime", value="\u53ef\u80fd\u7684\u5b9e\u4f8b\u521b\u5efa\u65f6\u95f4\uff08\u8d77\uff09\uff0c\u65f6\u95f4\u683c\u5f0f\u4e3ayyyy-MM-dd HH:mm:ss", required=false) @RequestParam(name="beginCreateTime", required=false) @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date beginCreateTime, @ApiParam(name="endCreateTime", value="\u53ef\u80fd\u7684\u5b9e\u4f8b\u521b\u5efa\u65f6\u95f4\uff08\u6b62\uff09\uff0c\u65f6\u95f4\u683c\u5f0f\u4e3ayyyy-MM-dd HH:mm:ss", required=false) @RequestParam(name="endCreateTime", required=false) @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date endCreateTime, @ApiParam(name="userName", value="\u53ef\u80fd\u7684\u521b\u5efa\u8005\u7528\u6237\u540d\uff08\u771f\u5b9e\u59d3\u540d\uff09", required=false) @RequestParam(name="userName", required=false) String userName, @PageableDefault(value=50) @ApiParam(name="pageable", value="\u5206\u9875\u53c2\u6570\uff0c\u5f53\u6307\u5b9apage\u65f6\u4e3a\u67e5\u8be2\u5f53\u524d\u9875\u7801\uff08\u9875\u7801\u4ece0\u5f00\u59cb\uff09\uff1b\u5f53\u6307\u5b9asize\u65f6\uff0c\u4e3a\u6307\u5b9a\u6bcf\u9875\u5927\u5c0f\uff0c\u9ed8\u8ba4\u4e3a50") Pageable pageable) {
        try {
            Page page = this.instanceService.findByConditions(code, instanceId, cversion, domain, templateName, projectName, beginCreateTime, endCreateTime, userName, pageable);
            return this.buildHttpResultW((Iterable)page, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u6307\u5b9a\u7684\u8868\u5355\u6a21\u677f\u7f16\u53f7\u4fe1\u606f\uff0c\u67e5\u8be2\u8fd9\u4e2a\u8868\u5355\u6a21\u677f\u4e0b\u6d89\u53ca\u7684\u8868\u5355\u5b9e\u4f8b\u6570\u91cf")
    @RequestMapping(value={"/countByTemplateId"}, method={RequestMethod.GET})
    public ResponseModel countByTemplateId(@ApiParam(name="templateId", value="\u6307\u5b9a\u7684\u8868\u5355\u6a21\u677f\u7f16\u53f7\u4fe1\u606f") @RequestParam(value="templateId") String templateId) {
        try {
            Integer count = this.instanceService.countByTemplateId(templateId);
            return this.buildHttpResultW(count, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

