/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.controller;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.core.service.file.NebulaFileService;
import com.bizunited.platform.kuiper.entity.InstanceItemImportEntity;
import com.bizunited.platform.kuiper.entity.TemplateItemExcelEntity;
import com.bizunited.platform.kuiper.starter.service.InstanceItemImportService;
import com.bizunited.platform.kuiper.starter.service.TemplateItemExcelService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/v1/kuiper/instancesItemImport"})
public class InstanceItemImportController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstanceItemImportController.class);
    @Autowired
    private InstanceItemImportService instanceItemImportService;
    @Autowired
    private TemplateItemExcelService templateItemExcelService;
    @Autowired
    private NebulaFileService nebulaFileService;

    @ApiOperation(value="\u4e0a\u4f20\u5bfc\u5165\u6a21\u7248")
    @RequestMapping(value={"/uploadExample"}, method={RequestMethod.POST})
    public ResponseModel uploadExample(@RequestParam(value="templateItemId") String templateItemId, @RequestParam(value="sheetNum") Integer sheetNum, @RequestParam(value="rowNum") Integer rowNum, @RequestParam(value="file") MultipartFile file) {
        try {
            Principal opUser = this.getPrincipal();
            JSONObject jsonResult = this.instanceItemImportService.uploadExample(templateItemId, file, sheetNum, rowNum, opUser);
            return this.buildHttpResultW(jsonResult, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5bfc\u5165\u660e\u7ec6\u6570\u636e")
    @RequestMapping(value={"/upload"}, method={RequestMethod.POST})
    public ResponseModel upload(@ApiParam(name="json", value="\u8868\u5355\u9a8c\u8bc1\u683c\u5f0fJSON") @RequestParam(value="json") String jsonObject, HttpServletRequest request, HttpServletResponse response, @ApiParam(name="file", value="\u4e0a\u4f20\u6587\u4ef6") @RequestParam(value="file") MultipartFile file, @ApiParam(name="sheetNum", value="\u8bfb\u5165EXCEL\u7b2cN\u9875\uff0c\u82e5\u65e0\uff0c\u5219\u9ed8\u8ba4\u8bfb\u5165\u7b2c1\u9875") @RequestParam(value="sheetNum") Integer sheetNum, @ApiParam(name="startRow", value="\u4ece\u7b2cN\u884c\u5f00\u59cb\u8bfb\u5165\u6570\u636e\uff0c\u82e5\u65e0\u5219\u9ed8\u8ba4\u4e3a2") @RequestParam(value="startRow") Integer startRow, @ApiParam(name="endRow", value="\u6570\u636e\u8bfb\u81f3\u7b2cN\u884c\uff0c\u82e5\u65e0\uff0c\u5219\u5f80\u4e0b\u8bfb\u81f3\u7a7a\u767d\u884c") @RequestParam(value="endRow") Integer endRow, @ApiParam(name="instanceId", value="\u8868\u5355\u5b9e\u4f8b\u7684ID") @RequestParam(value="instanceId") String instanceId, @ApiParam(name="paramsJson", value="\u5e72\u9884\u6e90\u53c2\u6570json\u683c\u5f0f") @RequestParam(value="paramsJson") String paramsJson) {
        try {
            Principal opUser = this.getPrincipal();
            JSONObject jsonResult = this.instanceItemImportService.upload(JSONObject.parseObject((String)jsonObject), request, response, file, sheetNum, startRow, endRow, opUser, instanceId, paramsJson);
            return this.buildHttpResultW(jsonResult, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u660e\u7ec6\u5bfc\u5165\u8bb0\u5f55")
    @RequestMapping(value={"/findItemImport"}, method={RequestMethod.GET})
    public ResponseModel findItemImport(@ApiParam(name="templateItemId", value="\u8868\u5355\u660e\u7ec6\u6a21\u7248Id") @RequestParam(value="templateItemId") String templateItemId, Pageable pageable) {
        try {
            Page<InstanceItemImportEntity> instanceItemImportEntities = this.instanceItemImportService.queryPage(templateItemId, pageable);
            return this.buildHttpResultW((Iterable)instanceItemImportEntities, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5bfc\u51fa\u5b9e\u4f8b\u660e\u7ec6\u6570\u636e")
    @RequestMapping(value={"/downloadItems"}, method={RequestMethod.POST})
    public ResponseModel downloadItems(@RequestBody @ApiParam(name="templateItemInfo", value="\u8868\u5355\u660e\u7ec6\u6570\u636e\u4fe1\u606f") JSONObject jsonObject, HttpServletResponse response) {
        try {
            this.instanceItemImportService.downloadItems(jsonObject, response);
            return this.buildHttpResult();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u8868\u5355\u6a21\u677f\u660e\u7ec6ID\uff0c\u4e0b\u8f7dEXCEL\u6587\u4ef6\u3002")
    @RequestMapping(value={"/download"}, method={RequestMethod.GET})
    public void downloadExcelTemplate(HttpServletResponse response, HttpServletRequest request, @ApiParam(name="templateItemId", value="\u8868\u5355\u6a21\u677f\u660e\u7ec6ID") @RequestParam(value="templateItemId") String templateItemId) throws IOException {
        if (StringUtils.isBlank((CharSequence)templateItemId)) {
            return;
        }
        TemplateItemExcelEntity itemExcel = this.templateItemExcelService.findByTemplateItem(templateItemId);
        if (itemExcel == null) {
            return;
        }
        byte[] fileByte = this.nebulaFileService.readFileContent(itemExcel.getFilePath(), itemExcel.getFileName());
        if (fileByte == null) {
            return;
        }
        this.writeResponseFile(request, response, fileByte, itemExcel.getOriginalFileName());
    }
}

