/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.controller;

import com.alibaba.fastjson.JSONArray;
import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.service.TemplateService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="TemplateControllerv")
@RestController
@RequestMapping(value={"/v1/kuiper/templates"})
public class TemplateController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplateController.class);
    @Autowired
    private TemplateService templateService;

    @RequestMapping(value={"/findDetailsById"}, method={RequestMethod.GET})
    public ResponseModel findDetailsById(@ApiParam(name="id", value="\u8868\u5355\u6a21\u677f\u7684\u6570\u636e\u5e93\u7f16\u53f7") String id) {
        try {
            TemplateEntity result = this.templateService.findDetailsById(id);
            return this.buildHttpResultW(result, new String[]{"properties", "relations", "creator", "groupRelations", "groupRelations.properties", "groupRelations.relations", "groupRelations.itemRelations", "groupRelations.itemRelations.properties", "groupRelations.itemRelations.relations", "itemRelations", "itemRelations.properties", "itemRelations.relations"});
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u8be5\u63a5\u53e3\u6309\u7167\u8868\u5355\u6a21\u677f\u7684\u6570\u636e\u5e93\u7f16\u53f7\uff0c\u8fd4\u56de\u8868\u5355\u6a21\u677f\u7684\u57fa\u672c\u4fe1\u606f\uff08\u6ce8\u610f\u53ea\u6709\u57fa\u672c\u4fe1\u606f\uff0c\u4e0d\u5305\u62ec\u4efb\u4f55\u7684\u5173\u8054\u4fe1\u606f\uff09\uff0c\u65e0\u8bba\u662f\u9759\u6001\u6a21\u677f\u8fd8\u662f\u52a8\u6001\u6a21\u677f")
    @RequestMapping(value={"/findById"}, method={RequestMethod.GET})
    public ResponseModel findById(@ApiParam(name="id", value="\u8868\u5355\u6a21\u677f\u7684\u6570\u636e\u5e93\u7f16\u53f7") String id) {
        try {
            TemplateEntity result = this.templateService.findById(id);
            return this.buildHttpResultW(result, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u6761\u4ef6\u641c\u7d22\uff0c\u76ee\u524d\u652f\u6301\u8868\u5355\u6a21\u677f\u540d\u3001\u4e1a\u52a1\u57df\u540d\u548c\u9879\u76ee\u540d\u4e09\u4e2a\u6761\u4ef6\uff0c\u65e0\u8bba\u662f\u9759\u6001\u6a21\u677f\u8fd8\u662f\u52a8\u6001\u6a21\u677f\uff0c\u4e0d\u652f\u6301\u6a21\u7cca\u67e5\u8be2")
    @RequestMapping(value={"/findByConditions"}, method={RequestMethod.GET})
    public ResponseModel findByConditions(@ApiParam(name="name", value="\u6a21\u677f\u540d\u79f0") String name, @ApiParam(name="domain", value="\u6a21\u677f\u6307\u5b9a\u7684\u57df\u4fe1\u606f") String domain, @ApiParam(name="isDefault", value="\u662f\u5426\u6307\u5b9a\u7684\u9ed8\u8ba4\u7248\u672c") Boolean isDefault, @ApiParam(name="tstatus", value="\u6a21\u677f\u72b6\u6001\u30021\uff1a\u6b63\u5e38\uff1b0\uff1a\u4f5c\u5e9f") Integer tstatus, @ApiParam(name="type", value="\u8868\u5355\u6a21\u677f\u6765\u6e90\u7c7b\u578b\uff0c\u76ee\u524d\u6709\u4e09\u79cd\uff1astatic\uff1a\u9759\u6001\u6a21\u578b;dynamic\uff1a\u52a8\u6001\u6a21\u578b;dsl\uff1adsl\u6a21\u578b\uff0c\u5176\u5b83\u503c\u65e0\u6548") String type, @ApiParam(name="create_start", value="\u521b\u5efa\u65f6\u95f4\u8303\u56f4\u5f00\u59cb\u70b9\uff0c\u7cbe\u786e\u5230\u79d2yyyy-MM-dd HH:mm:ss") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date createStart, @ApiParam(name="create_end", value="\u521b\u5efa\u65f6\u95f4\u67e5\u8be2\u8303\u56f4\u7ed3\u675f\u70b9\uff0c\u7cbe\u786e\u5230\u79d2yyyy-MM-dd HH:mm:ss") @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date createEnd, @ApiParam(name="porjectName", value="\u6a21\u677f\u5de5\u7a0b\u540d") String porjectName, @PageableDefault(value=50) @ApiParam(name="pageable", value="\u5206\u9875\u53c2\u6570\uff0c\u5f53\u6307\u5b9apage\u65f6\u4e3a\u67e5\u8be2\u5f53\u524d\u9875\u7801\uff08\u9875\u7801\u4ece0\u5f00\u59cb\uff09\uff1b\u5f53\u6307\u5b9asize\u65f6\uff0c\u4e3a\u6307\u5b9a\u6bcf\u9875\u5927\u5c0f\uff0c\u9ed8\u8ba4\u4e3a50") Pageable pageable) {
        try {
            HashMap<String, Object> conditions = new HashMap<String, Object>();
            if (StringUtils.isNotBlank((CharSequence)name)) {
                conditions.put("name", name);
            }
            if (StringUtils.isNotBlank((CharSequence)domain)) {
                conditions.put("domain", domain);
            }
            if (porjectName != null) {
                conditions.put("porjectName", porjectName);
            }
            if (isDefault != null) {
                conditions.put("isDefault", isDefault);
            }
            if (tstatus != null) {
                conditions.put("tstatus", tstatus);
            }
            if (type != null) {
                conditions.put("type", type);
            }
            conditions.put("createStart", createStart);
            conditions.put("createEnd", createEnd);
            Page page = this.templateService.findByConditions(conditions, pageable);
            return this.buildHttpResultW((Iterable)page, new String[]{"maintainers", "creator"});
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u6761\u4ef6\u641c\u7d22\u6240\u6709\u53ef\u7528\u7684\u6a21\u677f\u4fe1\u606f\uff0c\u65e0\u8bba\u662f\u9759\u6001\u6a21\u677f\u8fd8\u662f\u52a8\u6001\u6a21\u677f\uff0c\u652f\u6301\u6a21\u677f\u540d\u79f0\u6a21\u7cca\u67e5\u8be2")
    @RequestMapping(value={"/findAbleByConditions"}, method={RequestMethod.GET})
    public ResponseModel findAbleByConditions(@ApiParam(name="name", value="\u6a21\u677f\u540d\u79f0") String name, @ApiParam(name="cversion", value="\u6a21\u677f\u7248\u672c\u53f7") String cversion, @ApiParam(name="code", value="\u6a21\u677fcode") String code, @PageableDefault(value=50) @ApiParam(name="pageable", value="\u5206\u9875\u53c2\u6570\uff0c\u5f53\u6307\u5b9apage\u65f6\u4e3a\u67e5\u8be2\u5f53\u524d\u9875\u7801\uff08\u9875\u7801\u4ece0\u5f00\u59cb\uff09\uff1b\u5f53\u6307\u5b9asize\u65f6\uff0c\u4e3a\u6307\u5b9a\u6bcf\u9875\u5927\u5c0f\uff0c\u9ed8\u8ba4\u4e3a50") Pageable pageable) {
        try {
            HashMap<String, Object> conditions = new HashMap<String, Object>();
            conditions.put("tstatus", 1);
            if (StringUtils.isNotBlank((CharSequence)name)) {
                conditions.put("name", name);
            }
            if (StringUtils.isNotBlank((CharSequence)cversion)) {
                conditions.put("cversion", cversion);
            }
            if (StringUtils.isNotBlank((CharSequence)code)) {
                conditions.put("code", code);
            }
            Page page = this.templateService.findByConditions(conditions, pageable);
            return this.buildHttpResultW((Iterable)page, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4fdd\u5b58\u4e00\u4e2a\u65b0\u7684\u8868\u5355\u6a21\u677f\uff0c\u56e0\u4e3a\u8868\u5355\u6a21\u677f\u6709\u521d\u59cb\u5316\u8fc7\u7a0b\uff0c\u6240\u4ee5\u8fd9\u91cc\u7684\u4fdd\u5b58\u529f\u80fd\u80af\u5b9a\u90fd\u662f\u4fee\u6539\u529f\u80fd\u3002\u9996\u5148\u5c31\u662f\u8bf4\u8868\u5355\u6a21\u677f\u5bf9\u5e94\u7684\u6a21\u578b\u662f\u4e0d\u80fd\u6539\u53d8\u7684\uff0c\u6240\u4ee5\u8868\u5355\u6a21\u677f\u4fdd\u5b58\u529f\u80fd\u5bf9\u8868\u5355\u6a21\u578b\u65e0\u6548\uff1b\u53e6\u5916\u8868\u5355\u6a21\u677f\u4fdd\u5b58\u529f\u80fd\u4e3b\u8981\u5c31\u662f\u5bf9\u6570\u636e\u6e90\u3001\u4e8b\u4ef6\u3001\u5e03\u5c40\u3001\u53ef\u89c1\u6027\u4fe1\u606f\u8fdb\u884c\u4fee\u6539", notes="\u53e6\u5916\u8868\u5355\u6a21\u677f\u7684\u4fdd\u5b58\u529f\u80fd\u4f1a\u81ea\u52a8\u5224\u65ad\u6570\u636e\u6e90\u3001\u4e8b\u4ef6\u3001\u5e03\u5c40\u3001\u53ef\u89c1\u6027\u7684\u4fe1\u606f\u53d8\u5316\uff0c\u81ea\u884c\u8fdb\u884c\u8fd9\u4e9b\u6570\u636e\u9879\u7684\u65b0\u589e\u3001\u4fee\u6539\u3001\u5220\u9664\u64cd\u4f5c\u3002")
    @RequestMapping(value={""}, method={RequestMethod.PATCH})
    public ResponseModel update(@RequestBody @ApiParam(name="template", value="\u65b0\u7684\u8868\u5355\u6a21\u677f\u4fe1\u606f\uff0c\u5fc5\u987b\u81f3\u5c11\u5305\u62ec\u3001\u6570\u636e\u6e90\u3001\u4e8b\u4ef6\u3001\u5e03\u5c40\u3001\u53ef\u89c1\u6027\u7b49\u4fe1\u606f\uff0c\u53e6\u5916\u6ce8\u610f\uff0c\u5728\u6dfb\u52a0\u662f\u8868\u5355\u6a21\u677f\u7684id\uff08\u4e3b\u952e\u4fe1\u606f\uff09\u5fc5\u987b\u4f20\u5165") TemplateEntity template) {
        try {
            TemplateEntity result = this.templateService.update(template);
            return this.buildHttpResultW(result, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u8be5\u65b9\u6cd5\u8bbe\u5b9a\u6307\u5b9a\u7684\u8868\u5355\u6a21\u677f\u7248\u672c\u4e3a\u8fd9\u4e2a\u8868\u5355code\u4e0b\u552f\u4e00\u9ed8\u8ba4\u7684\u8868\u5355\u6a21\u677f\u3002", notes="\u8be5\u65b9\u6cd5\u8bbe\u5b9a\u6307\u5b9a\u7684\u8868\u5355\u6a21\u677f\u7248\u672c\u4e3a\u8fd9\u4e2a\u8868\u5355code\u4e0b\u552f\u4e00\u9ed8\u8ba4\u7684\u8868\u5355\u6a21\u677f\u3002\u5728\u8868\u5355\u6a21\u677f\u7684\u4fe1\u606f\u4e2d\uff0c\u76f8\u540ccode\u4e0b\u53ea\u6709\u4e00\u4e2a\u6307\u5b9a\u7684\u7248\u672c\u53ef\u4ee5\u662f\u9ed8\u8ba4\u7684\u7248\u672c\u53f7\uff08\u4e5f\u5c31\u662fdefaultVersion\u5c5e\u6027\u4e3atrue\uff09")
    @RequestMapping(value={"/updateDefaultVersion"}, method={RequestMethod.PATCH})
    public ResponseModel updateDefaultVersion(@ApiParam(name="templateId", value="\u6307\u5b9a\u7684\u7248\u672c\u4fe1\u606f") @RequestParam(name="templateId") String templateId) {
        try {
            this.templateService.updateDefaultVersion(templateId);
            return this.buildHttpResult();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u66f4\u65b0\u6a21\u677f\u72b6\u6001\u4fe1\u606f\uff0c\u5982\u679c\u5f53\u524d\u6a21\u677f\u88ab\u7981\u7528\uff0c\u90a3\u4e48\u5c31\u4e0d\u80fd\u7ee7\u7eed\u4f7f\u7528\u8be5\u6a21\u677f\u521b\u5efa\u8868\u5355\u5b9e\u4f8b\u4e86", notes="\u53e6\u4e00\u4e2a\u65b9\u9762\u662f\uff0c\u67d0\u4e00\u4e2a\u6a21\u677f\u7f16\u53f7\u4e0b\u7684\u9ed8\u8ba4\u7248\u672c\u4e0d\u5141\u8bb8\u88ab\u7981\u7528")
    @RequestMapping(value={"/updateStatusById"}, method={RequestMethod.PATCH})
    public ResponseModel updateStatusById(@ApiParam(name="templateId", value="\u6307\u5b9a\u7684\u6a21\u677f\u7f16\u53f7") @RequestParam(name="templateId") String templateId, @ApiParam(name="tstatus", value="\u72b6\u6001\u7b261\uff1a\u6b63\u5e38\uff1b0\uff1a\u7981\u7528/\u5e9f\u9664") @RequestParam(name="tstatus") Integer tstatus) {
        try {
            this.templateService.updateStatusById(templateId, tstatus);
            return this.buildHttpResult();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5bfc\u5165\u6a21\u677f")
    @RequestMapping(value={"/getTemplateRemote"}, method={RequestMethod.GET})
    public ResponseModel importTemplate(@RequestParam(name="templateEntityId") @ApiParam(value="templateEntityId") String templateEntityId) {
        try {
            JSONArray templateJsonArray = this.templateService.importTemplate(templateEntityId);
            return this.buildHttpResultW((Collection)templateJsonArray, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

