/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.controller;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.kuiper.entity.TemplateLayoutEntity;
import com.bizunited.platform.kuiper.starter.controller.TemplateVisibilityController;
import com.bizunited.platform.kuiper.starter.service.TemplateLayoutService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="TemplateLayoutController")
@RestController
@RequestMapping(value={"/v1/kuiper/templateLayouts"})
class TemplateLayoutController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplateVisibilityController.class);
    @Autowired
    private TemplateLayoutService templateLayoutService;

    TemplateLayoutController() {
    }

    @ApiOperation(value="\u6839\u636e\u6307\u5b9a\u6a21\u677f\u67e5\u8be2\u8868\u5355\u5e03\u5c40")
    @RequestMapping(value={"/findDetailsByTemplateId"}, method={RequestMethod.GET})
    public ResponseModel findDetailsByTemplateId(@ApiParam(name="templateId", value="\u6a21\u677f\u7f16\u53f7") @RequestParam(value="templateId") String templateId, @ApiParam(name="layoutType", value="\u5e03\u5c40\u7c7b\u578b\uff1a1.PC\u7aef\uff1b2.mobile\u7aef\uff1b3.print\u7aef \uff08\u53ef\u4ee5\u4e0d\u4f20\u5165\uff0c\u5982\u679c\u4e0d\u4f20\u5165\u5219\u9ed8\u8ba4\u67e5\u8be2\u5b9a\u4e49\u7684PC\u7aef\u6837\u5f0f\uff09", required=false) @RequestParam(name="layoutType", required=false) Integer layoutType) {
        try {
            JSONObject layout = this.templateLayoutService.findDetailsByTemplateId(templateId, layoutType);
            return this.buildHttpResult(layout);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u6a21\u677f\u7f16\u53f7\u4fdd\u5b58\u5f53\u524d\u6a21\u677f\u7684\u5404\u79cd\u7c7b\u578b\u7684\u5e03\u5c40\u4fe1\u606f", notes="\u9ed8\u8ba4\u60c5\u51b5\u4e0b\u5e76\u4e0d\u63a8\u8350\u4f7f\u7528\u8be5\u65b9\u6cd5\u8fdb\u884c\u521b\u5efa/\u66f4\u65b0\u64cd\u4f5c")
    @RequestMapping(value={""}, method={RequestMethod.POST, RequestMethod.PATCH})
    public ResponseModel save(@ApiParam(name="templateId", value="\u6a21\u677f\u7f16\u53f7") @RequestParam(value="templateId") String templateId, @ApiParam(name="layoutType", value="\u5e03\u5c40\u7c7b\u578b\uff1a1.PC\u7aef\uff1b2.mobile\u7aef\uff1b3.print\u7aef") @RequestParam(value="layoutType") Integer layoutType, @ApiParam(name="layout", value="\u6a21\u677f\u5e03\u5c40\u7684json\u7ed3\u6784") @RequestBody JSONObject layout) throws IOException {
        try {
            TemplateLayoutEntity result = this.templateLayoutService.save(templateId, layoutType, layout);
            return this.buildHttpResult(result);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

