/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.controller;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.kuiper.starter.service.migrate.TemplateMigrateExportService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.UUID;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="TemplateMigrateController")
@RestController
@RequestMapping(value={"/v1/kuiper/migrateExports"})
public class TemplateMigrateExportController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplateMigrateExportController.class);
    @Autowired
    private TemplateMigrateExportService templateMigrateExportService;

    @ApiOperation(value="\u5bfc\u51fa\u6307\u5b9a\u6570\u636e\u7f16\u53f7\u7684\u5217\u8868\u6a21\u677f\u548c\u8868\u5355\u6a21\u677f\u4fe1\u606f\uff0c\u5305\u62ec\u6a21\u677f\u7684\u5168\u90e8\u5173\u8054\u4fe1\u606f\uff0c\u4ee5\u53ca\u76f8\u5173\u9644\u4ef6\u4fe1\u606f")
    @RequestMapping(value={"export"}, method={RequestMethod.GET})
    public void export(@ApiParam(name="templateFormIds", value="\u9700\u8981\u5bfc\u51fa\u8868\u5355\u6a21\u677f\u6570\u636e\u7f16\u53f7\u4fe1\u606f", required=false) @RequestParam(name="templateFormIds", required=false) String[] templateFormIds, @ApiParam(name="listTemplateIds", value="\u9700\u8981\u5bfc\u51fa\u5217\u8868\u6a21\u677f\u6570\u636e\u7f16\u53f7\u4fe1\u606f", required=false) @RequestParam(name="listTemplateIds", required=false) String[] listTemplateIds, @ApiParam(name="frontFileIds", value="\u9700\u8981\u5bfc\u51fa\u7684\u524d\u7aef\u5934\u51fd\u6570\u4fe1\u606f", required=false) @RequestParam(name="frontFileIds", required=false) String[] frontFileIds, @ApiParam(name="exportItems", value="\u5bfc\u51fa\u7684\u8868\u5355\u6a21\u677f\u652f\u6301\u8fc7\u6ee4\u7279\u5b9a\u7684\u6a21\u677f\u7c7b\u578b\uff08\u4f8b\u5982\u4e0d\u5bfc\u51fa\u67d0\u4e2a\u8868\u5355\u6a21\u677f\u6253\u5370\u6a21\u677f\uff09\uff0c\u8fd9\u91cc\u8bf4\u660e\u8fd9\u4e9b\u6a21\u677f\u7684\u5bfc\u51fa\u8bbe\u5b9a", required=false) @RequestParam(name="exportItems", required=false) Boolean[] exportItems, HttpServletRequest request, HttpServletResponse response) {
        try {
            byte[] result = this.templateMigrateExportService.export(templateFormIds, listTemplateIds, frontFileIds, exportItems);
            if (result == null || result.length == 0) {
                throw new IllegalArgumentException("\u6ca1\u6709\u4efb\u4f55\u4e0b\u8f7d\u4fe1\u606f\uff0c\u5f88\u5927\u51e0\u7387\u539f\u56e0\u662f\u5bfc\u51fa\u903b\u8f91\u51fa\u73b0\u9519\u8bef!!");
            }
            String fileName = StringUtils.join((Object[])new String[]{UUID.randomUUID().toString(), ".zip"});
            this.writeResponseFile(request, response, result, fileName);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            this.printErrorMessage(this.buildHttpResultForException(e), response);
        }
    }

    private void printErrorMessage(ResponseModel errorMessage, HttpServletResponse response) {
        response.setContentType("application/json;charset=UTF-8");
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            out.write(JSONObject.toJSONString((Object)errorMessage).getBytes());
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }
}

