/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.controller;

import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.kuiper.entity.TemplateMigrateImportAnalysisEntity;
import com.bizunited.platform.kuiper.starter.service.migrate.TemplateMigrateImportAnalysisService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="TemplateMigrateImportAnalysisController")
@RestController
@RequestMapping(value={"/v1/formengine/migrationImportAnalysis"})
public class TemplateMigrateImportAnalysisController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplateMigrateImportAnalysisController.class);
    @Autowired
    private TemplateMigrateImportAnalysisService templateMigrateImportAnalysisService;

    @ApiOperation(value="\u6839\u636e\u4e0a\u4f20\u6587\u4ef6\u8bb0\u5f55ID\uff0c\u67e5\u8be2\u8be5\u4e0a\u4f20\u8bb0\u5f55\u5173\u8054\u7684\u9884\u5148\u5206\u6790\u7ed3\u679c")
    @RequestMapping(value={"/findByImportId"}, method={RequestMethod.GET})
    public ResponseModel findByImportId(@RequestParam(name="templateMigrateImportId") @ApiParam(name="templateMigrateImportId", value="\u4e0a\u4f20\u8bb0\u5f55ID") String templateMigrateImportId) {
        try {
            List<TemplateMigrateImportAnalysisEntity> analysisEntities = this.templateMigrateImportAnalysisService.findByImport(templateMigrateImportId);
            return this.buildHttpResultW(analysisEntities, new String[]{"templateMigrateImportEntity", "executor", "analysisItemEntities"});
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u9884\u5206\u6790ID\uff0c\u67e5\u8be2\u8be5\u9884\u5206\u6790\u7ed3\u679c\uff0c\u5305\u542b\u672c\u6b21\u5206\u6790\u6a21\u677f\u660e\u7ec6")
    @RequestMapping(value={"/findDetailById"}, method={RequestMethod.GET})
    public ResponseModel findDetailById(@RequestParam(name="analysisId") @ApiParam(name="analysisId", value="\u9884\u5206\u6790ID") String analysisId) {
        try {
            TemplateMigrateImportAnalysisEntity analysisEntity = this.templateMigrateImportAnalysisService.findDetailById(analysisId);
            return this.buildHttpResultW(analysisEntity, new String[]{"templateMigrateImportEntity", "executor", "analysisItemEntities"});
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u4e0a\u4f20\u6587\u4ef6\u8bb0\u5f55ID\uff0c\u6267\u884c\u9884\u5206\u6790\uff0c\u5e76\u4fdd\u5b58\u5206\u6790\u7ed3\u679c")
    @RequestMapping(value={"/analysis"}, method={RequestMethod.POST})
    public ResponseModel analysis(@RequestParam(name="templateMigrateImportId") @ApiParam(name="templateMigrateImportId", value="\u4e0a\u4f20\u8bb0\u5f55ID") String templateMigrateImportId) {
        try {
            TemplateMigrateImportAnalysisEntity analysisEntity = this.templateMigrateImportAnalysisService.analysis(templateMigrateImportId);
            return this.buildHttpResultW(analysisEntity, new String[]{"templateMigrateImportEntity", "executor", "analysisItemEntities"});
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

