/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.controller;

import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.kuiper.entity.TemplateVisibilityEntity;
import com.bizunited.platform.kuiper.starter.service.TemplateVisibilityService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="TemplateVisibilityController")
@RestController
@RequestMapping(value={"/v1/kuiper/templatevisibilities"})
class TemplateVisibilityController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplateVisibilityController.class);
    @Autowired
    private TemplateVisibilityService templateVisibilityService;
    private static final String[] FILTERS_PROPERTIES = new String[]{"template", "attributes", "buttons"};

    TemplateVisibilityController() {
    }

    @ApiOperation(value="\u6839\u636e\u6307\u5b9a\u6a21\u677f\u67e5\u8be2\u53ef\u89c1\u6027")
    @RequestMapping(value={"/findDetailsByTemplateId"}, method={RequestMethod.GET})
    public ResponseModel findDetailsByTemplateId(@ApiParam(name="templateId", value="\u6a21\u677fid") @RequestParam(value="templateId") String templateId) {
        try {
            Set<TemplateVisibilityEntity> templateVisibility = this.templateVisibilityService.findDetailsByTemplateId(templateId);
            return this.buildHttpResultW(templateVisibility, FILTERS_PROPERTIES);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u6307\u5b9a\u6a21\u677f\u548c\u5e03\u5c40\u67e5\u8be2\u53ef\u89c1\u6027")
    @RequestMapping(value={"/findDetailsByTemplateIdAndLayoutType"}, method={RequestMethod.GET})
    public ResponseModel findDetailsByTemplateIdAndLayoutType(@RequestParam @ApiParam(value="\u6a21\u677fid") String templateId, @RequestParam(defaultValue="1") @ApiParam(value="\u5e03\u5c40 1\uff1aPC\u30012\uff1a\u79fb\u52a8\u7aef\u30013\uff1a\u6253\u5370\u7aef", required=true) Integer layoutType) {
        try {
            Set<TemplateVisibilityEntity> templateVisibility = this.templateVisibilityService.findDetailsByTemplateIdAndLayoutType(templateId, layoutType);
            return this.buildHttpResultW(templateVisibility, FILTERS_PROPERTIES);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u6307\u5b9a\u6a21\u677f\u3001\u53ef\u89c1\u6027\u540d\u79f0\u548c\u5e03\u5c40\u67e5\u8be2\u53ef\u89c1\u6027")
    @RequestMapping(value={"/findDetailsByTemplateIdAndVisibilityNameAndLayoutType"}, method={RequestMethod.GET})
    public ResponseModel findDetailsByTemplateIdAndVisibilityNameAndLayoutType(@RequestParam @ApiParam(value="\u6a21\u677fid", required=true) String templateId, @RequestParam @ApiParam(value="\u53ef\u89c1\u6027\u540d\u79f0", required=true) String visibilityName, @RequestParam(defaultValue="1") @ApiParam(value="\u5e03\u5c40 1\uff1aPC\u30012\uff1a\u79fb\u52a8\u7aef\u30013\uff1a\u6253\u5370\u7aef", required=true) Integer layoutType) {
        try {
            TemplateVisibilityEntity visibility = this.templateVisibilityService.findDetailsByTemplateIdAndVisibilityNameAndLayoutType(templateId, visibilityName, layoutType);
            return this.buildHttpResultW(visibility, FILTERS_PROPERTIES);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

