/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.repository;

import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.starter.repository.internal.TemplateRepositoryCustom;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository(value="TemplateRepository")
public interface TemplateRepository
extends JpaRepository<TemplateEntity, String>,
JpaSpecificationExecutor<TemplateEntity>,
TemplateRepositoryCustom {
    @Modifying
    @Query(value="update engine_form_template set default_version = 1 where code = :templateCode and cversion = :cversion", nativeQuery=true)
    public void updateDefaultVersion(@Param(value="templateCode") String var1, @Param(value="cversion") String var2);

    @Modifying
    @Query(value="update engine_form_template set default_version = 0 where code = :templateCode", nativeQuery=true)
    public void updateDefaultVersion(@Param(value="templateCode") String var1);

    @Modifying
    @Query(value="delete from engine_form_template where engine_form_template.id = :templateId", nativeQuery=true)
    public void deleteByTemplateId(@Param(value="templateId") String var1);

    public TemplateEntity findByCodeAndCversion(String var1, String var2);

    @Query(value="from TemplateEntity te where te.code = :code order by te.createTime desc ")
    public List<TemplateEntity> findByCode(@Param(value="code") String var1);

    @Query(value="select distinct template from TemplateEntity template  left join fetch template.creator c  left join fetch template.properties p  left join fetch template.relations r  where template.id = :id ")
    public TemplateEntity findDetailsById(@Param(value="id") String var1);

    public List<TemplateEntity> findByFormStyle(String var1);

    @Query(value="select count(*) from engine_form_template where id in (:ids) ", nativeQuery=true)
    public int countByIds(@Param(value="ids") String[] var1);
}

