/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.entity.UserEntity;
import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.entity.TemplateEventEntity;
import com.bizunited.platform.kuiper.entity.TemplateLayoutEntity;
import com.bizunited.platform.kuiper.entity.TemplateVisibilityEntity;
import com.bizunited.platform.kuiper.starter.repository.TemplateRepository;
import com.bizunited.platform.kuiper.starter.service.TemplateEventService;
import com.bizunited.platform.kuiper.starter.service.TemplateLayoutService;
import com.bizunited.platform.kuiper.starter.service.TemplateVisibilityService;
import com.bizunited.platform.rbac.server.service.UserService;
import com.bizunited.platform.rbac.server.vo.UserVo;
import java.io.IOException;
import java.security.Principal;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractTemplateService {
    @Autowired
    private UserService userService;
    @Autowired
    private TemplateRepository templateRepository;
    @Autowired
    private TemplateLayoutService templateLayoutService;
    @Autowired
    private TemplateEventService templateEventService;
    @Autowired
    private TemplateVisibilityService templateVisibilityService;

    protected void saveTemplate(TemplateEntity template, Principal principal) {
        Date currentTime = new Date();
        template.setCreateTime(currentTime);
        template.setDefaultVersion(Boolean.valueOf(false));
        template.setDomain(template.getDomain() == null ? "" : template.getDomain());
        template.setPorjectName(template.getPorjectName() == null ? "" : template.getPorjectName());
        UserVo creator = this.userService.findByAccount(principal.getName());
        Validate.notNull((Object)creator, (String)"\u6ca1\u6709\u627e\u5230\u4efb\u4f55\u521b\u5efa\u8005\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        UserEntity creatore = new UserEntity();
        creatore.setId(creator.getId());
        template.setCreator(creatore);
        this.templateRepository.save(template);
        this.templateRepository.flush();
    }

    protected void upgradeTemplateLayout(String templateId, String newTemplateId, TemplateEntity newTemplate) {
        try {
            TemplateLayoutEntity newLayout;
            JSONObject templateLayout = this.templateLayoutService.findDetailsByTemplateId(templateId, 1);
            if (templateLayout != null) {
                newLayout = this.templateLayoutService.save(newTemplateId, 1, templateLayout);
                newTemplate.setTemplateLayout((Object)newLayout);
            }
            if ((templateLayout = this.templateLayoutService.findDetailsByTemplateId(templateId, 2)) != null) {
                newLayout = this.templateLayoutService.save(newTemplateId, 2, templateLayout);
                newTemplate.setMobileTemplateLayout((Object)newLayout);
            }
            if ((templateLayout = this.templateLayoutService.findDetailsByTemplateId(templateId, 3)) != null) {
                newLayout = this.templateLayoutService.save(newTemplateId, 3, templateLayout);
                newTemplate.setPrintTemplateLayout((Object)newLayout);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected void upgradeTemplateEvent(String templateId, String newTemplateId, TemplateEntity newTemplate) {
        List<TemplateEventEntity> templateEvents = this.templateEventService.findByTemplateId(templateId);
        if (templateEvents != null && !templateEvents.isEmpty()) {
            Set<TemplateEventEntity> newTemplateEvents = this.templateEventService.upgrade(newTemplateId, templateEvents);
            newTemplate.setEvent(newTemplateEvents);
        }
    }

    protected void upgradeTemplateVisibility(String templateId, String newTemplateId, TemplateEntity newTemplate) {
        Set<TemplateVisibilityEntity> templateVisibilities = this.templateVisibilityService.findDetailsByTemplateId(templateId);
        if (templateVisibilities != null && !templateVisibilities.isEmpty()) {
            Set<TemplateVisibilityEntity> newTemplateVisibilities = this.templateVisibilityService.upgrade(newTemplateId, templateVisibilities);
            newTemplate.setVisibility(newTemplateVisibilities);
        }
    }
}

