/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.internal;

import com.bizunited.platform.core.service.file.NebulaFileService;
import com.bizunited.platform.kuiper.entity.DynamicTemplateDraftEntity;
import com.bizunited.platform.kuiper.starter.repository.DynamicTemplateDraftRepository;
import com.bizunited.platform.kuiper.starter.service.DynamicTemplateDraftService;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.persistence.criteria.Predicate;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service(value="DynamicTemplateDraftServiceImpl")
public class DynamicTemplateDraftServiceImpl
implements DynamicTemplateDraftService {
    private static final String JSON_FILE_SUFFIX = "json";
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicTemplateDraftServiceImpl.class);
    @Autowired
    private DynamicTemplateDraftRepository dynamicTemplateDraftRepository;
    @Autowired
    private NebulaFileService nebulaFileService;

    @Override
    public void createValidation(DynamicTemplateDraftEntity dynamicTemplateDraftEntity) {
        Validate.notNull((Object)dynamicTemplateDraftEntity, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)dynamicTemplateDraftEntity.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        dynamicTemplateDraftEntity.setId(null);
        Validate.notBlank((CharSequence)dynamicTemplateDraftEntity.getCode(), (String)"\u4e1a\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dynamicTemplateDraftEntity.getName(), (String)"\u4e1a\u52a1\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dynamicTemplateDraftEntity.getTableName(), (String)"\u52a8\u6001\u6a21\u677f\u8bbe\u5b9a\u7684\u6570\u636e\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dynamicTemplateDraftEntity.getCversion(), (String)"\u7248\u672c\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((dynamicTemplateDraftEntity.getCode() == null || dynamicTemplateDraftEntity.getCode().length() < 255 ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u540d/\u4e1a\u52a1\u7f16\u53f7,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dynamicTemplateDraftEntity.getTableName() == null || dynamicTemplateDraftEntity.getTableName().length() < 255 ? 1 : 0) != 0, (String)"\u52a8\u6001\u6a21\u677f\u8bbe\u5b9a\u7684\u6570\u636e\u8868\u540d,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dynamicTemplateDraftEntity.getCversion() == null || dynamicTemplateDraftEntity.getCversion().length() < 255 ? 1 : 0) != 0, (String)"\u7248\u672c\u53f7,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        DynamicTemplateDraftEntity currentDynamicTemplateDraftEntity = this.dynamicTemplateDraftRepository.findByCode(dynamicTemplateDraftEntity.getCode());
        Validate.isTrue((currentDynamicTemplateDraftEntity == null ? 1 : 0) != 0, (String)"\u8be5\u4e1a\u52a1\u540d/\u4e1a\u52a1\u7f16\u53f7\u7684\u8349\u7a3f\u5df2\u5b58\u5728,\u8bf7\u5728\u8349\u7a3f\u4e0a\u7f16\u8f91", (Object[])new Object[0]);
        currentDynamicTemplateDraftEntity = this.dynamicTemplateDraftRepository.findByTableName(dynamicTemplateDraftEntity.getTableName());
        Validate.isTrue((currentDynamicTemplateDraftEntity == null ? 1 : 0) != 0, (String)"\u8be5\u8868\u540d\u7684\u8349\u7a3f\u5df2\u5b58\u5728,\u8bf7\u5728\u8349\u7a3f\u4e0a\u7f16\u8f91", (Object[])new Object[0]);
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public DynamicTemplateDraftEntity create(DynamicTemplateDraftEntity dynamicTemplateDraftEntity, String json) {
        byte[] jsonContent;
        this.createValidation(dynamicTemplateDraftEntity);
        Validate.notBlank((CharSequence)json, (String)"\u52a8\u6001\u6a21\u677f\u7684\u8349\u7a3fjson\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Date nowDate = new Date();
        String folderName = new SimpleDateFormat("yyyyMMdd").format(nowDate);
        String renameImage = UUID.randomUUID().toString();
        String fileRename = renameImage + "." + JSON_FILE_SUFFIX;
        String relativePath = StringUtils.join((Object[])new Serializable[]{"/draft/", folderName, "/", Integer.valueOf(new Random().nextInt(100) % 10)});
        try {
            jsonContent = json.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        this.nebulaFileService.saveFile(relativePath, fileRename, fileRename, jsonContent);
        dynamicTemplateDraftEntity.setCreateTime(nowDate);
        dynamicTemplateDraftEntity.setModifyTime(nowDate);
        dynamicTemplateDraftEntity.setFileCode(relativePath);
        dynamicTemplateDraftEntity.setFileName(fileRename);
        this.dynamicTemplateDraftRepository.save(dynamicTemplateDraftEntity);
        return dynamicTemplateDraftEntity;
    }

    @Override
    @Transactional
    public DynamicTemplateDraftEntity update(DynamicTemplateDraftEntity dynamicTemplateDraft, String json) {
        byte[] jsonContent;
        Validate.notNull((Object)dynamicTemplateDraft, (String)"\u672a\u80fd\u83b7\u53d6\u5230\u63d0\u4ea4\u7684\u8349\u7a3f\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dynamicTemplateDraft.getId(), (String)"\u8349\u7a3f\u7684id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)json, (String)"\u52a8\u6001\u6a21\u677f\u7684\u8349\u7a3fjson\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String id = dynamicTemplateDraft.getId();
        DynamicTemplateDraftEntity dynamicTemplateDraftEntity = this.findDetailsById(id);
        Validate.notNull((Object)dynamicTemplateDraftEntity, (String)"\u8349\u7a3f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        this.updateValidate(dynamicTemplateDraft);
        try {
            jsonContent = json.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        String fileName = dynamicTemplateDraftEntity.getFileName();
        this.nebulaFileService.saveFile(dynamicTemplateDraftEntity.getFileCode(), fileName, fileName, jsonContent);
        dynamicTemplateDraftEntity.setModifyTime(new Date());
        if (StringUtils.isNotBlank((CharSequence)dynamicTemplateDraft.getCode())) {
            dynamicTemplateDraftEntity.setCode(dynamicTemplateDraft.getCode());
        }
        if (StringUtils.isNotBlank((CharSequence)dynamicTemplateDraft.getTableName())) {
            dynamicTemplateDraftEntity.setTableName(dynamicTemplateDraft.getTableName());
        }
        if (StringUtils.isNotBlank((CharSequence)dynamicTemplateDraft.getCversion())) {
            dynamicTemplateDraftEntity.setCversion(dynamicTemplateDraft.getCversion());
        }
        if (StringUtils.isNotBlank((CharSequence)dynamicTemplateDraft.getName())) {
            dynamicTemplateDraftEntity.setName(dynamicTemplateDraft.getName());
        }
        this.dynamicTemplateDraftRepository.save(dynamicTemplateDraftEntity);
        return dynamicTemplateDraftEntity;
    }

    private void updateValidate(DynamicTemplateDraftEntity dynamicTemplateDraft) {
        Long count;
        if (StringUtils.isNotBlank((CharSequence)dynamicTemplateDraft.getCode())) {
            count = this.dynamicTemplateDraftRepository.countByCodeWithoutId(dynamicTemplateDraft.getId(), dynamicTemplateDraft.getCode());
            Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u7f16\u53f7\u5df2\u5b58\u5728", (Object[])new Object[0]);
        }
        if (StringUtils.isNotBlank((CharSequence)dynamicTemplateDraft.getTableName())) {
            count = this.dynamicTemplateDraftRepository.countByTableNameWithoutId(dynamicTemplateDraft.getId(), dynamicTemplateDraft.getTableName());
            Validate.isTrue((count == 0L ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u8868\u540d\u5df2\u5b58\u5728", (Object[])new Object[0]);
        }
    }

    @Override
    public DynamicTemplateDraftEntity findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.dynamicTemplateDraftRepository.findDetailsById(id);
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        Optional op = this.dynamicTemplateDraftRepository.findById(id);
        DynamicTemplateDraftEntity current = op.orElse(null);
        Validate.notNull((Object)current, (String)"\u5220\u9664\u7684\u6a21\u7248\u8349\u7a3f\u5bf9\u8c61\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        this.dynamicTemplateDraftRepository.delete(current);
        this.nebulaFileService.deleteFile(current.getFileCode(), current.getFileName(), current.getFileName());
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void deleteByCode(String code) {
        Validate.notBlank((CharSequence)code, (String)"\u4e1a\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DynamicTemplateDraftEntity draftEntity = this.dynamicTemplateDraftRepository.findByCode(code);
        if (draftEntity == null) {
            return;
        }
        this.dynamicTemplateDraftRepository.delete(draftEntity);
        this.nebulaFileService.deleteFile(draftEntity.getFileCode(), draftEntity.getFileName(), draftEntity.getFileName());
    }

    @Override
    public Page<DynamicTemplateDraftEntity> findByConditions(Pageable pageable, String tableName) {
        Sort sort = new Sort(Sort.Direction.DESC, new String[]{"modifyTime"});
        pageable = PageRequest.of((int)pageable.getPageNumber(), (int)pageable.getPageSize(), (Sort)sort);
        PageRequest pageRequest = (PageRequest)pageable;
        Specification & Serializable specification = (Specification & Serializable)(root, query, cb) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (StringUtils.isNotBlank((CharSequence)tableName)) {
                Predicate predicate = cb.equal(root.get("tableName").as(String.class), (Object)tableName);
                predicates.add(predicate);
            }
            return cb.and(predicates.toArray(new Predicate[0]));
        };
        return this.dynamicTemplateDraftRepository.findAll(specification, (Pageable)pageRequest);
    }

    @Override
    public String findJsonById(String id) {
        String json;
        Validate.notBlank((CharSequence)id, (String)"ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DynamicTemplateDraftEntity result = this.findDetailsById(id);
        Validate.notNull((Object)result, (String)"\u672a\u627e\u5230\u6a21\u7248\u8349\u7a3f", (Object[])new Object[0]);
        byte[] bytes = this.nebulaFileService.readFileContent(result.getFileCode(), result.getFileName());
        try {
            json = new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        return json;
    }
}

