/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.service.file.NebulaFileService;
import com.bizunited.platform.kuiper.entity.FrontFileEntity;
import com.bizunited.platform.kuiper.starter.repository.FrontFileRepository;
import com.bizunited.platform.kuiper.starter.service.FrontFileSevice;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service(value="FrontFileServiceImpl")
public class FrontFileServiceImpl
implements FrontFileSevice {
    @Autowired
    private NebulaFileService nebulaFileService;
    @Autowired
    private FrontFileRepository frontFileRepository;

    @Override
    @Transactional
    public FrontFileEntity create(String frontFileEntityStr, String fileContent) {
        FrontFileEntity entity;
        Validate.notBlank((CharSequence)frontFileEntityStr, (String)"\u524d\u7aef\u6587\u4ef6\u5b9e\u4f53json\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)fileContent, (String)"\u524d\u7aef\u6587\u4ef6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        try {
            JSONObject json = JSONObject.parseObject((String)frontFileEntityStr);
            entity = (FrontFileEntity)JSONObject.toJavaObject((JSON)json, FrontFileEntity.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        Validate.notNull((Object)entity, (String)"\u524d\u7aef\u6587\u4ef6json\u8f6c\u5316\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getName(), (String)"\u524d\u7aef\u6587\u4ef6\u5b9e\u4f53\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        FrontFileEntity existNameEntity = this.frontFileRepository.findByName(entity.getName());
        Validate.isTrue((null == existNameEntity ? 1 : 0) != 0, (String)"\u5b58\u5728\u91cd\u590d\u540d\u79f0\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Date nowDate = new Date();
        String folderName = new SimpleDateFormat("yyyyMMdd").format(nowDate);
        String uuid = UUID.randomUUID().toString();
        String fileRename = uuid + ".txt";
        String relativePath = StringUtils.join((Object[])new Serializable[]{"/frontFile/", folderName, "/", Integer.valueOf(new Random().nextInt(100) % 10)});
        byte[] content = fileContent.getBytes(StandardCharsets.UTF_8);
        this.nebulaFileService.saveFile(relativePath, fileRename, fileRename, content);
        entity.setFilePath(relativePath);
        entity.setFileName(fileRename);
        entity.setCreateTime(new Date());
        entity.setFileStatus(Integer.valueOf(0));
        return (FrontFileEntity)this.frontFileRepository.save(entity);
    }

    @Override
    @Transactional
    public FrontFileEntity update(String frontFileEntityStr, String fileContent) {
        FrontFileEntity entity;
        Validate.notBlank((CharSequence)frontFileEntityStr, (String)"\u524d\u7aef\u6587\u4ef6\u5b9e\u4f53json\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)fileContent, (String)"\u524d\u7aef\u6587\u4ef6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        try {
            JSONObject json = JSONObject.parseObject((String)frontFileEntityStr);
            entity = (FrontFileEntity)JSONObject.toJavaObject((JSON)json, FrontFileEntity.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        Validate.notNull((Object)entity, (String)"\u524d\u7aef\u6587\u4ef6json\u8f6c\u5316\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getId(), (String)"\u66f4\u65b0\u65f6\uff0c\u524d\u7aef\u6587\u4ef6\u5b9e\u4f53ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Optional op = this.frontFileRepository.findById(entity.getId());
        FrontFileEntity existEntity = op.orElse(null);
        Validate.notNull((Object)existEntity, (String)"\u672a\u6839\u636eID\u627e\u5230\u73b0\u6709\u5b9e\u4f53\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getName(), (String)"\u524d\u7aef\u6587\u4ef6\u5b9e\u4f53\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)entity.getFileStatus(), (String)"\u524d\u7aef\u6587\u4ef6\u5b9e\u4f53\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Date nowDate = new Date();
        String folderName = new SimpleDateFormat("yyyyMMdd").format(nowDate);
        String uuid = UUID.randomUUID().toString();
        String fileRename = uuid + ".txt";
        String relativePath = StringUtils.join((Object[])new Serializable[]{"/frontFile/", folderName, "/", Integer.valueOf(new Random().nextInt(100) % 10)});
        byte[] content = fileContent.getBytes(StandardCharsets.UTF_8);
        this.nebulaFileService.saveFile(relativePath, fileRename, fileRename, content);
        existEntity.setFilePath(relativePath);
        existEntity.setFileName(fileRename);
        existEntity.setName(entity.getName());
        existEntity.setFileClassify(entity.getFileClassify());
        existEntity.setFileDesc(existEntity.getFileDesc());
        return (FrontFileEntity)this.frontFileRepository.save(existEntity);
    }

    @Override
    public FrontFileEntity saveEntity(FrontFileEntity frontFileEntity) {
        Validate.notNull((Object)frontFileEntity, (String)"\u524d\u7aef\u6587\u4ef6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)frontFileEntity.getId()), (String)"\u524d\u7aef\u6587\u4ef6\u65b0\u5efa\u65f6ID\u5fc5\u987b\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)frontFileEntity.getName(), (String)"\u524d\u7aef\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        FrontFileEntity existName = this.frontFileRepository.findByName(frontFileEntity.getName());
        Validate.isTrue((null == existName ? 1 : 0) != 0, (String)"\u524d\u7aef\u6587\u4ef6\u540d\u4e0d\u80fd\u91cd\u590d\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)frontFileEntity.getFilePath(), (String)"\u524d\u7aef\u6587\u4ef6\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)frontFileEntity.getFileName(), (String)"\u524d\u7aef\u6587\u4ef6\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)frontFileEntity.getFileStatus(), (String)"\u524d\u7aef\u6587\u4ef6\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        frontFileEntity.setCreateTime(new Date());
        return (FrontFileEntity)this.frontFileRepository.save(frontFileEntity);
    }

    @Override
    public FrontFileEntity updateEntity(FrontFileEntity frontFileEntity) {
        Validate.notNull((Object)frontFileEntity, (String)"\u524d\u7aef\u6587\u4ef6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)frontFileEntity.getId()), (String)"\u66f4\u65b0\u6587\u4ef6\u65b0\u5efa\u65f6ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        FrontFileEntity existFront = (FrontFileEntity)this.frontFileRepository.findById(frontFileEntity.getId()).get();
        Validate.notNull((Object)existFront, (String)"\u524d\u7aef\u6587\u4ef6\u6839\u636eID\u67e5\u8be2\u4e0d\u5230\u4fe1\u606f\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)frontFileEntity.getName(), (String)"\u524d\u7aef\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (!StringUtils.equals((CharSequence)frontFileEntity.getName(), (CharSequence)existFront.getName())) {
            FrontFileEntity existName = this.frontFileRepository.findByName(frontFileEntity.getName());
            Validate.isTrue((existName == null ? 1 : 0) != 0, (String)"\u4fee\u6539\u540e\u7684\u524d\u7aef\u6587\u4ef6\u540d\u5df2\u91cd\u590d\uff0c\u8bf7\u4fee\u6539", (Object[])new Object[0]);
        }
        existFront.setName(frontFileEntity.getName());
        existFront.setFileClassify(frontFileEntity.getFileClassify());
        existFront.setFileDesc(frontFileEntity.getFileDesc());
        existFront.setFilePath(frontFileEntity.getFilePath());
        existFront.setFileName(frontFileEntity.getFileName());
        existFront.setCreateTime(frontFileEntity.getCreateTime());
        existFront.setFileStatus(frontFileEntity.getFileStatus());
        return (FrontFileEntity)this.frontFileRepository.save(existFront);
    }

    @Override
    @Transactional
    public FrontFileEntity disable(String frontFileId) {
        Validate.notBlank((CharSequence)frontFileId, (String)"\u4f20\u5165\u524d\u7aef\u6587\u4ef6ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Optional op = this.frontFileRepository.findById(frontFileId);
        FrontFileEntity entity = op.orElse(null);
        Validate.notNull((Object)entity, (String)"\u67e5\u8be2\u524d\u7aef\u6587\u4ef6\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        entity.setFileStatus(Integer.valueOf(1));
        return (FrontFileEntity)this.frontFileRepository.save(entity);
    }

    @Override
    @Transactional
    public FrontFileEntity enable(String frontFileId) {
        Validate.notBlank((CharSequence)frontFileId, (String)"\u4f20\u5165\u524d\u7aef\u6587\u4ef6ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Optional op = this.frontFileRepository.findById(frontFileId);
        FrontFileEntity entity = op.orElse(null);
        Validate.notNull((Object)entity, (String)"\u67e5\u8be2\u524d\u7aef\u6587\u4ef6\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        entity.setFileStatus(Integer.valueOf(0));
        return (FrontFileEntity)this.frontFileRepository.save(entity);
    }

    @Override
    @Transactional
    public void deleteByName(String frontFileName) {
        FrontFileEntity frontFileEntity = this.frontFileRepository.findByName(frontFileName);
        if (null == frontFileEntity) {
            return;
        }
        this.frontFileRepository.delete(frontFileEntity);
        this.frontFileRepository.flush();
        this.nebulaFileService.deleteFile(frontFileEntity.getFilePath(), frontFileEntity.getFileName(), frontFileEntity.getFileName());
    }

    @Override
    public String findContentById(String frontFileId) {
        Validate.notBlank((CharSequence)frontFileId, (String)"\u4f20\u5165\u524d\u7aef\u6587\u4ef6ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Optional op = this.frontFileRepository.findById(frontFileId);
        FrontFileEntity entity = op.orElse(null);
        Validate.notNull((Object)entity, (String)"\u67e5\u8be2\u524d\u7aef\u6587\u4ef6\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        byte[] content = this.nebulaFileService.readFileContent(entity.getFilePath(), entity.getFileName());
        return new String(content, StandardCharsets.UTF_8);
    }

    @Override
    public String findContentByName(String frontFileName) {
        Validate.notBlank((CharSequence)frontFileName, (String)"\u4f20\u5165\u524d\u7aef\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        FrontFileEntity entity = this.frontFileRepository.findByName(frontFileName);
        if (null == entity) {
            return null;
        }
        byte[] content = this.nebulaFileService.readFileContent(entity.getFilePath(), entity.getFileName());
        if (null != content) {
            return new String(content, StandardCharsets.UTF_8);
        }
        return "";
    }

    @Override
    public FrontFileEntity findByName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        return this.frontFileRepository.findByName(name);
    }

    @Override
    public FrontFileEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.frontFileRepository.findById(id).orElse(null);
    }

    @Override
    public Page<FrontFileEntity> queryPage(Pageable pageable, String name, String fileClassify, Integer fileStatus) {
        Validate.notNull((Object)pageable, (String)"\u5206\u9875\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        HashMap<String, Object> conditions = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            conditions.put("name", name);
        }
        if (StringUtils.isNotBlank((CharSequence)fileClassify)) {
            conditions.put("fileClassify", fileClassify);
        }
        if (null != fileStatus) {
            conditions.put("fileStatus", fileStatus);
        }
        return this.frontFileRepository.queryPage(pageable, conditions);
    }

    @Override
    public int countByIds(String[] ids) {
        if (ids == null || ids.length == 0) {
            return 0;
        }
        return this.frontFileRepository.countByIds(ids);
    }
}

