/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.internal;

import com.bizunited.platform.kuiper.entity.InstanceContextEntity;
import com.bizunited.platform.kuiper.entity.InstanceEntity;
import com.bizunited.platform.kuiper.service.InstanceService;
import com.bizunited.platform.kuiper.starter.repository.InstanceContextRepository;
import com.bizunited.platform.kuiper.starter.service.InstanceContextService;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="InstanceContextServiceImpl")
public class InstanceContextServiceImpl
implements InstanceContextService {
    @Autowired
    private InstanceContextRepository instanceContextRepository;
    @Autowired
    private InstanceService instanceService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<InstanceContextEntity> save(String instanceId, List<InstanceContextEntity> contexts) {
        Validate.notBlank((CharSequence)instanceId, (String)"instanceId is blank", (Object[])new Object[0]);
        InstanceEntity instance = this.instanceService.findById(instanceId);
        Validate.notNull((Object)instance, (String)"not found instance", (Object[])new Object[0]);
        if (CollectionUtils.isEmpty(contexts)) {
            return this.findByInstanceId(instanceId);
        }
        List<InstanceContextEntity> oldContexts = this.findByInstanceId(instanceId);
        HashSet<String> names = new HashSet<String>();
        Map oldContextsMap = oldContexts.stream().collect(Collectors.toMap(InstanceContextEntity::getName, item -> item, (a, b) -> b, () -> new HashMap(16)));
        for (InstanceContextEntity context : contexts) {
            Validate.notNull((Object)context.getName(), (String)"name not be null", (Object[])new Object[0]);
            Validate.notNull((Object)context.getValue(), (String)"value not be null", (Object[])new Object[0]);
            Validate.isTrue((!names.contains(context.getName()) ? 1 : 0) != 0, (String)"\u6709\u91cd\u590d\u7684name\u503c\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (Object[])new Object[0]);
            names.add(context.getName());
            InstanceContextEntity oldContext = (InstanceContextEntity)oldContextsMap.get(context.getName());
            if (oldContext != null) {
                oldContext.setValue(context.getValue());
                oldContext.setModifyTime(new Date());
                this.instanceContextRepository.save(oldContext);
                continue;
            }
            context.setCreateTime(new Date());
            context.setModifyTime(new Date());
            context.setInstance(instance);
            this.instanceContextRepository.save(context);
            oldContexts.add(context);
        }
        return oldContexts;
    }

    @Override
    public List<InstanceContextEntity> findByInstanceId(String instanceId) {
        if (StringUtils.isBlank((CharSequence)instanceId)) {
            return null;
        }
        return this.instanceContextRepository.findByInstanceId(instanceId);
    }

    @Override
    public InstanceContextEntity findByInstanceIdAndName(String instanceId, String name) {
        if (StringUtils.isBlank((CharSequence)instanceId) || StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        return this.instanceContextRepository.findByInstanceContextIdAndName(instanceId, name);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByInstanceIdAndName(String instanceId, String name) {
        Validate.notBlank((CharSequence)instanceId, (String)"\u8868\u5355\u5b9e\u4f8bID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)name, (String)"name\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        InstanceContextEntity instanceContext = this.instanceContextRepository.findByInstanceContextIdAndName(instanceId, name);
        if (instanceContext != null) {
            this.instanceContextRepository.delete(instanceContext);
        }
    }
}

