/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.entity.UserEntity;
import com.bizunited.platform.core.service.file.NebulaFileService;
import com.bizunited.platform.kuiper.entity.ListTemplateEntity;
import com.bizunited.platform.kuiper.starter.repository.ListTemplateRepository;
import com.bizunited.platform.kuiper.starter.service.KuiperToolkitService;
import com.bizunited.platform.kuiper.starter.service.ListTemplateService;
import com.bizunited.platform.rbac.server.service.UserService;
import com.bizunited.platform.rbac.server.vo.UserVo;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.Principal;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service(value="ListTemplateEntityServiceImpl")
public class ListTemplateServiceImpl
implements ListTemplateService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListTemplateServiceImpl.class);
    @Autowired
    private NebulaFileService nebulaFileService;
    @Autowired
    private UserService userService;
    @Autowired
    @Qualifier(value="KuiperToolkitService")
    private KuiperToolkitService kuiperToolkitService;
    @Autowired
    private ListTemplateRepository listTemplateEntityRepository;
    private static final String LAYOUTDIR = "/listTemplate/layout";
    private static final String EXTENDTYPE = ".txt";

    @Override
    @Transactional
    public ListTemplateEntity init(ListTemplateEntity listTemplateEntity, Principal principal) {
        String userName = principal.getName();
        Validate.notBlank((CharSequence)userName, (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u7528\u6237\u540d\u4fe1\u606f", (Object[])new Object[0]);
        UserVo creatorv = this.userService.findByAccount(userName);
        Validate.notNull((Object)creatorv, (String)"\u9519\u8bef\u7684\u521b\u5efa\u4eba\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        UserEntity creator = (UserEntity)this.kuiperToolkitService.copyObjectByWhiteList(creatorv, UserEntity.class, LinkedHashSet.class, LinkedList.class, new String[0]);
        listTemplateEntity.setCreator(creator);
        return this.initForm(listTemplateEntity);
    }

    private ListTemplateEntity initForm(ListTemplateEntity listTemplateEntity) {
        this.createValidation(listTemplateEntity);
        Long countByCode = this.listTemplateEntityRepository.countByCode(listTemplateEntity.getCode());
        if (null == countByCode || countByCode == 0L) {
            listTemplateEntity.setDefaultVersion(Boolean.valueOf(true));
        } else {
            listTemplateEntity.setDefaultVersion(Boolean.valueOf(false));
        }
        this.listTemplateEntityRepository.save(listTemplateEntity);
        return listTemplateEntity;
    }

    private void createValidation(ListTemplateEntity listTemplate) {
        Validate.notNull((Object)listTemplate, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)listTemplate.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        listTemplate.setId(null);
        Validate.notBlank((CharSequence)listTemplate.getCode(), (String)"\u5217\u8868\u6a21\u677f\u7684\u552f\u4e00\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)listTemplate.getCversion(), (String)"\u5217\u8868\u6a21\u677f\u7248\u672c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)listTemplate.getName(), (String)"\u5217\u8868\u6a21\u677f\u7684\u4e2d\u6587\u8bf4\u660e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        listTemplate.setTstatus(Integer.valueOf(1));
        if (listTemplate.getDatesource() == null) {
            listTemplate.setDatesource(Integer.valueOf(2));
        }
        listTemplate.setCreateTime(new Date());
        ListTemplateEntity exsit = this.listTemplateEntityRepository.findByCodeAndCversion(listTemplate.getCode(), listTemplate.getCversion());
        Validate.isTrue((exsit == null ? 1 : 0) != 0, (String)"\u5f53\u524d\u6307\u5b9a\u7f16\u53f7\u3010%s\u3011\uff0c\u6307\u5b9a\u7248\u672c\u4e0b\u3010%s\u3011\u7684\u5217\u8868\u6a21\u677f\u4fe1\u606f\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{listTemplate.getCode(), listTemplate.getCversion()});
        Validate.isTrue((listTemplate.getCode() == null || listTemplate.getCode().length() < 128 ? 1 : 0) != 0, (String)"\u5217\u8868\u6a21\u677f\u7684\u552f\u4e00\u7f16\u53f7,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((listTemplate.getPorjectName() == null || listTemplate.getPorjectName().length() < 128 ? 1 : 0) != 0, (String)"\u9879\u76ee\u540d,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((listTemplate.getCversion() == null || listTemplate.getCversion().length() < 64 ? 1 : 0) != 0, (String)"\u4e0d\u540c\u7684\u7248\u672c\u4fe1\u606f,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((listTemplate.getName() == null || listTemplate.getName().length() < 128 ? 1 : 0) != 0, (String)"\u5217\u8868\u6a21\u677f\u7684\u4e2d\u6587\u8bf4\u660e,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((listTemplate.getRelativePath() == null || listTemplate.getRelativePath().length() < 256 ? 1 : 0) != 0, (String)"\u5217\u8868\u6a21\u677f\u6587\u4ef6\u7684\u76f8\u5bf9\u76ee\u5f55,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(256)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((listTemplate.getFileName() == null || listTemplate.getFileName().length() < 256 ? 1 : 0) != 0, (String)"\u4fdd\u5b58\u7684\u5217\u8868\u6a21\u677f\u5e03\u5c40\u6587\u4ef6\u6587\u4ef6\u540d,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(256)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public ListTemplateEntity update(ListTemplateEntity listTemplateEntity) {
        return this.updateForm(listTemplateEntity);
    }

    private ListTemplateEntity updateForm(ListTemplateEntity listTemplateEntity) {
        this.updateValidation(listTemplateEntity);
        String currentId = listTemplateEntity.getId();
        Optional op = this.listTemplateEntityRepository.findById(currentId);
        ListTemplateEntity currentListTemplateEntity = op.orElse(null);
        Validate.notNull((Object)currentListTemplateEntity, (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]);
        currentListTemplateEntity.setCode(listTemplateEntity.getCode());
        currentListTemplateEntity.setPorjectName(listTemplateEntity.getPorjectName());
        currentListTemplateEntity.setCversion(listTemplateEntity.getCversion());
        currentListTemplateEntity.setName(listTemplateEntity.getName());
        currentListTemplateEntity.setTstatus(listTemplateEntity.getTstatus());
        currentListTemplateEntity.setDatesource(listTemplateEntity.getDatesource());
        currentListTemplateEntity.setRelativePath(listTemplateEntity.getRelativePath());
        currentListTemplateEntity.setFileName(listTemplateEntity.getFileName());
        this.listTemplateEntityRepository.saveAndFlush(currentListTemplateEntity);
        return currentListTemplateEntity;
    }

    private void updateValidation(ListTemplateEntity listTemplateEntity) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)listTemplateEntity.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)listTemplateEntity.getCode(), (String)"\u5217\u8868\u6a21\u677f\u7684\u552f\u4e00\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)listTemplateEntity.getCversion(), (String)"\u4e0d\u540c\u7684\u7248\u672c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)listTemplateEntity.getName(), (String)"\u5217\u8868\u6a21\u677f\u7684\u4e2d\u6587\u8bf4\u660e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)listTemplateEntity.getTstatus(), (String)"\u5217\u8868\u6a21\u677f\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)listTemplateEntity.getDatesource(), (String)"\u6570\u636e\u6e90\u7c7b\u578b\uff1a1\u3001\u670d\u52a1\u6e90\uff1b2\u3001\u6570\u636e\u89c6\u56fe\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((listTemplateEntity.getCode() == null || listTemplateEntity.getCode().length() < 128 ? 1 : 0) != 0, (String)"\u5217\u8868\u6a21\u677f\u7684\u552f\u4e00\u7f16\u53f7,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((listTemplateEntity.getPorjectName() == null || listTemplateEntity.getPorjectName().length() < 128 ? 1 : 0) != 0, (String)"\u9879\u76ee\u540d,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((listTemplateEntity.getCversion() == null || listTemplateEntity.getCversion().length() < 64 ? 1 : 0) != 0, (String)"\u4e0d\u540c\u7684\u7248\u672c\u4fe1\u606f,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((listTemplateEntity.getName() == null || listTemplateEntity.getName().length() < 128 ? 1 : 0) != 0, (String)"\u5217\u8868\u6a21\u677f\u7684\u4e2d\u6587\u8bf4\u660e,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    private byte[] writeObjectToBytes(Object obj) {
        byte[] bytes = null;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();
             ObjectOutputStream sOut = new ObjectOutputStream(out);){
            sOut.writeObject(obj);
            sOut.flush();
            bytes = out.toByteArray();
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new byte[0];
        }
        return bytes;
    }

    private JSONObject readBytesToJson(byte[] bytes) {
        Object layoutObject = null;
        try (ByteArrayInputStream in = new ByteArrayInputStream(bytes);
             ObjectInputStream sIn = new ObjectInputStream(in);){
            layoutObject = sIn.readObject();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
        if (layoutObject == null) {
            return null;
        }
        return JSON.parseObject((String)JSON.toJSONString((Object)layoutObject));
    }

    @Override
    @Transactional
    public ListTemplateEntity updateContentById(String id, JSONObject content) {
        Validate.notBlank((CharSequence)id, (String)"\u66f4\u65b0\u5217\u8868\u6a21\u677f\u5185\u5bb9\u65f6\uff0c\u5217\u8868\u6a21\u677f\u7f16\u53f7\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.notNull((Object)content, (String)"\u66f4\u65b0\u5217\u8868\u6a21\u677f\u5185\u5bb9\u65f6\uff0cJSON\u7ed3\u6784\u7684\u5185\u5bb9\u672c\u8eab\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        String relativePath = LAYOUTDIR;
        String fileName = StringUtils.join((Object[])new String[]{id, EXTENDTYPE});
        byte[] objectContents = this.writeObjectToBytes(content);
        this.nebulaFileService.saveFile(relativePath, fileName, fileName, objectContents);
        Optional op = this.listTemplateEntityRepository.findById(id);
        ListTemplateEntity listTemplate = op.orElse(null);
        Validate.notNull((Object)listTemplate, (String)"\u9519\u8bef\u7684\u5217\u8868\u6a21\u677f\u7f16\u53f7\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        listTemplate.setFileName(fileName);
        listTemplate.setRelativePath(relativePath);
        this.listTemplateEntityRepository.save(listTemplate);
        return listTemplate;
    }

    @Override
    public JSONObject findContentById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.listTemplateEntityRepository.findById(id);
        Validate.isTrue((boolean)op.isPresent(), (String)"\u9519\u8bef\u7684\u5217\u8868\u6a21\u677f\u7f16\u53f7\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String relativePath = LAYOUTDIR;
        String fileName = StringUtils.join((Object[])new String[]{id, EXTENDTYPE});
        byte[] contentBytes = this.nebulaFileService.readFileContent(relativePath, fileName);
        Validate.notNull((Object)contentBytes, (String)"\u672a\u8bfb\u53d6\u5230\u6307\u5b9a\u5217\u8868\u6a21\u677f\u7684\u5e03\u5c40\u63cf\u8ff0\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{id});
        return this.readBytesToJson(contentBytes);
    }

    @Override
    public Set<ListTemplateEntity> findDetailsByCreator(String creator) {
        if (StringUtils.isBlank((CharSequence)creator)) {
            return Sets.newHashSet();
        }
        return this.listTemplateEntityRepository.findDetailsByCreator(creator);
    }

    @Override
    public ListTemplateEntity findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.listTemplateEntityRepository.findDetailsById(id);
    }

    @Override
    public Set<ListTemplateEntity> findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return Sets.newHashSet();
        }
        return this.listTemplateEntityRepository.findByCode(code);
    }

    @Override
    public ListTemplateEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.listTemplateEntityRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    public Page<ListTemplateEntity> findByConditions(Pageable pageable, Map<String, Object> conditions) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        return this.listTemplateEntityRepository.findByConditions(pageable, conditions);
    }

    @Override
    public int countByIds(String[] ids) {
        if (ids == null || ids.length == 0) {
            return 0;
        }
        return this.listTemplateEntityRepository.countByIds(ids);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        Optional op = this.listTemplateEntityRepository.findById(id);
        op.ifPresent(listTemplateEntity -> this.listTemplateEntityRepository.delete(listTemplateEntity));
    }

    @Override
    public JSONObject findContentByCodeAndCversion(String code, String cversion) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        ListTemplateEntity templateEntity = this.listTemplateEntityRepository.findDetailsByCodeAndCversion(code, cversion);
        Validate.notNull((Object)templateEntity, (String)"\u9519\u8bef\u7684\u5217\u8868\u6a21\u677f\u7f16\u53f7\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String relativePath = LAYOUTDIR;
        String fileName = StringUtils.join((Object[])new String[]{templateEntity.getId(), EXTENDTYPE});
        byte[] contentBytes = this.nebulaFileService.readFileContent(relativePath, fileName);
        Validate.notNull((Object)contentBytes, (String)"\u672a\u8bfb\u53d6\u5230\u6307\u5b9a\u5217\u8868\u6a21\u677f\u7684\u5e03\u5c40\u63cf\u8ff0\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{code});
        return this.readBytesToJson(contentBytes);
    }

    @Override
    @Transactional
    public ListTemplateEntity updateContentByCodeAndCversion(String code, String cversion, JSONObject content) {
        Validate.notBlank((CharSequence)code, (String)"\u66f4\u65b0\u5217\u8868\u6a21\u677f\u5185\u5bb9\u65f6\uff0c\u5217\u8868\u6a21\u677f\u7f16\u7801\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)cversion, (String)"\u66f4\u65b0\u5217\u8868\u6a21\u677f\u5185\u5bb9\u65f6\uff0c\u5217\u8868\u6a21\u677f\u7248\u672c\u53f7\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.notNull((Object)content, (String)"\u66f4\u65b0\u5217\u8868\u6a21\u677f\u5185\u5bb9\u65f6\uff0cJSON\u7ed3\u6784\u7684\u5185\u5bb9\u672c\u8eab\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        ListTemplateEntity templateEntity = this.listTemplateEntityRepository.findDetailsByCodeAndCversion(code, cversion);
        Validate.notNull((Object)templateEntity, (String)"\u9519\u8bef\u7684\u5217\u8868\u6a21\u677f\u7f16\u53f7\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String relativePath = LAYOUTDIR;
        String fileName = StringUtils.join((Object[])new String[]{templateEntity.getId(), EXTENDTYPE});
        byte[] objectContents = this.writeObjectToBytes(content);
        this.nebulaFileService.saveFile(relativePath, fileName, fileName, objectContents);
        templateEntity.setFileName(fileName);
        templateEntity.setRelativePath(relativePath);
        this.listTemplateEntityRepository.save(templateEntity);
        return templateEntity;
    }

    @Override
    public JSONObject findDefaultContentByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        ListTemplateEntity templateEntity = this.listTemplateEntityRepository.findDefaultByCode(code);
        Validate.notNull((Object)templateEntity, (String)"\u9519\u8bef\u7684\u5217\u8868\u6a21\u677f\u7f16\u53f7\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String relativePath = LAYOUTDIR;
        String fileName = StringUtils.join((Object[])new String[]{templateEntity.getId(), EXTENDTYPE});
        byte[] contentBytes = this.nebulaFileService.readFileContent(relativePath, fileName);
        Validate.notNull((Object)contentBytes, (String)"\u672a\u8bfb\u53d6\u5230\u6307\u5b9a\u5217\u8868\u6a21\u677f\u7684\u5e03\u5c40\u63cf\u8ff0\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{code});
        return this.readBytesToJson(contentBytes);
    }

    @Override
    @Transactional
    public void updateDefaultVersion(String code, String cversion) {
        Validate.notBlank((CharSequence)code, (String)"\u66f4\u65b0\u5217\u8868\u6a21\u677f\u5185\u5bb9\u65f6\uff0c\u5217\u8868\u6a21\u677f\u7f16\u7801\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)cversion, (String)"\u66f4\u65b0\u5217\u8868\u6a21\u677f\u5185\u5bb9\u65f6\uff0c\u5217\u8868\u6a21\u677f\u7248\u672c\u53f7\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        ListTemplateEntity detailsByCode = this.listTemplateEntityRepository.findDetailsByCodeAndCversion(code, cversion);
        Validate.notNull((Object)detailsByCode, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u5217\u8868\u6a21\u677f\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((detailsByCode.getTstatus() == 1 ? 1 : 0) != 0, (String)"\u5f53\u524d\u6307\u5b9a\u6a21\u677f\u7684\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\uff08\u6a21\u677f\u72b6\u6001\u4e0d\u80fd\u4e3a\u7981\u7528\uff09!", (Object[])new Object[0]);
        this.listTemplateEntityRepository.updateDefaultVersion(code, Boolean.FALSE);
        this.listTemplateEntityRepository.updateDefaultVersion(code, cversion, Boolean.TRUE);
    }

    @Override
    public ListTemplateEntity findDefaultByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return this.listTemplateEntityRepository.findDefaultByCode(code);
    }
}

