/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.internal;

import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.entity.TemplateGroupEntity;
import com.bizunited.platform.kuiper.entity.TemplateItemEntity;
import com.bizunited.platform.kuiper.entity.TemplatePropertyEntity;
import com.bizunited.platform.kuiper.entity.TemplateRelationEntity;
import com.bizunited.platform.kuiper.starter.repository.TemplateItemRepository;
import com.bizunited.platform.kuiper.starter.repository.TemplatePropertyRepository;
import com.bizunited.platform.kuiper.starter.repository.TemplateRelationRepository;
import com.bizunited.platform.kuiper.starter.service.TemplateItemService;
import com.bizunited.platform.saturn.model.PersistentClass;
import com.bizunited.platform.saturn.model.PersistentProperty;
import com.bizunited.platform.saturn.model.PersistentRelation;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="TemplateItemServiceImpl")
public class TemplateItemServiceImpl
implements TemplateItemService {
    @Autowired
    private TemplateItemRepository templateItemRepository;
    @Autowired
    private TemplatePropertyRepository templatePropertyRepository;
    @Autowired
    private TemplateRelationRepository templateRelationRepository;

    @Override
    @Transactional
    public TemplateItemEntity initStaticItems(TemplateEntity parentTemplate, TemplateGroupEntity parentGroup, PersistentRelation parentRelation, PersistentClass persistentClass) {
        List relations;
        String parentClassName = parentRelation.getPersistentClassName();
        TemplateItemEntity templateItem = new TemplateItemEntity();
        templateItem.setPropertyClassName(persistentClass.getClassName());
        String propertyName = parentRelation.getPropertyName();
        Validate.notBlank((CharSequence)propertyName, (String)"\u660e\u7ec6\u9879\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((propertyName.length() <= 64 ? 1 : 0) != 0, (String)"\u5c5e\u6027\u540d[%s]\u7684\u957f\u5ea6\u9700\u8981\u5c0f\u4e8e64\u4e2a\u5b57\u7b26\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{propertyName});
        templateItem.setParentClassName(parentClassName);
        templateItem.setPkage(persistentClass.getPkage());
        templateItem.setRepositoryEntity(persistentClass.getRepositoryEntity());
        templateItem.setSimpleClassName(persistentClass.getSimpleClassName());
        templateItem.setType("static");
        templateItem.setParentTableName("");
        templateItem.setTableName("");
        templateItem.setParentTemplate(parentTemplate);
        templateItem.setParentGroup(parentGroup);
        templateItem.setId(null);
        templateItem.setParentTableName("");
        templateItem.setQueryService("");
        templateItem.setPropertyDesc(parentRelation.getPropertyDesc());
        templateItem.setPropertyName(propertyName);
        this.templateItemRepository.save(templateItem);
        Set<TemplatePropertyEntity> templateProperties = this.initStaticProperties(persistentClass, persistentClass.getProperties());
        templateItem.setProperties(templateProperties);
        if (templateProperties != null && !templateProperties.isEmpty()) {
            templateProperties.stream().forEach(item -> item.setCurrentItem(templateItem));
            this.templatePropertyRepository.saveAll(templateProperties);
            templateItem.setProperties(templateProperties);
        }
        if ((relations = persistentClass.getRelations()) == null || relations.isEmpty()) {
            return templateItem;
        }
        List<PersistentRelation> currentRelations = relations.stream().filter(item -> item.getRelationType() == PersistentRelation.RelationType.ManyToOne || item.getRelationType() == PersistentRelation.RelationType.ManyToMany).collect(Collectors.toList());
        Set<TemplateRelationEntity> templateRelations = this.initStaticRelations(parentClassName, persistentClass, currentRelations);
        templateItem.setRelations(templateRelations);
        if (templateRelations != null && !templateRelations.isEmpty()) {
            templateRelations.stream().forEach(item -> item.setCurrentItem(templateItem));
            this.templateRelationRepository.saveAll(templateRelations);
            templateItem.setRelations(templateRelations);
        }
        return templateItem;
    }

    private Set<TemplateRelationEntity> initStaticRelations(String parentClassName, PersistentClass persistentClass, List<PersistentRelation> persistentRelations) {
        LinkedHashSet<TemplateRelationEntity> templateRelations = new LinkedHashSet<TemplateRelationEntity>();
        for (PersistentRelation persistentRelationItem : persistentRelations) {
            TemplateRelationEntity relationModel = new TemplateRelationEntity();
            relationModel.setCanInsert(persistentRelationItem.getCanInsert());
            relationModel.setCanUpdate(persistentRelationItem.getCanUpdate());
            relationModel.setIndex(persistentRelationItem.getIndex());
            relationModel.setNullable(persistentRelationItem.getNullable());
            relationModel.setPropertyClassName(persistentRelationItem.getPropertyClass());
            String propertyDbName = persistentRelationItem.getPropertyDbName() == null ? "" : persistentRelationItem.getPropertyDbName();
            Validate.isTrue((propertyDbName.length() <= 64 ? 1 : 0) != 0, (String)"\u5982\u586b\u5199\u5b57\u6bb5\u7684\u6570\u636e\u5e93\u5c5e\u6027[%s]\uff0c\u5176\u957f\u5ea6\u5e94\u8be5\u5c0f\u4e8e64\u4e2a\u5b57\u7b26\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{propertyDbName});
            relationModel.setPropertyDbName(propertyDbName);
            relationModel.setPropertyDesc(persistentRelationItem.getPropertyDesc());
            String propertyName = persistentRelationItem.getPropertyName();
            Validate.notBlank((CharSequence)propertyName, (String)"\u660e\u7ec6\u9879\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Validate.isTrue((propertyName.length() <= 64 ? 1 : 0) != 0, (String)"\u5c5e\u6027\u540d[%s]\u7684\u957f\u5ea6\u9700\u8981\u5c0f\u4e8e64\u4e2a\u5b57\u7b26\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{propertyName});
            relationModel.setPropertyName(propertyName);
            relationModel.setRelationType(persistentRelationItem.getRelationType().toString());
            if (StringUtils.equals((CharSequence)parentClassName, (CharSequence)persistentRelationItem.getPropertyClass())) {
                relationModel.setBackProperty(Boolean.valueOf(true));
            } else {
                relationModel.setBackProperty(Boolean.valueOf(false));
            }
            relationModel.setCurrentView(null);
            relationModel.setTargetTableName("");
            templateRelations.add(relationModel);
        }
        return templateRelations;
    }

    private Set<TemplatePropertyEntity> initStaticProperties(PersistentClass persistentClass, List<PersistentProperty> persistentProperties) {
        LinkedHashSet<TemplatePropertyEntity> templateProperties = new LinkedHashSet<TemplatePropertyEntity>();
        for (PersistentProperty persistentProperty : persistentProperties) {
            TemplatePropertyEntity propertyEntity = new TemplatePropertyEntity();
            propertyEntity.setCanInsert(persistentProperty.getCanInsert());
            propertyEntity.setCanUpdate(persistentProperty.getCanUpdate());
            propertyEntity.setUnique(persistentProperty.getUnique());
            propertyEntity.setIndex(persistentProperty.getIndex());
            propertyEntity.setNullable(persistentProperty.getNullable());
            propertyEntity.setPrimaryKey(persistentProperty.getPrimaryKey());
            propertyEntity.setPropertyClassName(persistentProperty.getPropertyClass());
            String propertyDbName = persistentProperty.getPropertyDbName() == null ? "" : persistentProperty.getPropertyDbName();
            Validate.isTrue((propertyDbName.length() <= 64 ? 1 : 0) != 0, (String)"\u5982\u586b\u5199\u5b57\u6bb5\u7684\u6570\u636e\u5e93\u5c5e\u6027[%s]\uff0c\u5176\u957f\u5ea6\u5e94\u8be5\u5c0f\u4e8e64\u4e2a\u5b57\u7b26\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{propertyDbName});
            propertyEntity.setPropertyDbName(propertyDbName);
            propertyEntity.setPropertyDesc(persistentProperty.getPropertyDesc());
            String propertyName = persistentProperty.getPropertyName();
            Validate.notBlank((CharSequence)propertyName, (String)"\u660e\u7ec6\u9879\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Validate.isTrue((propertyName.length() <= 64 ? 1 : 0) != 0, (String)"\u5c5e\u6027\u540d[%s]\u7684\u957f\u5ea6\u9700\u8981\u5c0f\u4e8e64\u4e2a\u5b57\u7b26\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{propertyName});
            propertyEntity.setPropertyName(propertyName);
            propertyEntity.setDefaultKeys(persistentProperty.getDefaultKeys());
            propertyEntity.setDefaultValues(persistentProperty.getDefaultValues());
            propertyEntity.setDefaultController(persistentProperty.getDefaultType() != null ? persistentProperty.getDefaultType().toString() : "");
            propertyEntity.setMaxLen(persistentProperty.getMaxLen());
            templateProperties.add(propertyEntity);
        }
        return templateProperties;
    }

    @Override
    @Transactional
    public TemplateItemEntity initDynamicItems(TemplateItemEntity templateItem, TemplateEntity parentTemplate, TemplateGroupEntity parentGroup, String parentTableName) {
        templateItem.setId(null);
        templateItem.setParentGroup(parentGroup);
        templateItem.setParentTemplate(parentTemplate);
        templateItem.setParentTableName(parentTableName);
        templateItem.setPkage("");
        templateItem.setQueryService("");
        templateItem.setParentClassName("");
        templateItem.setSimpleClassName("");
        this.templateItemRepository.save(templateItem);
        this.initDynamicProperties(templateItem);
        this.initDynamicRelations(templateItem);
        return templateItem;
    }

    @Override
    public TemplateItemEntity findDetailsById(String templateItemId) {
        Validate.notBlank((CharSequence)templateItemId, (String)"\u67e5\u8be2\u6a21\u7248\u660e\u7ec6ID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        return this.templateItemRepository.findDetailsById(templateItemId);
    }

    @Override
    public TemplateItemEntity findParentById(String templateItemId) {
        if (StringUtils.isBlank((CharSequence)templateItemId)) {
            return null;
        }
        return this.templateItemRepository.findParentById(templateItemId);
    }

    private void initDynamicProperties(TemplateItemEntity templateItem) {
        Set templateProperties = templateItem.getProperties();
        for (TemplatePropertyEntity templateProperty : templateProperties) {
            templateProperty.setId(null);
            templateProperty.setCurrentGroup(null);
            templateProperty.setCurrentItem(templateItem);
            templateProperty.setCurrentTemplate(null);
            this.templatePropertyRepository.save(templateProperty);
        }
    }

    private void initDynamicRelations(TemplateItemEntity templateItem) {
        Set templateRelations = templateItem.getRelations();
        if (templateRelations != null && !templateRelations.isEmpty()) {
            for (TemplateRelationEntity templateRelation : templateRelations) {
                templateRelation.setCurrentGroup(null);
                templateRelation.setCurrentItem(templateItem);
                templateRelation.setCurrentTemplate(null);
                templateRelation.setId(null);
                templateRelation.setQueryService("");
                this.templateRelationRepository.save(templateRelation);
            }
        }
    }
}

