/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.internal;

import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.service.TemplateService;
import com.bizunited.platform.kuiper.starter.repository.TemplateMaintainerRepository;
import com.bizunited.platform.kuiper.starter.service.TemplateMaintainerService;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="TemplateMaintainerServiceImpl")
public class TemplateMaintainerServiceImpl
implements TemplateMaintainerService {
    @Autowired
    private TemplateService templateService;
    @Autowired
    private TemplateMaintainerRepository templateMaintainerRepository;

    @Override
    @Transactional
    public void binding(String code, String[] maintainerIds, String[] maintainerAccounts, Principal principal) {
        Validate.notBlank((CharSequence)code, (String)"\u6388\u6743\u65f6\uff0c\u6307\u5b9a\u7684\u6a21\u677fcode\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        String account = principal.getName();
        Validate.notBlank((CharSequence)account, (String)"\u672a\u80fd\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        if (maintainerAccounts == null || maintainerAccounts.length == 0) {
            maintainerAccounts = new String[]{"admin"};
        }
        List maintainerAccountList = Arrays.stream(maintainerAccounts).map(String::trim).collect(Collectors.toList());
        Validate.isTrue((boolean)maintainerAccountList.contains(account), (String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u6388\u6743\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!!", (Object[])new Object[0]);
        Validate.notNull((Object)maintainerIds, (String)"\u672a\u6307\u5b9a\u7ef4\u62a4\u4eba\u5458\u4fe1\u606f\uff0c\u8bf7\u9009\u62e9\u7ef4\u62a4\u4eba\u5458!!", (Object[])new Object[0]);
        Validate.isTrue((maintainerIds.length > 0 ? 1 : 0) != 0, (String)"\u672a\u6307\u5b9a\u7ef4\u62a4\u4eba\u5458\u4fe1\u606f\uff0c\u8bf7\u9009\u62e9\u7ef4\u62a4\u4eba\u5458!!", (Object[])new Object[0]);
        List dbTemplates = this.templateService.findByCode(code);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)dbTemplates) ? 1 : 0) != 0, (String)"\u6839\u636e\u6307\u5b9a\u7684\u6a21\u677fcode\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u6a21\u677f\u4fe1\u606f!!", (Object[])new Object[0]);
        for (TemplateEntity template : dbTemplates) {
            this.templateMaintainerRepository.unbindingByTemplateId(template.getId());
        }
        for (String maintainerId : maintainerIds) {
            for (TemplateEntity template : dbTemplates) {
                this.templateMaintainerRepository.binding(template.getId(), maintainerId);
            }
        }
    }
}

