/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.internal;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.entity.TemplateEventEntity;
import com.bizunited.platform.kuiper.entity.TemplateGroupEntity;
import com.bizunited.platform.kuiper.entity.TemplateItemEntity;
import com.bizunited.platform.kuiper.entity.TemplateLayoutEntity;
import com.bizunited.platform.kuiper.entity.TemplatePropertyEntity;
import com.bizunited.platform.kuiper.entity.TemplateRelationEntity;
import com.bizunited.platform.kuiper.service.TemplateService;
import com.bizunited.platform.kuiper.starter.repository.TemplateGroupRepository;
import com.bizunited.platform.kuiper.starter.repository.TemplateItemRepository;
import com.bizunited.platform.kuiper.starter.repository.TemplateRepository;
import com.bizunited.platform.kuiper.starter.service.KuiperToolkitService;
import com.bizunited.platform.kuiper.starter.service.TemplateEventService;
import com.bizunited.platform.kuiper.starter.service.TemplateLayoutService;
import com.bizunited.platform.kuiper.starter.service.TemplateVisibilityService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="TemplateServiceImpl")
public class TemplateServiceImpl
implements TemplateService {
    @Autowired
    private TemplateRepository templateRepository;
    @Autowired
    private TemplateGroupRepository templateGroupRepository;
    @Autowired
    private TemplateItemRepository templateItemRepository;
    @Autowired
    private TemplateEventService templateEventService;
    @Autowired
    private TemplateVisibilityService templateVisibilityService;
    @Autowired
    private TemplateLayoutService templateLayoutService;
    @Autowired
    @Qualifier(value="KuiperToolkitService")
    private KuiperToolkitService kuiperToolkitService;
    private static final String NULLABLE = "nullable";
    private static final String FIELD_NAME = "fieldName";
    private static final String TYPE = "type";
    private static final String DESC = "desc";
    private static final String OBJECT = "Object";
    private static final String OBJECT_ARRAY = "ObjectArray";
    private static final String KEY = "key";

    @Cacheable(cacheNames={"template"}, key="'findById_' + #id", sync=true)
    public TemplateEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.templateRepository.findById(id);
        TemplateEntity currentTemplate = op.orElse(null);
        if (currentTemplate == null) {
            return null;
        }
        return (TemplateEntity)this.kuiperToolkitService.copyObjectByWhiteList(currentTemplate, TemplateEntity.class, LinkedHashSet.class, LinkedList.class, new String[0]);
    }

    @Cacheable(cacheNames={"template"}, key="'findByCode_' + #code", sync=true)
    public List<TemplateEntity> findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return new ArrayList<TemplateEntity>();
        }
        List<TemplateEntity> templates = this.templateRepository.findByCode(code);
        if (templates == null || templates.isEmpty()) {
            return new ArrayList<TemplateEntity>();
        }
        Collection resutls = this.kuiperToolkitService.copyCollectionByWhiteList(templates, TemplateEntity.class, TemplateEntity.class, LinkedHashSet.class, LinkedList.class, new String[0]);
        return new LinkedList<TemplateEntity>(resutls);
    }

    @Cacheable(cacheNames={"template"}, key="'findDetailsById_' + #id", sync=true)
    public TemplateEntity findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        TemplateEntity currentTemplate = this.templateRepository.findDetailsById(id);
        if (currentTemplate == null) {
            return null;
        }
        Set properties = currentTemplate.getProperties();
        currentTemplate.setProperties(this.sortedProperties(properties));
        Set relations = currentTemplate.getRelations();
        currentTemplate.setRelations(this.sortedRelations(relations));
        Set<TemplateGroupEntity> templateGroups = this.templateGroupRepository.findDetailsByParentTemplate(id);
        if (templateGroups != null) {
            for (TemplateGroupEntity templateGroupEntity : templateGroups) {
                templateGroupEntity.setProperties(this.sortedProperties(templateGroupEntity.getProperties()));
                templateGroupEntity.setRelations(this.sortedRelations(templateGroupEntity.getRelations()));
                Set templateItems = templateGroupEntity.getItemRelations();
                if (templateItems == null) continue;
                for (TemplateItemEntity templateItem : templateItems) {
                    templateItem.setProperties(this.sortedProperties(templateItem.getProperties()));
                    templateItem.setRelations(this.sortedRelations(templateItem.getRelations()));
                }
            }
        }
        currentTemplate.setGroupRelations(templateGroups);
        Set<TemplateItemEntity> templateItems = this.templateItemRepository.findDetailsByParentTemplate(id);
        if (templateItems != null) {
            for (TemplateItemEntity templateItem : templateItems) {
                templateItem.setProperties(this.sortedProperties(templateItem.getProperties()));
                templateItem.setRelations(this.sortedRelations(templateItem.getRelations()));
            }
        }
        currentTemplate.setItemRelations(templateItems);
        TemplateEntity templateEntity = (TemplateEntity)this.kuiperToolkitService.copyObjectByWhiteList(currentTemplate, TemplateEntity.class, LinkedHashSet.class, LinkedList.class, new String[]{"properties", "relations", "creator", "groupRelations", "groupRelations.properties", "groupRelations.relations", "groupRelations.itemRelations", "groupRelations.itemRelations.properties", "groupRelations.itemRelations.relations", "itemRelations", "itemRelations.properties", "itemRelations.relations"});
        return templateEntity;
    }

    public List<TemplateEntity> findByFormStyle(String formStyle) {
        if (StringUtils.isBlank((CharSequence)formStyle)) {
            return null;
        }
        return this.templateRepository.findByFormStyle(formStyle);
    }

    private Set<TemplatePropertyEntity> sortedProperties(Set<TemplatePropertyEntity> properties) {
        LinkedHashSet currentProperties = null;
        if (properties != null) {
            currentProperties = new LinkedHashSet();
            currentProperties.addAll(properties.stream().sorted(Comparator.comparing(TemplatePropertyEntity::getIndex)).collect(Collectors.toList()));
        }
        return currentProperties;
    }

    private Set<TemplateRelationEntity> sortedRelations(Set<TemplateRelationEntity> relations) {
        LinkedHashSet currentRelations = null;
        if (relations != null) {
            currentRelations = new LinkedHashSet();
            currentRelations.addAll(relations.stream().sorted(Comparator.comparing(TemplateRelationEntity::getIndex)).collect(Collectors.toList()));
        }
        return currentRelations;
    }

    public Page<TemplateEntity> findByConditions(Map<String, Object> conditions, Pageable pageable) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        return this.templateRepository.queryPage(pageable, conditions);
    }

    public int countByIds(String[] ids) {
        if (ids == null || ids.length == 0) {
            return 0;
        }
        return this.templateRepository.countByIds(ids);
    }

    @Transactional
    @CacheEvict(cacheNames={"template"}, allEntries=true)
    public TemplateEntity update(TemplateEntity template) {
        Validate.notNull((Object)template, (String)"\u9700\u8981\u4fdd\u5b58\u7684\u8868\u5355\u6a21\u677f\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        String templateId = template.getId();
        Validate.notBlank((CharSequence)templateId, (String)"\u8868\u5355\u6a21\u677f\u7f16\u53f7\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Optional op = this.templateRepository.findById(templateId);
        TemplateEntity currentTemplate = op.orElse(null);
        Validate.notNull((Object)currentTemplate, (String)"\u672a\u627e\u5230\u5f53\u524d\u6307\u5b9a\u7f16\u53f7\u5bf9\u5e94\u7684\u6a21\u677f\u4fe1\u606f!!", (Object[])new Object[0]);
        currentTemplate.setCode(template.getCode());
        currentTemplate.setCversion(template.getCversion());
        currentTemplate.setDomain(template.getDomain());
        currentTemplate.setFormStyle(template.getFormStyle());
        currentTemplate.setName(template.getName());
        currentTemplate.setType(template.getType());
        try {
            Object printTemplateLayout;
            Object templateLayout = template.getTemplateLayout();
            Validate.notNull((Object)templateLayout, (String)"\u9519\u8bef\u7684\u8868\u5355\u6a21\u677f\u5e03\u5c40\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            TemplateLayoutEntity currentLayout = this.templateLayoutService.save(templateId, 1, templateLayout);
            Validate.notNull((Object)currentLayout, (String)"\u9519\u8bef\u7684\u8868\u5355\u6a21\u677f\u5e03\u5c40\u4fdd\u5b58\u8fc7\u7a0b\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Object mobileTemplateLayout = template.getMobileTemplateLayout();
            if (mobileTemplateLayout != null) {
                currentLayout = this.templateLayoutService.save(templateId, 2, mobileTemplateLayout);
                Validate.notNull((Object)currentLayout, (String)"\u9519\u8bef\u7684\u8868\u5355\u6a21\u677f\u5e03\u5c40\u4fdd\u5b58\u8fc7\u7a0b\uff08\u79fb\u52a8\u7aef\uff09\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            }
            if ((printTemplateLayout = template.getPrintTemplateLayout()) != null) {
                currentLayout = this.templateLayoutService.save(templateId, 3, printTemplateLayout);
                Validate.notNull((Object)currentLayout, (String)"\u9519\u8bef\u7684\u8868\u5355\u6a21\u677f\u5e03\u5c40\u4fdd\u5b58\u8fc7\u7a0b\uff08\u6253\u5370\u7aef\uff09\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        Set templateEvents = template.getEvent();
        ArrayList<Object> events = CollectionUtils.isEmpty((Collection)templateEvents) ? new ArrayList<TemplateEventEntity>() : new ArrayList(templateEvents);
        this.templateEventService.save(templateId, events);
        Set templateVisibilities = template.getVisibility();
        if (templateVisibilities != null && !templateVisibilities.isEmpty()) {
            this.templateVisibilityService.save(currentTemplate, templateVisibilities);
        }
        return currentTemplate;
    }

    @Transactional
    @CacheEvict(cacheNames={"template"}, allEntries=true)
    public void updateDefaultVersion(String templateId) {
        Validate.notBlank((CharSequence)templateId, (String)"\u6307\u5b9a\u9ed8\u8ba4\u7248\u672c\u4fe1\u606f\u65f6,\u539f\u59cb\u6307\u5b9a\u7684templateId\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        Optional op = this.templateRepository.findById(templateId);
        TemplateEntity currentTemplate = op.orElse(null);
        Validate.notNull((Object)currentTemplate, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u6a21\u677f\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notNull((Object)currentTemplate, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u6a21\u677f\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((currentTemplate.getTstatus() == 1 ? 1 : 0) != 0, (String)"\u5f53\u524d\u6307\u5b9a\u6a21\u677f\u7684\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\uff08\u6a21\u677f\u72b6\u6001\u4e0d\u80fd\u4e3a\u7981\u7528\uff09!", (Object[])new Object[0]);
        this.templateRepository.updateDefaultVersion(currentTemplate.getCode());
        this.templateRepository.updateDefaultVersion(currentTemplate.getCode(), currentTemplate.getCversion());
    }

    @Transactional
    @CacheEvict(cacheNames={"template"}, allEntries=true)
    public void updateStatusById(String templateId, Integer tstatus) {
        Validate.isTrue((tstatus == 1 || tstatus == 0 ? 1 : 0) != 0, (String)"\u6a21\u677f\u72b6\u6001\u53ea\u80fd\u8bbe\u5b9a\u4e3a1\uff08\u6b63\u5e38\uff09\u6216\u80050\uff08\u7981\u7528\uff09", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)templateId, (String)"\u6307\u5b9a\u9ed8\u8ba4\u7248\u672c\u4fe1\u606f\u65f6,\u539f\u59cb\u6307\u5b9a\u7684templateId\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        Optional op = this.templateRepository.findById(templateId);
        TemplateEntity currentTemplate = op.orElse(null);
        Validate.notNull((Object)currentTemplate, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u6a21\u677f\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((currentTemplate.getDefaultVersion() != false && tstatus == 1 || currentTemplate.getDefaultVersion() == false ? 1 : 0) != 0, (String)"\u5f53\u524d\u6307\u5b9a\u7684\u6a21\u677f[%s]\u4e3a\u9ed8\u8ba4\u7248\u672c\uff0c\u5176\u72b6\u6001\u4e0d\u5141\u8bb8\u88ab\u7981\u7528.", (Object[])new Object[]{templateId});
        currentTemplate.setTstatus(tstatus);
        this.templateRepository.save(currentTemplate);
    }

    public JSONArray importTemplate(String templateEntityId) {
        Validate.notBlank((CharSequence)templateEntityId, (String)"\u5bfc\u5165\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        TemplateEntity template = this.findDetailsById(templateEntityId);
        Validate.notNull((Object)template, (String)"\u672a\u627e\u5230\u8be5\u6a21\u677f\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Set properties = template.getProperties();
        Set items = template.getItemRelations();
        Set groups = template.getGroupRelations();
        Set relations = template.getRelations();
        JSONArray json = new JSONArray();
        Integer index = 1;
        if (!CollectionUtils.isEmpty((Collection)properties)) {
            json.addAll((Collection)this.propertiesToJson(properties, null, index));
            index = index + properties.size();
        }
        if (!CollectionUtils.isEmpty((Collection)items)) {
            json.addAll((Collection)this.itemsToJson(items, null, index));
            index = index + items.size();
        }
        if (!CollectionUtils.isEmpty((Collection)relations)) {
            json.addAll((Collection)this.relationsToJson(relations, null, index));
            index = index + relations.size();
        }
        if (!CollectionUtils.isEmpty((Collection)groups)) {
            json.addAll((Collection)this.groupsToJson(groups, null, index));
        }
        return json;
    }

    private JSONArray propertiesToJson(Set<TemplatePropertyEntity> properties, String oldSort, Integer currentIndex) {
        JSONArray propertyArray = new JSONArray();
        for (TemplatePropertyEntity o : properties) {
            JSONObject propertyJson = new JSONObject();
            String place = StringUtils.isEmpty((CharSequence)oldSort) ? currentIndex.toString() : String.format("%s-%s", oldSort, currentIndex.toString());
            propertyJson.put(KEY, (Object)place);
            propertyJson.put(FIELD_NAME, (Object)o.getPropertyName());
            propertyJson.put(DESC, (Object)o.getPropertyDesc());
            propertyJson.put(NULLABLE, (Object)o.getNullable());
            propertyArray.add((Object)propertyJson);
            currentIndex = currentIndex + 1;
        }
        return propertyArray;
    }

    private JSONArray relationsToJson(Set<TemplateRelationEntity> relations, String oldSort, Integer currentIndex) {
        JSONArray relationArray = new JSONArray();
        for (TemplateRelationEntity o : relations) {
            JSONObject relationJson = new JSONObject();
            String place = StringUtils.isEmpty((CharSequence)oldSort) ? currentIndex.toString() : String.format("%s-%s", oldSort, currentIndex.toString());
            relationJson.put(KEY, (Object)place);
            relationJson.put(FIELD_NAME, (Object)o.getPropertyName());
            relationJson.put(DESC, (Object)o.getPropertyDesc());
            relationJson.put(NULLABLE, (Object)o.getNullable());
            relationArray.add((Object)relationJson);
            currentIndex = currentIndex + 1;
        }
        return relationArray;
    }

    private JSONArray itemsToJson(Set<TemplateItemEntity> items, String oldSort, Integer currentIndex) {
        JSONArray itemArray = new JSONArray();
        for (TemplateItemEntity o : items) {
            JSONObject itemJson = new JSONObject();
            String place = StringUtils.isEmpty((CharSequence)oldSort) ? currentIndex.toString() : String.format("%s-%s", oldSort, currentIndex.toString());
            itemJson.put(KEY, (Object)place);
            itemJson.put(FIELD_NAME, (Object)o.getPropertyName());
            itemJson.put(DESC, (Object)o.getPropertyDesc());
            itemJson.put(NULLABLE, (Object)true);
            itemJson.put(TYPE, (Object)OBJECT);
            itemJson.put("content", (Object)this.propertiesToJson(o.getProperties(), place, 1));
            itemArray.add((Object)itemJson);
        }
        return itemArray;
    }

    private JSONArray groupsToJson(Set<TemplateGroupEntity> groups, String oldSort, Integer currentIndex) {
        JSONArray groupArray = new JSONArray();
        for (TemplateGroupEntity o : groups) {
            JSONObject groupJson = new JSONObject();
            String place = StringUtils.isEmpty((CharSequence)oldSort) ? currentIndex.toString() : String.format("%s-%s", oldSort, currentIndex.toString());
            groupJson.put(KEY, (Object)place);
            groupJson.put(FIELD_NAME, (Object)o.getPropertyName());
            groupJson.put(DESC, (Object)o.getPropertyDesc());
            groupJson.put(NULLABLE, (Object)true);
            groupJson.put(TYPE, (Object)OBJECT_ARRAY);
            JSONArray groupContent = new JSONArray();
            Integer subIndex = 1;
            if (!CollectionUtils.isEmpty((Collection)o.getProperties())) {
                groupContent.addAll((Collection)this.propertiesToJson(o.getProperties(), place, subIndex));
            }
            subIndex = CollectionUtils.isEmpty((Collection)o.getProperties()) ? subIndex : subIndex + o.getProperties().size();
            if (!CollectionUtils.isEmpty((Collection)o.getRelations())) {
                groupContent.addAll((Collection)this.relationsToJson(o.getRelations(), place, subIndex));
            }
            subIndex = CollectionUtils.isEmpty((Collection)o.getRelations()) ? subIndex : subIndex + o.getRelations().size();
            if (!CollectionUtils.isEmpty((Collection)o.getItemRelations())) {
                groupContent.addAll((Collection)this.itemsToJson(o.getItemRelations(), place, subIndex));
            }
            groupJson.put("content", (Object)groupContent);
            groupArray.add((Object)groupJson);
        }
        return groupArray;
    }
}

