/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.internal;

import com.bizunited.platform.core.entity.UuidEntity;
import com.bizunited.platform.core.service.file.NebulaFileService;
import com.bizunited.platform.kuiper.entity.TemplateStyleEntity;
import com.bizunited.platform.kuiper.service.TemplateService;
import com.bizunited.platform.kuiper.starter.repository.InstanceRepository;
import com.bizunited.platform.kuiper.starter.repository.TemplateStyleRepository;
import com.bizunited.platform.kuiper.starter.service.TemplateStyleService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="TemplateStyleServiceImpl")
public class TemplateStyleServiceImpl
implements TemplateStyleService {
    @Autowired
    private TemplateStyleRepository templateStyleRepository;
    @Autowired
    private TemplateService templateService;
    @Autowired
    private InstanceRepository instanceRepository;
    @Autowired
    private NebulaFileService kuiperFileService;

    @Override
    @Transactional
    public TemplateStyleEntity create(TemplateStyleEntity templateStyle, byte[] fileContent, boolean systemStyle, String prefix) {
        Validate.notNull((Object)templateStyle, (String)"\u8fdb\u884c\u521b\u5efa\u64cd\u4f5c\u65f6\uff0c\u6a21\u677f\u6837\u5f0f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        String id = templateStyle.getId();
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)id), (String)"\u8fdb\u884c\u521b\u5efa\u64cd\u4f5c\u65f6\uff0c\u4e0d\u80fd\u6307\u5b9a\u6570\u636e\u7f16\u53f7!!", (Object[])new Object[0]);
        templateStyle.setId(null);
        String code = templateStyle.getCode();
        Validate.notBlank((CharSequence)code, (String)"\u8fdb\u884c\u521b\u5efa\u64cd\u4f5c\u65f6\uff0c\u6a21\u677f\u7f16\u53f7\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Pattern pattern = Pattern.compile("[\u4e00-\u9fa5]");
        Validate.isTrue((!pattern.matcher(code).find() ? 1 : 0) != 0, (String)"\u8fdb\u884c\u521b\u5efa\u65f6\uff0c\u6a21\u677f\u7f16\u53f7\u4fe1\u606f\u4e0d\u80fd\u5e26\u6709\u4e2d\u6587\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        TemplateStyleEntity currentTemplate = this.templateStyleRepository.findDetailsByCode(code);
        Validate.isTrue((currentTemplate == null ? 1 : 0) != 0, (String)"\u8fdb\u884c\u521b\u5efa\u64cd\u4f5c\u65f6\uff0c\u5f53\u524d\u6a21\u677f\u4e1a\u52a1\u7f16\u53f7\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u586b\u5199!!", (Object[])new Object[0]);
        String name = templateStyle.getName();
        Validate.notBlank((CharSequence)name, (String)"\u8fdb\u884c\u521b\u5efa\u65f6\uff0c\u5f53\u524d\u6837\u5f0f\u540d\u5fc5\u987b\u586b\u5199!!", (Object[])new Object[0]);
        Validate.notNull((Object)fileContent, (String)"\u8fdb\u884c\u521b\u5efa\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u5f53\u524d\u6837\u5f0f\u6587\u4ef6\u7684\u5185\u5bb9\u4fe1\u606f", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)prefix, (String)"\u8fdb\u884c\u521b\u5efa\u65f6\uff0c\u6587\u4ef6\u6269\u5c55\u4fe1\u606f\u5fc5\u987b\u6307\u5b9a!!", (Object[])new Object[0]);
        String styleType = StringUtils.lowerCase((String)prefix);
        Validate.isTrue((boolean)StringUtils.equalsAny((CharSequence)styleType, (CharSequence[])new CharSequence[]{"css", "less"}), (String)"\u8fdb\u884c\u521b\u5efa\u65f6\uff0c\u6587\u4ef6\u540e\u7f00\u53ea\u80fd\u4f7f\u7528css\u6216\u8005less!!", (Object[])new Object[0]);
        Date nowDate = new Date();
        String folderName = new SimpleDateFormat("yyyyMMdd").format(nowDate);
        String renameFile = StringUtils.join((Object[])new String[]{UUID.randomUUID().toString(), ".", prefix});
        String subSystem = "style";
        String relativePath = "/" + subSystem + "/" + folderName + "/" + new Random().nextInt(100) % 10;
        this.kuiperFileService.saveFile(relativePath, renameFile, renameFile, fileContent);
        templateStyle.setCreateTime(new Date());
        templateStyle.setRelativePath(relativePath);
        templateStyle.setFileName(renameFile);
        templateStyle.setStyleType(styleType);
        if (systemStyle) {
            templateStyle.setSystemStyle(Integer.valueOf(1));
        } else {
            templateStyle.setSystemStyle(Integer.valueOf(0));
        }
        templateStyle.setTstatus(Integer.valueOf(1));
        this.templateStyleRepository.save(templateStyle);
        return templateStyle;
    }

    @Override
    @Transactional
    public TemplateStyleEntity update(TemplateStyleEntity templateStyle, byte[] fileContent, String prefix) {
        String name;
        Validate.notNull((Object)templateStyle, (String)"\u8fdb\u884c\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u6a21\u677f\u6837\u5f0f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        String id = templateStyle.getId();
        Optional op = this.templateStyleRepository.findById(id);
        TemplateStyleEntity currentTemplateStyle = op.orElse(null);
        Validate.notNull((Object)currentTemplateStyle, (String)"\u8fdb\u884c\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u6a21\u677f\u6837\u5f0f\u5bf9\u5e94\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((currentTemplateStyle.getSystemStyle() != 1 ? 1 : 0) != 0, (String)"\u5f53\u524d\u6837\u5f0f\u4fe1\u606f\u4e3a\u7cfb\u7edf\u6837\u5f0f\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u4fee\u6539!!", (Object[])new Object[0]);
        String code = currentTemplateStyle.getCode();
        List templates = this.templateService.findByFormStyle(code);
        if (templates != null && !templates.isEmpty()) {
            List<String> templateIds = templates.stream().map(UuidEntity::getId).collect(Collectors.toList());
            int insCount = this.instanceRepository.countByTemplateIds(templateIds.toArray(new String[0]));
            Validate.isTrue((insCount == 0 ? 1 : 0) != 0, (String)("\u5f53\u524d\u6a21\u677f\u6837\u5f0f[" + code + "]\u5df2\u7ecf\u5b58\u5728\u81f3\u5c11\u4e00\u4e2a\u5b9e\u4f8b\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u4fee\u6539!!"), (Object[])new Object[0]);
        }
        if (!StringUtils.isBlank((CharSequence)(name = templateStyle.getName()))) {
            currentTemplateStyle.setName(name);
        }
        if (fileContent != null) {
            Validate.notBlank((CharSequence)prefix, (String)"\u8fdb\u884c\u521b\u5efa\u65f6\uff0c\u6587\u4ef6\u6269\u5c55\u4fe1\u606f\u5fc5\u987b\u6307\u5b9a!!", (Object[])new Object[0]);
            String styleType = StringUtils.lowerCase((String)prefix);
            Validate.isTrue((boolean)StringUtils.equalsAny((CharSequence)styleType, (CharSequence[])new CharSequence[]{"css", "less"}), (String)"\u8fdb\u884c\u521b\u5efa\u65f6\uff0c\u6587\u4ef6\u540e\u7f00\u53ea\u80fd\u4f7f\u7528css\u6216\u8005less!!", (Object[])new Object[0]);
            Date nowDate = new Date();
            String folderName = new SimpleDateFormat("yyyyMMdd").format(nowDate);
            String renameFile = StringUtils.join((Object[])new String[]{UUID.randomUUID().toString(), ".", prefix});
            String subSystem = "style";
            String relativePath = "/" + subSystem + "/" + folderName + "/" + new Random().nextInt(100) % 10;
            this.kuiperFileService.saveFile(relativePath, renameFile, renameFile, fileContent);
            currentTemplateStyle.setRelativePath(relativePath);
            currentTemplateStyle.setFileName(renameFile);
            currentTemplateStyle.setStyleType(styleType);
        }
        this.templateStyleRepository.save(currentTemplateStyle);
        return currentTemplateStyle;
    }

    @Override
    @Transactional
    public void updateStatusById(String id, boolean tstatus) {
        Validate.notBlank((CharSequence)id, (String)"\u4fee\u6539\u72b6\u6001\u65f6\uff0c\u6307\u5b9a\u6a21\u677f\u6837\u5f0f\u7684\u7f16\u53f7\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Optional op = this.templateStyleRepository.findById(id);
        TemplateStyleEntity currentTemplateStyle = op.orElse(null);
        Validate.notNull((Object)currentTemplateStyle, (String)"\u8fdb\u884c\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u6a21\u677f\u6837\u5f0f\u5bf9\u5e94\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((currentTemplateStyle.getSystemStyle() != 1 ? 1 : 0) != 0, (String)"\u5f53\u524d\u6837\u5f0f\u4fe1\u606f\u4e3a\u7cfb\u7edf\u6837\u5f0f\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u4fee\u6539!!", (Object[])new Object[0]);
        if (tstatus) {
            currentTemplateStyle.setTstatus(Integer.valueOf(1));
        } else {
            currentTemplateStyle.setTstatus(Integer.valueOf(0));
        }
        this.templateStyleRepository.save(currentTemplateStyle);
    }

    @Override
    public List<TemplateStyleEntity> findAll() {
        return this.templateStyleRepository.findAll();
    }

    @Override
    public List<TemplateStyleEntity> findByTstatus(Integer tstatus) {
        if (tstatus == null) {
            return null;
        }
        return this.templateStyleRepository.findByTstatus(tstatus);
    }

    @Override
    public TemplateStyleEntity findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.templateStyleRepository.findDetailsById(id);
    }

    @Override
    public TemplateStyleEntity findDetailsByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return this.templateStyleRepository.findDetailsByCode(code);
    }

    @Override
    public byte[] findContentByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        TemplateStyleEntity currentTemplate = this.templateStyleRepository.findDetailsByCode(code);
        if (currentTemplate == null) {
            return null;
        }
        String relativePath = currentTemplate.getRelativePath();
        String fileName = currentTemplate.getFileName();
        return this.kuiperFileService.readFileContent(relativePath, fileName);
    }
}

