/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.internal;

import com.bizunited.platform.core.entity.UuidEntity;
import com.bizunited.platform.core.service.NebulaStaticPersistentService;
import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.entity.TemplateGroupEntity;
import com.bizunited.platform.kuiper.entity.TemplateItemEntity;
import com.bizunited.platform.kuiper.entity.TemplatePropertyEntity;
import com.bizunited.platform.kuiper.entity.TemplateRelationEntity;
import com.bizunited.platform.kuiper.entity.TemplateVisibilityAttributesEntity;
import com.bizunited.platform.kuiper.entity.TemplateVisibilityButtonsEntity;
import com.bizunited.platform.kuiper.entity.TemplateVisibilityEntity;
import com.bizunited.platform.kuiper.service.TemplateService;
import com.bizunited.platform.kuiper.starter.common.enums.TemplateLayoutTypeEnum;
import com.bizunited.platform.kuiper.starter.repository.InstanceActivityRepository;
import com.bizunited.platform.kuiper.starter.repository.TemplateVisibilityAttributesRepository;
import com.bizunited.platform.kuiper.starter.repository.TemplateVisibilityButtonRepository;
import com.bizunited.platform.kuiper.starter.repository.TemplateVisibilityRepository;
import com.bizunited.platform.kuiper.starter.service.KuiperToolkitService;
import com.bizunited.platform.kuiper.starter.service.TemplateVisibilityAttributeService;
import com.bizunited.platform.kuiper.starter.service.TemplateVisibilityButtonService;
import com.bizunited.platform.kuiper.starter.service.TemplateVisibilityService;
import com.bizunited.platform.saturn.model.PersistentClass;
import com.bizunited.platform.saturn.model.PersistentProperty;
import com.bizunited.platform.saturn.model.PersistentRelation;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="TemplateVisibilityServiceImpl")
public class TemplateVisibilityServiceImpl
implements TemplateVisibilityService {
    private static final String CONTROLLER_ID_SPLIT = "-";
    private static final String CONTROLLER_ID_SUFFIX = "Attri";
    private static final String VISIBILITY_CREATE = "create";
    @Autowired
    private TemplateVisibilityRepository templateVisibilityRepository;
    @Autowired
    private TemplateVisibilityAttributesRepository templateVisibilityAttributesRepository;
    @Autowired
    private TemplateVisibilityButtonRepository templateVisibilityButtonRepository;
    @Autowired
    private TemplateService templateService;
    @Autowired
    private NebulaStaticPersistentService nebulaStaticPersistentService;
    @Autowired
    private InstanceActivityRepository instanceActivityRepository;
    @Autowired
    @Qualifier(value="KuiperToolkitService")
    private KuiperToolkitService kuiperToolkitService;
    @Autowired
    private TemplateVisibilityButtonService templateVisibilityButtonService;
    @Autowired
    private TemplateVisibilityAttributeService templateVisibilityAttributeService;

    @Override
    @Transactional
    public Set<TemplateVisibilityEntity> initStaticTemplateVisibilities(String templateId, PersistentClass persistentClass) {
        Validate.notBlank((CharSequence)templateId, (String)"\u8868\u5355\u6a21\u677f\u7f16\u53f7\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.notNull((Object)persistentClass, (String)"\u9759\u6001\u6a21\u578b\u7684\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        TemplateEntity template = this.templateService.findById(templateId);
        Validate.notNull((Object)template, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u8868\u5355\u6a21\u677f\u4fe1\u606f!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)"static".equals(template.getType()), (String)"\u8be5\u521d\u59cb\u5316\u65b9\u6cd5\u53ea\u80fd\u9488\u5bf9\u9759\u6001\u6a21\u7248", (Object[])new Object[0]);
        TemplateVisibilityEntity templateVisibility = new TemplateVisibilityEntity();
        templateVisibility.setCanDelete(Boolean.valueOf(false));
        templateVisibility.setCreateTime(new Date());
        templateVisibility.setVisibilityName(VISIBILITY_CREATE);
        templateVisibility.setTemplate(template);
        this.templateVisibilityRepository.save(templateVisibility);
        Set<TemplateVisibilityAttributesEntity> attributes = this.initStaticTemplateVisibilityAttributes(templateVisibility, persistentClass);
        if (!CollectionUtils.isEmpty(attributes)) {
            this.templateVisibilityAttributesRepository.saveAll(attributes);
        }
        templateVisibility.setAttributes(attributes);
        return Collections.singleton(templateVisibility);
    }

    private Set<TemplateVisibilityAttributesEntity> initStaticTemplateVisibilityAttributes(TemplateVisibilityEntity templateVisibility, PersistentClass persistentClass) {
        HashSet<TemplateVisibilityAttributesEntity> attributes = new HashSet<TemplateVisibilityAttributesEntity>(64);
        attributes.addAll(this.initStaticTemplateVisibilityPropertiesAttributes(templateVisibility, persistentClass, ""));
        attributes.addAll(this.initStaticTemplateVisibilityRelationsAttributes(templateVisibility, persistentClass, "", null));
        attributes.addAll(this.initStaticTemplateVisibilityItemsAttributes(templateVisibility, persistentClass, ""));
        attributes.addAll(this.initStaticTemplateVisibilityGroupAttributes(templateVisibility, persistentClass));
        return attributes;
    }

    private Set<TemplateVisibilityAttributesEntity> initStaticTemplateVisibilityGroupAttributes(TemplateVisibilityEntity templateVisibility, PersistentClass persistentClass) {
        HashSet<TemplateVisibilityAttributesEntity> attributes = new HashSet<TemplateVisibilityAttributesEntity>(64);
        List relations = persistentClass.getRelations().stream().filter(relation -> PersistentRelation.RelationType.OneToOne.equals((Object)relation.getRelationType())).collect(Collectors.toList());
        for (PersistentRelation relation2 : relations) {
            String propertyName = relation2.getPropertyName();
            for (TemplateLayoutTypeEnum layoutTypeEnum : TemplateLayoutTypeEnum.values()) {
                TemplateVisibilityAttributesEntity attributesEntity = new TemplateVisibilityAttributesEntity();
                attributesEntity.setAttributeName(relation2.getPropertyName());
                attributesEntity.setControllerId(StringUtils.join((Object[])new String[]{propertyName, CONTROLLER_ID_SUFFIX}));
                attributesEntity.setNullable(relation2.getNullable());
                attributesEntity.setLayoutType(layoutTypeEnum.getType());
                if (relation2.getCanInsert().booleanValue() || relation2.getCanUpdate().booleanValue()) {
                    attributesEntity.setVisibilityType(Integer.valueOf(2));
                } else {
                    attributesEntity.setVisibilityType(Integer.valueOf(1));
                }
                attributesEntity.setTemplateVisibility(templateVisibility);
                attributes.add(attributesEntity);
            }
            String idPrefix = StringUtils.join((Object[])new String[]{propertyName, CONTROLLER_ID_SPLIT});
            PersistentClass newPersistentClass = this.nebulaStaticPersistentService.findByPersistentClass(relation2.getPropertyClass());
            Validate.notNull((Object)newPersistentClass, (String)"\u5728\u521d\u59cb\u5316\u4e3b\u9759\u6001\u6a21\u578b\u65f6\u53d1\u73b0NULL\u5173\u8054\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u8868\u5355\u5f15\u64ce\u5f00\u53d1\u56e2\u961f!!", (Object[])new Object[0]);
            attributes.addAll(this.initStaticTemplateVisibilityPropertiesAttributes(templateVisibility, newPersistentClass, idPrefix));
            attributes.addAll(this.initStaticTemplateVisibilityRelationsAttributes(templateVisibility, newPersistentClass, idPrefix, relation2));
            attributes.addAll(this.initStaticTemplateVisibilityItemsAttributes(templateVisibility, newPersistentClass, idPrefix));
        }
        return attributes;
    }

    private Set<TemplateVisibilityAttributesEntity> initStaticTemplateVisibilityItemsAttributes(TemplateVisibilityEntity templateVisibility, PersistentClass persistentClass, String idPrefix) {
        HashSet<TemplateVisibilityAttributesEntity> attributes = new HashSet<TemplateVisibilityAttributesEntity>(16);
        List relations = persistentClass.getRelations().stream().filter(relation -> PersistentRelation.RelationType.OneToMany.equals((Object)relation.getRelationType())).collect(Collectors.toList());
        for (PersistentRelation relation2 : relations) {
            String propertyName = relation2.getPropertyName();
            for (TemplateLayoutTypeEnum layoutTypeEnum : TemplateLayoutTypeEnum.values()) {
                TemplateVisibilityAttributesEntity attributesEntity = new TemplateVisibilityAttributesEntity();
                attributesEntity.setAttributeName(StringUtils.join((Object[])new String[]{idPrefix, propertyName}));
                attributesEntity.setControllerId(StringUtils.join((Object[])new String[]{idPrefix, propertyName, CONTROLLER_ID_SUFFIX}));
                attributesEntity.setNullable(relation2.getNullable());
                attributesEntity.setLayoutType(layoutTypeEnum.getType());
                if (relation2.getCanInsert().booleanValue() || relation2.getCanUpdate().booleanValue()) {
                    attributesEntity.setVisibilityType(Integer.valueOf(2));
                } else {
                    attributesEntity.setVisibilityType(Integer.valueOf(1));
                }
                attributesEntity.setTemplateVisibility(templateVisibility);
                attributes.add(attributesEntity);
            }
            PersistentClass newPersistentClass = this.nebulaStaticPersistentService.findByPersistentClass(relation2.getPropertyClass());
            Validate.notNull((Object)newPersistentClass, (String)"\u5728\u521d\u59cb\u5316\u4e3b\u9759\u6001\u6a21\u578b\u65f6\u53d1\u73b0NULL\u5173\u8054\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u8868\u5355\u5f15\u64ce\u5f00\u53d1\u56e2\u961f!!", (Object[])new Object[0]);
            String newIdPrefix = StringUtils.join((Object[])new String[]{idPrefix, propertyName, CONTROLLER_ID_SPLIT});
            attributes.addAll(this.initStaticTemplateVisibilityPropertiesAttributes(templateVisibility, newPersistentClass, newIdPrefix));
            attributes.addAll(this.initStaticTemplateVisibilityRelationsAttributes(templateVisibility, newPersistentClass, newIdPrefix, relation2));
        }
        return attributes;
    }

    private Set<TemplateVisibilityAttributesEntity> initStaticTemplateVisibilityRelationsAttributes(TemplateVisibilityEntity templateVisibility, PersistentClass persistentClass, String idPrefix, PersistentRelation parentRelation) {
        HashSet<TemplateVisibilityAttributesEntity> attributes = new HashSet<TemplateVisibilityAttributesEntity>(64);
        List persistentRelations = persistentClass.getRelations().stream().filter(relation -> !(!PersistentRelation.RelationType.ManyToOne.equals((Object)relation.getRelationType()) && !PersistentRelation.RelationType.ManyToMany.equals((Object)relation.getRelationType()) || parentRelation != null && parentRelation.getPersistentClassName().equals(relation.getPropertyClass()))).collect(Collectors.toList());
        for (PersistentRelation relation2 : persistentRelations) {
            String propertyName = relation2.getPropertyName();
            for (TemplateLayoutTypeEnum layoutTypeEnum : TemplateLayoutTypeEnum.values()) {
                TemplateVisibilityAttributesEntity attributesEntity = new TemplateVisibilityAttributesEntity();
                attributesEntity.setAttributeName(StringUtils.join((Object[])new String[]{idPrefix, propertyName}));
                attributesEntity.setControllerId(StringUtils.join((Object[])new String[]{idPrefix, propertyName, CONTROLLER_ID_SUFFIX}));
                attributesEntity.setNullable(relation2.getNullable());
                attributesEntity.setLayoutType(layoutTypeEnum.getType());
                if (relation2.getCanInsert().booleanValue() || relation2.getCanUpdate().booleanValue()) {
                    attributesEntity.setVisibilityType(Integer.valueOf(2));
                } else {
                    attributesEntity.setVisibilityType(Integer.valueOf(1));
                }
                attributesEntity.setTemplateVisibility(templateVisibility);
                attributes.add(attributesEntity);
            }
        }
        return attributes;
    }

    private Set<TemplateVisibilityAttributesEntity> initStaticTemplateVisibilityPropertiesAttributes(TemplateVisibilityEntity templateVisibility, PersistentClass persistentClass, String idPrefix) {
        HashSet<TemplateVisibilityAttributesEntity> attributes = new HashSet<TemplateVisibilityAttributesEntity>(16);
        List properties = persistentClass.getProperties();
        for (PersistentProperty property : properties) {
            for (TemplateLayoutTypeEnum layoutTypeEnum : TemplateLayoutTypeEnum.values()) {
                TemplateVisibilityAttributesEntity attribute = new TemplateVisibilityAttributesEntity();
                attribute.setAttributeName(StringUtils.join((Object[])new String[]{idPrefix, property.getPropertyName()}));
                attribute.setControllerId(StringUtils.join((Object[])new String[]{idPrefix, property.getPropertyName(), CONTROLLER_ID_SUFFIX}));
                attribute.setNullable(property.getNullable());
                attribute.setLayoutType(layoutTypeEnum.getType());
                if (this.isReadOnly(property, attribute)) {
                    attribute.setVisibilityType(Integer.valueOf(1));
                } else {
                    attribute.setVisibilityType(Integer.valueOf(2));
                }
                attribute.setTemplateVisibility(templateVisibility);
                attributes.add(attribute);
            }
        }
        return attributes;
    }

    private boolean isReadOnly(PersistentProperty property, TemplateVisibilityAttributesEntity attribute) {
        return property.getPrimaryKey() != false || StringUtils.equals((CharSequence)attribute.getAttributeName(), (CharSequence)"formInstanceId") || property.getCanInsert() == false && property.getCanUpdate() == false;
    }

    private boolean isReadOnly(TemplatePropertyEntity templateProperty, TemplateVisibilityAttributesEntity attribute) {
        boolean canInsert = templateProperty.getCanInsert() == null ? true : templateProperty.getCanInsert();
        boolean canUpdate = templateProperty.getCanUpdate() == null ? true : templateProperty.getCanUpdate();
        return templateProperty.getPrimaryKey() != false || StringUtils.equals((CharSequence)attribute.getAttributeName(), (CharSequence)"formInstanceId") || !canInsert && !canUpdate;
    }

    @Override
    @Transactional
    public Set<TemplateVisibilityEntity> initDynamicTemplateVisibilities(TemplateEntity template) {
        Validate.notNull((Object)template, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u8868\u5355\u6a21\u677f\u4fe1\u606f!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)template.getType(), (CharSequence)"dynamic"), (String)"\u8be5\u521d\u59cb\u5316\u8fc7\u7a0b\u53ea\u80fd\u9488\u5bf9\u52a8\u6001\u6a21\u677f!!", (Object[])new Object[0]);
        TemplateVisibilityEntity templateVisibility = new TemplateVisibilityEntity();
        templateVisibility.setCanDelete(Boolean.valueOf(false));
        templateVisibility.setCreateTime(new Date());
        templateVisibility.setVisibilityName(VISIBILITY_CREATE);
        templateVisibility.setTemplate(template);
        this.templateVisibilityRepository.save(templateVisibility);
        HashSet<TemplateVisibilityAttributesEntity> attributes = new HashSet<TemplateVisibilityAttributesEntity>(64);
        attributes.addAll(this.initDynamicTemplateVisibilityPropertyAttributes(template.getProperties(), templateVisibility, ""));
        attributes.addAll(this.initDynamicTemplateVisibilityRelationAttributes(template.getRelations(), templateVisibility, ""));
        attributes.addAll(this.initDynamicTemplateVisibilityItemAttributes(template.getItemRelations(), templateVisibility, ""));
        attributes.addAll(this.initDynamicTemplateVisibilityGroupAttributes(template.getGroupRelations(), templateVisibility));
        if (!CollectionUtils.isEmpty(attributes)) {
            this.templateVisibilityAttributesRepository.saveAll(attributes);
        }
        templateVisibility.setAttributes(attributes);
        templateVisibility.setButtons(null);
        return Collections.singleton(templateVisibility);
    }

    private Set<TemplateVisibilityAttributesEntity> initDynamicTemplateVisibilityItemAttributes(Set<TemplateItemEntity> items, TemplateVisibilityEntity templateVisibility, String idPrefix) {
        HashSet<TemplateVisibilityAttributesEntity> attributes = new HashSet<TemplateVisibilityAttributesEntity>(32);
        if (CollectionUtils.isEmpty(items)) {
            return attributes;
        }
        for (TemplateItemEntity item : items) {
            for (TemplateLayoutTypeEnum layoutTypeEnum : TemplateLayoutTypeEnum.values()) {
                TemplateVisibilityAttributesEntity attribute = new TemplateVisibilityAttributesEntity();
                attribute.setAttributeName(StringUtils.join((Object[])new String[]{idPrefix, item.getPropertyName()}));
                attribute.setControllerId(StringUtils.join((Object[])new String[]{idPrefix, item.getPropertyName(), CONTROLLER_ID_SUFFIX}));
                attribute.setVisibilityType(Integer.valueOf(2));
                attribute.setNullable(Boolean.valueOf(true));
                attribute.setLayoutType(layoutTypeEnum.getType());
                attribute.setTemplateVisibility(templateVisibility);
                attributes.add(attribute);
            }
            String newIdPrefix = idPrefix + item.getPropertyName() + CONTROLLER_ID_SPLIT;
            attributes.addAll(this.initDynamicTemplateVisibilityPropertyAttributes(item.getProperties(), templateVisibility, newIdPrefix));
            attributes.addAll(this.initDynamicTemplateVisibilityRelationAttributes(item.getRelations(), templateVisibility, newIdPrefix));
        }
        return attributes;
    }

    private Set<TemplateVisibilityAttributesEntity> initDynamicTemplateVisibilityGroupAttributes(Set<TemplateGroupEntity> groups, TemplateVisibilityEntity templateVisibility) {
        HashSet<TemplateVisibilityAttributesEntity> attributes = new HashSet<TemplateVisibilityAttributesEntity>(32);
        if (CollectionUtils.isEmpty(groups)) {
            return attributes;
        }
        for (TemplateGroupEntity group : groups) {
            for (TemplateLayoutTypeEnum layoutTypeEnum : TemplateLayoutTypeEnum.values()) {
                TemplateVisibilityAttributesEntity attribute = new TemplateVisibilityAttributesEntity();
                attribute.setAttributeName(group.getPropertyName());
                attribute.setControllerId(StringUtils.join((Object[])new String[]{group.getPropertyName(), CONTROLLER_ID_SUFFIX}));
                attribute.setVisibilityType(Integer.valueOf(2));
                attribute.setNullable(Boolean.valueOf(true));
                attribute.setLayoutType(layoutTypeEnum.getType());
                attribute.setTemplateVisibility(templateVisibility);
                attributes.add(attribute);
            }
            String newIdPrefix = group.getPropertyName() + CONTROLLER_ID_SPLIT;
            attributes.addAll(this.initDynamicTemplateVisibilityPropertyAttributes(group.getProperties(), templateVisibility, newIdPrefix));
            attributes.addAll(this.initDynamicTemplateVisibilityRelationAttributes(group.getRelations(), templateVisibility, newIdPrefix));
            attributes.addAll(this.initDynamicTemplateVisibilityItemAttributes(group.getItemRelations(), templateVisibility, newIdPrefix));
        }
        return attributes;
    }

    private Set<TemplateVisibilityAttributesEntity> initDynamicTemplateVisibilityRelationAttributes(Set<TemplateRelationEntity> relations, TemplateVisibilityEntity templateVisibility, String idPrefix) {
        HashSet<TemplateVisibilityAttributesEntity> attributes = new HashSet<TemplateVisibilityAttributesEntity>(16);
        if (CollectionUtils.isEmpty(relations)) {
            return attributes;
        }
        for (TemplateRelationEntity relation : relations) {
            for (TemplateLayoutTypeEnum layoutTypeEnum : TemplateLayoutTypeEnum.values()) {
                TemplateVisibilityAttributesEntity attribute = new TemplateVisibilityAttributesEntity();
                attribute.setAttributeName(StringUtils.join((Object[])new String[]{idPrefix, relation.getPropertyName()}));
                attribute.setControllerId(StringUtils.join((Object[])new String[]{idPrefix, relation.getPropertyName(), CONTROLLER_ID_SUFFIX}));
                boolean nullable = relation.getNullable() == null ? true : relation.getNullable();
                boolean canInsert = relation.getCanInsert() == null ? true : relation.getCanInsert();
                boolean canUpdate = relation.getCanUpdate() == null ? true : relation.getCanUpdate();
                attribute.setNullable(Boolean.valueOf(nullable));
                attribute.setLayoutType(layoutTypeEnum.getType());
                if (canInsert || canUpdate) {
                    attribute.setVisibilityType(Integer.valueOf(2));
                } else {
                    attribute.setVisibilityType(Integer.valueOf(1));
                }
                attribute.setTemplateVisibility(templateVisibility);
                attributes.add(attribute);
            }
        }
        return attributes;
    }

    private Set<TemplateVisibilityAttributesEntity> initDynamicTemplateVisibilityPropertyAttributes(Set<TemplatePropertyEntity> templateProperties, TemplateVisibilityEntity templateVisibility, String idPrefix) {
        HashSet<TemplateVisibilityAttributesEntity> attributes = new HashSet<TemplateVisibilityAttributesEntity>(16);
        for (TemplatePropertyEntity property : templateProperties) {
            for (TemplateLayoutTypeEnum layoutTypeEnum : TemplateLayoutTypeEnum.values()) {
                TemplateVisibilityAttributesEntity attribute = new TemplateVisibilityAttributesEntity();
                attribute.setAttributeName(StringUtils.join((Object[])new String[]{idPrefix, property.getPropertyName()}));
                attribute.setControllerId(StringUtils.join((Object[])new String[]{idPrefix, property.getPropertyName(), CONTROLLER_ID_SUFFIX}));
                attribute.setNullable(property.getNullable());
                attribute.setLayoutType(layoutTypeEnum.getType());
                if (this.isReadOnly(property, attribute)) {
                    attribute.setVisibilityType(Integer.valueOf(1));
                } else {
                    attribute.setVisibilityType(Integer.valueOf(2));
                }
                attribute.setTemplateVisibility(templateVisibility);
                attributes.add(attribute);
            }
        }
        return attributes;
    }

    private void saveValidation(TemplateEntity template, Set<TemplateVisibilityEntity> visibilities) {
        Validate.notNull((Object)template, (String)"\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(visibilities) ? 1 : 0) != 0, (String)"\u672a\u53d1\u73b0\u6a21\u677f\u63a7\u4ef6\u53ef\u89c1\u6027\u6570\u636e , \u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        HashSet<String> visibilityNameSet = new HashSet<String>();
        for (TemplateVisibilityEntity visibility : visibilities) {
            Validate.notNull((Object)visibility.getCanDelete(), (String)"\u53ef\u89c1\u6027\u662f\u5426\u80fd\u591f\u5220\u9664\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)visibility.getVisibilityName(), (String)"\u53ef\u89c1\u6027\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Validate.notNull((Object)visibility.getCreateTime(), (String)"\u521b\u5efa\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Validate.isTrue((boolean)visibilityNameSet.add(visibility.getVisibilityName()), (String)"\u53ef\u89c1\u6027\u540d\u79f0:%s ,\u91cd\u590d,\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{visibility.getVisibilityName()});
        }
    }

    @Override
    @Transactional
    public Set<TemplateVisibilityEntity> save(TemplateEntity template, Set<TemplateVisibilityEntity> visibilities) {
        HashSet<TemplateVisibilityEntity> savedVisibilities = new HashSet<TemplateVisibilityEntity>();
        this.saveValidation(template, visibilities);
        Set<TemplateVisibilityEntity> oldVisibilityList = this.templateVisibilityRepository.findByTemplateId(template.getId());
        if (oldVisibilityList == null) {
            oldVisibilityList = new HashSet<TemplateVisibilityEntity>();
        }
        HashSet<TemplateVisibilityEntity> oldVisibilities = new HashSet<TemplateVisibilityEntity>(oldVisibilityList);
        Map visibilitiesMap = visibilities.stream().collect(Collectors.toMap(TemplateVisibilityEntity::getVisibilityName, visibility -> visibility, (a, b) -> b, () -> new HashMap(16)));
        HashSet addVisibilities = new HashSet();
        HashSet updateVisibilities = new HashSet();
        HashSet deleteVisibilities = new HashSet();
        this.kuiperToolkitService.collectionDiscrepancy(visibilities, oldVisibilities, TemplateVisibilityEntity::getVisibilityName, deleteVisibilities, updateVisibilities, addVisibilities);
        Date date = new Date();
        for (TemplateVisibilityEntity visibility2 : deleteVisibilities) {
            Validate.isTrue((boolean)visibility2.getCanDelete(), (String)"\u53ef\u89c1\u6027\u3010%s\u3011\u4e0d\u80fd\u5220\u9664", (Object[])new Object[]{visibility2.getVisibilityName()});
            int count = this.instanceActivityRepository.countByVisibilityId(visibility2.getId());
            Validate.isTrue((count == 0 ? 1 : 0) != 0, (String)"\u53ef\u89c1\u6027\u3010%s\u3011\u5df2\u4ea7\u751f\u6d3b\u52a8\u4fe1\u606f\uff0c\u4e0d\u8fd0\u884c\u8fdb\u884c\u5220\u9664\u64cd\u4f5c\uff0c\u8bf7\u5347\u7ea7\u6a21\u677f\u8fdb\u884c\u53d8\u66f4\uff01\uff01", (Object[])new Object[]{visibility2.getVisibilityName()});
            this.templateVisibilityButtonService.deleteByVisibilityId(visibility2.getId());
            this.templateVisibilityAttributeService.deleteByVisibilityId(visibility2.getId());
            this.templateVisibilityRepository.delete(visibility2);
        }
        for (TemplateVisibilityEntity visibility2 : addVisibilities) {
            visibility2.setId(null);
            visibility2.setTemplate(template);
            visibility2.setCreateTime(date);
            this.templateVisibilityRepository.save(visibility2);
            Set<TemplateVisibilityAttributesEntity> attributes = this.templateVisibilityAttributeService.save(visibility2, visibility2.getAttributes());
            Set<TemplateVisibilityButtonsEntity> buttons = this.templateVisibilityButtonService.save(visibility2, visibility2.getButtons());
            visibility2.setAttributes(attributes);
            visibility2.setButtons(buttons);
            savedVisibilities.add(visibility2);
        }
        for (TemplateVisibilityEntity visibility2 : updateVisibilities) {
            TemplateVisibilityEntity newVisibility = (TemplateVisibilityEntity)visibilitiesMap.get(visibility2.getVisibilityName());
            visibility2.setCanDelete(newVisibility.getCanDelete());
            this.templateVisibilityRepository.save(visibility2);
            Set<TemplateVisibilityAttributesEntity> attributes = this.templateVisibilityAttributeService.save(visibility2, newVisibility.getAttributes());
            Set<TemplateVisibilityButtonsEntity> buttons = this.templateVisibilityButtonService.save(visibility2, newVisibility.getButtons());
            visibility2.setAttributes(attributes);
            visibility2.setButtons(buttons);
            savedVisibilities.add(visibility2);
        }
        return savedVisibilities;
    }

    @Override
    @Transactional
    public Set<TemplateVisibilityEntity> upgrade(String templateId, Set<TemplateVisibilityEntity> templateVisibilities) {
        Validate.notBlank((CharSequence)templateId, (String)"\u5347\u7ea7\u65f6,\u539f\u59cb\u6307\u5b9a\u7684templateId\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        TemplateEntity template = this.templateService.findById(templateId);
        Validate.notNull((Object)template, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u6a21\u677f\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        if (templateVisibilities == null || templateVisibilities.isEmpty()) {
            return null;
        }
        LinkedHashSet<TemplateVisibilityEntity> newTemplateVisibilities = new LinkedHashSet<TemplateVisibilityEntity>();
        for (TemplateVisibilityEntity templateVisibility : templateVisibilities) {
            Set visibilityButtons;
            TemplateVisibilityEntity newTemplateVisibility = new TemplateVisibilityEntity();
            newTemplateVisibility.setId(null);
            newTemplateVisibility.setCanDelete(templateVisibility.getCanDelete());
            newTemplateVisibility.setCreateTime(new Date());
            newTemplateVisibility.setVisibilityName(templateVisibility.getVisibilityName());
            newTemplateVisibility.setTemplate(template);
            this.templateVisibilityRepository.save(newTemplateVisibility);
            Set visibilityAttributes = templateVisibility.getAttributes();
            if (visibilityAttributes != null && !visibilityAttributes.isEmpty()) {
                LinkedHashSet<TemplateVisibilityAttributesEntity> newVisibilityAttributes = new LinkedHashSet<TemplateVisibilityAttributesEntity>();
                for (TemplateVisibilityAttributesEntity visibilityAttribute : visibilityAttributes) {
                    TemplateVisibilityAttributesEntity newVisibilityAttribute = new TemplateVisibilityAttributesEntity();
                    newVisibilityAttribute.setId(null);
                    newVisibilityAttribute.setAttributeName(visibilityAttribute.getAttributeName());
                    newVisibilityAttribute.setControllerId(visibilityAttribute.getControllerId());
                    newVisibilityAttribute.setNullable(visibilityAttribute.getNullable());
                    newVisibilityAttribute.setVisibilityType(visibilityAttribute.getVisibilityType());
                    newVisibilityAttribute.setTemplateVisibility(newTemplateVisibility);
                    newVisibilityAttribute.setLayoutType(visibilityAttribute.getLayoutType());
                    newVisibilityAttributes.add(newVisibilityAttribute);
                }
                newTemplateVisibility.setAttributes(newVisibilityAttributes);
                this.templateVisibilityAttributesRepository.saveAll(newVisibilityAttributes);
            }
            if ((visibilityButtons = templateVisibility.getButtons()) != null && !visibilityButtons.isEmpty()) {
                LinkedHashSet<TemplateVisibilityButtonsEntity> newVisibilityButtons = new LinkedHashSet<TemplateVisibilityButtonsEntity>();
                for (TemplateVisibilityButtonsEntity visibilityButton : visibilityButtons) {
                    TemplateVisibilityButtonsEntity newVisibilityButton = new TemplateVisibilityButtonsEntity();
                    newVisibilityButton.setId(null);
                    newVisibilityButton.setControllerId(visibilityButton.getControllerId());
                    newVisibilityButton.setVisible(visibilityButton.getVisible());
                    newVisibilityButton.setTemplateVisibility(newTemplateVisibility);
                    newVisibilityButton.setLayoutType(visibilityButton.getLayoutType());
                    newVisibilityButtons.add(newVisibilityButton);
                }
                newTemplateVisibility.setButtons(newVisibilityButtons);
                this.templateVisibilityButtonRepository.saveAll(newVisibilityButtons);
            }
            newTemplateVisibilities.add(newTemplateVisibility);
        }
        return newTemplateVisibilities;
    }

    @Override
    @Transactional
    public void deleteByTemplateId(String templateId) {
        if (StringUtils.isBlank((CharSequence)templateId)) {
            return;
        }
        TemplateEntity currentTemplate = this.templateService.findById(templateId);
        if (currentTemplate == null) {
            return;
        }
        Set<TemplateVisibilityEntity> templateVisibilities = this.templateVisibilityRepository.findByTemplateId(templateId);
        if (templateVisibilities == null || templateVisibilities.isEmpty()) {
            return;
        }
        for (TemplateVisibilityEntity templateVisibilityItem : templateVisibilities) {
            this.templateVisibilityAttributesRepository.deleteByTemplateVisibilityId(templateVisibilityItem.getId());
            this.templateVisibilityButtonRepository.deleteByTemplateVisibilityId(templateVisibilityItem.getId());
            this.templateVisibilityRepository.delete(templateVisibilityItem);
        }
    }

    @Override
    public Set<TemplateVisibilityEntity> findDetailsByTemplateId(String templateId) {
        if (StringUtils.isBlank((CharSequence)templateId)) {
            return null;
        }
        return this.templateVisibilityRepository.findDetailsByTemplateId(templateId);
    }

    @Override
    public TemplateVisibilityEntity findByTemplateIdAndVisibilityName(String templateId, String visibilityName) {
        if (StringUtils.isBlank((CharSequence)templateId) || StringUtils.isBlank((CharSequence)visibilityName)) {
            return null;
        }
        return this.templateVisibilityRepository.findByTemplateIdAndVisibilityName(templateId, visibilityName);
    }

    @Override
    public Set<TemplateVisibilityEntity> findDetailsByTemplateIdAndLayoutType(String templateId, Integer layoutType) {
        if (StringUtils.isBlank((CharSequence)templateId)) {
            return null;
        }
        if (layoutType == null) {
            layoutType = TemplateLayoutTypeEnum.PC.getType();
        }
        Set<TemplateVisibilityEntity> visibilities = this.templateVisibilityRepository.findVisibilityAndAttributesByTemplateIdAndLayoutType(templateId, layoutType);
        Set<TemplateVisibilityEntity> visibilitiesAndButtons = this.templateVisibilityRepository.findVisibilityAndButtonsByTemplateIdAndLayoutType(templateId, layoutType);
        this.merge(visibilities, visibilitiesAndButtons);
        return visibilities;
    }

    private Set<TemplateVisibilityEntity> merge(Set<TemplateVisibilityEntity> visibilities, Set<TemplateVisibilityEntity> visibilitiesAndButtons) {
        if (CollectionUtils.isEmpty(visibilities) || CollectionUtils.isEmpty(visibilitiesAndButtons)) {
            return visibilities;
        }
        Map tmpMap = visibilitiesAndButtons.stream().collect(Collectors.toMap(UuidEntity::getId, visibility -> visibility, (a, b) -> b, () -> new HashMap(8)));
        for (TemplateVisibilityEntity visibility2 : visibilities) {
            TemplateVisibilityEntity entity = (TemplateVisibilityEntity)tmpMap.get(visibility2.getId());
            if (entity == null) continue;
            visibility2.setButtons(entity.getButtons());
        }
        return visibilities;
    }

    @Override
    public TemplateVisibilityEntity findDetailsByTemplateIdAndVisibilityNameAndLayoutType(String templateId, String visibilityName, Integer layoutType) {
        TemplateVisibilityEntity visibility = this.findByTemplateIdAndVisibilityName(templateId, visibilityName);
        this.loadDetails(visibility, layoutType);
        return visibility;
    }

    private TemplateVisibilityEntity loadDetails(TemplateVisibilityEntity visibility, Integer layoutType) {
        if (visibility == null) {
            return visibility;
        }
        if (layoutType == null) {
            layoutType = TemplateLayoutTypeEnum.PC.getType();
        }
        Set<TemplateVisibilityAttributesEntity> attributes = this.templateVisibilityAttributeService.findByVisibilityIdAndLayoutType(visibility.getId(), layoutType);
        Set<TemplateVisibilityButtonsEntity> buttons = this.templateVisibilityButtonService.findByVisibilityIdAndLayoutType(visibility.getId(), layoutType);
        visibility.setAttributes(attributes);
        visibility.setButtons(buttons);
        return visibility;
    }
}

