/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.migrate;

import com.bizunited.platform.core.service.NebulaStaticPersistentService;
import com.bizunited.platform.core.service.file.NebulaFileService;
import com.bizunited.platform.kuiper.entity.FrontFileEntity;
import com.bizunited.platform.kuiper.entity.ListTemplateEntity;
import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.entity.TemplateMigrateImportAnalysisEntity;
import com.bizunited.platform.kuiper.entity.TemplateMigrateImportAnalysisItemEntity;
import com.bizunited.platform.kuiper.entity.TemplateMigrateImportEntity;
import com.bizunited.platform.kuiper.service.TemplateService;
import com.bizunited.platform.kuiper.starter.repository.table.TableOperateRepositoryCustom;
import com.bizunited.platform.kuiper.starter.repository.templateMigrate.TemplateMigrateImportAnalysisRepository;
import com.bizunited.platform.kuiper.starter.service.ListTemplateService;
import com.bizunited.platform.kuiper.starter.service.migrate.TemplateMigrateImportAnalysisItemService;
import com.bizunited.platform.kuiper.starter.service.migrate.TemplateMigrateImportAnalysisService;
import com.bizunited.platform.kuiper.starter.service.migrate.TemplateMigrateImportService;
import com.bizunited.platform.saturn.model.PersistentClass;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="TemplateMigrateImportAnalysisServiceImpl")
public class TemplateMigrateImportAnalysisServiceImpl
implements TemplateMigrateImportAnalysisService {
    @Value(value="${kuiper.file.fileRoot}")
    private String fileRoot;
    @Autowired
    private TemplateMigrateImportAnalysisRepository templateMigrateImportAnalysisRepository;
    @Autowired
    private TemplateMigrateImportService templateMigrateImportService;
    @Autowired
    private TemplateService templateService;
    @Autowired
    private NebulaFileService nebulaFileService;
    @Autowired
    private TemplateMigrateImportAnalysisItemService templateMigrateImportAnalysisItemService;
    @Autowired
    private NebulaStaticPersistentService nebulaStaticPersistentService;
    @Autowired
    private ListTemplateService listTemplateService;
    @Autowired
    private TableOperateRepositoryCustom tableOperateRepositoryCustom;

    @Override
    public List<TemplateMigrateImportAnalysisEntity> findByImport(String importId) {
        if (StringUtils.isBlank((CharSequence)importId)) {
            return null;
        }
        return this.templateMigrateImportAnalysisRepository.findByImport(importId);
    }

    @Override
    public TemplateMigrateImportAnalysisEntity findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.templateMigrateImportAnalysisRepository.findDetailById(id);
    }

    @Override
    @Transactional
    public TemplateMigrateImportAnalysisEntity analysis(String templateMigrateImportId) {
        Throwable throwable;
        Validate.notBlank((CharSequence)templateMigrateImportId, (String)"\u4f20\u5165\u8868\u5355\u4e0a\u4f20\u8bb0\u5f55ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        TemplateMigrateImportEntity recordEntity = this.templateMigrateImportService.findById(templateMigrateImportId);
        Validate.notNull((Object)recordEntity, (String)"\u4f20\u5165\u8868\u5355\u4e0a\u4f20\u8bb0\u5f55\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String fileName = recordEntity.getFileName();
        String relativeLocal = recordEntity.getRelativeLocal();
        byte[] fileBytes = this.nebulaFileService.readFileContent(relativeLocal, fileName);
        TemplateMigrateImportAnalysisEntity analysisEntity = new TemplateMigrateImportAnalysisEntity();
        TemplateMigrateImportEntity importEntity = this.templateMigrateImportService.findById(templateMigrateImportId);
        Validate.notNull((Object)importEntity, (String)"\u5206\u6790\u4f20\u5165\u7684\u8fc1\u79fb\u4e0a\u4f20\u4fe1\u606f\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        analysisEntity.setTemplateMigrateImportEntity(importEntity);
        String zipFileName = "serial.in";
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(fileBytes);
        String uuid = UUID.randomUUID().toString();
        File localFile = new File(StringUtils.join((Object[])new String[]{this.fileRoot, "/", uuid, ".zip"}));
        try {
            if (!localFile.exists()) {
                Boolean createFlag = localFile.createNewFile();
                Validate.isTrue((boolean)createFlag, (String)"\u521b\u5efa\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        try {
            throwable = null;
            try (FileOutputStream os = new FileOutputStream(localFile);){
                int realLen;
                int maxLen = 4096;
                byte[] contents = new byte[maxLen];
                while ((realLen = byteArrayInputStream.read(contents, 0, maxLen)) != -1) {
                    os.write(contents, 0, realLen);
                }
            }
            catch (Throwable maxLen) {
                throwable = maxLen;
                throw maxLen;
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("\u89e3\u6790\u4e0a\u4f20\u6587\u4ef6\u6a21\u677f\u6570\u636e\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
        try {
            throwable = null;
            try (ZipFile zipFile = new ZipFile(localFile);){
                ZipEntry zipEntry = zipFile.getEntry(zipFileName);
                Validate.notNull((Object)zipEntry, (String)"\u6587\u4ef6\u4e0d\u5408\u89c4\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
                InputStream is = zipFile.getInputStream(zipEntry);
                ObjectInputStream ois = new ObjectInputStream(is);
                Integer formSize = ois.readInt();
                Validate.isTrue((formSize >= 0 ? 1 : 0) != 0, (String)"\u8bfb\u53d6\u7684\u8868\u5355\u6570\u91cf\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
                Integer listSize = ois.readInt();
                Validate.isTrue((listSize >= 0 ? 1 : 0) != 0, (String)"\u8bfb\u53d6\u7684\u5217\u8868\u6570\u91cf\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
                Integer frontFileSize = ois.readInt();
                Validate.isTrue((frontFileSize >= 0 ? 1 : 0) != 0, (String)"\u8bfb\u53d6\u7684\u524d\u7aef\u51fd\u6570\u6570\u91cf\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
                List<TemplateMigrateImportAnalysisItemEntity> all = new ArrayList<TemplateMigrateImportAnalysisItemEntity>();
                ArrayList<TemplateMigrateImportAnalysisItemEntity> templates = new ArrayList<TemplateMigrateImportAnalysisItemEntity>();
                analysisEntity.setTemplateTotalNum(formSize);
                for (int i = 0; i < formSize && formSize > 0; ++i) {
                    Object layoutSize;
                    TemplateMigrateImportAnalysisItemEntity item = new TemplateMigrateImportAnalysisItemEntity();
                    TemplateEntity templateEntity = (TemplateEntity)ois.readObject();
                    this.validTemplateEntity(item, templateEntity);
                    if (templateEntity != null) {
                        item.setCode(templateEntity.getCode());
                        item.setCversion(templateEntity.getCversion());
                        item.setFormType(Integer.valueOf(1));
                        item.setName(templateEntity.getName());
                    }
                    Validate.isTrue(((Integer)(layoutSize = Integer.valueOf(ois.readInt())) >= 0 ? 1 : 0) != 0, (String)"\u8bfb\u53d6\u7684\u6570\u91cf\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
                    Integer excelEntitySize = ois.readInt();
                    Validate.isTrue((excelEntitySize >= 0 ? 1 : 0) != 0, (String)"\u8bfb\u53d6\u7684\u6570\u91cf\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
                    this.validLayoutSize(item, (Integer)layoutSize);
                    for (int layoutInt = 0; layoutSize != null && layoutInt < (Integer)layoutSize; ++layoutInt) {
                        ois.readObject();
                    }
                    for (int excelInt = 0; excelEntitySize != null && excelInt < excelEntitySize; ++excelInt) {
                        ois.readObject();
                    }
                    templates.add(item);
                }
                all.addAll(templates);
                Integer templateCreateNum = 0;
                Integer templateUpdateNum = 0;
                Integer templateErrorNum = 0;
                for (TemplateMigrateImportAnalysisItemEntity item : templates) {
                    Integer n;
                    Integer excelInt;
                    if (item.getMigrateStatus() == 1) {
                        excelInt = templateCreateNum;
                        n = templateCreateNum = Integer.valueOf(templateCreateNum + 1);
                    }
                    if (item.getMigrateStatus() == 2) {
                        excelInt = templateUpdateNum;
                        n = templateUpdateNum = Integer.valueOf(templateUpdateNum + 1);
                    }
                    if (item.getMigrateStatus() != 3) continue;
                    excelInt = templateErrorNum;
                    n = templateErrorNum = Integer.valueOf(templateErrorNum + 1);
                }
                analysisEntity.setTemplateCreateNum(templateCreateNum);
                analysisEntity.setTemplateUpdateNum(templateUpdateNum);
                analysisEntity.setTemplateErrorNum(templateErrorNum);
                analysisEntity.setListTotalNum(listSize);
                ArrayList<TemplateMigrateImportAnalysisItemEntity> listTemplates = new ArrayList<TemplateMigrateImportAnalysisItemEntity>();
                for (int i = 0; i < listSize; ++i) {
                    TemplateMigrateImportAnalysisItemEntity item = new TemplateMigrateImportAnalysisItemEntity();
                    ListTemplateEntity listTemplate = (ListTemplateEntity)ois.readObject();
                    this.validListEntity(item, listTemplate);
                    if (listTemplate != null) {
                        item.setCode(listTemplate.getCode());
                        item.setCversion(listTemplate.getCversion());
                        item.setFormType(Integer.valueOf(2));
                        item.setName(listTemplate.getName());
                    }
                    listTemplates.add(item);
                }
                all.addAll(listTemplates);
                Integer listCreateNum = 0;
                Integer listUpdateNum = 0;
                Integer listErrorNum = 0;
                for (TemplateMigrateImportAnalysisItemEntity item : listTemplates) {
                    Integer n;
                    Integer n2;
                    if (item.getMigrateStatus() == 1) {
                        n2 = listCreateNum;
                        n = listCreateNum = Integer.valueOf(listCreateNum + 1);
                    }
                    if (item.getMigrateStatus() == 2) {
                        n2 = listUpdateNum;
                        n = listUpdateNum = Integer.valueOf(listUpdateNum + 1);
                    }
                    if (item.getMigrateStatus() != 3) continue;
                    n2 = listErrorNum;
                    n = listErrorNum = Integer.valueOf(listErrorNum + 1);
                }
                analysisEntity.setListCreateNum(listCreateNum);
                analysisEntity.setListUpdateNum(listUpdateNum);
                analysisEntity.setListErrorNum(listErrorNum);
                Integer frontCreateNum = 0;
                Integer frontErrorNum = 0;
                for (int j = 0; j < frontFileSize; ++j) {
                    FrontFileEntity frontFileEntity = (FrontFileEntity)ois.readObject();
                    Validate.notNull((Object)frontFileEntity, (String)"\u8bfb\u53d6\u524d\u7aef\u6587\u4ef6Entity\u65f6\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
                    Boolean startWith = StringUtils.startsWith((CharSequence)frontFileEntity.getFilePath(), (CharSequence)"/") || StringUtils.startsWith((CharSequence)frontFileEntity.getFilePath(), (CharSequence)"\\");
                    String zipFrontFilePath = startWith != false ? frontFileEntity.getFilePath().substring(1) : frontFileEntity.getFilePath();
                    String frontFileZipPath = StringUtils.join((Object[])new String[]{zipFrontFilePath, "/", frontFileEntity.getFileName()});
                    ZipEntry frontFileEntry = zipFile.getEntry(frontFileZipPath);
                    if (frontFileEntry == null) {
                        frontErrorNum = frontErrorNum + 1;
                        continue;
                    }
                    frontCreateNum = frontCreateNum + 1;
                }
                analysisEntity.setFrontFileCreateNum(frontCreateNum);
                analysisEntity.setFrontFileErrorNum(frontErrorNum);
                analysisEntity = (TemplateMigrateImportAnalysisEntity)this.templateMigrateImportAnalysisRepository.saveAndFlush(analysisEntity);
                for (TemplateMigrateImportAnalysisItemEntity item : all) {
                    item.setAnalysisEntity(analysisEntity);
                }
                all = this.templateMigrateImportAnalysisItemService.save(all);
                HashSet<TemplateMigrateImportAnalysisItemEntity> setItems = new HashSet<TemplateMigrateImportAnalysisItemEntity>(all);
                analysisEntity.setAnalysisItemEntities(setItems);
                Boolean deleteFlag = localFile.delete();
                Validate.isTrue((boolean)deleteFlag, (String)"\u5220\u9664\u4e34\u65f6\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IllegalArgumentException("\u89e3\u6790\u4e0a\u4f20\u6587\u4ef6\u6a21\u677f\u6570\u636e\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
        return analysisEntity;
    }

    public void validTemplateEntity(TemplateMigrateImportAnalysisItemEntity itemEntity, TemplateEntity templateEntity) {
        if (templateEntity == null) {
            itemEntity.setMigrateStatus(Integer.valueOf(3));
            itemEntity.setMessage(itemEntity.getMessage().concat("\u6b64\u6a21\u677f\u5b9e\u4f53\u4e3a\u7a7a\u3002"));
            return;
        }
        List exist = this.templateService.findByCode(templateEntity.getCode());
        if (!CollectionUtils.isEmpty((Collection)exist)) {
            exist = exist.stream().filter(o -> StringUtils.equals((CharSequence)o.getCversion(), (CharSequence)templateEntity.getCversion())).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty((Collection)exist)) {
            itemEntity.setMigrateStatus(Integer.valueOf(2));
            itemEntity.setMessage(itemEntity.getMessage().concat("\u6b64\u6a21\u677f\u7f16\u53f7\u5df2\u5b58\u5728\uff0c\u5c06\u8fdb\u884c\u8986\u76d6\u3002"));
        }
        if (StringUtils.equals((CharSequence)templateEntity.getType(), (CharSequence)"static")) {
            templateEntity.setCode(templateEntity.getPersistentClassName());
            Validate.notBlank((CharSequence)templateEntity.getCode(), (String)StringUtils.join((Object[])new String[]{"\u8fc1\u79fb\u65f6\u8868\u5355\u6a21\u677fcode\u4e0d\u80fd\u4e3a\u7a7a\uff01", "ID:", templateEntity.getId(), ",\u76f8\u5173\u7248\u672c\uff1a", templateEntity.getCversion()}), (Object[])new Object[0]);
            String persistentClassName = templateEntity.getPersistentClassName();
            if (StringUtils.isBlank((CharSequence)persistentClassName)) {
                itemEntity.setMigrateStatus(Integer.valueOf(3));
                itemEntity.setMessage(itemEntity.getMessage().concat("\u8be5\u9759\u6001\u8868\u5355\u6a21\u677f\u5728\u5bf9\u5e94\u9759\u6001\u6a21\u578b\u540d\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002"));
            } else {
                PersistentClass persistentClass = this.nebulaStaticPersistentService.findByPersistentClass(persistentClassName);
                if (null == persistentClass) {
                    itemEntity.setMigrateStatus(Integer.valueOf(3));
                    itemEntity.setMessage(itemEntity.getMessage().concat("\u672a\u627e\u5230\u8be5\u9759\u6001\u8868\u5355\u6a21\u677f\u5728\u672c\u7cfb\u7edf\u5185\u7684\u5bf9\u5e94\u9759\u6001\u6a21\u578b\uff0c\u8bf7\u68c0\u67e5\u3002"));
                }
            }
        } else if (StringUtils.equals((CharSequence)templateEntity.getType(), (CharSequence)"dynamic")) {
            Boolean tableExist = this.tableOperateRepositoryCustom.existTableName(templateEntity.getTableName());
            if (tableExist.booleanValue()) {
                itemEntity.setMigrateStatus(Integer.valueOf(3));
                itemEntity.setMessage("\u8be5\u52a8\u6001\u8868\u5355\u7684\u6570\u636e\u5e93\u540d\u5728\u672c\u73af\u5883\u5df2\u5b58\u5728\uff0c\u5c06\u4e0d\u505a\u8fc1\u79fb\u3002");
            }
        } else {
            itemEntity.setMigrateStatus(Integer.valueOf(3));
            itemEntity.setMessage(itemEntity.getMessage().concat("\u8be5\u8868\u5355\u6a21\u677f\u7c7b\u578b\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01"));
        }
    }

    private void validListEntity(TemplateMigrateImportAnalysisItemEntity itemEntity, ListTemplateEntity listTemplate) {
        if (listTemplate == null) {
            itemEntity.setMigrateStatus(Integer.valueOf(3));
            itemEntity.setMessage(itemEntity.getMessage().concat("\u6b64\u5217\u8868\u6a21\u677f\u5b9e\u4f53\u4e3a\u7a7a\u3002"));
            return;
        }
        Set<Object> existLists = this.listTemplateService.findByCode(listTemplate.getCode());
        if (CollectionUtils.isEmpty(existLists)) {
            return;
        }
        if (!CollectionUtils.isEmpty(existLists = existLists.stream().filter(o -> StringUtils.equals((CharSequence)o.getCversion(), (CharSequence)listTemplate.getCversion())).collect(Collectors.toSet()))) {
            itemEntity.setMigrateStatus(Integer.valueOf(2));
            itemEntity.setMessage(itemEntity.getMessage().concat("\u6b64\u5217\u8868\u6a21\u677f\u5b58\u5728\u76f8\u540c\u7f16\u53f7-\u7248\u672c\uff0c\u5c06\u66f4\u65b0\u3002"));
        }
    }

    private void validLayoutSize(TemplateMigrateImportAnalysisItemEntity itemEntity, Integer layoutSize) {
        if (null == layoutSize) {
            itemEntity.setMigrateStatus(Integer.valueOf(3));
            itemEntity.setMessage(itemEntity.getMessage().concat("\u6b64\u6a21\u677f\u7f3a\u5c11\u5e03\u5c40\u4fe1\u606f\u6570\u91cf\uff01"));
        } else if (layoutSize < 1 || layoutSize > 3) {
            itemEntity.setMigrateStatus(Integer.valueOf(3));
            itemEntity.setMessage(itemEntity.getMessage().concat("\u6b64\u6a21\u677f\u5e03\u5c40\u4fe1\u606f\u6570\u91cf\u5f02\u5e38\uff08\u4e0d\u57281-3\u4e4b\u95f4\uff09\uff0c\u8bf7\u68c0\u67e5\uff01"));
        }
    }
}

