/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.controller;

import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.service.DynamicTemplateService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.security.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="DynamicTemplateController")
@RestController
@RequestMapping(value={"/v1/kuiper/dynamicTemplates"})
public class DynamicTemplateController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicTemplateController.class);
    @Autowired
    private DynamicTemplateService dynamicTemplateService;

    @ApiOperation(value="\u521d\u59cb\u5316\u52a8\u6001\u6a21\u677f\uff0c\u5305\u62ec\u52a8\u6001\u6a21\u677f\u4e2d\u7684\u4e00\u822c\u5c5e\u6027\u3001\u5173\u8054\u5c5e\u6027\u3001\u660e\u7ec6\u7f16\u8f91\u5c5e\u6027\u548c\u5206\u7ec4\u5c5e\u6027\uff0c\u5305\u62ec\u5efa\u7acb\u4e2a\u4e3b\u8981\u6570\u636e\u8868\u548c\u660e\u7ec6\u3001\u5206\u7ec4\u5173\u8054\u6570\u636e\u8868", notes="")
    @PostMapping(value={"/initDynamicTemplate"})
    @CacheEvict(cacheNames={"template"}, allEntries=true)
    public ResponseModel initDynamicTemplate(@RequestBody @ApiParam(name="template", value="\u65b0\u7684\u8868\u5355\u6a21\u677f\u4fe1\u606f\uff0c\u81f3\u5c11\u8bf4\u660e\u7248\u672c\u4fe1\u606f\u3001\u6a21\u677f\u7c7b\u578b\u3001\u5df2\u7ecf\u4f7f\u7528\u7684\u9759\u6001\u7c7b\u5168\u540d\uff0c\u5176\u5b83\u4e0d\u9700\u8981\u6307\u5b9a\u4e86") TemplateEntity template) {
        try {
            Principal principal = this.getPrincipal();
            TemplateEntity result = this.dynamicTemplateService.initDynamicTemplate(template, principal);
            return this.buildHttpReslutW(result, new String[]{"properties", "relations", "creator", "groupRelations", "groupRelations.properties", "groupRelations.relations", "groupRelations.itemRelations", "groupRelations.itemRelations.properties", "groupRelations.itemRelations.relations", "itemRelations", "itemRelations.properties", "itemRelations.relations", "event", "visibility", "visibility.attributes", "visibility.buttons"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpReslutForException(e);
        }
    }

    @ApiOperation(value="\u5bf9\u6307\u5b9a\u7684\u52a8\u6001\u8868\u5355\u6a21\u677f\u8fdb\u884c\u5347\u7ea7\u5904\u7406\uff0c\u901a\u8fc7\u8fd9\u4e2a\u63a5\u53e3\u670d\u52a1\u7cfb\u7edf\u5c06\u81ea\u52a8\u4fdd\u7559templateId\u5bf9\u5e94\u7684\u6a21\u677f\u7684\u5168\u90e8\u4e3b\u8981\u8bbe\u5b9a\uff08\u5305\u62ec\u6a21\u578b\u3001\u6570\u636e\u6e90\u3001\u4e8b\u4ef6\u3001\u53ef\u89c1\u6027\uff09")
    @PutMapping(value={""})
    @CacheEvict(cacheNames={"template"}, allEntries=true)
    public ResponseModel upgrade(@RequestParam(name="templateId") @ApiParam(name="templateId", value="\u6307\u5b9a\u7684\u8868\u5355\u6a21\u677f\u5347\u7ea7\u65f6\u4f7f\u7528\u7684\u53c2\u8003\u6a21\u677f") String templateId, @RequestBody @ApiParam(name="newTemplate", value="\u65b0\u7684\u5b8c\u6210\u7684\u52a8\u6001\u8868\u5355\u6a21\u677f\u7ed3\u6784\uff0cid\u3001formInstanceId\u5b9e\u4f8b\u5b57\u6bb5\u4e0d\u9700\u8981\u4f20\u5165") TemplateEntity newTemplate, @RequestParam(name="newVersion") @ApiParam(name="newVersion", value="\u65b0\u7684\u7248\u672c\u53f7") String newVersion) {
        try {
            Principal principal = this.getPrincipal();
            TemplateEntity result = this.dynamicTemplateService.upgrade(templateId, newTemplate, newVersion, principal);
            return this.buildHttpReslutW(result, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpReslutForException(e);
        }
    }

    @ApiOperation(value="\u5bf9\u6307\u5b9a\u7684\u52a8\u6001\u8868\u5355\u6a21\u677f\u8fdb\u884c\u5347\u7ea7\u5904\u7406\u65f6\uff0c\u9700\u8981\u83b7\u53d6\u539f\u6709\u6a21\u677f\u7684\u7ed3\u6784\u4fe1\u606f\uff0c\u540c\u65f6\u8fc7\u6ee4\u6389id\uff0cformInstanceId\u4ee5\u53ca\u56de\u6eaf\u5173\u7cfb\u7b49")
    @GetMapping(value={"/findStructByTemplateId"})
    public ResponseModel findStructByTemplateId(@RequestParam(name="templateId") @ApiParam(name="templateId", value="\u6307\u5b9a\u7684\u8868\u5355\u6a21\u677f\u5347\u7ea7\u65f6\u4f7f\u7528\u7684\u53c2\u8003\u6a21\u677f") String templateId) {
        try {
            TemplateEntity result = this.dynamicTemplateService.findStructByTemplateId(templateId);
            return this.buildHttpReslutW(result, new String[]{"properties", "relations", "groupRelations", "groupRelations.properties", "groupRelations.relations", "groupRelations.itemRelations", "groupRelations.itemRelations.properties", "groupRelations.itemRelations.relations", "itemRelations", "itemRelations.properties", "itemRelations.relations"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpReslutForException(e);
        }
    }
}

