/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.controller;

import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.kuiper.entity.InstanceContextEntity;
import com.bizunited.platform.kuiper.starter.service.InstanceContextService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/kuiper/instanceContexts"})
public class InstanceContextController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstanceContextController.class);
    @Autowired
    private InstanceContextService instanceContextService;

    @PostMapping(value={""})
    @ApiOperation(value="\u4fdd\u5b58\u8868\u5355\u5b9e\u4f8b\u4e0a\u4e0b\u6587\u660e\u7ec6", notes="\u4fdd\u5b58\u8868\u5355\u5b9e\u4f8b\u4e0a\u4e0b\u6587\u660e\u7ec6")
    public ResponseModel save(@RequestBody @ApiParam(name="\u8868\u5355\u5b9e\u4f8b\u4e0a\u4e0b\u6587\u660e\u7ec6", required=true) List<InstanceContextEntity> instanceContexts, @RequestParam(name="instanceId") @ApiParam(value="\u8868\u5355\u5b9e\u4f8bID", required=true) String instanceId) {
        try {
            List<InstanceContextEntity> savedInstanceContexts = this.instanceContextService.save(instanceId, instanceContexts);
            return this.buildHttpReslutW(savedInstanceContexts, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpReslutForException(e);
        }
    }

    @GetMapping(value={"/findByInstanceId"})
    @ApiOperation(value="\u67e5\u8be2\u8868\u5355\u5b9e\u4f8b\u4e0a\u4e0b\u6587\u660e\u7ec6", notes="\u67e5\u8be2\u8868\u5355\u5b9e\u4f8b\u4e0a\u4e0b\u6587\u660e\u7ec6")
    public ResponseModel findByInstanceId(@RequestParam(name="instanceId") @ApiParam(value="\u8868\u5355\u5b9e\u4f8bID", required=true) String instanceId) {
        try {
            List<InstanceContextEntity> instanceContexts = this.instanceContextService.findByInstanceId(instanceId);
            return this.buildHttpReslutW(instanceContexts, new String[]{""});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpReslutForException(e);
        }
    }

    @GetMapping(value={"/findByInstanceIdAndName"})
    @ApiOperation(value="\u6839\u7eddname\u67e5\u8be2\u8868\u5355\u5b9e\u4f8b\u4e0a\u4e0b\u6587\u660e\u7ec6", notes="\u6839\u7eddname\u67e5\u8be2\u8868\u5355\u5b9e\u4f8b\u4e0a\u4e0b\u6587\u660e\u7ec6")
    public ResponseModel findByInstanceIdAndName(@RequestParam(name="instanceId") @ApiParam(value="\u8868\u5355\u5b9e\u4f8bID", required=true) String instanceId, @RequestParam(name="name") @ApiParam(value="\u4e0a\u4e0b\u6587\u660e\u7ec6\u540d\u79f0", required=true) String name) {
        try {
            InstanceContextEntity instanceContext = this.instanceContextService.findByInstanceIdAndName(instanceId, name);
            return this.buildHttpReslutW(instanceContext, new String[]{""});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpReslutForException(e);
        }
    }

    @DeleteMapping(value={"/deleteByInstanceIdAndName"})
    @ApiOperation(value="\u6839\u636e\u8868\u5355\u5b9e\u4f8b\u5220\u9664\u4e0a\u4e0b\u6587\u7684\u503c", notes="\u6839\u636e\u8868\u5355\u5b9e\u4f8bID\u548c\u4e0a\u4e0b\u6587name\u5220\u9664\u4e0a\u4e0b\u6587value")
    public ResponseModel deleteByInstanceIdAndName(@RequestParam(name="instanceId") @ApiParam(value="\u8868\u5355\u5b9e\u4f8bID", required=true) String instanceId, @RequestParam(name="name") @ApiParam(value="\u4e0a\u4e0b\u6587\u660e\u7ec6\u540d\u79f0", required=true) String name) {
        try {
            this.instanceContextService.deleteByInstanceIdAndName(instanceId, name);
            return this.buildHttpReslut();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpReslutForException(e);
        }
    }
}

