/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.controller;

import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.kuiper.entity.TemplateEventEntity;
import com.bizunited.platform.kuiper.starter.service.TemplateEventService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="TemplateEventController", tags={"\u6a21\u677f\u4e8b\u4ef6\u76f8\u5173\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/v1/kuiper/templateEvents"})
public class TemplateEventController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplateEventController.class);
    @Autowired
    private TemplateEventService templateEventService;

    @ApiOperation(value="\u6839\u636e\u6307\u5b9a\u6a21\u677f\u7684id,\u67e5\u8be2\u5df2\u6709\u7684\u6a21\u677f\u4e8b\u4ef6\u4fe1\u606f", notes="\u8be5\u65b9\u6cd5\u5fc5\u987b\u5305\u542b\u6307\u5b9a\u6a21\u677f\u7684id,\u4e14\u4e0d\u80fd\u4e3a\u7a7a,\u8fd4\u56de\u6240\u6709\u7684\u524d\u540e\u7aef\u4e8b\u4ef6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="templateId", value="\u6307\u5b9a\u7684\u6a21\u677fid", required=true)})
    @GetMapping(value={"/findByTemplateId"})
    public ResponseModel findByTemplateId(@RequestParam(value="templateId") String templateId) {
        try {
            List<TemplateEventEntity> result = this.templateEventService.findByTemplateId(templateId);
            return this.buildHttpReslutW(result, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpReslutForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u6307\u5b9a\u4e8b\u4ef6id,\u67e5\u8be2\u4e8b\u4ef6\u8be6\u60c5\u4fe1\u606f", notes="\u8be5\u65b9\u6cd5\u5fc5\u987b\u5305\u542b\u4e8b\u4ef6\u7684id,\u4e14\u4e0d\u80fd\u4e3a\u7a7a,\u8fd4\u56de\u6307\u5b9a\u7684\u4e8b\u4ef6\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u9009\u5b9a\u7684\u4e8b\u4ef6id", required=true)})
    @GetMapping(value={"/findDetailById"})
    public ResponseModel findDetailById(@RequestParam(value="id") String id) {
        try {
            TemplateEventEntity result = this.templateEventService.findDetailById(id);
            return this.buildHttpReslutW(result, new String[]{"template"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpReslutForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u6307\u5b9a\u6a21\u677fid,\u67e5\u8be2\u6240\u6709\u4e8b\u4ef6\u8be6\u60c5\u4fe1\u606f", notes="\u8be5\u65b9\u6cd5\u5fc5\u987b\u5305\u542b\u6a21\u677f\u7684id,\u4e14\u4e0d\u80fd\u4e3a\u7a7a,\u8fd4\u56de\u8be5\u6a21\u677f\u6240\u6709\u7684\u4e8b\u4ef6\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="templateId", value="\u6307\u5b9a\u6a21\u677fid", required=true)})
    @GetMapping(value={"/findDetailsByTemplateId"})
    public ResponseModel findDetailsByTemplateId(@RequestParam(value="templateId") String templateId) {
        try {
            Set<TemplateEventEntity> result = this.templateEventService.findDetailsByTemplateId(templateId);
            return this.buildHttpReslutW(result, new String[]{"template"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpReslutForException(e);
        }
    }
}

