/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.repository;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.bizunited.platform.kuiper.entity.TemplatePropertyEntity;
import com.bizunited.platform.kuiper.starter.repository.DynamicInstanceCustomRepository;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.lang3.Validate;
import org.hibernate.query.internal.NativeQueryImpl;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="DynamicInstanceCustomRepositoryImpl")
public class DynamicInstanceCustomRepositoryImpl
implements DynamicInstanceCustomRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicInstanceCustomRepositoryImpl.class);
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public JSONArray execute(String sql) {
        Validate.notBlank((CharSequence)sql, (String)"\u4f20\u5165SQL\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        LOGGER.debug("\u52a8\u6001\u6a21\u578b\u6267\u884csql \uff1a" + sql);
        Query query = this.entityManager.createNativeQuery(sql);
        ((NativeQueryImpl)query.unwrap(NativeQueryImpl.class)).setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
        List list = query.getResultList();
        JSONArray jsonArr = JSON.parseArray((String)JSON.toJSONString((Object)list));
        LOGGER.debug(jsonArr == null ? "" : JSON.toJSONString((Object)jsonArr));
        return jsonArr;
    }

    @Override
    public JSONArray findManyToMany(String parentTableName, String targetTableName, String parentId) {
        List sortedNames = Arrays.asList(parentTableName, targetTableName).stream().sorted().collect(Collectors.toList());
        String mappingTable = String.format("%s_%s_mapping", sortedNames.get(0), sortedNames.get(1));
        String mtmFormat = "select %s_id id from %s where %s_id = '%s'";
        String mtmSQL = String.format(mtmFormat, targetTableName, mappingTable, parentTableName, parentId);
        return this.execute(mtmSQL);
    }

    @Override
    public JSONArray findProperties(Set<TemplatePropertyEntity> properties, String mainTableName, String formInstanceId) {
        String columnsPattern = "%s %s,";
        StringBuilder sqlBuilder = new StringBuilder();
        for (TemplatePropertyEntity prop : properties) {
            Validate.notBlank((CharSequence)prop.getPropertyDbName(), (String)"\u5728\u52a8\u6001\u6a21\u677f\u4e2d\uff0c\u4e3b\u8868\u4e00\u822c\u5c5e\u6027\u5bf9\u5e94\u7684\u6570\u636e\u5e93\u5b57\u6bb5\u4fe1\u606f\u5fc5\u987b\u6709\u503c\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)prop.getPropertyName(), (String)"\u5728\u52a8\u6001\u6a21\u677f\u4e2d\uff0c\u4e3b\u8868\u4e00\u822c\u5c5e\u6027\u7684\u540d\u79f0\u5fc5\u987b\u6709\u503c\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            sqlBuilder.append(String.format(columnsPattern, prop.getPropertyDbName(), prop.getPropertyName()));
        }
        sqlBuilder.insert(0, "select ").replace(sqlBuilder.length() - 1, sqlBuilder.length(), "").append(" from ").append(mainTableName).append(String.format(" where form_instance_id = '%s'", formInstanceId));
        return this.execute(sqlBuilder.toString());
    }

    @Override
    public JSONArray findProperties(Set<TemplatePropertyEntity> properties, String targetTableName, String parentTableName, String parentId, String targetPropertyDesc) {
        String columnsPattern = "target.%s %s,";
        StringBuilder sqlBuilder = new StringBuilder();
        for (TemplatePropertyEntity prop : properties) {
            Validate.notBlank((CharSequence)prop.getPropertyDbName(), (String)"%s\u7684\u4e00\u822c\u5c5e\u6027\u5bf9\u5e94\u7684\u6570\u636e\u5e93\u5b57\u6bb5\u4fe1\u606f\u5fc5\u987b\u6709\u503c\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{targetPropertyDesc});
            Validate.notBlank((CharSequence)prop.getPropertyName(), (String)"%s\u4e00\u822c\u5c5e\u6027\u7684\u540d\u79f0\u5fc5\u987b\u6709\u503c\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{targetPropertyDesc});
            sqlBuilder.append(String.format(columnsPattern, prop.getPropertyDbName(), prop.getPropertyName()));
        }
        sqlBuilder.insert(0, "select ").replace(sqlBuilder.length() - 1, sqlBuilder.length(), "").append(" from ").append(String.format("%s target ", targetTableName)).append(String.format("left join %s parent on target.%s_id = parent.id ", parentTableName, parentTableName)).append(String.format("where parent.id = '%s'", parentId));
        return this.execute(sqlBuilder.toString());
    }

    @Override
    public JSONArray findManyToOne(String parentTableName, String targetTableName, String parentPropertyDbName, String parentId) {
        String mtoFormat = "select target.id from %s target left join %s parent on target.id = parent.%s where parent.id = '%s'";
        String mtoSQL = String.format(mtoFormat, targetTableName, parentTableName, parentPropertyDbName, parentId);
        return this.execute(mtoSQL);
    }

    @Override
    public void executeNativeSQL(String pattern, Object ... params) {
        String sql = String.format(pattern, params);
        Query sqlQuery = this.entityManager.createNativeQuery(sql);
        sqlQuery.executeUpdate();
    }

    @Override
    public List<?> executeQuerySql(String pattern, Object ... params) {
        String querySql = String.format(pattern, params);
        Query query = this.entityManager.createNativeQuery(querySql);
        return query.getResultList();
    }
}

