/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.repository.internal;

import com.bizunited.platform.kuiper.entity.DataSourceTableEntity;
import com.bizunited.platform.kuiper.starter.repository.internal.DataSourceTableRepositoryCustom;
import com.mysql.jdbc.JDBC4DatabaseMetaData;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.orm.hibernate5.SessionFactoryUtils;
import org.springframework.stereotype.Repository;

@Repository(value="DataSourceTableRepositoryImpl")
public class DataSourceTableRepositoryImpl
implements DataSourceTableRepositoryCustom {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSourceTableRepositoryImpl.class);
    @Autowired
    private EntityManager entityManager;

    @Override
    public Page<DataSourceTableEntity> findByConditions(Pageable pageable, Integer tableType, String dataSourceId, Integer status, String tableName) {
        StringBuilder hql = new StringBuilder("select dtt from DataSourceTableEntity dtt left join fetch dtt.dataSource ds where 1=1 ");
        StringBuilder countHql = new StringBuilder("select count(*) from DataSourceTableEntity dtt left join dtt.dataSource ds where 1=1 ");
        if (tableType != null) {
            hql.append(" AND dtt.tableType = :tableType");
            countHql.append(" AND dtt.tableType = :tableType");
        }
        if (status != null) {
            hql.append(" AND dtt.tStatus = :status");
            countHql.append(" AND dtt.tStatus = :status");
        }
        if (StringUtils.isNotBlank((CharSequence)tableName)) {
            hql.append(" AND dtt.tableName = :tableName");
            countHql.append(" AND dtt.tableName = :tableName");
        }
        if (StringUtils.isNotBlank((CharSequence)dataSourceId)) {
            hql.append(" AND ds.id = :dataSourceId");
            countHql.append(" AND ds.id = :dataSourceId");
        } else {
            hql.append(" AND ds.id is null");
            countHql.append(" AND ds.id is null");
        }
        Query query = this.entityManager.createQuery(hql.toString());
        Query countQuery = this.entityManager.createQuery(countHql.toString());
        if (tableType != null) {
            query.setParameter("tableType", (Object)tableType);
            countQuery.setParameter("tableType", (Object)tableType);
        }
        if (status != null) {
            query.setParameter("status", (Object)status);
            countQuery.setParameter("status", (Object)status);
        }
        if (StringUtils.isNotBlank((CharSequence)tableName)) {
            query.setParameter("tableName", (Object)tableName);
            countQuery.setParameter("tableName", (Object)tableName);
        }
        if (StringUtils.isNotBlank((CharSequence)dataSourceId)) {
            query.setParameter("dataSourceId", (Object)dataSourceId);
            countQuery.setParameter("dataSourceId", (Object)dataSourceId);
        }
        query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
        query.setMaxResults(pageable.getPageSize());
        List result = query.getResultList();
        long count = (Long)countQuery.getResultList().get(0);
        return new PageImpl(result, pageable, count);
    }

    @Override
    public Set<String> queryMainDataSourceTables() {
        Session session = (Session)this.entityManager.getDelegate();
        return this.queryDataSourceTables(session.getSessionFactory());
    }

    @Override
    public Set<String> queryDataSourceTables(SessionFactory sessionFactory) {
        HashSet<String> tableNames = new HashSet<String>();
        try (Connection conn = SessionFactoryUtils.getDataSource((SessionFactory)sessionFactory).getConnection();){
            ResultSet rs;
            DatabaseMetaData metaData = conn.getMetaData();
            if (metaData instanceof JDBC4DatabaseMetaData) {
                String catalog = conn.getCatalog();
                rs = metaData.getTables(catalog, null, null, new String[]{"TABLE"});
            } else {
                rs = this.queryOracleDataSourceTables(conn);
            }
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME");
                tableNames.add(tableName);
            }
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
        }
        return tableNames;
    }

    private ResultSet queryOracleDataSourceTables(Connection conn) throws SQLException {
        String sql = "select TABLE_NAME from user_tables";
        try (PreparedStatement pre = conn.prepareStatement(sql);){
            ResultSet resultSet = pre.executeQuery();
            return resultSet;
        }
    }
}

