/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.kuiper.entity.InstanceEntity;
import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.entity.TemplateGroupEntity;
import com.bizunited.platform.kuiper.entity.TemplateItemEntity;
import com.bizunited.platform.kuiper.entity.TemplatePropertyEntity;
import com.bizunited.platform.kuiper.entity.TemplateRelationEntity;
import com.bizunited.platform.kuiper.service.DynamicInstanceService;
import com.bizunited.platform.kuiper.service.InstanceService;
import com.bizunited.platform.kuiper.service.TemplateService;
import com.bizunited.platform.kuiper.starter.common.enums.RelationsTypeEnum;
import com.bizunited.platform.kuiper.starter.repository.DynamicInstanceCustomRepository;
import com.bizunited.platform.kuiper.starter.repository.table.TableOperateRepositoryCustom;
import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="DynamicInstanceServiceImpl")
public class DynamicInstanceServiceImpl
implements DynamicInstanceService {
    private static final String DYNAMIC = "dynamic";
    private static final String MESS_FORMINSTANCE_ID = "formInstanceId";
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicInstanceServiceImpl.class);
    @Autowired
    private InstanceService instanceService;
    @Autowired
    private TemplateService templateService;
    @Autowired
    private DynamicInstanceCustomRepository dynamicInstanceCustomRepository;
    @Autowired
    private TableOperateRepositoryCustom tableOperateRepositoryCustom;

    public JSONObject findByFormInstanceId(String formInstanceId) {
        TemplateEntity template = this.validateInstanceAndTemplateInfo(formInstanceId);
        Set properties = template.getProperties();
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)properties) ? 1 : 0) != 0, (String)"\u672a\u53d1\u73b0\u6a21\u677f\u7684\u4e00\u822c\u5c5e\u6027\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        JSONArray jsonArr = this.dynamicInstanceCustomRepository.findProperties(properties, template.getTableName(), formInstanceId);
        return this.fetchOne(jsonArr);
    }

    public JSONObject findDetailsByFormInstanceId(String formInstanceId) {
        Set items;
        Set oneToOnes;
        TemplateEntity template = this.validateInstanceAndTemplateInfo(formInstanceId);
        Set properties = template.getProperties();
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)properties) ? 1 : 0) != 0, (String)"\u672a\u53d1\u73b0\u6a21\u677f\u7684\u4e00\u822c\u5c5e\u6027\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        JSONArray jsonArr = this.dynamicInstanceCustomRepository.findProperties(properties, template.getTableName(), formInstanceId);
        if (!this.existJSON(jsonArr)) {
            return null;
        }
        JSONObject json = this.fetchOne(jsonArr);
        if (json == null) {
            return null;
        }
        String mainId = json.getString("id");
        Validate.notBlank((CharSequence)mainId, (String)"\u5b9e\u4f8b\u6570\u636eID\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Set mainRelations = template.getRelations();
        if (!CollectionUtils.isEmpty((Collection)mainRelations)) {
            this.processManyToMany(mainRelations, template.getTableName(), mainId, json);
            this.processManyToOne(mainRelations, template.getTableName(), mainId, json);
        }
        if (!CollectionUtils.isEmpty((Collection)(oneToOnes = template.getGroupRelations()))) {
            this.processOneToOne(oneToOnes, mainId, json);
        }
        if (!CollectionUtils.isEmpty((Collection)(items = template.getItemRelations()))) {
            this.processOneToMany(items, mainId, json);
        }
        return json;
    }

    @Transactional
    public void create(JSONObject jsonObject) {
        this.validDynamicTemplateData(jsonObject, true);
        String parentId = UUID.randomUUID().toString();
        jsonObject.put("id", (Object)parentId);
        String formInstanceId = jsonObject.getString(MESS_FORMINSTANCE_ID);
        InstanceEntity instance = this.instanceService.findDetailsById(formInstanceId);
        TemplateEntity template = instance.getTemplate();
        this.saveTable(jsonObject, template.getProperties(), template.getRelations(), template.getTableName(), false, null, null);
        this.saveMappingTable(template.getRelations(), jsonObject, template.getTableName());
        this.saveItems(template.getItemRelations(), jsonObject, parentId);
        if (!CollectionUtils.isEmpty((Collection)template.getGroupRelations())) {
            Set groups = template.getGroupRelations().stream().filter(o -> null != jsonObject.get((Object)o.getPropertyName())).collect(Collectors.toSet());
            for (TemplateGroupEntity group : groups) {
                JSONObject itemJson = jsonObject.getJSONObject(group.getPropertyName());
                if (itemJson == null) continue;
                String groupId = UUID.randomUUID().toString();
                itemJson.put("id", (Object)groupId);
                this.saveTable(itemJson, group.getProperties(), group.getRelations(), group.getTableName(), true, group.getParentTableName(), parentId);
                this.saveMappingTable(this.filterOneToOneRelation(group.getRelations(), group.getParentTableName()), itemJson, group.getTableName());
                this.saveItems(group.getItemRelations(), itemJson, groupId);
            }
        }
    }

    private Set<TemplateRelationEntity> filterOneToOneRelation(Set<TemplateRelationEntity> relations, String parentTable) {
        if (!CollectionUtils.isEmpty(relations)) {
            return relations.stream().filter(o -> !o.getPropertyDbName().equals(String.format("%s_id", parentTable))).collect(Collectors.toSet());
        }
        return new HashSet<TemplateRelationEntity>();
    }

    private void saveTable(JSONObject jsonObject, Set<TemplatePropertyEntity> properties, Set<TemplateRelationEntity> relations, String tableName, Boolean isItem, String parentTableName, String parentId) {
        Set manyToOnes;
        HashMap<String, String> kv = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty(properties)) {
            HashMap<String, String> propertyKV = new HashMap<String, String>();
            for (TemplatePropertyEntity templatePropertyEntity : properties) {
                String key = String.format("`%s`", templatePropertyEntity.getPropertyDbName());
                String res = String.valueOf(jsonObject.get((Object)templatePropertyEntity.getPropertyName()));
                if (StringUtils.equals((CharSequence)"java.lang.String", (CharSequence)templatePropertyEntity.getPropertyClassName())) {
                    res = res == null ? null : String.format("'%s'", res);
                } else if (StringUtils.equals((CharSequence)"java.util.Date", (CharSequence)templatePropertyEntity.getPropertyClassName())) {
                    res = res == null ? null : String.format("'%s'", this.formatDate(res));
                }
                propertyKV.put(key, res);
            }
            kv.put(String.format("`%s`", "id"), String.format("'%s'", jsonObject.getString("id")));
            kv.putAll(propertyKV);
        }
        if (null != relations && !CollectionUtils.isEmpty(relations) && !CollectionUtils.isEmpty(manyToOnes = relations.stream().filter(o -> "ManyToOne".equals(o.getRelationType()) && o.getBackProperty() == false).collect(Collectors.toSet()))) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (TemplateRelationEntity p : manyToOnes) {
                String key = String.format("`%s`", p.getPropertyDbName());
                JSONObject json = jsonObject.getJSONObject(p.getPropertyName());
                Validate.isTrue((json != null ? 1 : 0) != 0, (String)"\u4f20\u5165manyToOne\u5bf9\u8c61\u4e0d\u5b58\u5728", (Object[])new Object[0]);
                String manyToOneId = json.getString("id");
                String value = manyToOneId == null ? null : String.format("'%s'", manyToOneId);
                map.put(key, value);
            }
            kv.putAll(map);
        }
        if (Boolean.TRUE.equals(isItem)) {
            String parentIdKey = String.format("`%s_id`", parentTableName);
            String parentIdValue = String.format("'%s'", parentId);
            kv.put(parentIdKey, parentIdValue);
        }
        StringBuilder vals = new StringBuilder();
        for (String string : kv.values()) {
            if (string == null) {
                vals.append("null,");
                continue;
            }
            if (StringUtils.isEmpty((CharSequence)string)) {
                vals.append(",");
                continue;
            }
            vals.append(string + ",");
        }
        this.dynamicInstanceCustomRepository.executeNativeSQL("INSERT INTO `%s` (%s) VALUES (%s)", tableName, StringUtils.join(kv.keySet(), (String)","), StringUtils.left((String)vals.toString(), (int)(vals.length() - 1)));
    }

    private void saveMappingTable(Set<TemplateRelationEntity> relations, JSONObject jsonObject, String tableName) {
        if (CollectionUtils.isEmpty(relations)) {
            return;
        }
        Set manyToManys = relations.stream().filter(o -> RelationsTypeEnum.MANY_TO_MANY.getRelation().equals(o.getRelationType())).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(manyToManys)) {
            return;
        }
        for (TemplateRelationEntity relation : manyToManys) {
            if (Boolean.TRUE.equals(relation.getBackProperty())) continue;
            ArrayList tableNames = new ArrayList(Lists.newArrayList((Object[])new String[]{tableName, relation.getTargetTableName()}));
            List sortedName = tableNames.stream().sorted().collect(Collectors.toList());
            String dbMappingTable = String.format("%s_%s_mapping", sortedName.get(0), sortedName.get(1));
            List nameWithId = tableNames.stream().map(o -> "`" + o.concat("_id") + "`").collect(Collectors.toList());
            String keys = StringUtils.join(nameWithId, (String)",");
            JSONArray targetIds = jsonObject.getJSONArray(relation.getPropertyName());
            for (Object targetIdObject : targetIds) {
                String targetId = this.analysisTargetId((Map)targetIdObject);
                String values = String.format("'%s','%s'", jsonObject.getString("id"), targetId);
                this.dynamicInstanceCustomRepository.executeNativeSQL("INSERT INTO `%s` (%s) VALUES (%s)", dbMappingTable, keys, values);
            }
        }
    }

    private String analysisTargetId(Map<String, Object> targetIdMap) {
        Object targetIdValue = targetIdMap.get("id");
        Validate.notNull((Object)targetIdValue, (String)"\u9519\u8bef\u7684id\u7f16\u53f7\u4fe1\u606f!!", (Object[])new Object[0]);
        String targetId = targetIdValue.toString();
        Validate.notBlank((CharSequence)targetId, (String)"\u9519\u8bef\u7684id\u7f16\u53f7\u4fe1\u606f!!", (Object[])new Object[0]);
        return targetId;
    }

    private void saveItems(Set<TemplateItemEntity> items, JSONObject jsonObject, String parentId) {
        if (CollectionUtils.isEmpty(items)) {
            return;
        }
        Set templateItems = items.stream().filter(o -> null != jsonObject.get((Object)o.getPropertyName())).collect(Collectors.toSet());
        for (TemplateItemEntity item : templateItems) {
            JSONArray jsonArray = jsonObject.getJSONArray(item.getPropertyName());
            if (jsonArray == null || jsonArray.isEmpty()) continue;
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject itemJson = jsonArray.getJSONObject(i);
                itemJson.put("id", (Object)UUID.randomUUID().toString());
                Set<TemplatePropertyEntity> itemProperties = item.getProperties().stream().filter(o -> null != itemJson.get((Object)o.getPropertyName())).collect(Collectors.toSet());
                Set itemRelations = item.getRelations().stream().filter(o -> !Boolean.TRUE.equals(o.getNullable()) || null != itemJson.get((Object)o.getPropertyName())).collect(Collectors.toSet());
                Set<TemplateRelationEntity> itemManyToOnes = itemRelations.stream().filter(o -> "ManyToOne".equals(o.getRelationType())).collect(Collectors.toSet());
                this.saveTable(itemJson, itemProperties, itemManyToOnes, item.getTableName(), true, item.getParentTableName(), parentId);
                this.saveMappingTable(item.getRelations(), itemJson, item.getTableName());
            }
        }
    }

    @Transactional
    public void update(JSONObject jsonObject) {
        this.validDynamicTemplateData(jsonObject, false);
        String formInstanceId = jsonObject.getString(MESS_FORMINSTANCE_ID);
        InstanceEntity instance = this.instanceService.findDetailsById(formInstanceId);
        TemplateEntity template = instance.getTemplate();
        Set properties = template.getProperties();
        this.updateProperties(jsonObject, properties, template.getTableName());
        this.updateRelations(jsonObject, template.getRelations(), template.getTableName());
        this.updateItems(jsonObject, template.getItemRelations());
        if (!CollectionUtils.isEmpty((Collection)template.getGroupRelations())) {
            Set groups = template.getGroupRelations().stream().filter(o -> null != jsonObject.get((Object)o.getPropertyName())).collect(Collectors.toSet());
            for (TemplateGroupEntity group : groups) {
                JSONObject itemJson = jsonObject.getJSONObject(group.getPropertyName());
                if (itemJson == null) continue;
                this.updateProperties(itemJson, group.getProperties(), group.getTableName());
                this.updateRelations(itemJson, this.filterOneToOneRelation(group.getRelations(), group.getParentTableName()), group.getTableName());
                this.updateItems(itemJson, group.getItemRelations());
            }
        }
    }

    private void updateProperties(JSONObject jsonObject, Set<TemplatePropertyEntity> properties, String tableName) {
        if (CollectionUtils.isEmpty(properties)) {
            return;
        }
        List kv = properties.stream().filter(o -> null != jsonObject.get((Object)o.getPropertyName()) && !StringUtils.equalsIgnoreCase((CharSequence)"id", (CharSequence)o.getPropertyName()) && !StringUtils.equalsIgnoreCase((CharSequence)MESS_FORMINSTANCE_ID, (CharSequence)o.getPropertyName())).map(o -> {
            String value;
            String valueStr = value = String.valueOf(jsonObject.get((Object)o.getPropertyName()));
            if (StringUtils.equals((CharSequence)"java.lang.String", (CharSequence)o.getPropertyClassName())) {
                valueStr = String.format("'%s'", value);
            } else if (StringUtils.equals((CharSequence)"java.util.Date", (CharSequence)o.getPropertyClassName())) {
                valueStr = String.format("'%s'", this.formatDate(value));
            }
            return String.format("`%s`=%s", o.getPropertyDbName(), valueStr);
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(kv)) {
            return;
        }
        this.dynamicInstanceCustomRepository.executeNativeSQL("UPDATE `%s` SET %s WHERE `id` = '%s'", tableName, StringUtils.join(kv, (String)","), jsonObject.getString("id"));
    }

    private void updateRelations(JSONObject jsonObject, Set<TemplateRelationEntity> relations, String tableName) {
        if (CollectionUtils.isEmpty(relations)) {
            return;
        }
        Set manyToOnes = relations.stream().filter(o -> "ManyToOne".equals(o.getRelationType()) && null != jsonObject.get((Object)o.getPropertyName())).collect(Collectors.toSet());
        Set manyToManys = relations.stream().filter(o -> "ManyToMany".equals(o.getRelationType()) && null != jsonObject.get((Object)o.getPropertyName())).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(manyToOnes)) {
            LinkedList<String> kvs = new LinkedList<String>();
            for (TemplateRelationEntity p : manyToOnes) {
                JSONObject json = jsonObject.getJSONObject(p.getPropertyName());
                Validate.isTrue((json != null ? 1 : 0) != 0, (String)"\u4f20\u5165manyToOne\u5bf9\u8c61\u4e0d\u5b58\u5728", (Object[])new Object[0]);
                String manyToOneId = json.getString("id");
                if (manyToOneId == null) {
                    kvs.add(String.format("`%s`=", p.getPropertyDbName()) + "null");
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)manyToOneId)) {
                    kvs.add(String.format("`%s`=''", p.getPropertyDbName()));
                    continue;
                }
                kvs.add(String.format("`%s`='%s'", p.getPropertyDbName(), manyToOneId));
            }
            this.dynamicInstanceCustomRepository.executeNativeSQL("UPDATE `%s` SET %s WHERE `id` = '%s'", tableName, StringUtils.join(kvs, (String)","), jsonObject.getString("id"));
        }
        if (!CollectionUtils.isEmpty(manyToManys)) {
            for (TemplateRelationEntity relation : manyToManys) {
                ArrayList tableNames = new ArrayList(Lists.newArrayList((Object[])new String[]{tableName, relation.getTargetTableName()}));
                List sortedName = tableNames.stream().sorted().collect(Collectors.toList());
                String dbMappingTable = String.format("%s_%s_mapping", sortedName.get(0), sortedName.get(1));
                this.deleteManyToMany(tableName, relation.getTargetTableName(), jsonObject.getString("id"));
                List nameWithId = tableNames.stream().map(o -> String.format("`%s_id`", o)).collect(Collectors.toList());
                String keys = StringUtils.join(nameWithId, (String)",");
                JSONArray targetIds = jsonObject.getJSONArray(relation.getPropertyName());
                for (Object targetIdObject : targetIds) {
                    String targetId = this.analysisTargetId((Map)targetIdObject);
                    String values = String.format("'%s','%s'", jsonObject.getString("id"), targetId);
                    this.dynamicInstanceCustomRepository.executeNativeSQL("INSERT INTO `%s` (%s) VALUES (%s)", dbMappingTable, keys, values);
                }
            }
        }
    }

    private void updateItems(JSONObject jsonObject, Set<TemplateItemEntity> items) {
        if (CollectionUtils.isEmpty(items)) {
            return;
        }
        Set templateItems = items.stream().filter(o -> null != jsonObject.get((Object)o.getPropertyName())).collect(Collectors.toSet());
        for (TemplateItemEntity item : templateItems) {
            List<?> existIds = this.dynamicInstanceCustomRepository.executeQuerySql("SELECT id FROM %s WHERE %s_id = '%s'", item.getTableName(), item.getParentTableName(), jsonObject.get((Object)"id"));
            ArrayList unProcessedIds = new ArrayList(existIds);
            JSONArray jsonArray = jsonObject.getJSONArray(item.getPropertyName());
            List itemJsonObjects = jsonArray.stream().map(o -> JSON.parseObject((String)JSON.toJSONString((Object)o))).collect(Collectors.toList());
            for (JSONObject itemJson : itemJsonObjects) {
                String itemId;
                Set<TemplatePropertyEntity> itemProperties = item.getProperties().stream().filter(o -> null != itemJson.get((Object)o.getPropertyName())).collect(Collectors.toSet());
                if (StringUtils.isBlank((CharSequence)itemJson.getString("id"))) {
                    itemJson.put("id", (Object)UUID.randomUUID().toString());
                    this.saveTable(itemJson, itemProperties, item.getRelations(), item.getTableName(), true, item.getParentTableName(), jsonObject.getString("id"));
                    this.saveMappingTable(item.getRelations(), itemJson, item.getTableName());
                }
                if (StringUtils.isBlank((CharSequence)itemJson.getString("id")) || !existIds.contains(itemId = itemJson.getString("id"))) continue;
                this.updateProperties(itemJson, itemProperties, item.getTableName());
                this.updateRelations(itemJson, item.getRelations(), item.getTableName());
                unProcessedIds.remove(itemJson.getString("id"));
            }
            if (CollectionUtils.isEmpty(unProcessedIds)) continue;
            for (Object id : unProcessedIds) {
                Set manyToManys = item.getRelations().stream().filter(o -> "ManyToMany".equals(o.getRelationType())).collect(Collectors.toSet());
                for (TemplateRelationEntity relation : manyToManys) {
                    this.deleteManyToMany(item.getTableName(), relation.getTargetTableName(), id.toString());
                }
                this.dynamicInstanceCustomRepository.executeNativeSQL("DELETE FROM `%s` WHERE `id` = '%s'", item.getTableName(), id);
            }
        }
    }

    private void deleteManyToMany(String tableName, String targetTableName, String itemId) {
        Validate.notBlank((CharSequence)tableName, (String)"\u79fb\u9664\u4e2d\u95f4\u8868\u4e2d\uff0c\u6570\u636e\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)targetTableName, (String)"\u79fb\u9664\u4e2d\u95f4\u8868\u4e2d\uff0c\u6570\u636e\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)itemId, (String)"\u79fb\u9664\u4e2d\u95f4\u8868\u4e2d\uff0c\u660e\u7ec6ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ArrayList tableNames = new ArrayList(Lists.newArrayList((Object[])new String[]{tableName, targetTableName}));
        List sortedName = tableNames.stream().sorted().collect(Collectors.toList());
        String dbMappingTable = String.format("%s_%s_mapping", sortedName.get(0), sortedName.get(1));
        this.dynamicInstanceCustomRepository.executeNativeSQL("DELETE FROM `%s` WHERE `%s_id` = '%s'", dbMappingTable, tableName, itemId);
    }

    private void validDynamicTemplateData(JSONObject jsonObject, Boolean isCreate) {
        Validate.notNull((Object)jsonObject, (String)"\u524d\u7aef\u4f20\u5165\u4e1a\u52a1\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        String id = jsonObject.getString("id");
        if (Boolean.TRUE.equals(isCreate)) {
            Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)id), (String)"\u65b0\u589e\u65f6\uff0c\u4e0d\u80fd\u4f20\u5165ID\uff01", (Object[])new Object[0]);
        } else {
            Validate.notBlank((CharSequence)id, (String)"\u66f4\u65b0\u65f6\u5019\uff0c\u4f20\u5165\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        }
        String formInstanceId = jsonObject.getString(MESS_FORMINSTANCE_ID);
        InstanceEntity instance = this.instanceService.findDetailsById(formInstanceId);
        Validate.notNull((Object)instance, (String)"\u672a\u627e\u5230\u8be5\u6a21\u677f\u5b9e\u4f8b\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        TemplateEntity template = instance.getTemplate();
        Validate.notNull((Object)template, (String)"\u672a\u627e\u5230\u8be5\u5b9e\u4f8b\u7ed1\u5b9a\u6a21\u677f\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        this.checkProperties(template.getProperties(), jsonObject, isCreate);
        this.checkRelations(template.getRelations(), jsonObject, isCreate);
        this.checkItems(template.getItemRelations(), jsonObject, isCreate);
        Set groups = template.getGroupRelations();
        if (!CollectionUtils.isEmpty((Collection)groups)) {
            for (TemplateGroupEntity group : groups) {
                JSONObject groupJSON = jsonObject.getJSONObject(group.getPropertyName());
                Validate.notNull((Object)group, (String)String.format("\u672a\u5199\u5165\u5206\u7ec4%s\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\uff01", group.getPropertyName()), (Object[])new Object[0]);
                if (groupJSON == null) continue;
                this.checkProperties(group.getProperties(), groupJSON, isCreate);
                this.checkRelations(this.filterOneToOneRelation(group.getRelations(), group.getParentTableName()), groupJSON, isCreate);
                this.checkItems(group.getItemRelations(), groupJSON, isCreate);
            }
        }
    }

    private void checkProperties(Set<TemplatePropertyEntity> properties, JSONObject jsonObject, Boolean isCreate) {
        if (CollectionUtils.isEmpty(properties)) {
            return;
        }
        for (TemplatePropertyEntity o : properties) {
            boolean b;
            if (!Boolean.TRUE.equals(o.getNullable())) {
                Boolean isNull = null == jsonObject.get((Object)o.getPropertyName()) || StringUtils.isBlank((CharSequence)o.getPropertyName());
                Validate.notNull((Object)isNull, (String)("\u4e1a\u52a1\u6570\u636e\u4e2d\u5fc5\u586b\u9879" + o.getPropertyName() + "\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01"), (Object[])new Object[0]);
            }
            if (null != o.getMaxLen() && o.getMaxLen() > 0 && null != jsonObject.getString(o.getPropertyName()) && "java.lang.String".equals(o.getPropertyClassName())) {
                Validate.isTrue((o.getMaxLen() > jsonObject.getString(o.getPropertyName()).length() ? 1 : 0) != 0, (String)("\u6570\u636e\u4e2d" + o.getPropertyName() + "\u8d85\u51fa\u9650\u5b9a\u957f\u5ea6" + o.getMaxLen() + "\uff0c\u8bf7\u68c0\u67e5\uff01"), (Object[])new Object[0]);
            }
            if (!(b = o.getUnique() != false && null != jsonObject.get((Object)o.getPropertyName()) && (isCreate != false || isCreate == false && !MESS_FORMINSTANCE_ID.equals(o.getPropertyName())))) continue;
            String tabelName = "";
            if (o.getCurrentTemplate() != null) {
                tabelName = o.getCurrentTemplate().getTableName();
            } else if (o.getCurrentGroup() != null) {
                tabelName = o.getCurrentGroup().getTableName();
            } else if (o.getCurrentItem() != null) {
                tabelName = o.getCurrentItem().getTableName();
            }
            List<?> rows = this.dynamicInstanceCustomRepository.executeQuerySql("select %s from `%s` where %s = '%s'", o.getPropertyDbName(), tabelName, o.getPropertyDbName(), jsonObject.get((Object)o.getPropertyName()));
            if (!Boolean.TRUE.equals(isCreate)) continue;
            Validate.isTrue((!rows.contains(jsonObject.get((Object)o.getPropertyName())) ? 1 : 0) != 0, (String)("\u4e1a\u52a1\u6570\u636e\u9879" + o.getPropertyDesc() + "\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\uff01"), (Object[])new Object[0]);
        }
    }

    private void checkRelations(Set<TemplateRelationEntity> relations, JSONObject jsonObject, Boolean isCreate) {
        if (CollectionUtils.isEmpty(relations)) {
            return;
        }
        relations.stream().filter(o -> o.getNullable() == false).forEach(p -> Validate.isTrue((null != jsonObject.get((Object)p.getPropertyName()) ? 1 : 0) != 0, (String)String.format("\u5173\u8054\u5173\u7cfb\u4e2d\u5fc5\u586b\u9879%s\u6ca1\u6709\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\uff01", p.getPropertyName()), (Object[])new Object[0]));
        relations.stream().forEach(p -> Validate.isTrue((boolean)this.tableOperateRepositoryCustom.existTableName(p.getTargetTableName()), (String)String.format("\u5173\u8054\u8868%s\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", p.getTargetTableName()), (Object[])new Object[0]));
        relations.stream().filter(o -> "ManyToMany".equals(o.getRelationType())).forEach(p -> {
            String tableName = null;
            if (p.getCurrentTemplate() != null) {
                tableName = p.getCurrentTemplate().getTableName();
            } else if (p.getCurrentItem() != null) {
                tableName = p.getCurrentItem().getTableName();
            } else if (p.getCurrentGroup() != null) {
                tableName = p.getCurrentGroup().getTableName();
            }
            ArrayList tableNames = new ArrayList(Lists.newArrayList((Object[])new String[]{tableName, p.getTargetTableName()}));
            List sortedName = tableNames.stream().sorted().collect(Collectors.toList());
            String dbMappingTable = String.format("%s_%s_mapping", sortedName.get(0), sortedName.get(1));
            Validate.isTrue((boolean)this.tableOperateRepositoryCustom.existTableName(dbMappingTable), (String)String.format("\u5173\u8054\u8868%s\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", p.getTargetTableName()), (Object[])new Object[0]);
        });
        relations.stream().filter(o -> null != jsonObject.get((Object)o.getPropertyName())).forEach(p -> {
            if (p.getRelationType().equals("ManyToOne")) {
                JSONObject json = jsonObject.getJSONObject(p.getPropertyName());
                String value = json.getString("id");
                Validate.notNull((Object)value, (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u6570\u636e\u7684id\u9879\u76ee", (Object[])new Object[0]);
                Validate.isTrue((boolean)this.checkRelationDataExist(p.getTargetTableName(), value.toString()), (String)"\u4f20\u5165manyToOne\u5bf9\u8c61ID\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            } else if (p.getRelationType().equals("ManyToMany")) {
                JSONArray manyToManyIds = jsonObject.getJSONArray(p.getPropertyName());
                manyToManyIds.stream().forEach(o -> {
                    Map kvs = (Map)o;
                    Object value = kvs.get("id");
                    Validate.notNull(value, (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u6570\u636e\u7684id\u9879\u76ee", (Object[])new Object[0]);
                    Validate.isTrue((boolean)this.checkRelationDataExist(p.getTargetTableName(), value.toString()), (String)"\u4f20\u5165manyToMany\u5bf9\u8c61ID\u4e0d\u5b58\u5728", (Object[])new Object[0]);
                });
            }
        });
    }

    private Boolean checkRelationDataExist(String targetTableName, String id) {
        Validate.notBlank((CharSequence)targetTableName, (String)"\u76ee\u6807\u6570\u636e\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)id, (String)"\u76ee\u6807\u6570\u636e\u8868\u6570\u636eID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        List<?> result = this.dynamicInstanceCustomRepository.executeQuerySql("SELECT id FROM `%s` where id = '%s'", targetTableName, id);
        return !CollectionUtils.isEmpty(result);
    }

    private void checkItems(Set<TemplateItemEntity> items, JSONObject jsonObject, Boolean isCreate) {
        if (CollectionUtils.isEmpty(items)) {
            return;
        }
        for (TemplateItemEntity item : items) {
            JSONArray itemJsonArray;
            if (null == jsonObject.get((Object)item.getPropertyName()) || (itemJsonArray = jsonObject.getJSONArray(item.getPropertyName())) == null || itemJsonArray.isEmpty()) continue;
            ArrayList<JSONObject> itemJsonObjects = new ArrayList<JSONObject>();
            for (int i = 0; i < itemJsonArray.size(); ++i) {
                itemJsonObjects.add(itemJsonArray.getJSONObject(i));
            }
            if (CollectionUtils.isEmpty(itemJsonObjects)) continue;
            for (JSONObject itemjson : itemJsonObjects) {
                this.checkProperties(item.getProperties(), itemjson, isCreate);
                this.checkRelations(this.filterOneToOneRelation(item.getRelations(), item.getParentTableName()), itemjson, isCreate);
            }
        }
    }

    private TemplateEntity validateInstanceAndTemplateInfo(String formInstanceId) {
        InstanceEntity instanceEntity = this.instanceService.findDetailsById(formInstanceId);
        Validate.notNull((Object)instanceEntity, (String)"\u6839\u636e\u4f20\u5165\u7684\u5b9e\u4f8bID\u672a\u80fd\u83b7\u53d6\u5230\u5b9e\u4f8b\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((instanceEntity.getTemplate() != null ? 1 : 0) != 0, (String)"\u5728\u5b9e\u4f8b\u4fe1\u606f\u4e2d\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u6a21\u677f\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)instanceEntity.getTemplate().getId(), (String)"\u5728\u5b9e\u4f8b\u4fe1\u606f\u4e2d\uff0c\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        TemplateEntity template = this.templateService.findDetailsById(instanceEntity.getTemplate().getId());
        Validate.notBlank((CharSequence)template.getId(), (String)"\u6839\u636e\u4f20\u5165\u7684\u5b9e\u4f8bID\u4fe1\u606f\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u6a21\u677fID\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)template.getType(), (CharSequence)DYNAMIC), (String)"\u8be5\u6a21\u677f\u4e0d\u662f\u52a8\u6001\u6a21\u677f\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)template.getTableName(), (String)"\u672a\u53d1\u73b0\u8be5\u52a8\u6001\u6a21\u677f\u7684\u8bbe\u7f6e\u7684\u6570\u636e\u5e93\u8868\u540d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)template.getRepositoryEntity(), (String)"\u8be5\u52a8\u6001\u8868\u5355\u6a21\u677f\u6ca1\u6709\u6570\u636e\u5c42\u4fe1\u606f\u8fdb\u884c\u652f\u6491\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((template.getTstatus() == 1 ? 1 : 0) != 0, (String)"\u8be5\u52a8\u6001\u8868\u5355\u6a21\u677f\u5f53\u524d\u72b6\u6001\u4e3a\u7981\u7528\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        return template;
    }

    private void processManyToMany(Set<TemplateRelationEntity> relations, String tableName, String id, JSONObject json) {
        Set manyToManys = relations.stream().filter(e -> this.isManyToMany(e.getRelationType()) && e.getBackProperty() == false).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(manyToManys)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (TemplateRelationEntity e2 : manyToManys) {
            JSONArray jsonArr = this.dynamicInstanceCustomRepository.findManyToMany(tableName, e2.getTargetTableName(), id);
            map.put(e2.getPropertyName(), jsonArr);
        }
        this.buildJSON(map, json);
    }

    private void processManyToOne(Set<TemplateRelationEntity> relations, String tableName, String id, JSONObject json) {
        Set manyToOnes = relations.stream().filter(e -> this.isManyToOne(e.getRelationType()) && e.getBackProperty() == false).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(manyToOnes)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (TemplateRelationEntity e2 : manyToOnes) {
            JSONArray jsonArr = this.dynamicInstanceCustomRepository.findManyToOne(tableName, e2.getTargetTableName(), e2.getPropertyDbName(), id);
            map.put(e2.getPropertyName(), this.fetchOne(jsonArr));
        }
        this.buildJSON(map, json);
    }

    private void processOneToOne(Set<TemplateGroupEntity> groups, String id, JSONObject resultJson) {
        HashMap<String, Object> otoMap = new HashMap<String, Object>();
        for (TemplateGroupEntity group : groups) {
            Set otmRelations;
            Set props = group.getProperties();
            Validate.notNull((Object)props, (String)"%s\u4e0b\u7684\u4e00\u822c\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{group.getPropertyDesc()});
            Validate.notBlank((CharSequence)group.getTableName(), (String)"%s\u4e0b\u7684\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{group.getPropertyDesc()});
            Validate.notBlank((CharSequence)group.getParentTableName(), (String)"%s\u4e0b\u7684\u4e0a\u5c42\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{group.getPropertyDesc()});
            JSONArray jsonArr = this.dynamicInstanceCustomRepository.findProperties(props, group.getTableName(), group.getParentTableName(), id, group.getPropertyDesc());
            JSONObject json = this.fetchOne(jsonArr);
            if (json == null) continue;
            String groupId = json.getString("id");
            Set otoRelations = group.getRelations();
            if (!CollectionUtils.isEmpty((Collection)otoRelations)) {
                this.processManyToMany(otoRelations, group.getTableName(), groupId, json);
                this.processManyToOne(otoRelations, group.getTableName(), groupId, json);
            }
            if (!CollectionUtils.isEmpty((Collection)(otmRelations = group.getItemRelations()))) {
                this.processOneToMany(otmRelations, groupId, json);
            }
            otoMap.put(group.getPropertyName(), json);
        }
        this.buildJSON(otoMap, resultJson);
    }

    private void processOneToMany(Set<TemplateItemEntity> oneToManys, String id, JSONObject json) {
        HashMap<String, Object> otmMap = new HashMap<String, Object>();
        for (TemplateItemEntity item : oneToManys) {
            Set itemProps = item.getProperties();
            Validate.notNull((Object)itemProps, (String)"%s\u4e0b\u7684\u4e00\u822c\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{item.getPropertyDesc()});
            Validate.notBlank((CharSequence)item.getTableName(), (String)"%s\u4e0b\u7684\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{item.getPropertyDesc()});
            Validate.notBlank((CharSequence)item.getParentTableName(), (String)"%s\u4e0b\u7684\u4e0a\u5c42\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{item.getPropertyDesc()});
            JSONArray jsonArr = this.dynamicInstanceCustomRepository.findProperties(itemProps, item.getTableName(), item.getParentTableName(), id, item.getPropertyDesc());
            Set itemRelations = item.getRelations();
            if (!CollectionUtils.isEmpty((Collection)itemRelations) && this.existJSON(jsonArr)) {
                for (int i = 0; i < jsonArr.size(); ++i) {
                    JSONObject itemJson = jsonArr.getJSONObject(i);
                    String itemId = itemJson.getString("id");
                    this.processManyToMany(itemRelations, item.getTableName(), itemId, itemJson);
                    this.processManyToOne(itemRelations, item.getTableName(), itemId, itemJson);
                }
            }
            otmMap.put(item.getPropertyName(), jsonArr);
        }
        this.buildJSON(otmMap, json);
    }

    private boolean existJSON(JSONArray jsonArr) {
        return jsonArr != null && !jsonArr.isEmpty();
    }

    private JSONObject fetchOne(JSONArray jsonArr) {
        return this.existJSON(jsonArr) ? jsonArr.getJSONObject(0) : null;
    }

    private void buildJSON(Map<String, Object> map, JSONObject json) {
        if (!CollectionUtils.isEmpty(map)) {
            map.forEach((key, value) -> json.put(key, value));
        }
    }

    private boolean isManyToMany(String relationType) {
        return StringUtils.equalsAnyIgnoreCase((CharSequence)relationType, (CharSequence[])new CharSequence[]{RelationsTypeEnum.MANY_TO_MANY.getRelation()});
    }

    private boolean isManyToOne(String relationType) {
        return StringUtils.equalsAnyIgnoreCase((CharSequence)relationType, (CharSequence[])new CharSequence[]{RelationsTypeEnum.MANY_TO_ONE.getRelation()});
    }

    private String formatDate(String value) {
        try {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(Long.parseLong(value));
        }
        catch (IllegalArgumentException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(String.format("\u65f6\u95f4\u7c7b\u578b\u53c2\u6570\u8f93\u5165\u975e\u6cd5, \u8bf7\u68c0\u67e5 input value: [%s]", value));
        }
    }
}

