/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.bizunited.platform.core.entity.ServicableMethodEntity;
import com.bizunited.platform.core.entity.UserEntity;
import com.bizunited.platform.core.entity.UuidEntity;
import com.bizunited.platform.core.service.file.NebulaFileService;
import com.bizunited.platform.core.service.serviceable.ServicableMethodService;
import com.bizunited.platform.kuiper.entity.InstanceActivityEntity;
import com.bizunited.platform.kuiper.entity.InstanceActivityLogEntity;
import com.bizunited.platform.kuiper.entity.InstanceEntity;
import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.entity.TemplateGroupEntity;
import com.bizunited.platform.kuiper.entity.TemplateItemEntity;
import com.bizunited.platform.kuiper.entity.TemplatePropertyEntity;
import com.bizunited.platform.kuiper.entity.TemplateRelationEntity;
import com.bizunited.platform.kuiper.service.DynamicInstanceService;
import com.bizunited.platform.kuiper.service.TemplateService;
import com.bizunited.platform.kuiper.starter.common.enums.RelationsTypeEnum;
import com.bizunited.platform.kuiper.starter.repository.InstanceActivityLogRepository;
import com.bizunited.platform.kuiper.starter.service.InstanceActivityLogService;
import com.bizunited.platform.kuiper.starter.service.InstanceActivityService;
import com.bizunited.platform.kuiper.starter.service.KuiperToolkitService;
import com.bizunited.platform.rbac.server.service.UserService;
import com.bizunited.platform.rbac.server.vo.UserVo;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.IllegalFormatFlagsException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service(value="InstanceActivityLogServiceImpl")
public class InstanceActivityLogServiceImpl
implements InstanceActivityLogService {
    @Autowired
    private TemplateService templateService;
    @Autowired
    private DynamicInstanceService dynamicInstanceService;
    @Autowired
    private InstanceActivityService instanceActivityService;
    @Autowired
    private InstanceActivityLogRepository instanceActivityLogRepository;
    @Autowired
    private NebulaFileService nebulaFileService;
    @Autowired
    private UserService userService;
    @Autowired
    private ServicableMethodService servicableMethodService;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="KuiperToolkitService")
    private KuiperToolkitService kuiperToolkitService;
    private static final Logger LOGGER = LoggerFactory.getLogger(InstanceActivityLogServiceImpl.class);

    @Override
    @Transactional
    public InstanceActivityLogEntity create(InstanceActivityLogEntity instanceActivityLog, JSONObject log) {
        Validate.notNull((Object)instanceActivityLog, (String)"\u8fdb\u884c\u4fdd\u5b58\u64cd\u4f5c\u65f6\uff0c\u65e5\u5fd7\u63cf\u8ff0\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        String id = instanceActivityLog.getId();
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)id), (String)"\u8fdb\u884c\u4fdd\u5b58\u64cd\u4f5c\u662f\uff0c\u65e5\u5fd7\u63cf\u8ff0\u5bf9\u8c61\u7684id\u7f16\u53f7\u4e0d\u80fd\u6709\u503c", (Object[])new Object[0]);
        instanceActivityLog.setId(null);
        InstanceActivityEntity instanceActivity = instanceActivityLog.getInstanceActivity();
        Validate.notNull((Object)instanceActivity, (String)"\u8fdb\u884c\u4fdd\u5b58\u65f6\uff0c\u5173\u8054\u7684\u5b9e\u4f8b\u6d3b\u52a8\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        String instanceActivityId = instanceActivity.getId();
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)instanceActivityId), (String)"\u8fdb\u884c\u4fdd\u5b58\u65f6\uff0c\u5173\u8054\u7684\u5b9e\u4f8b\u6d3b\u52a8\u7f16\u53f7\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        InstanceActivityEntity currentInstanceActivity = this.instanceActivityService.findById(instanceActivityId);
        Validate.notNull((Object)currentInstanceActivity, (String)"\u672a\u627e\u5230\u5f53\u524d\u6d3b\u52a8\u65e5\u5fd7\u5bf9\u5e94\u7684\u5b9e\u4f8b\u6d3b\u52a8\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u4f20\u53c2!!", (Object[])new Object[0]);
        UserEntity creator = instanceActivityLog.getCreator();
        Validate.notNull((Object)creator, (String)"\u8fdb\u884c\u4fdd\u5b58\u64cd\u4f5c\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u521b\u5efa\u8005\u4fe1\u606f!!", (Object[])new Object[0]);
        String creatorId = creator.getId();
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)creatorId), (String)"\u521b\u5efa\u8005\u7f16\u53f7\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        UserVo currentUser = this.userService.findByUserId(creatorId);
        Validate.notNull((Object)currentUser, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u521b\u5efa\u4eba\u8d44\u6599\uff0c\u8bf7\u68c0\u67e5\u8bbe\u5b9a!!", (Object[])new Object[0]);
        Validate.notNull((Object)log, (String)"\u8fdb\u884c\u4fdd\u5b58\u65f6\uff0c\u65e5\u5fd7\u5185\u5bb9\u7684json\u683c\u5f0f\u8868\u793a\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Date nowDate = new Date();
        String folderName = new SimpleDateFormat("yyyyMMdd").format(nowDate);
        String subSystem = "activityLog";
        String relativePath = StringUtils.join((Object[])new Serializable[]{"/", subSystem, "/", folderName, "/", Integer.valueOf(new Random().nextInt(100) % 10)});
        String fileName = StringUtils.join((Object[])new String[]{UUID.randomUUID().toString(), ".json"});
        this.nebulaFileService.saveFile(relativePath, fileName, fileName, log.toJSONString().getBytes());
        instanceActivityLog.setCreateTime(new Date());
        instanceActivityLog.setRelativePath(relativePath);
        instanceActivityLog.setFileName(fileName);
        this.instanceActivityLogRepository.save(instanceActivityLog);
        return instanceActivityLog;
    }

    @Override
    public Set<InstanceActivityLogEntity> findDetailsByInstanceActivity(String instanceActivityId) {
        if (StringUtils.isBlank((CharSequence)instanceActivityId)) {
            return Sets.newHashSet();
        }
        return this.instanceActivityLogRepository.findDetailsByInstanceActivity(instanceActivityId);
    }

    @Override
    public InstanceActivityLogEntity findDetailsById(String instanceActivityLogId) {
        if (StringUtils.isBlank((CharSequence)instanceActivityLogId)) {
            return null;
        }
        return this.instanceActivityLogRepository.findDetailsById(instanceActivityLogId);
    }

    @Override
    public JSONObject findContentById(String instanceActivityLogId) {
        String fileName;
        if (StringUtils.isBlank((CharSequence)instanceActivityLogId)) {
            return null;
        }
        InstanceActivityLogEntity currentLog = this.instanceActivityLogRepository.findDetailsById(instanceActivityLogId);
        if (currentLog == null) {
            return null;
        }
        String relativePath = currentLog.getRelativePath();
        byte[] contents = this.nebulaFileService.readFileContent(relativePath, fileName = currentLog.getFileName());
        if (contents == null || contents.length == 0) {
            return null;
        }
        return JSON.parseObject((String)new String(contents));
    }

    @Override
    public String findTopByInstanceId(String instanceId) {
        if (StringUtils.isBlank((CharSequence)instanceId)) {
            return null;
        }
        return this.instanceActivityLogRepository.findTopByInstanceId(instanceId);
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void validateRecoveryByInstanceActivityLogId(String instanceActivityLogId) {
        this.recoveryByInstanceActivityLogId(instanceActivityLogId);
        throw new IllegalStateException();
    }

    @Override
    @Transactional
    public JSONObject recoveryByInstanceActivityLogId(String instanceActivityLogId) {
        InstanceActivityLogEntity instanceActivityLog = this.findDetailsById(instanceActivityLogId);
        Validate.notNull((Object)instanceActivityLog, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6570\u636e\u53d8\u5316\u65e5\u5fd7!!", (Object[])new Object[0]);
        InstanceActivityEntity instanceActivity = instanceActivityLog.getInstanceActivity();
        Validate.notNull((Object)instanceActivity, (String)"\u672a\u53d1\u73b0\u5b9e\u4f8b\u6d3b\u52a8\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String instanceActivityId = instanceActivity.getId();
        Validate.notBlank((CharSequence)instanceActivityId, (String)"\u672a\u627e\u5230\u6307\u5b9a\u5b9e\u4f8b\u6d3b\u52a8\u7f16\u53f7\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        InstanceEntity currentInstance = instanceActivity.getInstance();
        Validate.notNull((Object)currentInstance, (String)"\u672a\u53d1\u73b0\u5b9e\u4f8b\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String instanceId = currentInstance.getId();
        TemplateEntity currentTemplate = currentInstance.getTemplate();
        String templateType = currentTemplate.getType();
        Validate.isTrue((StringUtils.equals((CharSequence)templateType, (CharSequence)"static") || StringUtils.equals((CharSequence)templateType, (CharSequence)"dynamic") ? 1 : 0) != 0, (String)"\u76ee\u524d\u6570\u636e\u6062\u590d\u529f\u80fd\u53ea\u652f\u6301\u9759\u6001/\u52a8\u6001\u8868\u5355\u5b9e\u4f8b\uff0c\u8bf7\u786e\u8ba4!!", (Object[])new Object[0]);
        Validate.notNull((Object)currentTemplate, (String)"\u672a\u53d1\u73b0\u5173\u8054\u7684\u6a21\u677f\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String templateId = currentTemplate.getId();
        JSONObject logJson = this.findContentById(instanceActivityLogId);
        Validate.notNull((Object)logJson, (String)"\u672a\u627e\u5230\u53d8\u5316\u65e5\u5fd7\u5185\u5bb9\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u7cfb\u7edf!!", (Object[])new Object[0]);
        String newestLogId = this.instanceActivityLogRepository.findTopByInstanceId(instanceId);
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)newestLogId, (CharSequence)instanceActivityLogId), (String)"\u5f53\u524d\u6570\u636e\u53d8\u5316\u65e5\u5fd7\u5e76\u4e0d\u662f\u672c\u5b9e\u4f8b[%s]\u6700\u8fd1\u4e00\u6b21\u6570\u636e\u53d8\u52a8\uff0c\u4e0d\u5141\u8bb8\u57fa\u4e8e\u8fd9\u4e2a\u65e5\u5fd7\u8fdb\u884c\u6570\u636e\u6062\u590d!!", (Object[])new Object[]{instanceId});
        if (StringUtils.equals((CharSequence)templateType, (CharSequence)"static")) {
            return this.recoveryByStaticInstanceActivityLogId(instanceId, currentTemplate, instanceActivityLogId, logJson);
        }
        if (StringUtils.equals((CharSequence)templateType, (CharSequence)"dynamic")) {
            return this.recoveryByDynamicInstanceActivityLogId(instanceId, templateId, instanceActivityLogId, logJson);
        }
        throw new IllegalFormatFlagsException("\u76ee\u524d\u6570\u636e\u6062\u590d\u529f\u80fd\u53ea\u652f\u6301\u9759\u6001/\u52a8\u6001\u8868\u5355\u5b9e\u4f8b\uff0c\u8bf7\u786e\u8ba4!!");
    }

    private JSONObject recoveryByStaticInstanceActivityLogId(String instanceId, TemplateEntity currentTemplate, String instanceActivityLogId, JSONObject logJson) {
        Validate.notBlank((CharSequence)instanceActivityLogId, (String)"\u6570\u636e\u53d8\u5316\u65e5\u5fd7\u7f16\u53f7\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)instanceId, (String)"\u9759\u6001\u5b9e\u4f8b\u7f16\u53f7\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        String persistentClassName = currentTemplate.getPersistentClassName();
        Validate.notBlank((CharSequence)persistentClassName, (String)"\u672a\u8bf4\u660e\u7684\u6a21\u578b\u7c7b\u5b9a\u4e49\uff0c\u8bf7\u68c0\u67e5\u8bbe\u5b9a!!", (Object[])new Object[0]);
        InstanceActivityLogEntity instanceActivityLog = this.findDetailsById(instanceActivityLogId);
        Validate.notNull((Object)instanceActivityLog, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6570\u636e\u53d8\u5316\u65e5\u5fd7!!", (Object[])new Object[0]);
        String templateId = currentTemplate.getId();
        String queryDetailsService = instanceActivityLog.getQueryDetailsService();
        String updateDetailsService = instanceActivityLog.getUpdateDetailsService();
        Validate.notBlank((CharSequence)queryDetailsService, (String)"\u672a\u53d1\u73b0\u6570\u636e\u660e\u7ec6\u67e5\u8be2\u670d\u52a1\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)updateDetailsService, (String)"\u672a\u53d1\u73b0\u6570\u636e\u66f4\u65b0\u670d\u52a1\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String queryMethodName = null;
        String updateMethodName = null;
        try {
            queryMethodName = queryDetailsService.split("\\.")[1];
            updateMethodName = updateDetailsService.split("\\.")[1];
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("\u9519\u8bef\u7684\u670d\u52a1\u540d\uff0c\u8bf7\u68c0\u67e5\u670d\u52a1\u6e90\u914d\u7f6e!!");
        }
        ServicableMethodEntity servicableMethod = this.servicableMethodService.findByName(queryDetailsService);
        Validate.notNull((Object)servicableMethod, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u670d\u52a1\u65b9\u6cd5\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        String interfaceName = servicableMethod.getInterfaceName();
        Object details = this.invokeQueryDetails(interfaceName, queryMethodName, instanceId);
        Validate.notNull((Object)details, (String)"\u6839\u636e\u670d\u52a1\u65b9\u6cd5[%s.%s]\uff0c\u672a\u67e5\u8be2\u5230\u4efb\u52a1\u4e1a\u52a1\u6570\u636e\u660e\u7ec6\uff08\u57fa\u4e8e\u8868\u5355\u5b9e\u4f8b[%s]\uff09\uff0c\u8bf7\u68c0\u67e5\u8bbe\u5b9a!!", (Object[])new Object[]{interfaceName, queryMethodName, instanceId});
        Class<?> returnType = details.getClass();
        TemplateEntity template = this.templateService.findDetailsById(templateId);
        Validate.notNull((Object)template, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u9759\u6001\u6a21\u677f\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{templateId});
        Set<String> wWhiteLists = this.kuiperToolkitService.buildAllWhiteList(template);
        String[] propertiesFilter = wWhiteLists.toArray(new String[0]);
        Object resouceObject = this.kuiperToolkitService.copyObjectByWhiteList(details, returnType, LinkedHashSet.class, ArrayList.class, propertiesFilter);
        JSONObject resouceJSONObject = (JSONObject)JSON.toJSON((Object)resouceObject);
        JSONObject targetSONObject = (JSONObject)JSON.toJSON((Object)resouceObject);
        this.recoveryByStep(targetSONObject, logJson);
        this.defineDiff(template, resouceJSONObject, targetSONObject);
        if (StringUtils.equals((CharSequence)template.getType(), (CharSequence)"static")) {
            this.invokeRecoveryStaticService(persistentClassName, template, targetSONObject, interfaceName, updateMethodName);
        } else if (StringUtils.equals((CharSequence)template.getType(), (CharSequence)"dynamic")) {
            this.invokeRecoveryDynamicService(template, instanceId, targetSONObject);
        } else {
            throw new IllegalFormatFlagsException("\u6570\u636e\u6062\u590d\u529f\u80fd\u76ee\u524d\u53ea\u652f\u6301\u9759\u6001\u6a21\u677f\u548c\u52a8\u6001\u6a21\u677f\u7c7b\u578b\u7684\u8868\u5355");
        }
        this.instanceActivityLogRepository.deleteById(instanceActivityLogId);
        return targetSONObject;
    }

    private JSONObject recoveryByDynamicInstanceActivityLogId(String instanceId, String templateId, String instanceActivityLogId, JSONObject logJson) {
        Validate.notBlank((CharSequence)instanceActivityLogId, (String)"\u6570\u636e\u53d8\u5316\u65e5\u5fd7\u7f16\u53f7\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        JSONObject resouceJSONObject = this.dynamicInstanceService.findDetailsByFormInstanceId(instanceId);
        Validate.notNull((Object)resouceJSONObject, (String)"\u672a\u67e5\u8be2\u5230\u4efb\u52a1\u4e1a\u52a1\u6570\u636e\u660e\u7ec6\uff08\u57fa\u4e8e\u8868\u5355\u5b9e\u4f8b[%s]\uff09\uff0c\u8bf7\u68c0\u67e5\u8bbe\u5b9a!!", (Object[])new Object[]{instanceId});
        TemplateEntity template = this.templateService.findDetailsById(templateId);
        Validate.notNull((Object)template, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u9759\u6001\u6a21\u677f\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{templateId});
        String jsonConent = resouceJSONObject.toJSONString();
        JSONObject targetSONObject = JSON.parseObject((String)jsonConent);
        this.recoveryByStep(targetSONObject, logJson);
        this.defineDiff(template, resouceJSONObject, targetSONObject);
        this.invokeRecoveryDynamicService(template, instanceId, targetSONObject);
        this.instanceActivityLogRepository.deleteById(instanceActivityLogId);
        return targetSONObject;
    }

    private void invokeRecoveryStaticService(String persistentClassName, TemplateEntity template, JSONObject targetSONObject, String interfaceName, String updateMethodName) {
        Class<?> currentPersistentClass = null;
        ClassLoader springClassLoader = this.applicationContext.getClassLoader();
        try {
            currentPersistentClass = springClassLoader.loadClass(persistentClassName);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u9759\u6001\u6a21\u578b\u7c7b[" + persistentClassName + "]\uff0c\u8bf7\u68c0\u67e5!!");
        }
        Object targetObject = null;
        targetObject = this.convertJSONToObject(targetSONObject, template, currentPersistentClass);
        Validate.notNull(targetObject, (String)"convertJSONToObject\u5185\u90e8\u65b9\u6cd5\u51fa\u73b0\u9519\u8bef\uff0c\u8bf7\u542f\u52a8\u8c03\u8bd5\u6a21\u5f0f", (Object[])new Object[0]);
        Object bean = null;
        try {
            Class<?> interfaceClass = springClassLoader.loadClass(interfaceName);
            bean = this.applicationContext.getBean(interfaceClass);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u5728\u6570\u636e\u6062\u590d\u65f6\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u670d\u52a1\u6ce8\u518c[" + interfaceName + "]");
        }
        try {
            Method currentUpdateMethod = bean.getClass().getMethod(updateMethodName, currentPersistentClass);
            currentUpdateMethod.invoke(bean, targetObject);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException e) {
            throw new IllegalArgumentException("\u5728\u6570\u636e\u6062\u590d\u65f6\uff0c\u67e5\u627e\u6570\u636e\u66f4\u65b0\u65b9\u6cd5\u53d1\u751f\u9519\u8bef[" + updateMethodName + "]\uff0c\u5f88\u53ef\u80fd\u8bbe\u5b9a\u7684\u65b9\u6cd5\u5df2\u7ecf\u4e0d\u5b58\u5728\u6216\u8005\u53c2\u6570\u5df2\u6539\u53d8\uff08\u6307\u5b9a\u7684\u65b9\u6cd5\u89c4\u5b9a\u53ea\u80fd\u7a7f\u5165\u4e00\u79cd\u7c7b\u578b\u7684\u53c2\u6570[" + persistentClassName + "]\uff09\uff0c\u8bf7\u68c0\u67e5!!");
        }
        catch (InvocationTargetException e) {
            Throwable targetThrowable = e.getTargetException();
            if (targetThrowable != null) {
                throw new RuntimeException("\u6570\u636e\u6062\u590d\u65f6\uff0c\u51fa\u73b0\u9519\u8bef\uff1a" + targetThrowable.getMessage() + "!\u5982\u53d1\u73b0\u5f53\u524d\u8868\u5355\u5b9e\u4f8b\u7684id\u4e3b\u952e\u5df2\u7ecf\u6ca1\u6709\u503c\uff0c\u90a3\u4e48\u8bf4\u660e\u5f53\u524d\u6062\u590d\u64cd\u4f5c\u5df2\u7ecf\u662f\u5f53\u524d\u8868\u5355\u5b9e\u4f8b\u7684\u6700\u521d\u6b65\u9aa4\uff0c\u4e0d\u80fd\u518d\u5411\u524d\u6062\u590d!!", targetThrowable);
            }
            throw new RuntimeException("\u6570\u636e\u6062\u590d\u65f6\uff0c\u51fa\u73b0\u9519\u8bef\uff1a" + e.getMessage() + "!\u5982\u53d1\u73b0\u5f53\u524d\u8868\u5355\u5b9e\u4f8b\u7684id\u4e3b\u952e\u5df2\u7ecf\u6ca1\u6709\u503c\uff0c\u90a3\u4e48\u8bf4\u660e\u5f53\u524d\u6062\u590d\u64cd\u4f5c\u5df2\u7ecf\u662f\u5f53\u524d\u8868\u5355\u5b9e\u4f8b\u7684\u6700\u521d\u6b65\u9aa4\uff0c\u4e0d\u80fd\u518d\u5411\u524d\u6062\u590d!!", e);
        }
        catch (Exception e) {
            throw new RuntimeException("\u6570\u636e\u6062\u590d\u65f6\uff0c\u51fa\u73b0\u9519\u8bef\uff1a" + e.getMessage() + "!\u5982\u53d1\u73b0\u5f53\u524d\u8868\u5355\u5b9e\u4f8b\u7684id\u4e3b\u952e\u5df2\u7ecf\u6ca1\u6709\u503c\uff0c\u90a3\u4e48\u8bf4\u660e\u5f53\u524d\u6062\u590d\u64cd\u4f5c\u5df2\u7ecf\u662f\u5f53\u524d\u8868\u5355\u5b9e\u4f8b\u7684\u6700\u521d\u6b65\u9aa4\uff0c\u4e0d\u80fd\u518d\u5411\u524d\u6062\u590d!!", e);
        }
    }

    private void invokeRecoveryDynamicService(TemplateEntity template, String formInstanceId, JSONObject targetSONObject) {
        targetSONObject.put("formInstanceId", (Object)formInstanceId);
        this.dynamicInstanceService.update(targetSONObject);
    }

    private Object invokeQueryDetails(String interfaceName, String queryMethodName, String instanceId) {
        Object bean = null;
        try {
            ClassLoader springClassLoader = this.applicationContext.getClassLoader();
            Class<?> interfaceClass = springClassLoader.loadClass(interfaceName);
            bean = this.applicationContext.getBean(interfaceClass);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u5728\u6570\u636e\u6062\u590d\u65f6\uff0c\u672a\u627e\u5230\u6307\u5b9a\u7684\u670d\u52a1\u6ce8\u518c[" + interfaceName + "]");
        }
        Object details = null;
        Class<?> returnType = null;
        try {
            Method currentMethod = bean.getClass().getMethod(queryMethodName, String.class);
            returnType = currentMethod.getReturnType();
            Validate.isTrue((returnType != null && returnType != Void.class ? 1 : 0) != 0, (String)"\u65b9\u6cd5[%s.%s]\u6ca1\u6709\u8bbe\u5b9a\u8fd4\u56de\u503c\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{interfaceName, queryMethodName});
            details = currentMethod.invoke(bean, instanceId);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u5728\u6570\u636e\u6062\u590d\u65f6\uff0c\u67e5\u627e\u6570\u636e\u660e\u7ec6\u53d1\u751f\u9519\u8bef[" + queryMethodName + "]\uff0c\u5f88\u53ef\u80fd\u8bbe\u5b9a\u7684\u65b9\u6cd5\u5df2\u7ecf\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5!!");
        }
        return details;
    }

    private <T> T convertJSONToObject(JSONObject dataJson, TemplateEntity template, Class<T> currentPersistentClass) {
        Set templateGroups;
        Set templateItems;
        Set relations;
        T targetData = null;
        String className = currentPersistentClass.getName();
        try {
            targetData = currentPersistentClass.newInstance();
        }
        catch (Exception e) {
            LOGGER.error("\u7c7b[{}]\u672a\u80fd\u5b8c\u6210\u521d\u59cb\u5316\uff0c\u8bf7\u68c0\u67e5\u7c7b\u4e2d\u662f\u5426\u4fdd\u7559\u4e86\u9ed8\u8ba4\u7684\u6784\u9020\u51fd\u6570!!", (Object)className);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        Set templateProperties = template.getProperties();
        if (templateProperties != null && !templateProperties.isEmpty()) {
            this.convertJSONToObjectProperties(dataJson, targetData, templateProperties, currentPersistentClass);
        }
        if ((relations = template.getRelations()) != null && !relations.isEmpty()) {
            this.convertJSONToObjectRelations(dataJson, targetData, relations, currentPersistentClass);
        }
        if ((templateItems = template.getItemRelations()) != null && !templateItems.isEmpty()) {
            this.convertJSONToObjectItems(dataJson, targetData, templateItems, currentPersistentClass);
        }
        if ((templateGroups = template.getGroupRelations()) != null && !templateGroups.isEmpty()) {
            this.convertJSONToObjectGroups(dataJson, targetData, templateGroups, currentPersistentClass);
        }
        return targetData;
    }

    private void convertJSONToObjectGroups(JSONObject dataJson, Object targetData, Set<TemplateGroupEntity> templateGroups, Class<?> currentPersistentClass) {
        for (TemplateGroupEntity templateGroup : templateGroups) {
            Set templateGroupItems;
            Set templateGroupRelations;
            String propertyName = templateGroup.getPropertyName();
            String propertyClassName = templateGroup.getPropertyClassName();
            Class<?> groupClass = null;
            Field propertyField = null;
            Object groupObject = null;
            ClassLoader springClassLoader = this.applicationContext.getClassLoader();
            try {
                groupClass = springClassLoader.loadClass(propertyClassName);
                groupObject = groupClass.newInstance();
                propertyField = this.findField(currentPersistentClass, propertyName);
                if (propertyField == null) {
                    LOGGER.warn("\u672a\u5728\u6307\u5b9a\u7684\u7c7b[{}]\u627e\u5230\u5c5e\u6027\u5b57\u6bb5[{}]\uff0c\u8bf7\u68c0\u67e5!!", (Object)propertyClassName, (Object)propertyName);
                    continue;
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
            JSONObject groupJsonData = (JSONObject)JSONPath.eval((Object)dataJson, (String)("$['" + propertyName + "']"));
            if (groupJsonData == null) continue;
            Set templateGroupProperties = templateGroup.getProperties();
            if (templateGroupProperties != null && !templateGroupProperties.isEmpty()) {
                this.convertJSONToObjectProperties(groupJsonData, groupObject, templateGroupProperties, groupClass);
            }
            if ((templateGroupRelations = templateGroup.getRelations()) != null && !templateGroupRelations.isEmpty()) {
                this.convertJSONToObjectRelations(groupJsonData, groupObject, templateGroupRelations, groupClass);
            }
            if ((templateGroupItems = templateGroup.getItemRelations()) != null && !templateGroupItems.isEmpty()) {
                this.convertJSONToObjectItems(groupJsonData, groupObject, templateGroupItems, groupClass);
            }
            try {
                propertyField.setAccessible(true);
                propertyField.set(targetData, groupObject);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
    }

    private void convertJSONToObjectItems(JSONObject dataJson, Object targetData, Set<TemplateItemEntity> templateItems, Class<?> currentPersistentClass) {
        for (TemplateItemEntity templateItem : templateItems) {
            String propertyName = templateItem.getPropertyName();
            String propertyClassName = templateItem.getPropertyClassName();
            Class<?> itemClass = null;
            Field propertyField = null;
            ClassLoader springClassLoader = this.applicationContext.getClassLoader();
            try {
                itemClass = springClassLoader.loadClass(propertyClassName);
                propertyField = this.findField(currentPersistentClass, propertyName);
                if (propertyField == null) {
                    LOGGER.warn("\u672a\u5728\u6307\u5b9a\u7684\u7c7b[{}]\u627e\u5230\u5c5e\u6027\u5b57\u6bb5[{}]\uff0c\u8bf7\u68c0\u67e5!!", (Object)propertyClassName, (Object)propertyName);
                    continue;
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
            boolean isSet = !List.class.isAssignableFrom(propertyField.getDeclaringClass());
            AbstractCollection collection = null;
            collection = isSet ? new LinkedHashSet() : new LinkedList();
            JSONArray itemJsonArrays = (JSONArray)JSONPath.eval((Object)dataJson, (String)("$['" + propertyName + "']"));
            if (itemJsonArrays == null || itemJsonArrays.isEmpty()) continue;
            for (int index = 0; index < itemJsonArrays.size(); ++index) {
                Set itemRelations;
                JSONObject itemJsonData = itemJsonArrays.getJSONObject(index);
                Object itemObject = null;
                try {
                    itemObject = itemClass.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new IllegalArgumentException(e.getMessage(), e);
                }
                Set itemProperties = templateItem.getProperties();
                if (itemProperties != null && !itemProperties.isEmpty()) {
                    this.convertJSONToObjectProperties(itemJsonData, itemObject, itemProperties, itemClass);
                }
                if ((itemRelations = templateItem.getRelations()) != null && !itemRelations.isEmpty()) {
                    this.convertJSONToObjectRelations(itemJsonData, itemObject, itemRelations, itemClass);
                }
                collection.add(itemObject);
            }
            try {
                propertyField.setAccessible(true);
                propertyField.set(targetData, collection);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
    }

    private void convertJSONToObjectRelations(JSONObject dataJson, Object targetData, Set<TemplateRelationEntity> relations, Class<?> currentPersistentClass) {
        for (TemplateRelationEntity templateRelation : relations) {
            String propertyClassName = templateRelation.getPropertyClassName();
            String propertyName = templateRelation.getPropertyName();
            String relationType = templateRelation.getRelationType();
            Class<?> relationClass = null;
            Field relationIdField = null;
            Field propertyField = null;
            AbstractCollection propertyValue = null;
            ClassLoader springClassLoader = this.applicationContext.getClassLoader();
            try {
                relationClass = springClassLoader.loadClass(propertyClassName);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
            propertyField = this.findField(currentPersistentClass, propertyName);
            if (propertyField == null) {
                LOGGER.warn("\u672a\u5728\u6307\u5b9a\u7684\u7c7b[{}]\u627e\u5230\u5c5e\u6027\u5b57\u6bb5[{}]\uff0c\u8bf7\u68c0\u67e5!!", (Object)propertyClassName, (Object)propertyName);
                continue;
            }
            if (StringUtils.equals((CharSequence)relationType, (CharSequence)RelationsTypeEnum.MANY_TO_MANY.getRelation())) {
                Object valueObjects = dataJson.get((Object)propertyName);
                if (!(valueObjects instanceof JSONArray)) continue;
                JSONArray values = (JSONArray)valueObjects;
                boolean isSet = !List.class.isAssignableFrom(propertyField.getDeclaringClass());
                AbstractCollection collection = null;
                collection = isSet ? new LinkedHashSet() : new LinkedList();
                for (int index = 0; index < values.size(); ++index) {
                    Object relationObject = null;
                    String idValue = values.getString(index);
                    try {
                        relationIdField = this.findField(relationClass, "id");
                        if (relationIdField == null) {
                            LOGGER.warn("\u672a\u5728\u6307\u5b9a\u7684\u7c7b[{}]\u627e\u5230\u5c5e\u6027\u5b57\u6bb5[id]\uff0c\u8bf7\u68c0\u67e5!!", (Object)propertyClassName);
                            continue;
                        }
                        relationObject = relationClass.newInstance();
                        relationIdField.setAccessible(true);
                        relationIdField.set(relationObject, idValue);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(e.getMessage(), e);
                    }
                    collection.add(relationObject);
                }
                propertyValue = collection;
            } else {
                JSONObject manyToOneObject = dataJson.getJSONObject(propertyName);
                if (manyToOneObject == null) continue;
                String idValue = manyToOneObject.getString("id");
                Object relationObject = null;
                try {
                    relationClass = springClassLoader.loadClass(propertyClassName);
                    relationIdField = this.findField(relationClass, "id");
                    if (relationIdField == null) {
                        LOGGER.warn("\u672a\u5728\u6307\u5b9a\u7684\u7c7b[{}]\u627e\u5230\u5c5e\u6027\u5b57\u6bb5[id]\uff0c\u8bf7\u68c0\u67e5!!", (Object)propertyClassName);
                        continue;
                    }
                    relationObject = relationClass.newInstance();
                    relationIdField.setAccessible(true);
                    relationIdField.set(relationObject, idValue);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e.getMessage(), e);
                }
                propertyValue = relationObject;
            }
            try {
                propertyField.setAccessible(true);
                propertyField.set(targetData, propertyValue);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
    }

    private void convertJSONToObjectProperties(JSONObject dataJson, Object targetData, Set<TemplatePropertyEntity> properties, Class<?> currentPersistentClass) {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        String className = currentPersistentClass.getName();
        for (TemplatePropertyEntity propertyItem : properties) {
            String propertyName = propertyItem.getPropertyName();
            String propertyClassName = propertyItem.getPropertyClassName();
            Field field = this.findField(currentPersistentClass, propertyName);
            if (field == null) {
                LOGGER.warn("\u672a\u5728\u7c7b[{}]\u4ee5\u53ca\u5176\u7236\u7c7b\u4e2d\u627e\u5230\u5c5e\u6027[{}]\uff0c\u8bf7\u68c0\u67e5\u7c7b\u5b9a\u4e49.", (Object)className, (Object)propertyName);
                continue;
            }
            try {
                Boolean booleanValue;
                Double doubletValue;
                Float floatValue;
                Long longValue;
                Byte byteValue;
                Short shortValue;
                Integer intValue;
                field.setAccessible(true);
                if (StringUtils.equals((CharSequence)propertyClassName, (CharSequence)"java.lang.String")) {
                    String stringValue = dataJson.getString(propertyName);
                    if (stringValue == null) continue;
                    field.set(targetData, stringValue);
                    continue;
                }
                if (StringUtils.equals((CharSequence)propertyClassName, (CharSequence)"java.lang.Integer")) {
                    intValue = dataJson.getInteger(propertyName);
                    if (intValue == null) continue;
                    field.set(targetData, intValue);
                    continue;
                }
                if (StringUtils.equals((CharSequence)propertyClassName, (CharSequence)"int")) {
                    intValue = dataJson.getInteger(propertyName);
                    if (intValue == null) continue;
                    field.setInt(targetData, intValue);
                    continue;
                }
                if (StringUtils.equals((CharSequence)propertyClassName, (CharSequence)"java.lang.Short")) {
                    shortValue = dataJson.getShort(propertyName);
                    if (shortValue == null) continue;
                    field.set(targetData, shortValue);
                    continue;
                }
                if (StringUtils.equals((CharSequence)propertyClassName, (CharSequence)"short")) {
                    shortValue = dataJson.getShort(propertyName);
                    if (shortValue == null) continue;
                    field.setShort(targetData, shortValue);
                    continue;
                }
                if (StringUtils.equals((CharSequence)propertyClassName, (CharSequence)"java.lang.Byte")) {
                    byteValue = dataJson.getByte(propertyName);
                    if (byteValue == null) continue;
                    field.set(targetData, byteValue);
                    continue;
                }
                if (StringUtils.equals((CharSequence)propertyClassName, (CharSequence)"byte")) {
                    byteValue = dataJson.getByte(propertyName);
                    if (byteValue == null) continue;
                    field.setByte(targetData, byteValue);
                    continue;
                }
                if (StringUtils.equals((CharSequence)propertyClassName, (CharSequence)"java.lang.Long")) {
                    longValue = dataJson.getLong(propertyName);
                    if (longValue == null) continue;
                    field.set(targetData, longValue);
                    continue;
                }
                if (StringUtils.equals((CharSequence)propertyClassName, (CharSequence)"long")) {
                    longValue = dataJson.getLong(propertyName);
                    if (longValue == null) continue;
                    field.setLong(targetData, longValue);
                    continue;
                }
                if (StringUtils.equals((CharSequence)propertyClassName, (CharSequence)"java.lang.Float")) {
                    floatValue = dataJson.getFloat(propertyName);
                    if (floatValue == null) continue;
                    field.set(targetData, floatValue);
                    continue;
                }
                if (StringUtils.equals((CharSequence)propertyClassName, (CharSequence)"float")) {
                    floatValue = dataJson.getFloat(propertyName);
                    if (floatValue == null) continue;
                    field.setFloat(targetData, floatValue.floatValue());
                    continue;
                }
                if (StringUtils.equals((CharSequence)propertyClassName, (CharSequence)"java.lang.Double")) {
                    doubletValue = dataJson.getDouble(propertyName);
                    if (doubletValue == null) continue;
                    field.set(targetData, doubletValue);
                    continue;
                }
                if (StringUtils.equals((CharSequence)propertyClassName, (CharSequence)"double")) {
                    doubletValue = dataJson.getDouble(propertyName);
                    if (doubletValue == null) continue;
                    field.setDouble(targetData, doubletValue);
                    continue;
                }
                if (StringUtils.equals((CharSequence)propertyClassName, (CharSequence)"java.util.Date")) {
                    Date dateValue = dataJson.getDate(propertyName);
                    if (dateValue == null) continue;
                    field.set(targetData, dateValue);
                    continue;
                }
                if (StringUtils.equals((CharSequence)propertyClassName, (CharSequence)"java.math.BigDecimal")) {
                    BigDecimal bigValue = dataJson.getBigDecimal(propertyName);
                    if (bigValue == null) continue;
                    field.set(targetData, bigValue);
                    continue;
                }
                if (StringUtils.equals((CharSequence)propertyClassName, (CharSequence)"java.lang.Boolean")) {
                    booleanValue = dataJson.getBoolean(propertyName);
                    if (booleanValue == null) continue;
                    field.set(targetData, booleanValue);
                    continue;
                }
                if (!StringUtils.equals((CharSequence)propertyClassName, (CharSequence)"boolean") || (booleanValue = dataJson.getBoolean(propertyName)) == null) continue;
                field.setBoolean(targetData, booleanValue);
            }
            catch (IllegalAccessException e) {
                LOGGER.warn("\u7c7b[{}]\u4e2d\u5c5e\u6027[{}]\u5728\u8d4b\u503c\u65f6\u53d1\u73b0\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u7c7b\u5b9a\u4e49.", (Object)className, (Object)propertyName);
            }
        }
    }

    private Field findField(Class<?> currentClass, String fieldName) {
        Field currentField = null;
        try {
            currentField = currentClass.getDeclaredField(fieldName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (currentField != null) {
            return currentField;
        }
        Class<?> parentClass = currentClass.getSuperclass();
        if (parentClass != null) {
            return this.findField(parentClass, fieldName);
        }
        return null;
    }

    private void defineDiff(TemplateEntity template, JSONObject resouceJSONObject, JSONObject targetSONObject) {
        Set templateGroups;
        Set templateItems;
        Validate.notNull((Object)template, (String)"\u8fdb\u884c\u5dee\u5f02\u6e05\u7406\u65f6\uff0c\u6a21\u677f\u4fe1\u606f\u5fc5\u987b\u4f20\u5165\uff01\uff01", (Object[])new Object[0]);
        if (resouceJSONObject == null) {
            resouceJSONObject = new JSONObject();
        }
        if (targetSONObject == null) {
            targetSONObject = new JSONObject();
        }
        if ((templateItems = template.getItemRelations()) != null && !templateItems.isEmpty()) {
            this.handleItemIds(templateItems, resouceJSONObject, targetSONObject);
        }
        if ((templateGroups = template.getGroupRelations()) != null && !templateGroups.isEmpty()) {
            for (TemplateGroupEntity templateGroup : templateGroups) {
                String groupName = templateGroup.getPropertyName();
                JSONObject resouceGroupJSONObject = resouceJSONObject.getJSONObject(groupName);
                JSONObject targetGroupJSONObject = targetSONObject.getJSONObject(groupName);
                Set groupItems = templateGroup.getItemRelations();
                if (groupItems == null || groupItems.isEmpty()) continue;
                this.handleItemIds(groupItems, resouceGroupJSONObject, targetGroupJSONObject);
            }
        }
    }

    private void handleItemIds(Set<TemplateItemEntity> templateItems, JSONObject resouceJSONObject, JSONObject targetSONObject) {
        for (TemplateItemEntity templateItem : templateItems) {
            JSONArray targetItem;
            String templateItemName = templateItem.getPropertyName();
            JSONArray resouceItem = resouceJSONObject.getJSONArray(templateItemName);
            if (resouceItem == null) {
                resouceItem = new JSONArray();
            }
            if ((targetItem = targetSONObject.getJSONArray(templateItemName)) == null) {
                targetItem = new JSONArray();
            }
            JSONArray existIds = (JSONArray)JSONPath.eval((Object)resouceItem, (String)"$['id']");
            block1: for (int index = 0; index < targetItem.size(); ++index) {
                JSONObject targetItemObject = targetItem.getJSONObject(index);
                String targetId = targetItemObject.getString("id");
                for (int idIndex = 0; idIndex < existIds.size(); ++idIndex) {
                    String existId = existIds.getString(idIndex);
                    if (StringUtils.equals((CharSequence)targetId, (CharSequence)existId)) continue block1;
                }
                targetItemObject.remove((Object)"id");
            }
        }
    }

    private void recoveryByStep(JSONObject dataJson, JSONObject logJson) {
        JSONArray relationsLogJson;
        Validate.notNull((Object)dataJson, (String)"\u8fdb\u884c\u56de\u590d\u65f6\uff0c\u6570\u636e\u7684json\u683c\u5f0f\u8868\u8fbe\u4e0d\u80fd\u4e3anull", (Object[])new Object[0]);
        Validate.notNull((Object)logJson, (String)"\u8fdb\u884c\u56de\u590d\u65f6\uff0c\u53d8\u5316\u65e5\u5fd7\u7684json\u683c\u5f0f\u8868\u8fbe\u4e0d\u80fd\u4e3anull", (Object[])new Object[0]);
        JSONArray propertiesLogJson = (JSONArray)JSONPath.eval((Object)logJson, (String)"$['properties']");
        if (propertiesLogJson != null && !propertiesLogJson.isEmpty()) {
            this.recoveryProperties(dataJson, propertiesLogJson);
        }
        if ((relationsLogJson = (JSONArray)JSONPath.eval((Object)logJson, (String)"$['relations']")) != null && !relationsLogJson.isEmpty()) {
            this.recoveryRelations(dataJson, relationsLogJson);
        }
        JSONArray itemsLogJsons = (JSONArray)JSONPath.eval((Object)logJson, (String)"$['items']");
        for (int index = 0; itemsLogJsons != null && index < itemsLogJsons.size(); ++index) {
            JSONObject itemsLogJson = itemsLogJsons.getJSONObject(index);
            String propertyName = itemsLogJson.getString("propertyName");
            JSONArray itemLogs = itemsLogJson.getJSONArray("datas");
            JSONArray dataArrays = dataJson.getJSONArray(propertyName);
            if (dataArrays == null) {
                dataArrays = new JSONArray();
            }
            JSONArray results = this.recoveryItems(propertyName, dataArrays, itemLogs);
            dataJson.put(propertyName, (Object)results);
        }
        JSONArray groupsLogJsons = (JSONArray)JSONPath.eval((Object)logJson, (String)"$['groups']");
        for (int index = 0; groupsLogJsons != null && index < groupsLogJsons.size(); ++index) {
            JSONObject groupsLogJson = groupsLogJsons.getJSONObject(index);
            String propertyName = groupsLogJson.getString("propertyName");
            JSONObject propertyDataJson = dataJson.getJSONObject(propertyName);
            Validate.notNull((Object)propertyDataJson, (String)"\u5728\u6570\u636e\u6062\u590d\u65f6\uff0c\u672a\u53d1\u73b0\u5206\u7ec4[%s]\u7684\u539f\u59cb\u6570\u636e\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{propertyName});
            this.recoveryByStep(propertyDataJson, groupsLogJson);
        }
    }

    private JSONArray recoveryItems(String propertyName, JSONArray datas, JSONArray itemLogs) {
        if (itemLogs == null || itemLogs.isEmpty()) {
            return datas;
        }
        JSONArray deleteOpLogs = (JSONArray)JSONPath.eval((Object)itemLogs, (String)"$[?(@.changeType = 'NEW')]");
        if (deleteOpLogs != null && !deleteOpLogs.isEmpty()) {
            Validate.isTrue((datas != null && !datas.isEmpty() ? 1 : 0) != 0, (String)"\u5728\u6062\u590d\u64cd\u4f5c\u65f6\uff0c\u53d1\u73b0\u6570\u636e\u4e2d\u7684\u660e\u7ec6\u7f16\u8f91\u9879[%s]\u539f\u59cb\u6570\u636e\u548c\u64cd\u4f5c\u65e5\u5fd7\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{propertyName});
        }
        block0: for (int index = 0; deleteOpLogs != null && index < deleteOpLogs.size(); ++index) {
            JSONObject deleteOpLog = deleteOpLogs.getJSONObject(index);
            String idLog = deleteOpLog.getString("id");
            for (int itemIndex = 0; itemIndex < datas.size(); ++itemIndex) {
                JSONObject itemData = datas.getJSONObject(itemIndex);
                String currentId = itemData.getString("id");
                Validate.notBlank((CharSequence)currentId, (String)"\u5728\u6062\u590d\u64cd\u4f5c\u65f6\uff0c\u660e\u7ec6\u7f16\u8f91\u9879[%s]\u539f\u59cb\u6570\u636e[%s]\u672a\u627e\u5230\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{propertyName, idLog});
                if (!StringUtils.equals((CharSequence)idLog, (CharSequence)currentId)) continue;
                datas.remove(itemIndex);
                continue block0;
            }
        }
        JSONArray newOpLogs = (JSONArray)JSONPath.eval((Object)itemLogs, (String)"$[?(@.changeType = 'DELETE')]");
        for (int index = 0; newOpLogs != null && index < newOpLogs.size(); ++index) {
            JSONArray relationsLogs;
            JSONObject newOpLog = newOpLogs.getJSONObject(index);
            JSONObject newData = new JSONObject();
            JSONArray propertiesLogs = (JSONArray)JSONPath.eval((Object)newOpLog, (String)"$['properties']");
            if (propertiesLogs != null && !propertiesLogs.isEmpty()) {
                this.recoveryProperties(newData, propertiesLogs);
            }
            if ((relationsLogs = (JSONArray)JSONPath.eval((Object)newOpLog, (String)"$['relations']")) != null && !relationsLogs.isEmpty()) {
                this.recoveryRelations(newData, relationsLogs);
            }
            datas.add((Object)newData);
        }
        JSONArray updateOpLogs = (JSONArray)JSONPath.eval((Object)itemLogs, (String)"$[?(@.changeType = 'UPDATE')]");
        block3: for (int index = 0; updateOpLogs != null && index < updateOpLogs.size(); ++index) {
            JSONObject updateOpLog = updateOpLogs.getJSONObject(index);
            String idLog = updateOpLog.getString("id");
            for (int itemIndex = 0; itemIndex < datas.size(); ++itemIndex) {
                JSONArray relationsLogs;
                JSONObject itemData = datas.getJSONObject(itemIndex);
                String currentId = itemData.getString("id");
                Validate.notBlank((CharSequence)currentId, (String)"\u5728\u6062\u590d\u64cd\u4f5c\u65f6\uff0c\u660e\u7ec6\u7f16\u8f91\u9879[%s]\u539f\u59cb\u6570\u636e[%s]\u672a\u627e\u5230\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{propertyName, idLog});
                if (!StringUtils.equals((CharSequence)idLog, (CharSequence)currentId)) continue;
                JSONArray propertiesLogs = (JSONArray)JSONPath.eval((Object)updateOpLog, (String)"$['properties']");
                if (propertiesLogs != null && !propertiesLogs.isEmpty()) {
                    this.recoveryProperties(itemData, propertiesLogs);
                }
                if ((relationsLogs = (JSONArray)JSONPath.eval((Object)updateOpLog, (String)"$['relations']")) == null || relationsLogs.isEmpty()) continue block3;
                this.recoveryRelations(itemData, relationsLogs);
                continue block3;
            }
        }
        return datas;
    }

    private void recoveryProperties(JSONObject dataJson, JSONArray propertiesLogJson) {
        for (int index = 0; propertiesLogJson != null && index < propertiesLogJson.size(); ++index) {
            JSONObject propertyLogJson = propertiesLogJson.getJSONObject(index);
            Object beforeValue = propertyLogJson.get((Object)"beforeValue");
            String propertyName = propertyLogJson.getString("propertyName");
            if (beforeValue == null) {
                dataJson.put(propertyName, null);
                continue;
            }
            dataJson.put(propertyName, beforeValue);
        }
    }

    private void recoveryRelations(JSONObject dataJson, JSONArray relationsLogJson) {
        for (int index = 0; relationsLogJson != null && index < relationsLogJson.size(); ++index) {
            JSONObject relationLogJsonItem = relationsLogJson.getJSONObject(index);
            Object beforeValue = relationLogJsonItem.get((Object)"beforeValue");
            String propertyName = relationLogJsonItem.getString("propertyName");
            if (beforeValue instanceof JSONArray) {
                JSONArray beforeValues = (JSONArray)beforeValue;
                JSONArray manyToMany = new JSONArray();
                for (int itemIndex = 0; itemIndex < beforeValues.size(); ++itemIndex) {
                    JSONObject idObject = new JSONObject();
                    idObject.put("id", beforeValues.get(itemIndex));
                    manyToMany.add((Object)idObject);
                }
                dataJson.put(propertyName, (Object)manyToMany);
                continue;
            }
            JSONObject manyToOne = new JSONObject();
            manyToOne.put("id", beforeValue);
            dataJson.put(propertyName, (Object)manyToOne);
        }
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void validateRecoveryByInstanceActivityId(String targetInstanceActivityId) throws Exception {
        this.recoveryByInstanceActivityId(targetInstanceActivityId);
        throw new Exception();
    }

    @Override
    @Transactional
    public JSONObject recoveryByInstanceActivityId(String targetInstanceActivityId) {
        Validate.notBlank((CharSequence)targetInstanceActivityId, (String)"\u8fdb\u884c\u6279\u91cf\u6570\u636e\u6062\u590d\u65f6\uff0c\u8bf7\u6307\u5b9a\u76ee\u6807\u6d3b\u52a8\u7f16\u53f7!!", (Object[])new Object[0]);
        InstanceActivityEntity currentInstanceActivity = this.instanceActivityService.findById(targetInstanceActivityId);
        Validate.notNull((Object)currentInstanceActivity, (String)"\u5f53\u524d\u6307\u5b9a\u7684\u76ee\u6807\u6d3b\u52a8\u672a\u627e\u5230\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        InstanceEntity currentInstance = currentInstanceActivity.getInstance();
        String currentInstanceId = currentInstance.getId();
        TemplateEntity template = currentInstance.getTemplate();
        String type = template.getType();
        Validate.isTrue((StringUtils.equals((CharSequence)type, (CharSequence)"static") || StringUtils.equals((CharSequence)type, (CharSequence)"dynamic") ? 1 : 0) != 0, (String)"\u76ee\u524d\u6279\u91cf\u6570\u636e\u6062\u590d\u529f\u80fd\u4ec5\u652f\u6301\u9759\u6001/\u52a8\u6001\u6a21\u578b\uff0c\u8bf7\u68c0\u67e5\u5f53\u524d\u8868\u5355\u5b9e\u4f8b\u7684\u6a21\u677f\u7c7b\u578b!!", (Object[])new Object[0]);
        if (StringUtils.equals((CharSequence)type, (CharSequence)"static")) {
            return this.recoveryByStaticInstanceActivityId(template, currentInstanceId, targetInstanceActivityId);
        }
        if (StringUtils.equals((CharSequence)type, (CharSequence)"dynamic")) {
            return this.recoveryByDynamicInstanceActivityId(template, currentInstanceId, targetInstanceActivityId);
        }
        throw new IllegalFormatFlagsException("\u76ee\u524d\u6570\u636e\u6062\u590d\u529f\u80fd\u53ea\u652f\u6301\u9759\u6001/\u52a8\u6001\u8868\u5355\u5b9e\u4f8b\uff0c\u8bf7\u786e\u8ba4!!");
    }

    private JSONObject recoveryByStaticInstanceActivityId(TemplateEntity template, String currentInstanceId, String targetInstanceActivityId) {
        String persistentClassName = template.getPersistentClassName();
        Validate.notBlank((CharSequence)persistentClassName, (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u9759\u6001\u6a21\u578b\u7c7b\u540d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Set<InstanceActivityEntity> instanceActivities = this.instanceActivityService.findByInstanceId(currentInstanceId);
        Validate.isTrue((instanceActivities != null && !instanceActivities.isEmpty() ? 1 : 0) != 0, (String)"\u672a\u5728\u6307\u5b9a\u5b9e\u4f8b\u4e0b\u627e\u5230\u4efb\u4f55\u6d3b\u52a8\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String templateId = template.getId();
        List<InstanceActivityLogEntity> recoveryLogs = this.analysisActivityLogs(currentInstanceId, instanceActivities, targetInstanceActivityId);
        Class<?> returnType = null;
        Object details = null;
        String interfaceName = null;
        String queryMethodName = null;
        String updateMethodName = null;
        Validate.notNull(recoveryLogs, (String)"\u6ca1\u6709\u53d1\u73b0\u4efb\u4f55\u5f85\u6062\u590d\u7684\u65e5\u5fd7\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u4e0a\u62a5bug!!", (Object[])new Object[0]);
        template = this.templateService.findDetailsById(templateId);
        Validate.notNull((Object)template, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u9759\u6001\u6a21\u677f\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{templateId});
        JSONObject resouceJSONObject = null;
        JSONObject targetSONObject = new JSONObject();
        for (int index = 0; index < recoveryLogs.size(); ++index) {
            InstanceActivityLogEntity currentLog = recoveryLogs.get(index);
            String currentLogId = currentLog.getId();
            if (index == 0) {
                String queryDetailsService = currentLog.getQueryDetailsService();
                String updateDetailsService = currentLog.getUpdateDetailsService();
                ServicableMethodEntity servicableMethod = this.servicableMethodService.findByName(queryDetailsService);
                Validate.notNull((Object)servicableMethod, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u670d\u52a1\u65b9\u6cd5\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
                interfaceName = servicableMethod.getInterfaceName();
                try {
                    queryMethodName = queryDetailsService.split("\\.")[1];
                    updateMethodName = updateDetailsService.split("\\.")[1];
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    throw new IllegalArgumentException("\u9519\u8bef\u7684\u670d\u52a1\u540d\uff0c\u8bf7\u68c0\u67e5\u670d\u52a1\u6e90\u914d\u7f6e!!");
                }
                details = this.invokeQueryDetails(interfaceName, queryMethodName, currentInstanceId);
                Validate.notNull((Object)details, (String)"\u672a\u627e\u5230\u5f53\u524d\u8868\u5355\u5b9e\u4f8b\u7684\u4efb\u4f55\u8be6\u7ec6\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u670d\u52a1\u6e90\u63a5\u53e3!!", (Object[])new Object[0]);
                returnType = details.getClass();
                Validate.notNull((Object)details, (String)"\u6839\u636e\u670d\u52a1\u65b9\u6cd5[%s.%s]\uff0c\u672a\u67e5\u8be2\u5230\u4efb\u52a1\u4e1a\u52a1\u6570\u636e\u660e\u7ec6\uff08\u57fa\u4e8e\u8868\u5355\u5b9e\u4f8b[%s]\uff09\uff0c\u8bf7\u68c0\u67e5\u8bbe\u5b9a!!", (Object[])new Object[]{interfaceName, queryMethodName, currentInstanceId});
                Set<String> wWhiteLists = this.kuiperToolkitService.buildAllWhiteList(template);
                String[] propertiesFilter = wWhiteLists.toArray(new String[0]);
                Object resouceObject = this.kuiperToolkitService.copyObjectByWhiteList(details, returnType, LinkedHashSet.class, ArrayList.class, propertiesFilter);
                resouceJSONObject = (JSONObject)JSON.toJSON((Object)resouceObject);
                targetSONObject = (JSONObject)JSON.toJSON((Object)resouceObject);
            }
            JSONObject logJSONData = this.findContentById(currentLogId);
            Validate.notNull((Object)logJSONData, (String)"\u672a\u627e\u5230\u53d8\u5316\u65e5\u5fd7\u5185\u5bb9\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u7cfb\u7edf!!", (Object[])new Object[0]);
            this.recoveryByStep(targetSONObject, logJSONData);
        }
        this.defineDiff(template, resouceJSONObject, targetSONObject);
        if (StringUtils.equals((CharSequence)template.getType(), (CharSequence)"static")) {
            this.invokeRecoveryStaticService(persistentClassName, template, targetSONObject, interfaceName, updateMethodName);
        } else if (StringUtils.equals((CharSequence)template.getType(), (CharSequence)"dynamic")) {
            this.invokeRecoveryDynamicService(template, currentInstanceId, targetSONObject);
        } else {
            throw new IllegalFormatFlagsException("\u6570\u636e\u6279\u91cf\u6062\u590d\u529f\u80fd\u76ee\u524d\u53ea\u652f\u6301\u9759\u6001\u6a21\u677f\u548c\u52a8\u6001\u6a21\u677f\u7c7b\u578b\u7684\u8868\u5355");
        }
        for (InstanceActivityLogEntity recoveryLog : recoveryLogs) {
            this.instanceActivityLogRepository.deleteById(recoveryLog.getId());
        }
        return targetSONObject;
    }

    private JSONObject recoveryByDynamicInstanceActivityId(TemplateEntity template, String currentInstanceId, String targetInstanceActivityId) {
        Set<InstanceActivityEntity> instanceActivities = this.instanceActivityService.findByInstanceId(currentInstanceId);
        Validate.isTrue((instanceActivities != null && !instanceActivities.isEmpty() ? 1 : 0) != 0, (String)"\u672a\u5728\u6307\u5b9a\u5b9e\u4f8b\u4e0b\u627e\u5230\u4efb\u4f55\u6d3b\u52a8\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String templateId = template.getId();
        List<InstanceActivityLogEntity> recoveryLogs = this.analysisActivityLogs(currentInstanceId, instanceActivities, targetInstanceActivityId);
        Validate.notNull(recoveryLogs, (String)"\u6ca1\u6709\u53d1\u73b0\u4efb\u4f55\u5f85\u6062\u590d\u7684\u65e5\u5fd7\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u4e0a\u62a5bug!!", (Object[])new Object[0]);
        template = this.templateService.findDetailsById(templateId);
        Validate.notNull((Object)template, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u9759\u6001\u6a21\u677f\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{templateId});
        JSONObject resouceJSONObject = null;
        JSONObject targetSONObject = new JSONObject();
        for (int index = 0; index < recoveryLogs.size(); ++index) {
            InstanceActivityLogEntity currentLog = recoveryLogs.get(index);
            String currentLogId = currentLog.getId();
            if (index == 0) {
                resouceJSONObject = this.dynamicInstanceService.findDetailsByFormInstanceId(currentInstanceId);
                Validate.notNull((Object)resouceJSONObject, (String)"\u672a\u627e\u5230\u5f53\u524d\u8868\u5355\u5b9e\u4f8b\u7684\u4efb\u4f55\u8be6\u7ec6\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u670d\u52a1\u6e90\u63a5\u53e3!!", (Object[])new Object[0]);
                String jsonConent = resouceJSONObject.toJSONString();
                targetSONObject = JSON.parseObject((String)jsonConent);
            }
            JSONObject logJSONData = this.findContentById(currentLogId);
            Validate.notNull((Object)logJSONData, (String)"\u672a\u627e\u5230\u53d8\u5316\u65e5\u5fd7\u5185\u5bb9\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u7cfb\u7edf!!", (Object[])new Object[0]);
            this.recoveryByStep(targetSONObject, logJSONData);
        }
        this.defineDiff(template, resouceJSONObject, targetSONObject);
        this.invokeRecoveryDynamicService(template, currentInstanceId, targetSONObject);
        for (InstanceActivityLogEntity recoveryLog : recoveryLogs) {
            this.instanceActivityLogRepository.deleteById(recoveryLog.getId());
        }
        return targetSONObject;
    }

    private List<InstanceActivityLogEntity> analysisActivityLogs(String currentInstanceId, Set<InstanceActivityEntity> instanceActivities, String targetInstanceActivityId) {
        Iterator<InstanceActivityEntity> instanceActivityIterator = instanceActivities.iterator();
        String currnetTargetInstanceActivityId = targetInstanceActivityId;
        while (instanceActivityIterator.hasNext()) {
            Set<InstanceActivityLogEntity> set;
            InstanceActivityEntity instanceActivityItem = instanceActivityIterator.next();
            String instanceActivityItemId = instanceActivityItem.getId();
            if (!StringUtils.equals((CharSequence)instanceActivityItemId, (CharSequence)targetInstanceActivityId)) continue;
            while ((set = this.instanceActivityLogRepository.findByInstanceActivity(currnetTargetInstanceActivityId)) == null || set.isEmpty()) {
                if ((set == null || set.isEmpty()) && instanceActivityIterator.hasNext()) {
                    currnetTargetInstanceActivityId = instanceActivityIterator.next().getId();
                    continue;
                }
                if (set != null && !set.isEmpty() || instanceActivityIterator.hasNext()) continue;
                throw new IllegalArgumentException("\u672a\u627e\u5230\u4efb\u4f55\u53ef\u7528\u7684\u76ee\u6807\u6d3b\u52a8\u65e5\u5fd7\uff0c\u56e0\u4e3a\u6307\u5b9a\u7684\u6570\u636e\u6062\u590d\u70b9\u5df2\u7ecf\u6ca1\u6709\u4efb\u4f55\u6d3b\u52a8\u65e5\u5fd7\uff0c\u4e0d\u80fd\u518d\u8fdb\u884c\u56de\u9000\u4e86!!");
            }
            break block0;
        }
        LinkedList<String> recoveryActivityIds = new LinkedList<String>();
        for (InstanceActivityEntity instanceActivityEntity : instanceActivities) {
            String instanceActivityItemId = instanceActivityEntity.getId();
            recoveryActivityIds.add(instanceActivityItemId);
            if (!StringUtils.equals((CharSequence)instanceActivityItemId, (CharSequence)currnetTargetInstanceActivityId)) continue;
            break;
        }
        HashMap<String, Collection> recoveryActivityLogMapping = new HashMap<String, Collection>();
        for (String recoveryActivityId : recoveryActivityIds) {
            Set<InstanceActivityLogEntity> logs = this.instanceActivityLogRepository.findByInstanceActivity(recoveryActivityId);
            if (logs == null || logs.isEmpty()) continue;
            Collection logIds = logs.stream().map(UuidEntity::getId).collect(Collectors.toList());
            recoveryActivityLogMapping.put(recoveryActivityId, logIds);
        }
        Validate.isTrue((!recoveryActivityLogMapping.isEmpty() ? 1 : 0) != 0, (String)"\u672a\u53d1\u73b0\u6062\u590d\u7684\u76ee\u6807\u6d3b\u52a8\u4e0b\u6709\u4efb\u4f55\u64cd\u4f5c\u65e5\u5fd7\uff0c\u4e0d\u5141\u8bb8\u6062\u590d!!", (Object[])new Object[0]);
        Validate.isTrue((recoveryActivityLogMapping.size() > 1 ? 1 : 0) != 0, (String)"\u6279\u91cf\u6062\u590d\u5fc5\u987b\u8de8\u8d8a\u81f3\u5c11\u4e24\u4e2a\u6d3b\u52a8\uff0c\u5982\u679c\u662f\u5728\u540c\u4e00\u6d3b\u52a8\u5185\u8fdb\u884c\u6062\u590d\uff0c\u8bf7\u4f7f\u7528\u5355\u6b65\u6062\u590d", (Object[])new Object[0]);
        Set<InstanceActivityLogEntity> set = this.instanceActivityLogRepository.findByInstanceId(currentInstanceId);
        LinkedList<InstanceActivityLogEntity> recoveryLogs = new LinkedList<InstanceActivityLogEntity>();
        Validate.isTrue((set != null && set.size() > 1 ? 1 : 0) != 0, (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u8868\u5355\u5b9e\u4f8b\u6709\u4efb\u4f55\u6570\u636e\u53d8\u5316\u5386\u53f2\uff0c\u6216\u8005\u4ec5\u6709\u4e00\u6761\u6570\u636e\u53d8\u5316\u5386\u53f2\uff0c\u4e0d\u80fd\u8fdb\u884c\u6570\u636e\u6062\u590d\u64cd\u4f5c!!", (Object[])new Object[0]);
        String endActivityLogId = null;
        for (InstanceActivityLogEntity logItem : set) {
            String logItemId = logItem.getId();
            String logActivityId = logItem.getInstanceActivity().getId();
            if (StringUtils.equals((CharSequence)logActivityId, (CharSequence)targetInstanceActivityId) && recoveryActivityLogMapping.size() == 1) {
                endActivityLogId = logItemId;
                break;
            }
            recoveryLogs.add(logItem);
            Collection logActivityLogIds = (Collection)recoveryActivityLogMapping.get(logActivityId);
            if (logActivityLogIds != null) {
                logActivityLogIds.remove(logItemId);
                if (logActivityLogIds.isEmpty()) {
                    recoveryActivityLogMapping.remove(logActivityId);
                }
            }
            Validate.isTrue((!recoveryActivityLogMapping.isEmpty() ? 1 : 0) != 0, (String)"\u9519\u8bef\u7684\u7b97\u6cd5\u8fc7\u7a0b\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!!", (Object[])new Object[0]);
        }
        Validate.notNull(endActivityLogId, (String)"\u9519\u8bef\u7684\u7b97\u6cd5\u8fc7\u7a0b\uff0c\u672a\u627e\u5230\u7ec8\u6b62\u65e5\u5fd7\u70b9\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!!", (Object[])new Object[0]);
        return recoveryLogs;
    }
}

