/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.instances.handle;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.annotations.NebulaServiceMethod;
import com.bizunited.platform.core.entity.ServicableMethodEntity;
import com.bizunited.platform.core.service.invoke.HandleChain;
import com.bizunited.platform.core.service.invoke.InvokeProxyContext;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.invoke.InvokeRequestHandle;
import com.bizunited.platform.core.service.invoke.InvokeResponseHandle;
import com.bizunited.platform.core.service.serviceable.ServicableMethodService;
import com.bizunited.platform.core.service.serviceable.model.InputParamsModel;
import com.bizunited.platform.kuiper.entity.InstanceEntity;
import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.service.InstanceService;
import com.bizunited.platform.kuiper.service.TemplateService;
import com.bizunited.platform.kuiper.starter.service.KuiperToolkitService;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;

public class StaticFormDetailsRecordHandle
implements InvokeRequestHandle,
InvokeResponseHandle {
    private static final Logger LOGGER = LoggerFactory.getLogger(StaticFormDetailsRecordHandle.class);
    private static final String BEFORE_DETAILS = "_beforeDetails";
    private static final String AFTER_DETAILS = "_afterDetails";
    @Autowired
    @Qualifier(value="KuiperToolkitService")
    private KuiperToolkitService kuiperToolkitService;
    @Autowired
    private InstanceService instanceService;
    @Autowired
    private TemplateService templateService;
    @Autowired
    private ServicableMethodService servicableMethodService;
    @Autowired
    private ApplicationContext applicationContext;
    private boolean isbefore = false;

    public void doHandle(InvokeProxyContext context, HandleChain chain) throws InvokeProxyException {
        if (context.isException()) {
            return;
        }
        InputParamsModel inputParams = (InputParamsModel)context.getChainParam(InputParamsModel.class.getName());
        String serviceName = inputParams.getServiceName();
        ServicableMethodEntity methodInfo = this.servicableMethodService.findByName(serviceName);
        Validate.notNull((Object)methodInfo, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u65b9\u6cd5\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        if (StringUtils.equals((CharSequence)methodInfo.getUsedScope(), (CharSequence)NebulaServiceMethod.ScopeType.READ.name())) {
            return;
        }
        try {
            this.invoke(context, methodInfo);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        chain.doHandle(context, HandleChain.ChainLogic.CONTINUE);
    }

    private void invoke(InvokeProxyContext context, ServicableMethodEntity methodInfo) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> iocBeanClass;
        InputParamsModel model = (InputParamsModel)context.getChainParam(InputParamsModel.class.getName());
        JSONObject modelJson = model.getFormData();
        Validate.notNull((Object)modelJson, (String)"\u672a\u83b7\u53d6\u5230\u63d0\u4ea4\u7684\u8868\u5355\u6570\u636e\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String instanceId = modelJson.getString("formInstanceId");
        Validate.notBlank((CharSequence)instanceId, (String)"\u672a\u83b7\u53d6\u5230\u8868\u5355\u7684\u5b9e\u4f8bID\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String recordQuery = methodInfo.getRecordQuery();
        String methodName = StringUtils.substringAfterLast((String)recordQuery, (String)".");
        String interfaceName = methodInfo.getInterfaceName();
        try {
            iocBeanClass = context.getClassLoader().loadClass(interfaceName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        Object iocBean = this.applicationContext.getBean(iocBeanClass);
        Validate.notNull((Object)iocBean, (String)"\u672a\u5728spring ioc\u5bb9\u5668\u4e2d\u53d1\u73b0\u6307\u5b9a\u7684bean\u5b9a\u4e49!!", (Object[])new Object[0]);
        Method method = iocBeanClass.getMethod(methodName, String.class);
        Object result = method.invoke(iocBean, instanceId);
        JSONObject resultJson = new JSONObject();
        Validate.isTrue((result != null || StringUtils.contains((CharSequence)methodInfo.getName(), (CharSequence)".create") ? 1 : 0) != 0, (String)"\u66f4\u65b0\u4fdd\u5b58\u65f6\uff0c\u6839\u636e\u5b9e\u4f8b%s\u672a\u80fd\u83b7\u53d6\u5230\u4efb\u4f55\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{instanceId});
        if (result != null) {
            InstanceEntity instanceEntity = this.instanceService.findDetailsById(instanceId);
            TemplateEntity template = instanceEntity.getTemplate();
            String templateId = template.getId();
            template = this.templateService.findDetailsById(templateId);
            Set<String> whiteList = this.kuiperToolkitService.buildAllWhiteList(template);
            LOGGER.debug("\u767d\u540d\u5355\u8fc7\u6ee4\u6e05\u5355\uff1a{}", whiteList);
            Object transData = this.kuiperToolkitService.copyObjectByWhiteList(result, result.getClass(), LinkedHashSet.class, ArrayList.class, whiteList.toArray(new String[whiteList.size()]));
            resultJson = JSON.parseObject((String)JSON.toJSONString((Object)transData));
        }
        if (this.isbefore) {
            LOGGER.debug("\u524d\u7f6e\u6570\u636e\uff1a{}", (Object)resultJson);
            context.setChainParam(BEFORE_DETAILS, (Object)resultJson);
        } else {
            LOGGER.debug("\u540e\u7f6e\u6570\u636e\uff1a{}", (Object)resultJson);
            context.setChainParam(AFTER_DETAILS, (Object)resultJson);
        }
    }

    public boolean handleException(InvokeProxyContext context) {
        return false;
    }

    public void setbefore(boolean isbefore) {
        this.isbefore = isbefore;
    }
}

