/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.configuration;

import com.bizunited.platform.core.service.invoke.InvokeProxy;
import com.bizunited.platform.core.service.invoke.InvokeRequestHandle;
import com.bizunited.platform.core.service.invoke.InvokeResponseHandle;
import com.bizunited.platform.core.service.invoke.handle.request.PrincipalHandle;
import com.bizunited.platform.core.service.invoke.handle.request.TransactionalHandle;
import com.bizunited.platform.core.service.serviceable.handle.SpringMVCResponseHandle;
import com.bizunited.platform.kuiper.starter.service.instances.handle.DynamicFormDetailsRecordHandle;
import com.bizunited.platform.kuiper.starter.service.instances.handle.DynamicFormSaveHandle;
import com.bizunited.platform.kuiper.starter.service.instances.handle.DynamicInstanceActivityUpdateHandle;
import com.bizunited.platform.kuiper.starter.service.instances.handle.DynamicInstanceDetailsLogUpdateHandle;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
public class DynamicFormProxyConfig {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private PrincipalHandle principalHandle;
    @Autowired
    private TransactionalHandle transactionalHandle;
    @Autowired
    private SpringMVCResponseHandle springMVCResponseHandle;
    @Autowired
    private DynamicInstanceActivityUpdateHandle dynamicInstanceActivityUpdateHandle;
    @Autowired
    private DynamicInstanceDetailsLogUpdateHandle dynamicInstanceDetailsLogUpdateHandle;
    @Autowired
    private DynamicFormSaveHandle dynamicFormSaveHandle;

    @Bean(value={"DynamicFormWriteProxy"})
    @Scope(value="prototype")
    @ConditionalOnMissingBean(name={"DynamicFormWriteProxy"})
    public InvokeProxy getDynamicFormWriteProxy() {
        InvokeProxy.Build build = new InvokeProxy.Build();
        build.addClassLoader(this.applicationContext.getClassLoader());
        build.addInvokeRequestFilter(new InvokeRequestHandle[]{this.principalHandle, this.transactionalHandle, this.getBeforeDynamicFormDetailsRecordHandle(), this.dynamicFormSaveHandle});
        build.addInvokeResponseFilter(new InvokeResponseHandle[]{this.getAfterDynamicFormDetailsRecordHandle(), this.dynamicInstanceDetailsLogUpdateHandle, this.dynamicInstanceActivityUpdateHandle, this.springMVCResponseHandle});
        return build.build();
    }

    @Bean(value={"BeforeDynamicFormDetailsRecordHandle"})
    public DynamicFormDetailsRecordHandle getBeforeDynamicFormDetailsRecordHandle() {
        DynamicFormDetailsRecordHandle formDetailsRecordHandle = new DynamicFormDetailsRecordHandle();
        formDetailsRecordHandle.setbefore(true);
        return formDetailsRecordHandle;
    }

    @Bean(value={"AfterDynamicFormDetailsRecordHandle"})
    public DynamicFormDetailsRecordHandle getAfterDynamicFormDetailsRecordHandle() {
        DynamicFormDetailsRecordHandle formDetailsRecordHandle = new DynamicFormDetailsRecordHandle();
        formDetailsRecordHandle.setbefore(false);
        return formDetailsRecordHandle;
    }
}

