/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.controller;

import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.kuiper.entity.DataSourceTableEntity;
import com.bizunited.platform.kuiper.starter.service.DataSourceTableService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/kuiper/dataSourceTables"})
public class DataSourceTableController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSourceTableController.class);
    @Autowired
    private DataSourceTableService dataSourceTableService;

    @PatchMapping(value={""})
    @ApiOperation(value="\u66f4\u65b0\u6570\u636e\u8868", notes="\u66f4\u65b0\u6570\u636e\u8868\uff0c\u66f4\u65b0\u5b57\u65ad\u4e0d\u80fd\u5168\u90e8\u4e3a\u7a7a")
    public ResponseModel update(@RequestBody @ApiParam(value="\u66f4\u65b0\u5b9e\u4f53") DataSourceTableEntity dataSourceTable) {
        try {
            DataSourceTableEntity table = this.dataSourceTableService.update(dataSourceTable);
            return this.buildHttpResultW(table, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"/findByConditions"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6570\u636e\u8868", notes="dataSourceId\u4e3a\u7a7a\u5219\u9ed8\u8ba4\u4e3a\u4e3b\u6570\u636e\u6e90,\u9875\u6570\u53c2\u6570\u4e3apage\uff0c\u7b2c\u4e00\u9875\u4ece0\u5f00\u59cb\uff0c\u5206\u9875\u5927\u5c0f\u53c2\u6570\u4e3asize\uff08size\u9ed8\u8ba4\u4e3a50\uff09")
    public ResponseModel findByConditions(@PageableDefault(value=50) Pageable pageable, @RequestParam(name="tableType", required=false) @ApiParam(name="tableType", value="\u6570\u636e\u8868\u6027\u8d28(0:\u975e\u4e1a\u52a1\u8868, 1:\u4e1a\u52a1\u8868)") Integer tableType, @RequestParam(name="dataSourceId", required=false) @ApiParam(name="dataSourceId", value="\u6570\u636e\u6e90ID") String dataSourceId, @RequestParam(name="status", required=false) @ApiParam(name="status", value="\u6570\u636e\u8868\u72b6\u6001(0:\u7981\u7528\uff0c1:\u542f\u7528)") Integer status, @RequestParam(name="tableName", required=false) @ApiParam(name="tableName", value="\u6570\u636e\u8868\u540d") String tableName) {
        try {
            Page<DataSourceTableEntity> page = this.dataSourceTableService.findByConditions(pageable, tableType, dataSourceId, status, tableName);
            return this.buildHttpResultW((Iterable)page, new String[]{"dataSource"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"/reload"})
    @ApiOperation(value="\u91cd\u65b0\u52a0\u8f7d\u6570\u636e\u8868", notes="\u91cd\u65b0\u52a0\u8f7d\u6240\u6709\u6570\u636e\u6e90\u7684\u6570\u636e\u8868")
    public ResponseModel reloadTables() {
        try {
            this.dataSourceTableService.refresh();
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

