/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.controller;

import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.kuiper.entity.TemplateStyleEntity;
import com.bizunited.platform.kuiper.starter.service.TemplateStyleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(value="TemplateStyleController")
@RestController
@RequestMapping(value={"/v1/kuiper/templateStyles"})
public class TemplateStyleController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplateStyleController.class);
    @Autowired
    private TemplateStyleService templateStyleService;

    @ApiOperation(value="\u67e5\u8be2\u76ee\u524d\u7cfb\u7edf\u4e2d\u6240\u6709\u5b9a\u4e49\u7684\u6837\u5f0f\u4fe1\u606f\uff0c\u65e0\u8bba\u6837\u5f0f\u4fe1\u606f\u5904\u4e8e\u4ec0\u4e48\u72b6\u6001\u3002\u5e76\u6309\u7167\u521b\u5efa\u65f6\u95f4\u8fdb\u884c\u5012\u5e8f\u6392\u5217")
    @RequestMapping(value={"/findAll"}, method={RequestMethod.GET})
    public ResponseModel findAll() {
        try {
            List<TemplateStyleEntity> results = this.templateStyleService.findAll();
            return this.buildHttpResultW(results, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u6307\u5b9a\u7684\u72b6\u6001\u6761\u4ef6\uff0c\u67e5\u8be2\u7b26\u5408\u72b6\u6001\u7684\u6837\u5f0f\u4fe1\u606f")
    @RequestMapping(value={"/findByTstatus"}, method={RequestMethod.GET})
    public ResponseModel findByTstatus(@ApiParam(name="tstatus", value="1\uff1a\u72b6\u6001\u6b63\u786e\uff1b0\uff1a\u72b6\u6001\u5f02\u5e38") @RequestParam(value="tstatus") Integer tstatus) {
        try {
            List<TemplateStyleEntity> results = this.templateStyleService.findByTstatus(tstatus);
            return this.buildHttpResultW(results, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u76ee\u524d\u7cfb\u7edf\u4e2d\uff0c\u6307\u5b9a\u6837\u5f0f\u6570\u636e\u7f16\u53f7\u7684\u6837\u5f0f\u57fa\u672c\u4fe1\u606f")
    @RequestMapping(value={"/findDetailsById"}, method={RequestMethod.GET})
    public ResponseModel findDetailsById(@ApiParam(name="id", value="\u6307\u5b9a\u7684\u6837\u5f0f\u7f16\u53f7\u4fe1\u606f") @RequestParam(value="id") String id) {
        try {
            TemplateStyleEntity results = this.templateStyleService.findDetailsById(id);
            return this.buildHttpResultW(results, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u76ee\u524d\u7cfb\u7edf\u4e2d\uff0c\u6307\u5b9a\u6837\u5f0f\u4e1a\u52a1\u7f16\u53f7\uff08code\uff09\u7684\u6837\u5f0f\u57fa\u672c\u4fe1\u606f")
    @RequestMapping(value={"/findDetailsByCode"}, method={RequestMethod.GET})
    public ResponseModel findDetailsByCode(@ApiParam(name="code", value="\u6307\u5b9a\u7684\u6837\u5f0f\u4e1a\u52a1\u7f16\u53f7\u4fe1\u606f") @RequestParam(value="code") String code) {
        try {
            TemplateStyleEntity results = this.templateStyleService.findDetailsByCode(code);
            return this.buildHttpResultW(results, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u6307\u5b9a\u7684\u8868\u5355\u6837\u5f0f\u4e1a\u52a1\u7f16\u53f7\uff08code\uff09\uff0c\u67e5\u8be2\u6307\u5b9a\u7684\u6837\u5f0f\u6587\u4ef6\u5185\u5bb9\u4fe1\u606f", notes="\u6307\u5b9a\u7684\u6587\u4ef6\u5185\u5bb9\uff0c\u5982\u679c\u6ca1\u6709\u67e5\u8be2\u5230\u4efb\u4f55\u6587\u4ef6\u5185\u5bb9\uff0c\u5219\u8fd4\u56de\u4e00\u4e2a\u7a7a\u5185\u5bb9")
    @RequestMapping(value={"/findContentByCode"}, method={RequestMethod.GET})
    public void findContentByCode(HttpServletResponse response, @ApiParam(name="code", value="\u6307\u5b9a\u7684\u6837\u5f0f\u4e1a\u52a1\u7f16\u53f7\u4fe1\u606f") @RequestParam(value="code") String code) {
        try {
            byte[] cssBytes = this.templateStyleService.findContentByCode(code);
            if (cssBytes == null) {
                return;
            }
            this.writeResponseGif(response, cssBytes);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private void writeResponseGif(HttpServletResponse response, byte[] result) {
        response.setContentType("text/css");
        ServletOutputStream out = null;
        try {
            out = response.getOutputStream();
            out.write(result);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @ApiOperation(value="\u521b\u5efa\u4e00\u4e2a\u6a21\u677f\u6837\u5f0f\u4fe1\u606f", notes="\u521b\u5efa\u65f6\uff0c\u9700\u8981\u4f20\u5165code\u3001name\u3001systemStyle(true\uff1a\u7cfb\u7edf\u6837\u5f0f\uff1bfalse\uff1a\u975e\u7cfb\u7edf\u6837\u5f0f)\u548cfile\uff08\u6837\u5f0f\u6587\u4ef6\uff09\u4fe1\u606f")
    @RequestMapping(value={""}, method={RequestMethod.POST})
    public ResponseModel create(HttpServletRequest request, @ApiParam(required=true, name="file", value="\u53ea\u80fd\u4e0a\u4f20\u4e00\u4e2a\u6837\u5f0f\u6587\u4ef6\u4fe1\u606f\uff0c\u4e14\u53ea\u80fd\u662f\u540e\u7f00css\u3001less") @RequestParam(value="file") MultipartFile file) {
        try {
            String code = request.getParameter("code");
            String name = request.getParameter("name");
            String systemStyle = request.getParameter("systemStyle");
            Boolean currentSystemStyle = Boolean.valueOf(systemStyle);
            TemplateStyleEntity templateStyle = new TemplateStyleEntity();
            templateStyle.setCode(code);
            templateStyle.setName(name);
            Validate.notNull((Object)file, (String)"\u521b\u5efa\u6837\u5f0f\u4fe1\u606f\u65f6\uff0c\u5fc5\u987b\u4e0a\u4f20\u6587\u4ef6\u4fe1\u606f!!", (Object[])new Object[0]);
            String originalFilename = file.getOriginalFilename();
            String prefix = null;
            int prefixIndex = originalFilename.lastIndexOf(46);
            if (prefixIndex != -1) {
                prefix = originalFilename.substring(prefixIndex + 1);
                prefix = prefix.toLowerCase();
            }
            TemplateStyleEntity result = this.templateStyleService.create(templateStyle, file.getBytes(), currentSystemStyle, prefix);
            return this.buildHttpResultW(result, new String[0]);
        }
        catch (IOException | RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4fee\u6539\u6307\u5b9a\u7684\u6a21\u677f\u6837\u5f0f\u4fe1\u606f", notes="\u53ea\u6709\u4e00\u90e8\u5206\u4fe1\u606f\u53ef\u4ee5\u4fee\u6539\uff08\u53ea\u6709\u6837\u5f0f\u4e2d\u6587\u8bf4\u660e\uff0c\u6587\u4ef6\u5185\u5bb9\u4fe1\u606f\uff09\uff0c\u9664\u4e86file\u53ef\u4ee5\u6307\u5b9a\u4ee5\u5916\uff0c\u8fd8\u53ef\u4ee5\u6307\u5b9aname\u53c2\u6570\uff0c\u53e6\u5916id\u53c2\u6570\u662f\u5fc5\u987b\u4f20\u5165\u7684")
    @RequestMapping(value={""}, method={RequestMethod.PATCH})
    public ResponseModel update(HttpServletRequest request, @ApiParam(required=false, name="file", value="\u53ea\u80fd\u4e0a\u4f20\u4e00\u4e2a\u6837\u5f0f\u6587\u4ef6\u4fe1\u606f\uff0c\u4e14\u53ea\u80fd\u662f\u540e\u7f00css\u3001less") @RequestParam(name="file", required=false) MultipartFile file) {
        try {
            TemplateStyleEntity templateStyle = new TemplateStyleEntity();
            String id = request.getParameter("id");
            String name = request.getParameter("name");
            templateStyle.setId(id);
            templateStyle.setName(name);
            byte[] fileContent = null;
            String prefix = null;
            if (file != null) {
                String originalFilename = file.getOriginalFilename();
                int prefixIndex = originalFilename.lastIndexOf(46);
                if (prefixIndex != -1) {
                    prefix = originalFilename.substring(prefixIndex + 1);
                    prefix = prefix.toLowerCase();
                }
                fileContent = file.getBytes();
            }
            TemplateStyleEntity result = this.templateStyleService.update(templateStyle, fileContent, prefix);
            return this.buildHttpResultW(result, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u6307\u5b9a\u7684\u6837\u5f0f\u6570\u636e\u5c42\u7f16\u53f7\uff0c\u5bf9\u6307\u5b9a\u6837\u5f0f\u4fe1\u606f\u7684\u72b6\u6001\u8fdb\u884c\u4fee\u6539")
    @RequestMapping(value={"/updateStatusById"}, method={RequestMethod.PATCH})
    public ResponseModel updateStatusById(@ApiParam(required=true, name="id", value="\u8981\u8fdb\u884c\u4fee\u6539\u7684\u6837\u5f0f\u7f16\u53f7\u4fe1\u606f") @RequestParam(value="id") String id, @ApiParam(required=true, name="tstatus", value="\u6539\u53d8\u540e\u7684\u72b6\u6001\u4fe1\u606f\uff0ctrue\uff1a\u542f\u7528\uff1bfalse\uff1a\u7981\u7528") @RequestParam(value="tstatus") boolean tstatus) {
        try {
            this.templateStyleService.updateStatusById(id, tstatus);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

