/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.internal;

import com.bizunited.platform.core.service.file.NebulaFileService;
import com.bizunited.platform.kuiper.entity.FormInstanceUuidEntity;
import com.bizunited.platform.kuiper.entity.FromDetailsImportEntity;
import com.bizunited.platform.kuiper.entity.InstanceEntity;
import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.service.InstanceService;
import com.bizunited.platform.kuiper.service.TemplateService;
import com.bizunited.platform.kuiper.starter.repository.FromDetailsImportRepository;
import com.bizunited.platform.kuiper.starter.service.FromDetailsImportService;
import com.bizunited.platform.kuiper.starter.service.instances.imports.FromDetailsImportProcess;
import com.bizunited.platform.rbac.server.service.UserService;
import com.bizunited.platform.rbac.server.vo.UserVo;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="FromDetailsImportServiceImpl")
public class FromDetailsImportServiceImpl
implements FromDetailsImportService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FromDetailsImportServiceImpl.class);
    @Autowired
    private TemplateService templateService;
    @Autowired
    private InstanceService instanceService;
    @Autowired
    private UserService userService;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private NebulaFileService nebulaFileService;
    @Autowired
    private FromDetailsImportRepository fromDetailsImportRepository;
    private static Set<String> processClassNamesMapping = new HashSet<String>();

    @Override
    @Transactional
    public void imports(byte[] fileBytes, Map<String, Object> params, Principal principal, String templateCode, String templateVersion, String processClassName) {
        Validate.notNull((Object)fileBytes, (String)"\u672c\u6b21\u5bfc\u51fa\u64cd\u4f5c\u6240\u57fa\u4e8e\u7684xls/xlsx\u6587\u4ef6\u5185\u5bb9\u4e0d\u80fd\u4e3anull", (Object[])new Object[0]);
        Map<String, Object> currentParams = params;
        if (currentParams == null) {
            currentParams = new HashMap<String, Object>();
        }
        Validate.notNull((Object)principal, (String)"\u5f53\u524d\u64cd\u4f5c\u8005\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        String account = principal.getName();
        UserVo currentUser = this.userService.findByAccount(account);
        Validate.notNull((Object)currentUser, (String)"\u9519\u8bef\u7684\u64cd\u4f5c\u8005\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        TemplateEntity currentTemplate = null;
        if (StringUtils.isBlank((CharSequence)templateVersion)) {
            List templetes = this.templateService.findByCode(templateCode);
            Validate.notNull((Object)templetes, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u8868\u5355\u6a21\u677f\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{templateCode});
            Optional<TemplateEntity> templateOp = templetes.stream().filter(item -> item.getDefaultVersion()).findFirst();
            currentTemplate = templateOp.orElse(null);
            Validate.notNull((Object)currentTemplate, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u8868\u5355\u6a21\u677f\u7684\u9ed8\u8ba4\u7248\u672c\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{templateCode});
        } else {
            currentTemplate = this.templateService.findByCodeAndCversion(templateCode, templateVersion);
            Validate.notNull((Object)currentTemplate, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u8868\u5355\u6a21\u677f\u4fe1\u606f[%s : %s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{templateCode, templateVersion});
        }
        Validate.notBlank((CharSequence)processClassName, (String)"\u6307\u5b9a\u7684process Class name\u5fc5\u987b\u4f20\u5165\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Class<?> processClass = null;
        try {
            processClass = this.applicationContext.getClassLoader().loadClass(processClassName);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(String.format("\u5728\u5f53\u524d\u8fdb\u7a0b\u7684spring ioc\u5bb9\u5668\u4e2d\uff0c\u672a\u53d1\u73b0\u6307\u5b9a\u7684process Class[%s]\uff0c\u8bf7\u68c0\u67e5!!", processClassName));
        }
        Validate.isTrue((boolean)FromDetailsImportProcess.class.isAssignableFrom(processClass), (String)"\u5f53\u524d\u7ed9\u5b9a\u7684processClassName\u5e76\u6ca1\u6709\u6b63\u786e\u5b9e\u73b0FromDetailsImportProcess\u63a5\u53e3\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        FromDetailsImportProcess process = (FromDetailsImportProcess)this.applicationContext.getBean(processClass);
        Set instanceUuidEntities = null;
        try (ByteArrayInputStream is = new ByteArrayInputStream(fileBytes);
             Workbook workbook = XSSFWorkbookFactory.create((InputStream)is);){
            instanceUuidEntities = process.validate(workbook, currentParams, templateCode, templateVersion);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("\u76ee\u524d\u4e1a\u52a1\u6570\u636e\u7684\u6279\u91cf\u5bfc\u5165\u548c\u8868\u5355\u751f\u6210\u529f\u80fd\uff0c\u53ea\u652f\u6301\u57fa\u4e8exls,xlsx\u6587\u4ef6\u7684\u5bfc\u5165\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u5185\u5bb9\u548c\u6587\u4ef6\u683c\u5f0f!!");
        }
        Validate.isTrue((!CollectionUtils.isEmpty(instanceUuidEntities) ? 1 : 0) != 0, (String)"\u672c\u6b21\u5bfc\u5165\u64cd\u4f5c\uff0c\u672a\u53d1\u73b0\u4efb\u4f55\u9700\u8981\u5bfc\u5165\u7684\u4e1a\u52a1\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u4e1a\u52a1\u6570\u636e\u5bfc\u5165\u524d\u7684\u6821\u9a8c\u903b\u8f91!!", (Object[])new Object[0]);
        for (FormInstanceUuidEntity instanceEntity : instanceUuidEntities) {
            InstanceEntity instance = this.instanceService.create(templateCode, templateVersion, principal);
            instanceEntity.setFormInstanceId(instance.getId());
        }
        process.execute(instanceUuidEntities, currentParams);
    }

    @Override
    public Set<String> findProcessClassNames() {
        return processClassNamesMapping;
    }

    @Override
    public void putProcessClassNames(String processClassNames) {
        if (StringUtils.isBlank((CharSequence)processClassNames)) {
            return;
        }
        processClassNamesMapping.add(processClassNames);
    }

    @Override
    @Transactional
    public FromDetailsImportEntity importTemplate(byte[] fileBytes, String listTemplateCode, String listTemplateVersion, String buttonCode, String originalFilename) {
        Validate.notNull((Object)fileBytes, (String)"\u6a21\u677f\u6587\u4ef6\u5185\u5bb9\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        try (ByteArrayInputStream is = new ByteArrayInputStream(fileBytes);){
            Workbook workbook = XSSFWorkbookFactory.create((InputStream)is);
            Throwable throwable = null;
            if (workbook != null) {
                if (throwable != null) {
                    try {
                        workbook.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    workbook.close();
                }
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("\u4e1a\u52a1\u6570\u636e\u7684\u5bfc\u5165\u6a21\u677f\u6587\u4ef6\uff0c\u53ea\u652f\u6301\u57fa\u4e8exls,xlsx\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u5185\u5bb9\u548c\u6587\u4ef6\u683c\u5f0f!!");
        }
        Validate.notBlank((CharSequence)listTemplateCode, (String)"\u6570\u636e\u5bfc\u5165\u6a21\u677f\u4e0a\u4f20\u65f6\uff0c\u5217\u8868\u6a21\u677f\u7f16\u7801\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)listTemplateVersion, (String)"\u6570\u636e\u5bfc\u5165\u6a21\u677f\u4e0a\u4f20\u65f6\uff0c\u5217\u8868\u6a21\u677f\u7248\u672c\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)buttonCode, (String)"\u6570\u636e\u5bfc\u5165\u6a21\u677f\u4e0a\u4f20\u65f6\uff0c\u529f\u80fd\u6309\u94ae\u7f16\u7801\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)originalFilename, (String)"\u6570\u636e\u5bfc\u5165\u6a21\u677f\u4e0a\u4f20\u65f6\uff0c\u539f\u59cb\u6587\u4ef6\u540d\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        String filenameSuffix = StringUtils.substringAfterLast((String)originalFilename, (String)".");
        Validate.notBlank((CharSequence)filenameSuffix, (String)"\u672a\u53d1\u73b0\u4e0a\u4f20\u7684\u6a21\u677f\u6587\u4ef6\u540d\u7684\u540e\u7f00\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        filenameSuffix = StringUtils.lowerCase((String)filenameSuffix);
        Validate.isTrue((boolean)StringUtils.containsAny((CharSequence)filenameSuffix, (CharSequence[])new CharSequence[]{"xls", "xlsx"}), (String)"\u76ee\u524d\u6a21\u677f\u6587\u4ef6\u7684\u6269\u5c55\u540d\u4ec5\u652f\u6301xls\u548cxlsx\u4e24\u7c7b\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        FromDetailsImportEntity currentFromDetailsImport = this.fromDetailsImportRepository.findByCodeAndVersion(listTemplateCode, listTemplateVersion, buttonCode);
        if (currentFromDetailsImport == null) {
            currentFromDetailsImport = new FromDetailsImportEntity();
            currentFromDetailsImport.setButtonCode(buttonCode);
            currentFromDetailsImport.setListTempleteCode(listTemplateCode);
            currentFromDetailsImport.setListTempleteVersion(listTemplateVersion);
        }
        Date nowDate = new Date();
        String folderName = new SimpleDateFormat("yyyyMMdd").format(nowDate);
        String uuid = UUID.randomUUID().toString();
        String systemName = "fromDetailsImport";
        String fileRename = uuid + "." + filenameSuffix;
        String relativePath = StringUtils.join((Object[])new Serializable[]{"/", systemName, "/", folderName, "/", Integer.valueOf(new Random().nextInt(100) % 10)});
        this.nebulaFileService.saveFile(relativePath, originalFilename, fileRename, fileBytes);
        currentFromDetailsImport.setFileName(fileRename);
        currentFromDetailsImport.setRelativePath(relativePath);
        this.fromDetailsImportRepository.save(currentFromDetailsImport);
        return currentFromDetailsImport;
    }
}

