/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.migrate;

import com.bizunited.platform.core.entity.OrdinaryFileEntity;
import com.bizunited.platform.core.entity.UserEntity;
import com.bizunited.platform.core.service.file.NebulaFileService;
import com.bizunited.platform.core.service.image.FileUpdateService;
import com.bizunited.platform.kuiper.entity.FrontFileEntity;
import com.bizunited.platform.kuiper.entity.ListTemplateEntity;
import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.entity.TemplateEventEntity;
import com.bizunited.platform.kuiper.entity.TemplateGroupEntity;
import com.bizunited.platform.kuiper.entity.TemplateItemEntity;
import com.bizunited.platform.kuiper.entity.TemplateItemExcelEntity;
import com.bizunited.platform.kuiper.entity.TemplateLayoutEntity;
import com.bizunited.platform.kuiper.entity.TemplateMigrateImportAnalysisEntity;
import com.bizunited.platform.kuiper.entity.TemplateMigrateImportAnalysisItemEntity;
import com.bizunited.platform.kuiper.entity.TemplateMigrateImportEntity;
import com.bizunited.platform.kuiper.entity.TemplatePropertyEntity;
import com.bizunited.platform.kuiper.entity.TemplateRelationEntity;
import com.bizunited.platform.kuiper.entity.TemplateVisibilityAttributesEntity;
import com.bizunited.platform.kuiper.entity.TemplateVisibilityButtonsEntity;
import com.bizunited.platform.kuiper.entity.TemplateVisibilityEntity;
import com.bizunited.platform.kuiper.service.DynamicTemplateService;
import com.bizunited.platform.kuiper.service.StaticTemplateService;
import com.bizunited.platform.kuiper.service.TemplateService;
import com.bizunited.platform.kuiper.starter.repository.template.migrate.TemplateMigrateImportRepository;
import com.bizunited.platform.kuiper.starter.service.FrontFileSevice;
import com.bizunited.platform.kuiper.starter.service.KuiperToolkitService;
import com.bizunited.platform.kuiper.starter.service.ListTemplateService;
import com.bizunited.platform.kuiper.starter.service.TemplateItemExcelService;
import com.bizunited.platform.kuiper.starter.service.migrate.TemplateMigrateImportAnalysisItemService;
import com.bizunited.platform.kuiper.starter.service.migrate.TemplateMigrateImportAnalysisService;
import com.bizunited.platform.kuiper.starter.service.migrate.TemplateMigrateImportService;
import com.bizunited.platform.rbac.server.service.UserService;
import com.bizunited.platform.rbac.server.vo.UserVo;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.transaction.Transactional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Service(value="TemplateMigrateImportServiceImpl")
public class TemplateMigrateImportServiceImpl
implements TemplateMigrateImportService {
    @Autowired
    private TemplateMigrateImportRepository templateMigrateImportRepository;
    @Autowired
    private FileUpdateService fileUpdateService;
    @Autowired
    private UserService userService;
    @Autowired
    private TemplateService templateService;
    @Autowired
    private StaticTemplateService staticTemplateService;
    @Autowired
    private DynamicTemplateService dynamicTemplateService;
    @Autowired
    private TemplateItemExcelService templateItemExcelService;
    @Autowired
    private ListTemplateService listTemplateService;
    @Autowired
    private TemplateMigrateImportAnalysisService templateMigrateImportAnalysisService;
    @Autowired
    private FrontFileSevice frontFileSevice;
    @Autowired
    private TemplateMigrateImportAnalysisItemService templateMigrateImportAnalysisItemService;
    @Autowired
    private NebulaFileService nebulaFileService;
    @Autowired
    private KuiperToolkitService kuiperToolkitService;
    @Value(value="${nebula.file.fileRoot}")
    private String fileRoot;
    private static final String DYNAMIC = "dynamic";
    private static final String STATIC = "static";
    private static final String LAYOUTDIR = "/listTemplate/layout";
    private static final String EXTENDTYPE = ".txt";

    @Override
    public TemplateMigrateImportEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.templateMigrateImportRepository.findById(id).orElse(null);
    }

    @Override
    @Transactional
    public TemplateMigrateImportEntity upload(String code, String migrateDesc, Principal currentUser, MultipartFile file) {
        Validate.notNull((Object)file, (String)"\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        TemplateMigrateImportEntity recordEntity = new TemplateMigrateImportEntity();
        recordEntity.setCode(code);
        recordEntity.setCreateTime(new Date());
        recordEntity.setExecuted(Boolean.valueOf(false));
        recordEntity.setCreator(this.getCurrentUser(currentUser.getName()));
        recordEntity.setOriginalFileName(file.getOriginalFilename());
        Object[] files = new MultipartFile[]{file};
        List ordinaryFileEntities = this.fileUpdateService.fileUpload("templateMigrate", currentUser.getName(), null, (MultipartFile[])files);
        Validate.notEmpty((Object[])files, (String)"\u4fdd\u5b58\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        OrdinaryFileEntity fileEntity = (OrdinaryFileEntity)ordinaryFileEntities.get(0);
        recordEntity.setFileName(fileEntity.getFileName());
        recordEntity.setRelativeLocal(fileEntity.getRelativeLocal());
        recordEntity.setMigrateDesc(migrateDesc);
        return this.create(recordEntity);
    }

    @Override
    @Transactional
    public TemplateMigrateImportEntity create(TemplateMigrateImportEntity importEntity) {
        Validate.notBlank((CharSequence)importEntity.getCode(), (String)"\u65b0\u589e\u6a21\u677f\u7684\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        TemplateMigrateImportEntity existCode = this.templateMigrateImportRepository.findByCode(importEntity.getCode());
        Validate.isTrue((null == existCode ? 1 : 0) != 0, (String)"\u6a21\u677f\u7f16\u53f7\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)importEntity.getCreateTime(), (String)"\u4fdd\u5b58\u8bb0\u5f55\u65f6\uff0c\u5bfc\u5165\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)importEntity.getRelativeLocal(), (String)"\u5bfc\u5165\u6587\u4ef6\u5728\u672c\u5730\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)importEntity.getFileName(), (String)"\u5bfc\u5165\u6587\u4ef6\u91cd\u547d\u540d\u540e\u7684\u6587\u4ef6\u540d\u5b57\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)importEntity.getCreator(), (String)"\u5bfc\u5165\u6587\u4ef6\u4e0a\u4f20\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)importEntity.getCreateTime(), (String)"\u5bfc\u5165\u6587\u4ef6\u4e0a\u4f20\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)importEntity.getExecuted(), (String)"\u5bfc\u5165\u6587\u4ef6\u4efb\u52a1\u662f\u5426\u88ab\u6267\u884c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        return (TemplateMigrateImportEntity)this.templateMigrateImportRepository.save(importEntity);
    }

    @Override
    public Page<TemplateMigrateImportEntity> findByConditions(Pageable pageable, String code, String fileName, String creator, Boolean executed, String executor) {
        if (null == pageable) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        HashMap<String, Object> conditions = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)code)) {
            conditions.put("code", code);
        }
        if (StringUtils.isNotBlank((CharSequence)fileName)) {
            conditions.put("fileName", fileName);
        }
        if (StringUtils.isNotBlank((CharSequence)creator)) {
            conditions.put("creator", creator);
        }
        if (null != executed) {
            conditions.put("executed", executed);
        }
        if (StringUtils.isNotBlank((CharSequence)executor)) {
            conditions.put("executor", executor);
        }
        return this.templateMigrateImportRepository.queryPage(pageable, conditions);
    }

    @Override
    @Transactional
    public TemplateMigrateImportEntity execute(String templateMigrateImportId, Principal principal) {
        Validate.notBlank((CharSequence)templateMigrateImportId, (String)"\u4f20\u5165\u8868\u5355\u4e0a\u4f20\u8bb0\u5f55ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        TemplateMigrateImportEntity recordEntity = this.templateMigrateImportRepository.findDetailById(templateMigrateImportId);
        Validate.notNull((Object)recordEntity, (String)"\u4f20\u5165\u8868\u5355\u4e0a\u4f20\u8bb0\u5f55\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        recordEntity.setExecuted(Boolean.valueOf(true));
        UserEntity executor = this.getCurrentUser(principal.getName());
        recordEntity.setExecutor(executor);
        ArrayList<TemplateEntity> templateEntities = new ArrayList<TemplateEntity>();
        ArrayList<TemplateItemExcelEntity> excelEntities = new ArrayList<TemplateItemExcelEntity>();
        ArrayList<byte[]> excelByte = new ArrayList<byte[]>();
        ArrayList<ListTemplateEntity> listTemplates = new ArrayList<ListTemplateEntity>();
        ArrayList<byte[]> listFiles = new ArrayList<byte[]>();
        ArrayList<FrontFileEntity> frontFileEntities = new ArrayList<FrontFileEntity>();
        ArrayList<byte[]> frontFileByte = new ArrayList<byte[]>();
        this.readData(recordEntity, templateEntities, excelEntities, excelByte, listTemplates, listFiles, frontFileEntities, frontFileByte);
        TemplateMigrateImportAnalysisEntity newAnalysis = this.templateMigrateImportAnalysisService.analysis(templateMigrateImportId);
        if (!CollectionUtils.isEmpty(templateEntities)) {
            this.saveTemplateAndLayout(newAnalysis, templateEntities, principal, excelEntities, excelByte);
        }
        this.saveListTemplate(newAnalysis, listTemplates, listFiles, principal);
        this.saveFrontFile(frontFileEntities, frontFileByte, principal);
        return (TemplateMigrateImportEntity)this.templateMigrateImportRepository.save(recordEntity);
    }

    private void saveFrontFile(List<FrontFileEntity> frontFileEntities, List<byte[]> frontFileByte, Principal principal) {
        if (CollectionUtils.isEmpty(frontFileEntities) || CollectionUtils.isEmpty(frontFileByte)) {
            return;
        }
        Validate.isTrue((frontFileEntities.size() == frontFileByte.size() ? 1 : 0) != 0, (String)"\u8bfb\u53d6\u51fa\u7684\u524d\u7aef\u6587\u4ef6entity\u4e0e\u5b9e\u4f53\u6570\u91cf\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        for (int i = 0; i < frontFileEntities.size(); ++i) {
            FrontFileEntity frontFile = frontFileEntities.get(i);
            byte[] bytes = frontFileByte.get(i);
            FrontFileEntity existName = this.frontFileSevice.findByName(frontFile.getName());
            if (existName != null) {
                String newName = StringUtils.join((Object[])new String[]{existName.getName(), ".bak"});
                FrontFileEntity existNewName = this.frontFileSevice.findByName(newName);
                while (existNewName != null) {
                    newName = StringUtils.join((Object[])new String[]{newName, ".bak"});
                    existNewName = this.frontFileSevice.findByName(newName);
                }
                existName.setName(newName);
                this.frontFileSevice.updateEntity(existName);
                this.templateMigrateImportRepository.flush();
            }
            String[] fileName = new String[]{frontFile.getFileName()};
            String base64 = Base64.getEncoder().encodeToString(bytes);
            String[] base64s = new String[]{base64};
            List fileEntities = this.fileUpdateService.fileUpload("frontFile", principal.getName(), null, fileName, base64s);
            Validate.notEmpty((Collection)fileEntities, (String)"\u4fdd\u5b58\u524d\u7aef\u6587\u4ef6\u5931\u6548\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            OrdinaryFileEntity fileEntity = (OrdinaryFileEntity)fileEntities.get(0);
            frontFile.setFileName(fileEntity.getFileName());
            frontFile.setFilePath(fileEntity.getRelativeLocal());
            frontFile.setId(null);
            this.frontFileSevice.saveEntity(frontFile);
            this.templateMigrateImportRepository.flush();
        }
    }

    private void saveTemplateAndLayout(TemplateMigrateImportAnalysisEntity newAnalysis, List<TemplateEntity> templates, Principal principal, List<TemplateItemExcelEntity> excelEntities, List<byte[]> excelByte) {
        if (CollectionUtils.isEmpty(templates)) {
            return;
        }
        Validate.notNull((Object)newAnalysis, (String)"\u65b0\u6267\u884c\u7684\u5206\u6790\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<TemplateMigrateImportAnalysisItemEntity> analysisItems = this.templateMigrateImportAnalysisItemService.findByAnalysis(newAnalysis.getId());
        Validate.notEmpty(analysisItems, (String)"\u672a\u67e5\u8be2\u5230\u5206\u6790\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        for (TemplateEntity template : templates) {
            Set templateProperties;
            ArrayList<TemplateItemExcelEntity> thisTemplateExcels = new ArrayList<TemplateItemExcelEntity>();
            for (TemplateItemExcelEntity templateItemExcelEntity : excelEntities) {
                if (!StringUtils.equals((CharSequence)templateItemExcelEntity.getTemplateId(), (CharSequence)template.getId())) continue;
                thisTemplateExcels.add(templateItemExcelEntity);
            }
            ArrayList<TemplateMigrateImportAnalysisItemEntity> templateItems = new ArrayList<TemplateMigrateImportAnalysisItemEntity>();
            for (TemplateMigrateImportAnalysisItemEntity itemEntity : analysisItems) {
                if (!StringUtils.equals((CharSequence)template.getCode(), (CharSequence)itemEntity.getCode()) || !StringUtils.equals((CharSequence)template.getCversion(), (CharSequence)itemEntity.getCversion()) || itemEntity.getFormType() != 1) continue;
                templateItems.add(itemEntity);
            }
            Validate.isTrue((!CollectionUtils.isEmpty(templateItems) && templateItems.size() == 1 ? 1 : 0) != 0, (String)"\u5206\u6790\u6a21\u677f\u53d1\u751f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            TemplateMigrateImportAnalysisItemEntity templateMigrateImportAnalysisItemEntity = (TemplateMigrateImportAnalysisItemEntity)templateItems.get(0);
            template = this.removeTemplateId(template, principal);
            if (templateMigrateImportAnalysisItemEntity.getMigrateStatus() == 1) {
                if (StringUtils.equals((CharSequence)DYNAMIC, (CharSequence)template.getType())) {
                    templateProperties = template.getProperties();
                    templateProperties = templateProperties.stream().filter(o -> !StringUtils.equals((CharSequence)o.getPropertyDbName(), (CharSequence)"id") && !StringUtils.equals((CharSequence)o.getPropertyDbName(), (CharSequence)"form_instance_id")).collect(Collectors.toSet());
                    template.setProperties(templateProperties);
                    this.initDynamicTemplate(template, principal);
                }
                if (StringUtils.equals((CharSequence)STATIC, (CharSequence)template.getType())) {
                    this.initStaticTemplateAndMore(template, principal);
                }
            }
            if (templateMigrateImportAnalysisItemEntity.getMigrateStatus() == 2) {
                templateProperties = template.getProperties();
                templateProperties = templateProperties.stream().filter(o -> !StringUtils.equals((CharSequence)o.getPropertyDbName(), (CharSequence)"id") && !StringUtils.equals((CharSequence)o.getPropertyDbName(), (CharSequence)"form_instance_id")).collect(Collectors.toSet());
                template.setProperties(templateProperties);
                template.setCversion(StringUtils.join((Object[])new String[]{template.getCversion(), "M"}));
                List list = this.templateService.findByCode(template.getCode());
                ArrayList<TemplateEntity> templateEntities = new ArrayList<TemplateEntity>();
                for (TemplateEntity o2 : list) {
                    if (!StringUtils.equals((CharSequence)o2.getCversion(), (CharSequence)template.getCversion())) continue;
                    templateEntities.add(o2);
                }
                List versions = list.stream().map(TemplateEntity::getCversion).collect(Collectors.toList());
                while (versions.contains(template.getCversion())) {
                    template.setCversion(StringUtils.join((Object[])new Serializable[]{template.getCversion(), Integer.valueOf(new Random().nextInt(10))}));
                }
                if (StringUtils.equals((CharSequence)DYNAMIC, (CharSequence)template.getType())) {
                    template = this.initDynamicTemplate(template, principal);
                }
                if (StringUtils.equals((CharSequence)STATIC, (CharSequence)template.getType())) {
                    template = this.initStaticTemplateAndMore(template, principal);
                }
            }
            this.templateMigrateImportRepository.flush();
            if (StringUtils.isNotBlank((CharSequence)template.getId())) {
                template = this.templateService.findDetailsById(template.getId());
            }
            if (CollectionUtils.isEmpty(thisTemplateExcels) || StringUtils.isBlank((CharSequence)template.getId())) continue;
            for (TemplateItemExcelEntity templateItemExcelEntity : thisTemplateExcels) {
                if (StringUtils.isBlank((CharSequence)templateItemExcelEntity.getTemplateGroupId())) {
                    Set newItems = template.getItemRelations();
                    for (TemplateItemEntity itemEntity : newItems) {
                        if (!StringUtils.equals((CharSequence)templateItemExcelEntity.getItemPropertyName(), (CharSequence)itemEntity.getPropertyName())) continue;
                        int index = excelEntities.indexOf(templateItemExcelEntity);
                        byte[] excelFile = excelByte.get(index);
                        templateItemExcelEntity.setId(null);
                        templateItemExcelEntity.setTemplateId(template.getId());
                        templateItemExcelEntity.setTemplateItemId(itemEntity.getId());
                        OrdinaryFileEntity file = this.saveSingleExcel(principal.getName(), templateItemExcelEntity.getOriginalFileName(), excelFile);
                        templateItemExcelEntity.setFilePath(file.getRelativeLocal());
                        templateItemExcelEntity.setFileName(file.getFileName());
                        templateItemExcelEntity.setOriginalFileName(file.getOriginalFileName());
                        this.templateItemExcelService.save(templateItemExcelEntity);
                    }
                    continue;
                }
                Set groups = template.getGroupRelations();
                for (TemplateGroupEntity group : groups) {
                    if (!StringUtils.equals((CharSequence)group.getPropertyName(), (CharSequence)templateItemExcelEntity.getGroupPropertyName())) continue;
                    Set items = group.getItemRelations();
                    for (TemplateItemEntity item : items) {
                        int index = excelEntities.indexOf(templateItemExcelEntity);
                        byte[] excelFile = excelByte.get(index);
                        templateItemExcelEntity.setId(null);
                        templateItemExcelEntity.setTemplateId(template.getId());
                        templateItemExcelEntity.setTemplateItemId(item.getId());
                        templateItemExcelEntity.setTemplateGroupId(group.getId());
                        templateItemExcelEntity.setGroupPropertyName(group.getPropertyName());
                        OrdinaryFileEntity file = this.saveSingleExcel(principal.getName(), templateItemExcelEntity.getOriginalFileName(), excelFile);
                        templateItemExcelEntity.setFilePath(file.getRelativeLocal());
                        templateItemExcelEntity.setFileName(file.getFileName());
                        templateItemExcelEntity.setOriginalFileName(file.getOriginalFileName());
                        this.templateItemExcelService.save(templateItemExcelEntity);
                    }
                }
            }
        }
    }

    private void saveListTemplate(TemplateMigrateImportAnalysisEntity newAnalysis, List<ListTemplateEntity> listTemplates, List<byte[]> listFiles, Principal principal) {
        Validate.notNull((Object)principal, (String)"\u4fdd\u5b58\u5217\u8868\u6a21\u677f\u65f6\uff0c\u5f53\u524d\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (CollectionUtils.isEmpty(listTemplates)) {
            return;
        }
        Validate.isTrue((listTemplates.size() == listFiles.size() ? 1 : 0) != 0, (String)"\u5217\u8868\u6a21\u677f\u4e0e\u6587\u4ef6\u6570\u91cf\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)newAnalysis, (String)"\u65b0\u6267\u884c\u7684\u5206\u6790\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<TemplateMigrateImportAnalysisItemEntity> analysisItems = this.templateMigrateImportAnalysisItemService.findByAnalysis(newAnalysis.getId());
        for (int i = 0; i < listTemplates.size(); ++i) {
            ListTemplateEntity listTemplate = listTemplates.get(i);
            byte[] listFile = listFiles.get(i);
            ArrayList<TemplateMigrateImportAnalysisItemEntity> listItems = new ArrayList<TemplateMigrateImportAnalysisItemEntity>();
            for (TemplateMigrateImportAnalysisItemEntity itemEntity : analysisItems) {
                if (!StringUtils.equals((CharSequence)listTemplate.getCode(), (CharSequence)itemEntity.getCode()) || !StringUtils.equals((CharSequence)listTemplate.getCversion(), (CharSequence)itemEntity.getCversion()) || itemEntity.getFormType() != 2) continue;
                listItems.add(itemEntity);
            }
            Validate.isTrue((!CollectionUtils.isEmpty(listItems) && listItems.size() == 1 ? 1 : 0) != 0, (String)"\u5206\u6790\u5217\u8868\u6a21\u677f\u53d1\u751f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            TemplateMigrateImportAnalysisItemEntity listItem = (TemplateMigrateImportAnalysisItemEntity)listItems.get(0);
            if (listItem.getMigrateStatus() == 1) {
                listTemplate.setId(null);
                listTemplate = this.listTemplateService.init(listTemplate, principal);
                this.templateMigrateImportRepository.flush();
                String relativePath = LAYOUTDIR;
                String fileName = StringUtils.join((Object[])new String[]{listTemplate.getId(), EXTENDTYPE});
                this.nebulaFileService.saveFile(relativePath, fileName, fileName, listFile);
                listTemplate.setFileName(fileName);
                listTemplate.setRelativePath(relativePath);
                this.listTemplateService.update(listTemplate);
            }
            if (listItem.getMigrateStatus() != 2) continue;
            listTemplate.setCversion(StringUtils.join((Object[])new String[]{listTemplate.getCversion(), "M"}));
            Set<ListTemplateEntity> sameVersion = this.listTemplateService.findByCode(listTemplate.getCode());
            List versions = sameVersion.stream().map(ListTemplateEntity::getCversion).collect(Collectors.toList());
            while (versions.contains(listTemplate.getCversion())) {
                listTemplate.setCversion(StringUtils.join((Object[])new Serializable[]{listTemplate.getCversion(), Integer.valueOf(new Random().nextInt(10))}));
            }
            listTemplate.setId(null);
            listTemplate = this.listTemplateService.init(listTemplate, principal);
            this.templateMigrateImportRepository.flush();
            String relativePath = LAYOUTDIR;
            String fileName = StringUtils.join((Object[])new String[]{listTemplate.getId(), EXTENDTYPE});
            this.nebulaFileService.saveFile(relativePath, fileName, fileName, listFile);
            listTemplate.setFileName(fileName);
            listTemplate.setRelativePath(relativePath);
            this.listTemplateService.update(listTemplate);
        }
    }

    private OrdinaryFileEntity saveSingleExcel(String creator, String fileName, byte[] bytes) {
        String[] fileNames = new String[]{fileName};
        String base64 = Base64.getEncoder().encodeToString(bytes);
        String[] base64Contents = new String[]{base64};
        List files = this.fileUpdateService.fileUpload("excelTemplate", creator, null, fileNames, base64Contents);
        Validate.notEmpty((Collection)files, (String)"\u4fdd\u5b58EXCEL\u6587\u4ef6\u5931\u8d25\uff01", (Object[])new Object[0]);
        return (OrdinaryFileEntity)files.get(0);
    }

    private TemplateEntity initStaticTemplateAndMore(TemplateEntity template, Principal principal) {
        TemplateEntity newTemplateEntity = new TemplateEntity();
        newTemplateEntity.setPersistentClassName(template.getPersistentClassName());
        newTemplateEntity.setCversion(template.getCversion());
        newTemplateEntity.setName(template.getName());
        newTemplateEntity.setFormStyle(template.getFormStyle());
        newTemplateEntity = this.staticTemplateService.initStaticTemplate(newTemplateEntity, principal, false);
        String templateId = newTemplateEntity.getId();
        template.setId(templateId);
        this.addPropertiesId(template.getProperties(), templateId);
        this.addRelationsId(template.getRelations(), templateId);
        this.addGroupId(template.getGroupRelations(), templateId);
        this.addItemsId(template.getItemRelations(), templateId);
        this.addVisibilitiesId(template.getVisibility(), templateId);
        this.addEventId(template.getEvent(), templateId);
        template.setTemplateLayout(template.getTemplateLayout());
        template.setMobileTemplateLayout(template.getMobileTemplateLayout());
        template.setPrintTemplateLayout(template.getPrintTemplateLayout());
        template = this.templateService.update(template);
        return template;
    }

    private TemplateEntity initDynamicTemplate(TemplateEntity template, Principal principal) {
        TemplateEntity newTemplate = new TemplateEntity();
        newTemplate.setPersistentClassName(template.getPersistentClassName());
        newTemplate.setCversion(template.getCversion());
        newTemplate.setName(template.getName());
        newTemplate.setFormStyle(template.getFormStyle());
        newTemplate.setDomain(template.getDomain());
        newTemplate.setType(template.getType());
        newTemplate.setPersistentClassName(template.getPersistentClassName());
        newTemplate.setCode(template.getCode());
        newTemplate.setPorjectName(template.getPorjectName());
        newTemplate.setTableName(template.getTableName());
        newTemplate.setRepositoryEntity(template.getRepositoryEntity());
        newTemplate.setDefaultVersion(template.getDefaultVersion());
        newTemplate.setFormStyle(template.getFormStyle());
        newTemplate.setTstatus(template.getTstatus());
        newTemplate.setProperties(template.getProperties());
        newTemplate.setRelations(template.getRelations());
        newTemplate.setGroupRelations(template.getGroupRelations());
        newTemplate.setItemRelations(template.getItemRelations());
        this.handleDynamicTemplate(newTemplate);
        TemplateEntity jpaTemplate = this.dynamicTemplateService.initDynamicTemplate(newTemplate, principal, true);
        TemplateEntity templateUpdate = (TemplateEntity)this.kuiperToolkitService.copyObjectByWhiteList(template, TemplateEntity.class, HashSet.class, ArrayList.class, new String[0]);
        templateUpdate.setId(jpaTemplate.getId());
        templateUpdate.setVisibility(template.getVisibility());
        templateUpdate.setTemplateLayout(template.getTemplateLayout());
        templateUpdate.setEvent(template.getEvent());
        templateUpdate = this.templateService.update(templateUpdate);
        return templateUpdate;
    }

    private TemplateEntity handleDynamicTemplate(TemplateEntity template) {
        Set<TemplateItemEntity> items = this.handleDynamicTemplateItem(template.getItemRelations());
        template.setItemRelations(items);
        Set groupRelations = template.getGroupRelations();
        if (!CollectionUtils.isEmpty((Collection)groupRelations)) {
            for (TemplateGroupEntity groupRelation : groupRelations) {
                Set<TemplateItemEntity> itemRelations = this.handleDynamicTemplateItem(groupRelation.getItemRelations());
                groupRelation.setItemRelations(itemRelations);
                this.removeIdProperty(groupRelation.getProperties());
                this.removeDynamicTemplateItemParentRelation(groupRelation.getParentTableName(), groupRelation.getRelations());
            }
        }
        return template;
    }

    private Set<TemplatePropertyEntity> removeIdProperty(Set<TemplatePropertyEntity> properties) {
        if (CollectionUtils.isEmpty(properties)) {
            return properties;
        }
        Iterator<TemplatePropertyEntity> iterator = properties.iterator();
        while (iterator.hasNext()) {
            TemplatePropertyEntity property = iterator.next();
            if (!property.getPropertyDbName().equals("id")) continue;
            iterator.remove();
        }
        return properties;
    }

    private Set<TemplateItemEntity> handleDynamicTemplateItem(Set<TemplateItemEntity> itemRelations) {
        if (CollectionUtils.isEmpty(itemRelations)) {
            return itemRelations;
        }
        for (TemplateItemEntity itemRelation : itemRelations) {
            Set properties = itemRelation.getProperties();
            this.removeIdProperty(properties);
            this.removeDynamicTemplateItemParentRelation(itemRelation.getParentTableName(), itemRelation.getRelations());
        }
        return itemRelations;
    }

    private Set<TemplateRelationEntity> removeDynamicTemplateItemParentRelation(String parentTableName, Set<TemplateRelationEntity> relations) {
        if (CollectionUtils.isEmpty(relations)) {
            return relations;
        }
        Iterator<TemplateRelationEntity> iterator = relations.iterator();
        while (iterator.hasNext()) {
            TemplateRelationEntity relation = iterator.next();
            if (!relation.getTargetTableName().equals(parentTableName)) continue;
            iterator.remove();
        }
        return relations;
    }

    private void readData(TemplateMigrateImportEntity importEntity, List<TemplateEntity> templates, List<TemplateItemExcelEntity> itemExcelEntities, List<byte[]> excelBytes, List<ListTemplateEntity> listTemplates, List<byte[]> listFiles, List<FrontFileEntity> frontFileEntities, List<byte[]> frontFileBytes) {
        Throwable throwable;
        Validate.notNull((Object)importEntity, (String)"\u6a21\u677f\u8fc1\u79fb\u6587\u4ef6\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (Object[])new Object[0]);
        String fileName = importEntity.getFileName();
        String relativeLocal = importEntity.getRelativeLocal();
        byte[] fileBytes = this.nebulaFileService.readFileContent(relativeLocal, fileName);
        String zipFileName = "serial.in";
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(fileBytes);
        File dir = new File(this.fileRoot);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String uuid = UUID.randomUUID().toString();
        File localFile = new File(StringUtils.join((Object[])new String[]{this.fileRoot, "/", uuid, ".zip"}));
        try {
            if (!localFile.exists()) {
                Boolean createFlag = localFile.createNewFile();
                Validate.isTrue((boolean)createFlag, (String)"\u521b\u5efa\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        try {
            throwable = null;
            try (FileOutputStream os = new FileOutputStream(localFile);){
                int realLen;
                int maxLen = 4096;
                byte[] contents = new byte[maxLen];
                while ((realLen = byteArrayInputStream.read(contents, 0, maxLen)) != -1) {
                    os.write(contents, 0, realLen);
                }
            }
            catch (Throwable maxLen) {
                throwable = maxLen;
                throw maxLen;
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("\u8bfb\u53d6\u4fdd\u5b58\u7684\u4e0a\u4f20\u8868\u5355\u8bb0\u5f55\u6587\u4ef6\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
        }
        try {
            throwable = null;
            try (ZipFile zipFile = new ZipFile(localFile);){
                byte[] bytes;
                InputStream frontInput;
                Boolean startWith;
                int i;
                ZipEntry zipEntry = zipFile.getEntry(zipFileName);
                InputStream is = zipFile.getInputStream(zipEntry);
                ObjectInputStream ois = new ObjectInputStream(is);
                Integer formSize = ois.readInt();
                Validate.isTrue((formSize >= 0 ? 1 : 0) != 0, (String)"\u8bfb\u53d6\u7684\u8868\u5355\u6a21\u677f\u6570\u91cf\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
                Integer listSize = ois.readInt();
                Validate.isTrue((listSize >= 0 ? 1 : 0) != 0, (String)"\u8bfb\u53d6\u7684\u5217\u8868\u6a21\u677f\u6570\u91cf\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
                Integer frontFileSize = ois.readInt();
                Validate.isTrue((frontFileSize >= 0 ? 1 : 0) != 0, (String)"\u8bfb\u53d6\u7684\u524d\u7aef\u6587\u4ef6\u6570\u91cf\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
                for (i = 0; i < formSize && formSize > 0; ++i) {
                    Boolean startWith2;
                    TemplateEntity templateEntity = (TemplateEntity)ois.readObject();
                    Integer layoutSize = ois.readInt();
                    Validate.isTrue((layoutSize >= 0 ? 1 : 0) != 0, (String)"\u8bfb\u53d6\u7684\u6570\u91cf\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
                    Integer excelSize = ois.readInt();
                    Validate.isTrue((excelSize >= 0 ? 1 : 0) != 0, (String)"\u8bfb\u53d6\u7684\u6570\u91cf\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
                    for (int layoutInt = 0; layoutInt < layoutSize; ++layoutInt) {
                        TemplateLayoutEntity layout = (TemplateLayoutEntity)ois.readObject();
                        startWith2 = StringUtils.startsWith((CharSequence)layout.getRelativePath(), (CharSequence)"/") || StringUtils.startsWith((CharSequence)layout.getRelativePath(), (CharSequence)"\\");
                        String layoutPath = Boolean.TRUE.equals(startWith2) ? layout.getRelativePath().substring(1) : layout.getRelativePath();
                        String fullLayoutFilePath = StringUtils.join((Object[])new String[]{layoutPath, "/", layout.getFileName()});
                        ZipEntry layoutFile = zipFile.getEntry(fullLayoutFilePath);
                        Validate.notNull((Object)layoutFile, (String)("\u672a\u627e\u5230\u6307\u5b9a\u7684\u5e03\u5c40\u6587\u4ef6[" + fullLayoutFilePath + "]\uff0c\u5bfc\u51fa\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5!!"), (Object[])new Object[0]);
                        try (InputStream fis = zipFile.getInputStream(layoutFile);
                             ObjectInputStream objectIn = new ObjectInputStream(fis);){
                            Object layoutObject = objectIn.readObject();
                            if (layout.getLayoutType() == 1) {
                                templateEntity.setTemplateLayout(layoutObject);
                                continue;
                            }
                            if (layout.getLayoutType() == 2) {
                                templateEntity.setMobileTemplateLayout(layoutObject);
                                continue;
                            }
                            if (layout.getLayoutType() != 3) continue;
                            templateEntity.setPrintTemplateLayout(layoutObject);
                            continue;
                        }
                    }
                    for (int excelInt = 0; excelInt < excelSize; ++excelInt) {
                        TemplateItemExcelEntity itemExcel = (TemplateItemExcelEntity)ois.readObject();
                        startWith2 = StringUtils.startsWith((CharSequence)itemExcel.getFilePath(), (CharSequence)"/") || StringUtils.startsWith((CharSequence)itemExcel.getFilePath(), (CharSequence)"\\");
                        String excelPath = Boolean.TRUE.equals(startWith2) ? itemExcel.getFilePath().substring(1) : itemExcel.getFilePath();
                        String fullExcelFilePath = StringUtils.join((Object[])new String[]{excelPath, "/", itemExcel.getFileName()});
                        ZipEntry excelFile = zipFile.getEntry(fullExcelFilePath);
                        InputStream frontInput2 = zipFile.getInputStream(excelFile);
                        byte[] bytes2 = IOUtils.toByteArray((InputStream)frontInput2);
                        itemExcelEntities.add(itemExcel);
                        excelBytes.add(bytes2);
                    }
                    templates.add(templateEntity);
                }
                for (i = 0; i < listSize; ++i) {
                    ListTemplateEntity listTemplate = (ListTemplateEntity)ois.readObject();
                    if (listTemplate == null) continue;
                    listTemplates.add(listTemplate);
                    startWith = StringUtils.startsWith((CharSequence)listTemplate.getRelativePath(), (CharSequence)"/") || StringUtils.startsWith((CharSequence)listTemplate.getRelativePath(), (CharSequence)"\\");
                    String filePath = Boolean.TRUE.equals(startWith) ? listTemplate.getRelativePath().substring(1) : listTemplate.getRelativePath();
                    String fullFilePath = StringUtils.join((Object[])new String[]{filePath, "/", listTemplate.getFileName()});
                    ZipEntry fileEntry = zipFile.getEntry(fullFilePath);
                    frontInput = zipFile.getInputStream(fileEntry);
                    bytes = IOUtils.toByteArray((InputStream)frontInput);
                    listFiles.add(bytes);
                }
                for (int j = 0; j < frontFileSize; ++j) {
                    FrontFileEntity frontFile = (FrontFileEntity)ois.readObject();
                    startWith = StringUtils.startsWith((CharSequence)frontFile.getFilePath(), (CharSequence)"/") || StringUtils.startsWith((CharSequence)frontFile.getFilePath(), (CharSequence)"\\");
                    String zipFrontFilePath = Boolean.TRUE.equals(startWith) ? frontFile.getFilePath().substring(1) : frontFile.getFilePath();
                    String frontFileZipName = StringUtils.join((Object[])new String[]{zipFrontFilePath, "/", frontFile.getFileName()});
                    ZipEntry frontFileEntry = zipFile.getEntry(frontFileZipName);
                    frontInput = zipFile.getInputStream(frontFileEntry);
                    bytes = IOUtils.toByteArray((InputStream)frontInput);
                    frontFileEntities.add(frontFile);
                    frontFileBytes.add(bytes);
                }
                localFile.delete();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IllegalArgumentException("\u8bfb\u53d6\u4fdd\u5b58\u7684\u4e0a\u4f20\u8868\u5355\u8bb0\u5f55\u6587\u4ef6\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    private UserEntity getCurrentUser(String account) {
        UserVo userVo = this.userService.findByAccount(account);
        Validate.notNull((Object)userVo, (String)"\u4e0a\u4f20\u6a21\u677f\u4fe1\u606f\u65f6\u672a\u627e\u5230\u5f53\u524d\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        UserEntity userEntity = new UserEntity();
        userEntity.setId(userVo.getId());
        return userEntity;
    }

    private TemplateEntity removeTemplateId(TemplateEntity template, Principal principal) {
        Validate.notNull((Object)template, (String)"\u6240\u8bfb\u53d6\u8868\u5355\u6a21\u677f\u6570\u91cf\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        template.setId(null);
        template.setCreateTime(new Date());
        template.setCreator(this.getCurrentUser(principal.getName()));
        template.setMaintainers(null);
        Set properties = template.getProperties();
        template.setProperties(this.removePropertiesId(properties));
        Set relations = template.getRelations();
        template.setRelations(this.removeRelationsId(relations));
        Set groups = template.getGroupRelations();
        template.setGroupRelations(this.removeGroupId(groups));
        Set items = template.getItemRelations();
        template.setItemRelations(this.removeItemsId(items));
        Set event = template.getEvent();
        template.setEvent(this.removeEventId(event));
        Set visibilities = template.getVisibility();
        template.setVisibility(this.removeVisibilitiesId(visibilities));
        template.setInstances(null);
        return template;
    }

    private Set<TemplatePropertyEntity> removePropertiesId(Set<TemplatePropertyEntity> properties) {
        if (CollectionUtils.isEmpty(properties)) {
            return Collections.emptySet();
        }
        properties.stream().forEach(property -> {
            property.setId(null);
            property.setCurrentTemplate(null);
            property.setCurrentGroup(null);
            property.setCurrentItem(null);
        });
        return properties;
    }

    private Set<TemplatePropertyEntity> addPropertiesId(Set<TemplatePropertyEntity> properties, String templateId) {
        if (CollectionUtils.isEmpty(properties)) {
            return Collections.emptySet();
        }
        properties.stream().forEach(property -> {
            TemplateEntity templateEntity = new TemplateEntity();
            templateEntity.setId(templateId);
            property.setCurrentTemplate(templateEntity);
        });
        return properties;
    }

    private Set<TemplateRelationEntity> removeRelationsId(Set<TemplateRelationEntity> relations) {
        if (CollectionUtils.isEmpty(relations)) {
            return Collections.emptySet();
        }
        relations.stream().forEach(relation -> {
            relation.setId(null);
            relation.setCurrentTemplate(null);
            relation.setCurrentGroup(null);
            relation.setCurrentItem(null);
        });
        return relations;
    }

    private Set<TemplateRelationEntity> addRelationsId(Set<TemplateRelationEntity> relations, String templateId) {
        if (CollectionUtils.isEmpty(relations)) {
            return Collections.emptySet();
        }
        relations.stream().forEach(relation -> {
            TemplateEntity templateEntity = new TemplateEntity();
            templateEntity.setId(templateId);
            relation.setCurrentTemplate(templateEntity);
        });
        return relations;
    }

    private Set<TemplateItemEntity> removeItemsId(Set<TemplateItemEntity> items) {
        if (CollectionUtils.isEmpty(items)) {
            return Collections.emptySet();
        }
        items.stream().forEach(item -> {
            item.setId(null);
            item.setParentTemplate(null);
            item.setParentGroup(null);
            Set properties = item.getProperties();
            item.setProperties(this.removePropertiesId(properties));
            Set relations = item.getRelations();
            item.setRelations(this.removeRelationsId(relations));
        });
        return items;
    }

    private Set<TemplateItemEntity> addItemsId(Set<TemplateItemEntity> items, String templateId) {
        if (CollectionUtils.isEmpty(items)) {
            return Collections.emptySet();
        }
        items.stream().forEach(item -> {
            TemplateEntity templateEntity = new TemplateEntity();
            templateEntity.setId(templateId);
            item.setParentTemplate(templateEntity);
        });
        return items;
    }

    private Set<TemplateGroupEntity> removeGroupId(Set<TemplateGroupEntity> groups) {
        if (CollectionUtils.isEmpty(groups)) {
            return Collections.emptySet();
        }
        groups.stream().forEach(group -> {
            group.setId(null);
            group.setParentTemplate(null);
            Set properties = group.getProperties();
            group.setProperties(this.removePropertiesId(properties));
            Set relations = group.getRelations();
            group.setRelations(this.removeRelationsId(relations));
            Set<TemplateItemEntity> itemRelations = this.removeItemsId(group.getItemRelations());
            group.setItemRelations(itemRelations);
        });
        return groups;
    }

    private Set<TemplateGroupEntity> addGroupId(Set<TemplateGroupEntity> groups, String templateId) {
        if (CollectionUtils.isEmpty(groups)) {
            return Collections.emptySet();
        }
        groups.stream().forEach(group -> {
            TemplateEntity templateEntity = new TemplateEntity();
            templateEntity.setId(templateId);
            group.setParentTemplate(templateEntity);
        });
        return groups;
    }

    private Set<TemplateEventEntity> removeEventId(Set<TemplateEventEntity> events) {
        if (CollectionUtils.isEmpty(events)) {
            return Collections.emptySet();
        }
        events.stream().forEach(event -> {
            event.setId(null);
            event.setTemplate(null);
        });
        return events;
    }

    private Set<TemplateEventEntity> addEventId(Set<TemplateEventEntity> events, String templateId) {
        if (CollectionUtils.isEmpty(events)) {
            return Collections.emptySet();
        }
        events.stream().forEach(event -> {
            TemplateEntity templateEntity = new TemplateEntity();
            templateEntity.setId(templateId);
            event.setTemplate(templateEntity);
        });
        return events;
    }

    private Set<TemplateVisibilityEntity> removeVisibilitiesId(Set<TemplateVisibilityEntity> visibilities) {
        if (CollectionUtils.isEmpty(visibilities)) {
            return Collections.emptySet();
        }
        visibilities.stream().forEach(visibility -> {
            visibility.setId(null);
            visibility.setTemplate(null);
            Set attributes = visibility.getAttributes();
            visibility.setAttributes(this.removeVisibilityAttributesId(attributes));
            Set buttons = visibility.getButtons();
            visibility.setButtons(this.removeVisibilityButtonsId(buttons));
        });
        return visibilities;
    }

    private Set<TemplateVisibilityEntity> addVisibilitiesId(Set<TemplateVisibilityEntity> visibilities, String templateId) {
        if (CollectionUtils.isEmpty(visibilities)) {
            return Collections.emptySet();
        }
        visibilities.stream().forEach(visibility -> {
            TemplateEntity templateEntity = new TemplateEntity();
            templateEntity.setId(templateId);
            visibility.setTemplate(templateEntity);
        });
        return visibilities;
    }

    private Set<TemplateVisibilityAttributesEntity> removeVisibilityAttributesId(Set<TemplateVisibilityAttributesEntity> attributes) {
        if (CollectionUtils.isEmpty(attributes)) {
            return Collections.emptySet();
        }
        attributes.stream().forEach(attribute -> {
            attribute.setId(null);
            attribute.setTemplateVisibility(null);
        });
        return attributes;
    }

    private Set<TemplateVisibilityButtonsEntity> removeVisibilityButtonsId(Set<TemplateVisibilityButtonsEntity> buttons) {
        if (CollectionUtils.isEmpty(buttons)) {
            return Collections.emptySet();
        }
        buttons.stream().forEach(button -> button.setId(null));
        return buttons;
    }
}

