/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.controller;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.core.service.invoke.InvokeProxy;
import com.bizunited.platform.core.service.serviceable.model.InputParamsModel;
import com.bizunited.platform.kuiper.service.DynamicInstanceService;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/kuiper/dynamicInstatnces"})
public class DynamicInstanceController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicInstanceController.class);
    @Autowired
    private DynamicInstanceService dynamicInstanceService;
    @Autowired
    private ApplicationContext ctx;

    @ApiOperation(value="\u83b7\u53d6\u5b9e\u4f8b\u57fa\u672c\u4fe1\u606f\uff0c\u4e0d\u5bf9\u4efb\u4f55\u5173\u8054\u4fe1\u606f\u8fdb\u884c\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="formInstanceId", value="\u6307\u5b9a\u7684\u5b9e\u4f8bid", required=true)})
    @GetMapping(value={"/findByFormInstanceId"})
    public ResponseModel findByFormInstanceId(@RequestParam(value="formInstanceId") String formInstanceId) {
        try {
            JSONObject json = this.dynamicInstanceService.findByFormInstanceId(formInstanceId);
            return this.buildHttpResultW(json, new String[]{""});
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value=" \u6839\u636e\u5b9e\u4f8bID\u4fe1\u606f\uff0c\u83b7\u53d6\u5b9e\u4f8b\u7684\u8be6\u60c5\uff0c\u5305\u542b\u6240\u6709\u53ef\u80fd\u7684\u5173\u8054\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="formInstanceId", value="\u6307\u5b9a\u7684\u5b9e\u4f8bid", required=true)})
    @GetMapping(value={"/findDetailsByFormInstanceId"})
    public ResponseModel findDetailsByFormInstanceId(@RequestParam(value="formInstanceId") String formInstanceId) {
        try {
            JSONObject json = this.dynamicInstanceService.findDetailsByFormInstanceId(formInstanceId);
            return this.buildHttpResultW(json, new String[]{""});
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4fdd\u5b58\u6216\u4fee\u6539\u8868\u5355\u6a21\u677f\u4fe1\u606f\u4e1a\u52a1\u6570\u636e")
    @RequestMapping(value={""}, method={RequestMethod.POST, RequestMethod.PATCH})
    public ResponseModel save(@RequestBody @ApiParam(name="templateData", value="\u8868\u5355\u6a21\u677f\u4e1a\u52a1\u6570\u636e\u4fe1\u606f") InputParamsModel inputParamsModel, HttpServletRequest request) {
        try {
            Map<String, Object> params = this.toMapParams(inputParamsModel, request);
            InvokeProxy dynamicFormWriteProxy = (InvokeProxy)this.ctx.getBean("DynamicFormWriteProxy");
            Object result = dynamicFormWriteProxy.doHandle(params);
            return this.buildHttpResult(result);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    private Map<String, Object> toMapParams(InputParamsModel inputParamsModel, HttpServletRequest request) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String opType = null;
        if (StringUtils.equalsIgnoreCase((CharSequence)request.getMethod(), (CharSequence)RequestMethod.POST.name())) {
            opType = "create";
        } else if (StringUtils.equalsIgnoreCase((CharSequence)request.getMethod(), (CharSequence)RequestMethod.PATCH.name())) {
            opType = "update";
        }
        Validate.notBlank((CharSequence)opType, (String)"\u4e0d\u652f\u6301[%s] method", (Object[])new Object[]{request.getMethod()});
        params.put("opType", opType);
        params.put("instanceActivityId", inputParamsModel.getInstanceActivityId());
        JSONObject formData = inputParamsModel.getFormData();
        String formInstanceId = formData.getString("formInstanceId");
        params.put("formInstanceId", formInstanceId);
        params.put("formData", formData);
        return params;
    }
}

