/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.controller;

import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.kuiper.starter.service.TemplateMaintainerService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="TemplateMaintainerController")
@RestController
@RequestMapping(value={"/v1/kuiper/templates/maintainer"})
public class TemplateMaintainerController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplateMaintainerController.class);
    @Value(value="${rbac.template.maintainers}")
    private String[] maintainerAccounts;
    @Autowired
    private TemplateMaintainerService templateMaintainerService;

    @ApiOperation(value="\u5177\u6709\u6388\u6743\u6743\u9650\u7684\u4eba\uff0c\u6388\u6743\u7528\u6237\u80fd\u7ef4\u62a4\u5176\u4ed6\u7528\u6237\u521b\u5efa\u7684\u6a21\u677f")
    @PatchMapping(value={"/binding"})
    public ResponseModel updateMaintainers(@ApiParam(name="code", value="\u6307\u5b9a\u7684\u6a21\u677fcode") @RequestParam(name="code") String code, @ApiParam(name="maintainerIds", value="\u7ef4\u62a4\u4eba\u5458\u7684id\u4fe1\u606f(\u6570\u7ec4)") @RequestBody String[] maintainerIds) {
        try {
            Principal principal = this.getPrincipal();
            this.templateMaintainerService.binding(code, maintainerIds, this.maintainerAccounts, principal);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u914d\u7f6e\u6587\u4ef6\u4e2d\u8bbe\u7f6e\u7684\uff0c\u5177\u6709\u6388\u6743\u53d8\u66f4\u6a21\u677f\u4fe1\u606f\u7684\u4eba\u5458")
    @GetMapping(value={"/loadAuthorProps"})
    public ResponseModel findAuthorMaintainers() {
        try {
            if (this.maintainerAccounts == null || this.maintainerAccounts.length == 0) {
                this.maintainerAccounts = new String[]{"admin"};
            }
            List maintainerAccountList = Arrays.stream(this.maintainerAccounts).map(String::trim).collect(Collectors.toList());
            return this.buildHttpResultW(maintainerAccountList, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

