/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.controller;

import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.kuiper.entity.TemplateMigrateImportEntity;
import com.bizunited.platform.kuiper.starter.service.migrate.TemplateMigrateImportService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.security.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(value="TemplateMigrateImportController")
@RestController
@RequestMapping(value={"/v1/formengine/migrationImports"})
public class TemplateMigrateImportController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplateMigrateImportController.class);
    private static final String EXECUTOR = "executor";
    private static final String CREATOR = "creator";
    @Autowired
    private TemplateMigrateImportService templateMigrateImportService;

    @ApiOperation(value="\u6309\u7167\u6761\u4ef6\u641c\u7d22\u4e0a\u4f20\u8bb0\u5f55\uff0c\u4e0d\u652f\u6301\u6a21\u7cca\u67e5\u8be2")
    @GetMapping(value={"/findByConditions"})
    public ResponseModel findByConditions(@ApiParam(name="code", value="\u7f16\u7801") String code, @ApiParam(name="fileName", value="\u6587\u4ef6\u540d") String fileName, @ApiParam(name="creator", value="\u4e0a\u4f20\u4eba\u8d26\u6237") String creator, @ApiParam(name="executed", value="\u662f\u5426\u5df2\u6267\u884c") Boolean executed, @ApiParam(name="executor", value="\u6267\u884c\u4eba\u8d26\u6237") String executor, @PageableDefault(value=50) Pageable pageable) {
        try {
            Page<TemplateMigrateImportEntity> page = this.templateMigrateImportService.findByConditions(pageable, code, fileName, creator, executed, executor);
            return this.buildHttpResultW((Iterable)page, new String[]{CREATOR, EXECUTOR});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4e0a\u4f20\u6587\u4ef6")
    @PostMapping(value={"/upload"})
    public ResponseModel upload(@RequestParam(name="code") @ApiParam(name="code", value="\u7f16\u7801") String code, @RequestParam(name="migrateDesc") @ApiParam(name="migrateDesc", value="\u4e0a\u4f20\u6587\u4ef6\u63cf\u8ff0") String migrateDesc, Principal currentUser, @RequestParam(name="file", required=true) @ApiParam(required=true, name="file", value="\u4e0a\u4f20\u7684\u6587\u4ef6\u5bf9\u8c61") MultipartFile file) {
        try {
            TemplateMigrateImportEntity entity = this.templateMigrateImportService.upload(code, migrateDesc, currentUser, file);
            return this.buildHttpResultW(entity, new String[]{CREATOR, EXECUTOR});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6267\u884c\u67d0\u6b21\u4e0a\u4f20\u6587\u4ef6\u7684\u5bfc\u5165\u4fe1\u606f\u63d2\u5165")
    @PostMapping(value={"/execute"})
    public ResponseModel execute(@RequestParam(name="templateMigrateImportId") @ApiParam(name="templateMigrateImportId", value="\u4e0a\u4f20\u8bb0\u5f55ID") String templateMigrateImportId, Principal currentUser) {
        try {
            TemplateMigrateImportEntity entity = this.templateMigrateImportService.execute(templateMigrateImportId, currentUser);
            return this.buildHttpResultW(entity, new String[]{CREATOR, EXECUTOR});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

