/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.init;

import com.bizunited.platform.core.common.PlatformContext;
import com.bizunited.platform.core.service.init.AbstractCompetenceInitProcess;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="KuiperCompetenceInitProcess")
public class KuiperCompetenceInitProcess
extends AbstractCompetenceInitProcess {
    private static final Logger LOGGER = LoggerFactory.getLogger(KuiperCompetenceInitProcess.class);
    @Autowired
    private PlatformContext platformContext;

    public boolean doProcess() {
        return this.platformContext.isEnableKuiper();
    }

    public void init() {
        try (InputStream is = KuiperCompetenceInitProcess.class.getClassLoader().getResourceAsStream("kuiper-competences.json");){
            super.initCompetences(is);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }
}

