/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.controller.StaticFormProxyController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.core.entity.DataViewEntity;
import com.bizunited.platform.core.entity.DictEntity;
import com.bizunited.platform.core.entity.DictItemEntity;
import com.bizunited.platform.core.entity.OrdinaryFileEntity;
import com.bizunited.platform.core.entity.ServicableMethodEntity;
import com.bizunited.platform.core.entity.UserEntity;
import com.bizunited.platform.core.repository.dynamic.DynamicDataSourceManager;
import com.bizunited.platform.core.service.DictService;
import com.bizunited.platform.core.service.dataview.DataViewService;
import com.bizunited.platform.core.service.image.FileUpdateService;
import com.bizunited.platform.core.service.serviceable.ServicableMethodService;
import com.bizunited.platform.core.service.serviceable.model.InputParamsModel;
import com.bizunited.platform.kuiper.entity.InstanceItemImportEntity;
import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.entity.TemplateGroupEntity;
import com.bizunited.platform.kuiper.entity.TemplateItemEntity;
import com.bizunited.platform.kuiper.entity.TemplateItemExcelEntity;
import com.bizunited.platform.kuiper.entity.TemplateRelationEntity;
import com.bizunited.platform.kuiper.starter.common.excel.ExcelImportVo;
import com.bizunited.platform.kuiper.starter.repository.InstanceItemImportRepository;
import com.bizunited.platform.kuiper.starter.repository.table.TableOperateRepositoryCustom;
import com.bizunited.platform.kuiper.starter.service.InstanceItemImportService;
import com.bizunited.platform.kuiper.starter.service.TemplateGroupService;
import com.bizunited.platform.kuiper.starter.service.TemplateItemExcelService;
import com.bizunited.platform.kuiper.starter.service.TemplateItemService;
import com.bizunited.platform.rbac.server.service.UserService;
import com.bizunited.platform.rbac.server.vo.UserVo;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.security.Principal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.poi.hssf.usermodel.DVConstraint;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataValidation;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.orm.hibernate5.SessionFactoryUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Service(value="InstanceItemImportServiceImpl")
public class InstanceItemImportServiceImpl
implements InstanceItemImportService {
    @Autowired
    private InstanceItemImportRepository instanceItemImportRepository;
    @Autowired
    private TemplateItemService templateItemService;
    @Autowired
    private TemplateGroupService templateGroupService;
    @Autowired
    private DictService dictService;
    @Autowired
    private InstanceItemImportService instanceItemImportService;
    @Autowired
    private TableOperateRepositoryCustom tableOperateRepositoryCustom;
    @Autowired
    private UserService userService;
    @Autowired
    private DataViewService dataViewService;
    @Autowired
    private ServicableMethodService servicableMethodService;
    @Autowired
    private DynamicDataSourceManager dynamicDataSourceManager;
    @Autowired
    private FileUpdateService fileUpdateService;
    @Autowired
    private TemplateItemExcelService templateItemExcelService;
    @Autowired
    private ApplicationContext applicationContext;
    private static final Integer EXCEL_MAX_ROW = 20;
    private static final List<String> DATA_TYPES = Arrays.asList("normal", "view", "service", "local", "dict", "iframe");
    private static final List<String> NUMBERIC = Arrays.asList("java.math.BigDecimal", "java.lang.Integer", "java.lang.Long", "java.lang.Double", "java.lang.Short", "java.lang.Float", "java.lang.Byte");
    private static final String INDEX = "index";
    private static final String EXCEL_INDEX = "excelIndex";
    private static final String LIST = "list";
    private static final String FILE_PATH = "filePath";
    private static final String FILE_NAME = "fileName";
    private static final String TEMPLATE_ITEM_ID = "templateItemId";
    private static final String IS_PREVIEW = "isPreview";
    private static final String DATE_TYPE = "datatype";
    private static final String PROPERTIES = "properties";
    private static final String PROPERTY_DB_NAME = "propertyDbName";
    private static final String PROPERTY_DESC = "propertyDesc";
    private static final String PROPERTY_CLASS_NAME = "propertyClassName";
    private static final String NULLABLE = "nullable";
    private static final String HAS_ERROR = "hasError";
    private static final String PARAMS = "params";
    private static final String PROPERTY_NAME = "propertyName";
    private static final String DICT = "dict";
    private static final String NORMAL = "normal";
    private static final String SERVICE = "service";
    private static final String LOCAL = "local";
    private static final String VIEW = "view";
    private static final String IS_MANY = "isMany";
    private static final String DICT_CODE = "dictCode";
    private static final String DATA_VIEW_CODE = "dataViewCode";
    private static final String PARRENT_ID = "parrentId";
    private static final String STATIC = "static";
    private static final String DYNAMIC = "dynamic";
    private static final String KEYS = "keys";
    private static final String VALUES = "values";
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final String IMPORT_NUM = "importNum";
    private static final String CONTENT = "content";
    private static final String DATA_SOURCE_CODE = "dataSourceCode";
    private static final String METHOD_NAME = "methodName";

    @Override
    @Transactional
    public InstanceItemImportEntity save(InstanceItemImportEntity itemImport) {
        Validate.notNull((Object)itemImport, (String)"\u660e\u7ec6\u5bfc\u5165\u8bb0\u5f55\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)itemImport.getTemplateItemId(), (String)"\u5bfc\u5165\u660e\u7ec6\u6a21\u7248ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)itemImport.getOperator(), (String)"\u5bfc\u5165\u660e\u7ec6\u64cd\u4f5c\u8005\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        itemImport.setImportDate(new Date());
        return (InstanceItemImportEntity)this.instanceItemImportRepository.save(itemImport);
    }

    @Override
    public Page<InstanceItemImportEntity> queryPage(String templateItemId, Pageable pageable) {
        HashMap<String, String> conditions = new HashMap<String, String>();
        Validate.notBlank((CharSequence)templateItemId, (String)"\u67e5\u8be2\u53c2\u6570\u660e\u7ec6\u6a21\u7248ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        conditions.put(TEMPLATE_ITEM_ID, templateItemId);
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        return this.instanceItemImportRepository.queryPage(pageable, conditions);
    }

    @Override
    public JSONObject uploadExample(String templateItemId, MultipartFile file, Integer sheetNum, Integer rowNum, Principal opUser) {
        Validate.notBlank((CharSequence)templateItemId, (String)"\u660e\u7ec6\u6a21\u7248ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        TemplateItemEntity templateItem = this.templateItemService.findDetailsById(templateItemId);
        Validate.notNull((Object)templateItem, (String)"\u660e\u7ec6\u6a21\u7248ID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notNull((Object)rowNum, (String)"\u8bbe\u5b9a\u884c\u9996\u6392\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)file, (String)"\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)opUser, (String)"\u64cd\u4f5c\u8005\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        sheetNum = sheetNum == null ? 0 : sheetNum - 1;
        rowNum = rowNum == null ? 0 : rowNum - 1;
        JSONObject result = new JSONObject();
        JSONArray colArray = this.getExcelHead(file, sheetNum, rowNum);
        result.put(LIST, (Object)colArray);
        List ordinaryFiles = this.fileUpdateService.fileUpload("excelTemplate", opUser.getName(), null, new MultipartFile[]{file});
        Validate.notEmpty((Collection)ordinaryFiles, (String)"\u4fdd\u5b58\u6587\u4ef6\u64cd\u4f5c\u5931\u8d25\uff01", (Object[])new Object[0]);
        OrdinaryFileEntity ordinaryFile = (OrdinaryFileEntity)ordinaryFiles.get(0);
        result.put(FILE_NAME, (Object)ordinaryFile.getFileName());
        result.put(FILE_PATH, (Object)ordinaryFile.getRelativeLocal());
        TemplateItemExcelEntity excelEntity = new TemplateItemExcelEntity();
        excelEntity.setFileName(ordinaryFile.getFileName());
        excelEntity.setOriginalFileName(ordinaryFile.getOriginalFileName());
        excelEntity.setFilePath(ordinaryFile.getRelativeLocal());
        excelEntity.setCreateDate(new Date());
        excelEntity.setTemplateItemId(templateItemId);
        TemplateItemEntity parentItemEntity = this.templateItemService.findParentById(templateItemId);
        Validate.notNull((Object)parentItemEntity, (String)"\u672a\u6839\u636eID\u67e5\u8be2\u5230\u660e\u7ec6\u6a21\u677f\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.isTrue((parentItemEntity.getParentGroup() != null || parentItemEntity.getParentTemplate() != null ? 1 : 0) != 0, (String)"\u672a\u67e5\u8be2\u5230\u8be5\u6a21\u677f\u7684\u7236\u7ea7\u6a21\u677f\u6216\u7236\u7ea7\u5206\u7ec4\u6a21\u677f\uff01", (Object[])new Object[0]);
        excelEntity.setItemPropertyName(templateItem.getPropertyName());
        if (templateItem.getParentTemplate() != null) {
            excelEntity.setTemplateId(templateItem.getParentTemplate().getId());
        } else {
            String groupId = templateItem.getParentGroup().getId();
            excelEntity.setTemplateGroupId(groupId);
            TemplateGroupEntity parentGroup = this.templateGroupService.findParentById(groupId);
            Validate.notNull((Object)parentGroup, (String)"\u672a\u627e\u5230\u8be5\u6a21\u677f\u7684\u7236\u7ea7\u5206\u7ec4\u8868\u5355\u4fe1\u606f\uff01", (Object[])new Object[0]);
            excelEntity.setGroupPropertyName(parentGroup.getPropertyName());
            TemplateEntity parent = parentGroup.getParentTemplate();
            Validate.notNull((Object)parent, (String)"\u672a\u627e\u5230\u6a21\u677f\u7236\u7ea7\u5206\u7ec4\u8868\u5355\u7684\u5173\u8054\u4e3b\u8868\u5355\u4fe1\u606f\uff01", (Object[])new Object[0]);
            excelEntity.setTemplateId(parent.getId());
        }
        this.templateItemExcelService.save(excelEntity);
        return result;
    }

    @Override
    public JSONObject upload(JSONObject jsonObject, HttpServletRequest request, HttpServletResponse response, MultipartFile file, Integer sheetNum, Integer startRow, Integer endRow, Principal opUser, String instanceId, String paramsJson) {
        ServicableMethodEntity servicableMethod;
        Class<?> itemClass;
        JSONObject allResult = new JSONObject();
        this.validateJson(jsonObject);
        Boolean isPreview = jsonObject.getBoolean(IS_PREVIEW);
        Boolean hasError = false;
        sheetNum = sheetNum == null ? 0 : sheetNum - 1;
        startRow = startRow == null ? 1 : startRow - 1;
        endRow = null;
        Workbook wb = this.readExcel(file);
        Validate.notNull((Object)wb, (String)"\u89e3\u6790EXCEL\u6587\u4ef6\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Sheet sheet = wb.getSheetAt(sheetNum.intValue());
        Validate.notNull((Object)sheet, (String)String.format("\u89e3\u6790EXCEL\u7b2c%s\u9875 SHEET\u4e3a\u7a7a\uff01", sheetNum + 1), (Object[])new Object[0]);
        List<JSONObject> propertySort = this.getSortProperties(jsonObject, PROPERTIES, INDEX);
        String itemId = jsonObject.getString(TEMPLATE_ITEM_ID);
        TemplateItemEntity item = this.templateItemService.findDetailsById(itemId);
        Validate.notNull((Object)item, (String)"\u672a\u67e5\u8be2\u6839\u636e\u8868\u5355\u660e\u7ec6ID\u67e5\u8be2\u5230\u660e\u7ec6\u4fe1\u606f\uff01", (Object[])new Object[0]);
        String itemClassName = item.getPropertyClassName();
        Validate.notBlank((CharSequence)itemClassName, (String)"\u672a\u83b7\u53d6\u5230\u660e\u7ec6\u5b9e\u4f53\u7c7b\u540d\u4fe1\u606f\uff01", (Object[])new Object[0]);
        try {
            itemClass = Class.forName(itemClassName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("\u672a\u67e5\u8be2\u5230\u8be5\u660e\u7ec6\u5b9e\u4f53,\u6216\u5b9e\u4f53\u53cd\u5c04\u9519\u8bef\uff01\u9519\u8bef\u4fe1\u606f\uff1a" + e.getMessage());
        }
        Map<Integer, String> errorMaps = new HashMap<Integer, String>();
        List<Object> itemObjects = new ArrayList<Object>();
        ArrayList<Integer> filterObjectIndex = new ArrayList<Integer>();
        Map<String, Object> returnParams = this.readObjectFromExcel(itemObjects, sheet, itemClass, propertySort, startRow, endRow, errorMaps, hasError, filterObjectIndex);
        hasError = (Boolean)returnParams.get(HAS_ERROR);
        Integer readEndNum = (Integer)returnParams.get("endNum");
        String totalError = "";
        String methodName = jsonObject.getString(METHOD_NAME);
        if (StringUtils.isNotBlank((CharSequence)methodName) && !CollectionUtils.isEmpty(itemObjects) && null != (servicableMethod = this.servicableMethodService.findDetailsByName(methodName))) {
            InputParamsModel inputParamsModel = new InputParamsModel();
            inputParamsModel.setServiceName(methodName);
            HashMap<String, Object> objectMap = new HashMap<String, Object>();
            objectMap.put("objects", itemObjects);
            objectMap.put("indexes", filterObjectIndex);
            if (StringUtils.isNotBlank((CharSequence)instanceId)) {
                objectMap.put("instanceId", instanceId);
            }
            if (StringUtils.isNotBlank((CharSequence)paramsJson)) {
                objectMap.put("paramsJson", paramsJson);
            }
            inputParamsModel.setCustomData(objectMap);
            StaticFormProxyController controller = (StaticFormProxyController)this.applicationContext.getBean("StaticFormProxyController");
            ResponseModel result = controller.invoke(inputParamsModel);
            Validate.notNull((Object)result, (String)"EXCEL\u5bfc\u5165\u6267\u884c\u8bbe\u5b9a\u670d\u52a1\u6e90\u540e\uff0c\u8fd4\u56de\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            ExcelImportVo importVo = (ExcelImportVo)result;
            itemObjects = importVo.getObjects();
            List<String> errors = importVo.getErrorMsgs();
            List<Integer> errorIndexes = importVo.getErrorIndexs();
            totalError = importVo.getTotalError();
            errorMaps = this.addSeviceMethodError(errorMaps, errors, errorIndexes);
            if (!CollectionUtils.isEmpty(errors) || StringUtils.isNotBlank((CharSequence)totalError)) {
                hasError = true;
            }
        }
        allResult.put(CONTENT, itemObjects);
        allResult.put(IMPORT_NUM, (Object)itemObjects.size());
        if (Boolean.TRUE.equals(hasError)) {
            allResult.put(HAS_ERROR, (Object)true);
            Integer headRowNum = startRow - 1 < 0 ? 0 : startRow - 1;
            Integer errorCol = this.getErrorCol(sheet, headRowNum);
            wb = this.addErrorMsg(wb, sheetNum, errorMaps, errorCol, totalError, readEndNum);
            this.exportExcel(response, wb, item.getPropertyDesc());
        }
        if (!Boolean.TRUE.equals(isPreview) && !Boolean.TRUE.equals(hasError)) {
            MultipartFile[] files = new MultipartFile[]{file};
            List saveFiles = this.fileUpdateService.fileUpload("", opUser.getName(), null, files);
            Validate.notEmpty((Collection)saveFiles, (String)"\u4e0a\u4f20\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25\uff01", (Object[])new Object[0]);
            OrdinaryFileEntity ordinaryFile = (OrdinaryFileEntity)saveFiles.get(0);
            InstanceItemImportEntity itemImport = new InstanceItemImportEntity();
            String operator = opUser.getName();
            Validate.notBlank((CharSequence)operator, (String)"\u4e0a\u4f20\u9700\u8981\u4f20\u5165\u64cd\u4f5c\u8005account", (Object[])new Object[0]);
            UserVo userVo = this.userService.findByAccount(operator);
            Validate.notNull((Object)userVo, (String)"\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f\uff01", (Object[])new Object[0]);
            UserEntity userEntity = new UserEntity();
            userEntity.setId(userVo.getId());
            itemImport.setTemplateItemId(itemId);
            itemImport.setOperator(userEntity);
            itemImport.setImportDate(new Date());
            itemImport.setImportNum(Integer.valueOf(itemObjects.size()));
            itemImport.setOriginalExcelName(ordinaryFile.getOriginalFileName());
            itemImport.setExcelName(ordinaryFile.getFileName());
            itemImport.setUploadPath(ordinaryFile.getRelativeLocal());
            itemImport.setOrdinaryFileId(ordinaryFile.getId());
            this.instanceItemImportService.save(itemImport);
            allResult.put(HAS_ERROR, (Object)false);
        }
        return allResult;
    }

    private Integer getErrorCol(Sheet sheet, Integer rowNum) {
        Validate.notNull((Object)sheet, (String)"\u8868\u5355\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)rowNum, (String)"\u8bfb\u5165\u4fe1\u606f\u884c\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((rowNum >= 0 ? 1 : 0) != 0, (String)"\u8bfb\u5165\u884c\u6570\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        Integer errorCol = 0;
        Boolean hasData = true;
        Row row = sheet.getRow(rowNum.intValue());
        if (row == null) {
            return errorCol;
        }
        while (Boolean.TRUE.equals(hasData)) {
            Cell cell = row.getCell(errorCol.intValue());
            if (cell == null) {
                hasData = false;
            } else {
                String value = cell.getStringCellValue();
                if (StringUtils.isBlank((CharSequence)value)) {
                    hasData = false;
                }
            }
            Integer n = errorCol;
            Integer n2 = errorCol = Integer.valueOf(errorCol + 1);
        }
        return errorCol - 1;
    }

    @Override
    public void downloadItems(JSONObject jsonObject, HttpServletResponse response) {
        this.validateJson(jsonObject);
        String itemId = jsonObject.getString(TEMPLATE_ITEM_ID);
        TemplateItemEntity item = this.templateItemService.findDetailsById(itemId);
        List<JSONObject> propertySort = this.getSortProperties(jsonObject, PROPERTIES, INDEX);
        HSSFWorkbook workbook = this.createWorkBook(jsonObject);
        HSSFSheet sheet = workbook.getSheetAt(0);
        if (item.getType().equals(STATIC)) {
            workbook = this.downloadStaticItems(jsonObject);
        } else if (item.getType().equals(DYNAMIC)) {
            this.downloadDynamicItems(jsonObject, sheet, propertySort);
        }
        this.exportExcel(response, (Workbook)workbook, item.getPropertyDesc());
    }

    private <T> Map<String, Object> readObjectFromExcel(List<Object> itemObjects, Sheet sheet, Class<T> classType, List<JSONObject> sortedProperties, Integer startRow, Integer endRow, Map<Integer, String> errorMsg, Boolean hasError, List<Integer> filterObjectIndex) {
        Boolean hasNextRow = this.hasNextRow(sheet, startRow, sortedProperties, endRow);
        Integer readRowNum = startRow;
        while (Boolean.TRUE.equals(hasNextRow)) {
            Boolean thisRowError = false;
            Row row = sheet.getRow(readRowNum.intValue());
            hasNextRow = this.hasNextRow(sheet, readRowNum + 1, sortedProperties, endRow);
            JSONObject itemJson = new JSONObject();
            for (JSONObject colJson : sortedProperties) {
                List<String> keys;
                String value;
                Integer excelIndex = colJson.getInteger(EXCEL_INDEX) - 1;
                String dataType = colJson.getString(DATE_TYPE);
                if (!Boolean.TRUE.equals(colJson.getBoolean(NULLABLE)) && StringUtils.isBlank((CharSequence)(value = this.getCellValue(row.getCell(excelIndex.intValue()))))) {
                    errorMsg.put(readRowNum, StringUtils.join((Object[])new String[]{errorMsg.get(readRowNum), String.format("\u7b2c%s\u9879\u6570\u636e\u4e3a\u5fc5\u586b\u9879\uff0c\u8bf7\u68c0\u67e5\uff01", excelIndex + 1)}));
                    hasError = true;
                    break;
                }
                if (StringUtils.equals((CharSequence)dataType, (CharSequence)NORMAL)) {
                    String propertyClassName = colJson.getString(PROPERTY_CLASS_NAME);
                    if (NUMBERIC.contains(propertyClassName)) {
                        if (row.getCell(excelIndex.intValue()) != null && !StringUtils.isBlank((CharSequence)this.getCellValue(row.getCell(excelIndex.intValue())))) {
                            String value2;
                            Boolean isNumberic = this.getCellValue(row.getCell(excelIndex.intValue())).matches("-?[0-9]+.*[0-9]*");
                            if (!Boolean.TRUE.equals(isNumberic)) {
                                errorMsg.put(readRowNum, StringUtils.join((Object[])new String[]{errorMsg.get(readRowNum), String.format("\u7b2c%s\u9879\u6570\u636e\u8981\u6c42\u4e3a\u6570\u5b57\uff0c\u8bf7\u68c0\u67e5\uff01", excelIndex + 1)}));
                                thisRowError = true;
                                break;
                            }
                            if (StringUtils.equals((CharSequence)propertyClassName, (CharSequence)"java.math.BigDecimal")) {
                                value2 = this.getCellValue(row.getCell(excelIndex.intValue()));
                                itemJson.put(colJson.getString(PROPERTY_NAME), (Object)new BigDecimal(value2));
                            }
                            if (StringUtils.equals((CharSequence)propertyClassName, (CharSequence)"java.lang.Integer")) {
                                value2 = this.getCellValue(row.getCell(excelIndex.intValue()));
                                itemJson.put(colJson.getString(PROPERTY_NAME), (Object)Integer.valueOf(value2));
                            }
                            if (StringUtils.equals((CharSequence)propertyClassName, (CharSequence)"java.lang.Long")) {
                                itemJson.put(colJson.getString(PROPERTY_NAME), (Object)Long.valueOf(row.getCell(excelIndex.intValue()).getStringCellValue()));
                            }
                            if (StringUtils.equals((CharSequence)propertyClassName, (CharSequence)"java.lang.Double")) {
                                itemJson.put(colJson.getString(PROPERTY_NAME), (Object)Double.valueOf(row.getCell(excelIndex.intValue()).getStringCellValue()));
                            }
                            if (StringUtils.equals((CharSequence)propertyClassName, (CharSequence)"java.lang.Short")) {
                                itemJson.put(colJson.getString(PROPERTY_NAME), (Object)Short.valueOf(row.getCell(excelIndex.intValue()).getStringCellValue()));
                            }
                            if (StringUtils.equals((CharSequence)propertyClassName, (CharSequence)"java.lang.Float")) {
                                itemJson.put(colJson.getString(PROPERTY_NAME), (Object)Float.valueOf(row.getCell(excelIndex.intValue()).getStringCellValue()));
                            }
                            if (StringUtils.equals((CharSequence)propertyClassName, (CharSequence)"java.lang.Byte")) {
                                itemJson.put(colJson.getString(PROPERTY_NAME), (Object)Byte.valueOf(row.getCell(excelIndex.intValue()).getStringCellValue()));
                            }
                        }
                    } else if (row.getCell(excelIndex.intValue()) != null && !StringUtils.isBlank((CharSequence)this.getCellValue(row.getCell(excelIndex.intValue())))) {
                        itemJson.put(colJson.getString(PROPERTY_NAME), (Object)this.getCellValue(row.getCell(excelIndex.intValue())));
                    }
                }
                if (StringUtils.equals((CharSequence)dataType, (CharSequence)VIEW)) {
                    itemJson.put(colJson.getString(PROPERTY_NAME), (Object)this.getCellValue(row.getCell(excelIndex.intValue())));
                }
                if (StringUtils.equals((CharSequence)dataType, (CharSequence)DICT)) {
                    JSONObject dictJson = colJson.getJSONObject(dataType);
                    Page dicts = this.dictService.findByConditions(dictJson.getString(DICT_CODE), null, null, null, (Pageable)PageRequest.of((int)0, (int)50));
                    DictEntity dict = (DictEntity)dicts.getContent().get(0);
                    keys = dict.getDictItemEntities().stream().map(DictItemEntity::getDictKey).collect(Collectors.toList());
                    if (row.getCell(excelIndex.intValue()) != null && !StringUtils.isBlank((CharSequence)this.getCellValue(row.getCell(excelIndex.intValue())))) {
                        String readKey = this.getCellValue(row.getCell(excelIndex.intValue()));
                        if (keys.contains(readKey)) {
                            List dictItem = dict.getDictItemEntities().stream().filter(o -> o.getDictKey().equals(row.getCell(excelIndex.intValue()).getStringCellValue())).collect(Collectors.toList());
                            Validate.isTrue((!CollectionUtils.isEmpty(dictItem) ? 1 : 0) != 0, (String)"\u586b\u5165\u503c\u4e0d\u5339\u914d\u5b57\u5178\u4e2d", (Object[])new Object[0]);
                            itemJson.put(colJson.getString(PROPERTY_NAME), (Object)((DictItemEntity)dictItem.get(0)).getDictValue());
                        } else {
                            errorMsg.put(readRowNum, StringUtils.join((Object[])new String[]{errorMsg.get(readRowNum), String.format("\u7b2c%s\u5217\u586b\u5165\u503c\u672a\u5728\u8bbe\u5b9a\u5b57\u5178\u91cc\uff0c\u8bf7\u68c0\u67e5\uff01", excelIndex + 1)}));
                            thisRowError = true;
                            break;
                        }
                    }
                }
                if (StringUtils.equals((CharSequence)dataType, (CharSequence)SERVICE)) {
                    itemJson.put(colJson.getString(PROPERTY_NAME), (Object)this.getCellValue(row.getCell(excelIndex.intValue())));
                }
                if (!StringUtils.equals((CharSequence)dataType, (CharSequence)LOCAL)) continue;
                JSONObject kvJson = colJson.getJSONObject(dataType);
                String keysStr = kvJson.getString(KEYS);
                String valuesStr = kvJson.getString(VALUES);
                keys = Arrays.asList(StringUtils.split((String)keysStr, (String)","));
                List<String> values = Arrays.asList(StringUtils.split((String)valuesStr, (String)","));
                if (row.getCell(excelIndex.intValue()) == null || StringUtils.isBlank((CharSequence)this.getCellValue(row.getCell(excelIndex.intValue())))) continue;
                String cellValue = this.getCellValue(row.getCell(excelIndex.intValue()));
                if (keys.contains(cellValue)) {
                    itemJson.put(colJson.getString(PROPERTY_NAME), (Object)values.get(keys.indexOf(cellValue)));
                    continue;
                }
                errorMsg.put(readRowNum, StringUtils.join((Object[])new String[]{errorMsg.get(readRowNum), String.format("\u7b2c%s\u5217\u586b\u5165\u503c\u672a\u5728\u8bbe\u5b9a\u672c\u5730\u6570\u636e\u91cc\uff0c\u8bf7\u68c0\u67e5\uff01", excelIndex + 1)}));
                thisRowError = true;
                break;
            }
            if (!Boolean.TRUE.equals(thisRowError)) {
                String itemJsonStr = itemJson.toJSONString();
                ObjectMapper om = new ObjectMapper();
                try {
                    Object itemObject = om.readValue(itemJsonStr, classType);
                    itemObjects.add(itemObject);
                    filterObjectIndex.add(readRowNum);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("\u5bfc\u5165\u6570\u636e\u8f6c\u6362\u4e2d\u53d1\u751f\u9519\u8bef\uff01\u539f\u56e0\uff1a" + e.getMessage());
                }
            }
            if (Boolean.TRUE.equals(thisRowError)) {
                hasError = true;
            }
            readRowNum = readRowNum + 1;
        }
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        returnMap.put(HAS_ERROR, hasError);
        returnMap.put("endNum", readRowNum);
        return returnMap;
    }

    private Workbook addErrorMsg(Workbook wb, Integer sheetNum, Map<Integer, String> errorMsg, Integer errorCol, String totalError, Integer readEndRow) {
        Row row;
        Sheet sheet = wb.getSheetAt(sheetNum.intValue());
        Set<Integer> rowNums = errorMsg.keySet();
        CellStyle red = wb.createCellStyle();
        Font font = wb.createFont();
        font.setColor((short)10);
        red.setFont(font);
        for (Integer rowNum : rowNums) {
            Cell cell;
            Row row2 = sheet.getRow(rowNum.intValue());
            if (row2 == null) {
                row2 = sheet.createRow(rowNum.intValue());
            }
            if ((cell = row2.getCell(errorCol.intValue())) == null) {
                cell = row2.createCell(errorCol.intValue());
            }
            cell.setCellStyle(red);
            cell.setCellValue(errorMsg.get(rowNum));
        }
        if (null != readEndRow && StringUtils.isNotBlank((CharSequence)totalError) && (row = sheet.getRow(readEndRow.intValue())) == null) {
            row = sheet.createRow(readEndRow.intValue());
            Cell cell = row.getCell(0);
            if (cell == null) {
                cell = row.createCell(0);
            }
            cell.setCellStyle(red);
            cell.setCellValue(totalError);
        }
        return wb;
    }

    private Workbook readExcel(MultipartFile file) {
        XSSFWorkbook wb;
        block4: {
            wb = null;
            try {
                InputStream in = file.getInputStream();
                String fileName = file.getOriginalFilename();
                Validate.notBlank((CharSequence)fileName, (String)"\u4e0a\u4f20\u6587\u4ef6\u6587\u4ef6\u540d\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
                if (StringUtils.endsWith((CharSequence)fileName, (CharSequence)".xlsx")) {
                    wb = new XSSFWorkbook(in);
                    break block4;
                }
                if (StringUtils.endsWith((CharSequence)fileName, (CharSequence)".xls")) {
                    wb = new HSSFWorkbook(in);
                    break block4;
                }
                throw new IllegalArgumentException("\u4e0a\u4f20\u6587\u4ef6\u4e0d\u662fExcel\u6587\u4ef6!");
            }
            catch (IOException e) {
                throw new IllegalArgumentException("\u89e3\u6790\u4e0a\u4f20\u6587\u4ef6\u53d1\u751f\u9519\u8bef\uff01\u9519\u8bef\u539f\u56e0\uff1a" + e.getMessage());
            }
        }
        return wb;
    }

    private JSONArray getExcelHead(MultipartFile file, Integer sheetNum, Integer rowNum) {
        sheetNum = sheetNum == null ? 0 : sheetNum;
        rowNum = rowNum == null ? 0 : rowNum;
        Validate.notNull((Object)file, (String)"\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Workbook workbook = this.readExcel(file);
        Validate.notNull((Object)workbook, (String)"\u89e3\u6790EXCEL\u6587\u4ef6\u51fa\u9519\uff01", (Object[])new Object[0]);
        Sheet sheet = workbook.getSheetAt(sheetNum.intValue());
        Validate.notNull((Object)sheet, (String)String.format("\u672a\u5728EXCEL\u9875\u7801%s\u4e2d\u627e\u5230\u5bf9\u5e94\u8868\u5355", sheetNum), (Object[])new Object[0]);
        Row row = sheet.getRow(rowNum.intValue());
        Validate.notNull((Object)row, (String)String.format("\u672a\u5728EXCEL\u6587\u4ef6\u7b2c%s\u9875\u4e2d\u627e\u5230\u5bf9\u5e94%s\u884c\u4fe1\u606f", sheetNum + 1, rowNum + 1), (Object[])new Object[0]);
        JSONArray colArray = new JSONArray();
        String cellValue = "notBlank";
        Integer colNum = 0;
        while (!StringUtils.isBlank((CharSequence)cellValue)) {
            JSONObject item = new JSONObject();
            Cell cell = row.getCell(colNum.intValue());
            colNum = colNum + 1;
            if (cell == null || StringUtils.isBlank((CharSequence)this.getCellValue(cell))) {
                cellValue = "";
                continue;
            }
            item.put(String.valueOf(colNum), (Object)this.getCellValue(cell));
            colArray.add((Object)item);
        }
        return colArray;
    }

    private List<JSONObject> getSortProperties(JSONObject jsonObject, String propertyName, String indexName) {
        JSONArray properties = jsonObject.getJSONArray(propertyName);
        List propertyList = properties.toJavaList(JSONObject.class);
        return propertyList.stream().filter(o -> null != o.getInteger(indexName) && o.getInteger(EXCEL_INDEX) != null && -1 != o.getInteger(EXCEL_INDEX)).sorted(Comparator.comparing(o -> o.getInteger(indexName))).collect(Collectors.toList());
    }

    private HSSFWorkbook createWorkBook(JSONObject jsonObject) {
        String itemId = jsonObject.getString(TEMPLATE_ITEM_ID);
        TemplateItemEntity item = this.templateItemService.findDetailsById(itemId);
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(item.getPropertyDesc());
        int sheetRowNum = 0;
        sheet = this.writeHEAD(sheet, sheetRowNum, item);
        JSONArray properties = jsonObject.getJSONArray(PROPERTIES);
        List propertyList = properties.toJavaList(JSONObject.class);
        List propertySort = propertyList.stream().filter(o -> null != o.getInteger(INDEX)).sorted(Comparator.comparing(o -> o.getInteger(INDEX))).collect(Collectors.toList());
        Integer propertySize = propertySort.size();
        sheet = this.initSheet(sheet, ++sheetRowNum, sheetRowNum + EXCEL_MAX_ROW + 1, 0, propertySize);
        HSSFRow secoundRow = sheet.getRow(sheetRowNum);
        for (int colNum = 0; colNum < propertySize; ++colNum) {
            JSONObject colJson = (JSONObject)propertySort.get(colNum);
            secoundRow.createCell(colNum).setCellValue(colJson.getString(PROPERTY_DESC));
            String dataType = colJson.getString(DATE_TYPE);
            if (dataType.equals(LOCAL)) {
                JSONObject kvJson = colJson.getJSONObject(dataType);
                String keysStr = kvJson.getString(KEYS);
                sheet = this.setHSSFValidation(sheet, StringUtils.split((String)keysStr, (String)","), sheetRowNum, sheetRowNum + EXCEL_MAX_ROW, colNum, colNum);
            }
            if (!dataType.equals(DICT)) continue;
            JSONObject dictJson = colJson.getJSONObject(DICT);
            Page dicts = this.dictService.findByConditions(dictJson.getString(DICT_CODE), null, null, null, (Pageable)PageRequest.of((int)0, (int)50));
            DictEntity dict = (DictEntity)dicts.getContent().get(0);
            List keys = dict.getDictItemEntities().stream().map(DictItemEntity::getDictKey).collect(Collectors.toList());
            sheet = this.setHSSFValidation(sheet, (String[])keys.stream().toArray(String[]::new), sheetRowNum, sheetRowNum + EXCEL_MAX_ROW, colNum, colNum);
        }
        this.setAreaBorder(sheet, workbook, sheetRowNum, sheetRowNum + EXCEL_MAX_ROW, 0, propertySize - 1);
        return workbook;
    }

    private Boolean hasNextRow(Sheet sheet, Integer currentRow, List<JSONObject> propertySort, Integer endRow) {
        if (endRow != null && currentRow > endRow) {
            return false;
        }
        Row row = sheet.getRow(currentRow.intValue());
        if (row == null) {
            return false;
        }
        for (JSONObject colJson : propertySort) {
            Cell cell = row.getCell(colJson.getInteger(EXCEL_INDEX) - 1);
            if (cell == null || !StringUtils.isNotBlank((CharSequence)this.getCellValue(cell))) continue;
            return true;
        }
        return false;
    }

    private void exportExcel(HttpServletResponse response, Workbook workbook, String fileName) {
        try {
            response.setContentType("application/octet-stream;charset=utf-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName + ".xls", "utf-8"));
            response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
            ServletOutputStream outputStream = response.getOutputStream();
            workbook.write((OutputStream)outputStream);
            outputStream.flush();
            outputStream.close();
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private HSSFSheet setHSSFValidation(HSSFSheet sheet, String[] textlist, int firstRow, int endRow, int firstCol, int endCol) {
        DVConstraint constraint = DVConstraint.createExplicitListConstraint((String[])textlist);
        CellRangeAddressList regions = new CellRangeAddressList(firstRow, endRow, firstCol, endCol);
        HSSFDataValidation dataValidationList = new HSSFDataValidation(regions, (DataValidationConstraint)constraint);
        sheet.addValidationData((DataValidation)dataValidationList);
        return sheet;
    }

    private HSSFSheet initSheet(HSSFSheet sheet, int firstRow, int endRow, int firstCol, int endCol) {
        for (int rowNum = firstRow; rowNum <= endRow; ++rowNum) {
            HSSFRow row = sheet.createRow(rowNum);
            for (int colNum = firstCol; colNum <= endCol; ++colNum) {
                row.createCell(colNum);
            }
        }
        return sheet;
    }

    private HSSFSheet setAreaBorder(HSSFSheet sheet, HSSFWorkbook workbook, int firstRow, int endRow, int firstCol, int endCol) {
        int i;
        HSSFCellStyle styleLeft = workbook.createCellStyle();
        HSSFCellStyle styleRight = workbook.createCellStyle();
        HSSFCellStyle styleTop = workbook.createCellStyle();
        HSSFCellStyle styleBottom = workbook.createCellStyle();
        styleLeft.setBorderLeft(BorderStyle.THIN);
        styleRight.setBorderRight(BorderStyle.THIN);
        styleTop.setBorderTop(BorderStyle.THIN);
        styleBottom.setBorderBottom(BorderStyle.THIN);
        HSSFCellStyle styleLeftTop = workbook.createCellStyle();
        styleLeftTop.setBorderLeft(BorderStyle.THIN);
        styleLeftTop.setBorderTop(BorderStyle.THIN);
        HSSFCellStyle styleTopRight = workbook.createCellStyle();
        styleTopRight.setBorderRight(BorderStyle.THIN);
        styleTopRight.setBorderTop(BorderStyle.THIN);
        HSSFCellStyle styleLeftButtom = workbook.createCellStyle();
        styleLeftButtom.setBorderLeft(BorderStyle.THIN);
        styleLeftButtom.setBorderBottom(BorderStyle.THIN);
        HSSFCellStyle styleButtomRight = workbook.createCellStyle();
        styleButtomRight.setBorderRight(BorderStyle.THIN);
        styleButtomRight.setBorderBottom(BorderStyle.THIN);
        for (i = firstRow; i <= endRow; ++i) {
            HSSFCell cellLeft = sheet.getRow(i).getCell(firstCol);
            cellLeft.setCellStyle(styleLeft);
            HSSFCell cellRight = sheet.getRow(i).getCell(endCol);
            cellRight.setCellStyle(styleRight);
        }
        for (i = firstCol; i <= endCol; ++i) {
            HSSFCell cellTop = sheet.getRow(firstRow).getCell(i);
            cellTop.setCellStyle(styleTop);
            HSSFCell cellBottom = sheet.getRow(endRow).getCell(i);
            cellBottom.setCellStyle(styleBottom);
        }
        HSSFCell cellLeftTop = sheet.getRow(firstRow).getCell(firstCol);
        cellLeftTop.setCellStyle(styleLeftTop);
        HSSFCell cellRightTop = sheet.getRow(firstRow).getCell(endCol);
        cellRightTop.setCellStyle(styleTopRight);
        HSSFCell cellLeftBottom = sheet.getRow(endRow).getCell(firstCol);
        cellLeftBottom.setCellStyle(styleLeftButtom);
        HSSFCell cellRightBottom = sheet.getRow(endRow).getCell(endCol);
        cellRightBottom.setCellStyle(styleButtomRight);
        return sheet;
    }

    private String getCellValue(Cell cell) {
        if (cell == null) {
            return "";
        }
        CellType type = cell.getCellType();
        if (type == null) {
            type = CellType.STRING;
        }
        String value = "";
        if (type.equals((Object)CellType.NUMERIC)) {
            value = String.valueOf((long)cell.getNumericCellValue());
        } else if (type.equals((Object)CellType.STRING)) {
            value = cell.getStringCellValue();
        } else if (type.equals((Object)CellType.BOOLEAN)) {
            value = String.valueOf(cell.getBooleanCellValue());
        }
        return value;
    }

    private void validateJson(JSONObject json) {
        String itemId = json.getString(TEMPLATE_ITEM_ID);
        Validate.notBlank((CharSequence)itemId, (String)"\u6a21\u7248\u660e\u7ec6ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Boolean isPreview = json.getBoolean(IS_PREVIEW);
        Validate.notNull((Object)isPreview, (String)"JSON\u4e2d\u7f3a\u5931\u53c2\u6570\uff1aisPreview\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        TemplateItemEntity item = this.templateItemService.findDetailsById(itemId);
        Validate.notNull((Object)item, (String)"\u672a\u627e\u5230\u8be5\u6a21\u7248\u660e\u7ec6\uff01", (Object[])new Object[0]);
        JSONArray properties = json.getJSONArray(PROPERTIES);
        Validate.isTrue((properties != null && !CollectionUtils.isEmpty((Collection)properties) ? 1 : 0) != 0, (String)"\u4f20\u5165\u5c5e\u6027\u96c6\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List propertyList = properties.toJavaList(JSONObject.class);
        Validate.notEmpty((Collection)propertyList, (String)"\u4f20\u5165\u5c5e\u6027\u96c6\u8f6c\u6362\u540e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List propertySort = propertyList.stream().filter(o -> null != o.getInteger(INDEX)).sorted(Comparator.comparing(o -> o.getInteger(INDEX))).collect(Collectors.toList());
        Validate.notEmpty(propertySort, (String)"\u4f20\u5165\u5c5e\u6027\u96c6\u4e2d\u5fc5\u987b\u586b\u5165\u6392\u5e8f\u503c", (Object[])new Object[0]);
        for (JSONObject colJson : propertySort) {
            List<String> keys;
            Integer index = colJson.getInteger(INDEX);
            Validate.notNull((Object)index, (String)"\u672a\u83b7\u53d6\u5230\u660e\u7ec6\u6392\u5e8f\uff01", (Object[])new Object[0]);
            String propertyName = colJson.getString(PROPERTY_NAME);
            Validate.notBlank((CharSequence)propertyName, (String)String.format("\u7b2c%s\u5c5e\u6027\u672a\u83b7\u53d6\u5230\u5c5e\u6027\u540d", index), (Object[])new Object[0]);
            String dataType = colJson.getString(DATE_TYPE);
            Validate.isTrue((StringUtils.isNotEmpty((CharSequence)dataType) && DATA_TYPES.contains(dataType) ? 1 : 0) != 0, (String)String.format("\u5c5e\u6027%s\u6570\u636e\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5", colJson.get((Object)PROPERTY_NAME)), (Object[])new Object[0]);
            Boolean nullable = colJson.getBoolean(NULLABLE);
            Validate.isTrue((nullable != null ? 1 : 0) != 0, (String)String.format("\u7b2c%s\u5c5e\u6027\u672a\u83b7\u53d6\u5230\u662f\u5426\u5fc5\u586b", index), (Object[])new Object[0]);
            if (dataType.equals(NORMAL)) {
                String propertyClassName = colJson.getString(PROPERTY_CLASS_NAME);
                Validate.notBlank((CharSequence)propertyClassName, (String)String.format("\u4e00\u822c\u5c5e\u6027\u5b57\u6bb5%s\u4e2d\u672a\u6807\u6ce8\u7c7b\u578b\uff01", colJson.getString(PROPERTY_NAME)), (Object[])new Object[0]);
            }
            if (dataType.equals(VIEW)) {
                JSONObject viewJson = colJson.getJSONObject(dataType);
                Boolean isMany = viewJson.getBoolean(IS_MANY);
                Validate.notNull((Object)isMany, (String)"%s\u5217\u8be5\u6570\u636e\u89c6\u56fe\u7f3a\u5c11isMany\u5c5e\u6027", (Object[])new Object[0]);
                String viewPropertyName = viewJson.getString(PROPERTY_NAME);
                Validate.notBlank((CharSequence)viewPropertyName, (String)String.format("\u7b2c%s\u5217\u4e2d\u672a\u6807\u6ce8\u6570\u636e\u89c6\u56fe\u9009\u4e2d\u5c5e\u6027\u540d\uff01", index), (Object[])new Object[0]);
            }
            if (dataType.equals(DICT)) {
                JSONObject dictJson = colJson.getJSONObject(dataType);
                Validate.notNull((Object)dictJson, (String)"\u6240\u8bbe\u5b9a\u7684\u5b57\u5178\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)dictJson.getString(DICT_CODE), (String)"\u6240\u8bbe\u5b9a\u7684\u5b57\u5178\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Page dicts = this.dictService.findByConditions(dictJson.getString(DICT_CODE), null, null, null, (Pageable)PageRequest.of((int)0, (int)50));
                Validate.notNull((Object)dicts, (String)"\u6240\u67e5\u8be2\u7684\u5b57\u5178\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                Validate.isTrue((dicts.getTotalElements() == 1L ? 1 : 0) != 0, (String)"\u6839\u636e\u7f16\u7801\u67e5\u8be2\u51fa\u7684\u5b57\u5178\u4e0d\u552f\u4e00\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
                DictEntity dict = (DictEntity)dicts.getContent().get(0);
                keys = dict.getDictItemEntities().stream().map(DictItemEntity::getDictKey).collect(Collectors.toList());
                Validate.notEmpty(keys, (String)"\u67e5\u8be2\u51fa\u5b57\u5178KEY\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            }
            if (!dataType.equals(LOCAL)) continue;
            JSONObject kvJson = colJson.getJSONObject(dataType);
            String keysStr = kvJson.getString(KEYS);
            String valuesStr = kvJson.getString(VALUES);
            Validate.notNull((Object)keysStr, (String)"\u5c5e\u6027\u8bbe\u5b9a\u7684key\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)valuesStr, (String)"\u5c5e\u6027\u8bbe\u5b9a\u7684values\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            keys = Arrays.asList(StringUtils.split((String)keysStr, (String)","));
            List<String> values = Arrays.asList(StringUtils.split((String)valuesStr, (String)","));
            Validate.isTrue((keys.size() == values.size() ? 1 : 0) != 0, (String)"\u4f20\u5165\u672c\u5730\u6570\u636e\u952e\u503c\u5bf9\u4e0d\u5339\u914d!", (Object[])new Object[0]);
        }
    }

    private HSSFSheet writeHEAD(HSSFSheet sheet, Integer rowNum, TemplateItemEntity item) {
        HSSFRow headRow = sheet.createRow(rowNum.intValue());
        headRow.createCell(0).setCellValue("\u660e\u7ec6\u540d\u79f0\uff1a");
        headRow.createCell(1).setCellValue(item.getPropertyName());
        headRow.createCell(2).setCellValue("\u660e\u7ec6\u63cf\u8ff0\uff1a");
        headRow.createCell(3).setCellValue(item.getPropertyDesc());
        headRow.createCell(4).setCellValue("\u65f6\u95f4\uff1a");
        headRow.createCell(5).setCellValue(new Date().toString());
        return sheet;
    }

    private HSSFWorkbook downloadStaticItems(JSONObject jsonObject) {
        HSSFWorkbook workbook = new HSSFWorkbook();
        String dataViewCode = jsonObject.getString(DATA_VIEW_CODE);
        DataViewEntity dataView = this.dataViewService.findDetailsByCode(dataViewCode);
        Validate.notNull((Object)dataView, (String)"\u672a\u627e\u5230\u6240\u8bbe\u5b9a\u7684\u6570\u636e\u89c6\u56fe\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        String dataSourceCode = jsonObject.getString(DATA_SOURCE_CODE);
        String nativeSql = dataView.getSourceSql();
        JSONArray paramsArray = jsonObject.getJSONArray(PARAMS);
        if (!CollectionUtils.isEmpty((Collection)paramsArray)) {
            List paramsList = paramsArray.toJavaList(JSONObject.class);
            for (JSONObject o : paramsList) {
                String paramName = o.getString(NAME);
                String paramValue = o.getString(VALUE);
                String replaceParamName = String.format("{:%s}", paramName);
                String replaceParamValue = String.format("'%s'", paramValue);
                nativeSql = nativeSql.replace(replaceParamName, replaceParamValue);
            }
        }
        if (StringUtils.isBlank((CharSequence)dataSourceCode)) {
            List<?> result = this.tableOperateRepositoryCustom.executeQuerySql(nativeSql);
            HSSFSheet sheet = workbook.createSheet();
            int rowIndex = 0;
            for (Object obj : result) {
                HSSFRow row = sheet.createRow(rowIndex);
                String objJsonStr = JSON.toJSONString(obj);
                List jsonArray = JSON.parseArray((String)objJsonStr, String.class);
                if (!CollectionUtils.isEmpty((Collection)jsonArray)) {
                    for (int i = 0; i < jsonArray.size(); ++i) {
                        row.createCell(i).setCellValue((String)jsonArray.get(i));
                    }
                }
                ++rowIndex;
            }
        } else {
            SessionFactory sessionFactory = this.dynamicDataSourceManager.getCurrentSessionFactory(dataSourceCode);
            Validate.notNull((Object)sessionFactory, (String)"\u672a\u627e\u5230\u8be5\u6570\u636e\u6e90\uff01", (Object[])new Object[0]);
            DataSource dataSource = SessionFactoryUtils.getDataSource((SessionFactory)sessionFactory);
            HSSFSheet sheet = workbook.createSheet();
            try (Connection connection = dataSource.getConnection();
                 Statement statement = connection.createStatement();
                 ResultSet result = statement.executeQuery(nativeSql);){
                int rowIndex = 0;
                while (result.next()) {
                    HSSFRow row = sheet.createRow(rowIndex);
                    String objJsonStr = JSON.toJSONString((Object)result.getObject(rowIndex));
                    List jsonArray = JSON.parseArray((String)objJsonStr, String.class);
                    if (!CollectionUtils.isEmpty((Collection)jsonArray)) {
                        for (int i = 0; i < jsonArray.size(); ++i) {
                            row.createCell(i).setCellValue((String)jsonArray.get(i));
                        }
                    }
                    ++rowIndex;
                }
            }
            catch (SQLException e) {
                throw new IllegalStateException("SQL\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5!\u8be6\u60c5\uff1a" + e.getMessage());
            }
        }
        return workbook;
    }

    private void downloadDynamicItems(JSONObject jsonObject, HSSFSheet sheet, List<JSONObject> propertySort) {
        List<?> result = this.queryDynamicItems(jsonObject);
        Integer rowNum = 2;
        for (Object resultRow : result) {
            String strJson = JSON.toJSONString(resultRow);
            List strList = JSON.parseArray((String)strJson, String.class);
            HSSFRow row = sheet.getRow(rowNum.intValue());
            Integer colNum = 0;
            while (colNum < strList.size()) {
                String key;
                List<String> values;
                List<String> keys;
                JSONObject colJson = propertySort.get(colNum);
                String dataType = colJson.getString(DATE_TYPE);
                if (dataType.equals(NORMAL)) {
                    row.getCell(colNum.intValue()).setCellValue((String)strList.get(colNum));
                }
                if (dataType.equals(VIEW)) {
                    row.getCell(colNum.intValue()).setCellValue((String)strList.get(colNum));
                }
                if (dataType.equals(DICT)) {
                    JSONObject dictJson = colJson.getJSONObject(DICT);
                    Page dicts = this.dictService.findByConditions(dictJson.getString(DICT_CODE), null, null, null, (Pageable)PageRequest.of((int)0, (int)50));
                    DictEntity dict = (DictEntity)dicts.getContent().get(0);
                    keys = dict.getDictItemEntities().stream().map(DictItemEntity::getDictKey).collect(Collectors.toList());
                    values = dict.getDictItemEntities().stream().map(DictItemEntity::getDictKey).collect(Collectors.toList());
                    if (values.contains(strList.get(colNum))) {
                        key = keys.get(values.indexOf(strList.get(colNum)));
                        row.getCell(colNum.intValue()).setCellValue(key);
                    } else {
                        row.getCell(colNum.intValue()).setCellValue((String)strList.get(colNum));
                    }
                }
                if (dataType.equals(SERVICE)) {
                    row.getCell(colNum.intValue()).setCellValue((String)strList.get(colNum));
                }
                if (dataType.equals(LOCAL)) {
                    JSONObject kvJson = colJson.getJSONObject(dataType);
                    String keysStr = kvJson.getString(KEYS);
                    String valuesStr = kvJson.getString(VALUES);
                    keys = Arrays.asList(StringUtils.split((String)keysStr, (String)","));
                    values = Arrays.asList(StringUtils.split((String)valuesStr, (String)","));
                    if (values.contains(strList.get(colNum))) {
                        key = keys.get(values.indexOf(strList.get(colNum)));
                        row.getCell(colNum.intValue()).setCellValue(key);
                    } else {
                        row.getCell(colNum.intValue()).setCellValue((String)strList.get(colNum));
                    }
                }
                Integer n = colNum;
                Integer n2 = colNum = Integer.valueOf(colNum + 1);
            }
            rowNum = rowNum + 1;
        }
    }

    private List<?> queryDynamicItems(JSONObject jsonObject) {
        String itemId = jsonObject.getString(TEMPLATE_ITEM_ID);
        String parentId = jsonObject.getString(PARRENT_ID);
        TemplateItemEntity item = this.templateItemService.findDetailsById(itemId);
        if (item.getType().equals(STATIC)) {
            String dataViewCode = jsonObject.getString(DATA_VIEW_CODE);
            DataViewEntity dataView = this.dataViewService.findDetailsByCode(dataViewCode);
            Validate.notNull((Object)dataView, (String)"\u672a\u627e\u5230\u6240\u8bbe\u5b9a\u7684\u6570\u636e\u89c6\u56fe\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            String tableName = item.getTableName();
            List relation = item.getRelations().stream().filter(o -> item.getParentClassName().equals(o.getPropertyClassName())).collect(Collectors.toList());
            Validate.notEmpty(relation, (String)"\u8be5\u9759\u6001\u6a21\u578b\u660e\u7ec6\u5c5e\u6027\u7f3a\u5931\u4e0a\u5c42\u5173\u8054\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            Validate.isTrue((relation.size() == 1 ? 1 : 0) != 0, (String)"\u8be5\u9759\u6001\u6a21\u578b\u660e\u7ec6\u5c5e\u6027\u4e0a\u5c42\u5173\u8054\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
            List<JSONObject> propertySort = this.getSortProperties(jsonObject, PROPERTIES, INDEX);
            List propertyDbName = propertySort.stream().map(o -> o.getString(PROPERTY_DB_NAME)).collect(Collectors.toList());
            return this.instanceItemImportRepository.queryDynamicItems(propertyDbName, tableName, ((TemplateRelationEntity)relation.get(0)).getPropertyDbName(), parentId);
        }
        if (item.getType().equals(DYNAMIC)) {
            String tableName = item.getTableName();
            String parrentTableName = String.format("%s_id", item.getParentTableName());
            List<JSONObject> propertySort = this.getSortProperties(jsonObject, PROPERTIES, INDEX);
            List propertyDbName = propertySort.stream().map(o -> o.getString(PROPERTY_DB_NAME)).collect(Collectors.toList());
            return this.instanceItemImportRepository.queryDynamicItems(propertyDbName, tableName, parrentTableName, parentId);
        }
        return Lists.newArrayList();
    }

    private Map<Integer, String> addSeviceMethodError(Map<Integer, String> exist, List<String> errors, List<Integer> indexes) {
        if (CollectionUtils.isEmpty(indexes) || CollectionUtils.isEmpty(errors)) {
            return exist;
        }
        for (int i = 0; i < indexes.size(); ++i) {
            exist.put(indexes.get(i), errors.get(i));
        }
        return exist;
    }
}

