/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.internal;

import com.bizunited.platform.core.entity.UuidEntity;
import com.bizunited.platform.core.service.file.NebulaFileService;
import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.entity.TemplateEventEntity;
import com.bizunited.platform.kuiper.service.TemplateService;
import com.bizunited.platform.kuiper.starter.repository.TemplateEventRepository;
import com.bizunited.platform.kuiper.starter.service.KuiperToolkitService;
import com.bizunited.platform.kuiper.starter.service.TemplateEventService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="TemplateEventServiceImpl")
public class TemplateEventServiceImpl
implements TemplateEventService {
    private static final String SCRIPT_PATH = "/javascript";
    @Autowired
    private TemplateEventRepository templateEventRepository;
    @Autowired
    private TemplateService templateService;
    @Autowired
    private NebulaFileService nebulaFileService;
    @Autowired
    private KuiperToolkitService kuiperToolkitService;

    @Override
    @Transactional
    public void save(String templateId, List<TemplateEventEntity> eventEntityVos) {
        Set needDeleteKeys;
        Validate.notBlank((CharSequence)templateId, (String)"%s\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{"\u6a21\u677fid"});
        TemplateEntity template = this.templateService.findById(templateId);
        Validate.notNull((Object)template, (String)"\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        List<TemplateEventEntity> dbTemplateEvents = this.templateEventRepository.findByTemplateId(templateId);
        HashSet eventIdSet = new HashSet();
        Date now = new Date();
        if (!CollectionUtils.isEmpty(eventEntityVos)) {
            eventEntityVos.forEach(event -> {
                this.validate(eventIdSet, template, (TemplateEventEntity)event);
                int count = this.templateEventRepository.countByTemplateIdAndEventIdAndControllerId(template.getId(), event.getControllerId(), event.getEventId());
                if (StringUtils.isNotBlank((CharSequence)event.getId())) {
                    Validate.isTrue((count <= 1 ? 1 : 0) != 0, (String)"\u4e8b\u4ef6\u540d:%s , templateId\u3001controllerId\u3001eventId\u7ec4\u5408\u7f16\u53f7\u91cd\u590d,\u8bf7\u66f4\u6362!!", (Object[])new Object[]{event.getOnEvent(), 0});
                } else {
                    Validate.isTrue((count == 0 ? 1 : 0) != 0, (String)"\u4e8b\u4ef6\u540d:%s , templateId\u3001controllerId\u3001eventId\u7ec4\u5408\u7f16\u53f7\u91cd\u590d,\u8bf7\u66f4\u6362!!", (Object[])new Object[]{event.getOnEvent(), 0});
                    event.setCreateTime(now);
                }
                this.saveFile((TemplateEventEntity)event, templateId);
                this.templateEventRepository.save(event);
            });
        }
        if (!CollectionUtils.isEmpty((Collection)(needDeleteKeys = this.kuiperToolkitService.collectionDiffent(dbTemplateEvents, eventEntityVos, UuidEntity::getId)))) {
            needDeleteKeys.forEach(e -> {
                Optional<TemplateEventEntity> op = dbTemplateEvents.stream().filter(x -> StringUtils.equals((CharSequence)e, (CharSequence)x.getId())).findFirst();
                TemplateEventEntity eventEntity = op.orElse(null);
                if (eventEntity != null) {
                    this.deleteFile(eventEntity, templateId);
                }
                this.templateEventRepository.deleteById(e);
            });
        }
    }

    private void validate(Set<String> eventIdSet, TemplateEntity template, TemplateEventEntity event) {
        event.setTemplate(template);
        Validate.notBlank((CharSequence)event.getOnEvent(), (String)"\u4e8b\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{"\u63a7\u4ef6\u4e8b\u4ef6\u540d "});
        Validate.notBlank((CharSequence)event.getEventId(), (String)"\u4e8b\u4ef6\u540d: %s\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{"\u63a7\u4ef6eventid\u7f16\u53f7", event.getOnEvent()});
        Validate.isTrue((boolean)eventIdSet.add(event.getEventId()), (String)"\u4e8b\u4ef6\u540d:%s , %s\u91cd\u590d,\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{event.getOnEvent(), "\u63a7\u4ef6eventid\u7f16\u53f7"});
        Validate.notBlank((CharSequence)event.getControllerId(), (String)"\u4e8b\u4ef6\u540d\uff1a%s , %s\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{event.getOnEvent(), "\u63a7\u4ef6controllerid\u7f16\u53f7 "});
        Validate.notBlank((CharSequence)event.getControllerType(), (String)"\u4e8b\u4ef6\u540d\uff1a%s , %s\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{event.getOnEvent(), "\u63a7\u4ef6\u7c7b\u578b"});
        Validate.notBlank((CharSequence)event.getOnEvent(), (String)"\u4e8b\u4ef6\u540d:%s, %s\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{event.getOnEvent(), " \u63a7\u4ef6\u4e8b\u4ef6\u540d"});
        Validate.notBlank((CharSequence)event.getAttributeName(), (String)"\u4e8b\u4ef6\u540d:%s, %s\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{event.getOnEvent(), "\u6a21\u677f\u5c5e\u6027\u540d"});
        Validate.notNull((Object)event.getEventType(), (String)"\u4e8b\u4ef6\u540d:%s , %s \u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{event.getOnEvent(), "\u63a7\u4ef6\u4e8b\u4ef6\u7c7b\u578b"});
        Validate.notBlank((CharSequence)event.getEventDesc(), (String)"\u4e8b\u4ef6\u540d:%s , %s \u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{event.getOnEvent(), "\u63a7\u4ef6\u4e8b\u4ef6\u63cf\u8ff0"});
    }

    @Override
    public Set<TemplateEventEntity> upgrade(String templateId, List<TemplateEventEntity> templateEvents) {
        Validate.notBlank((CharSequence)templateId, (String)"\u5347\u7ea7\u65f6,\u539f\u59cb\u6307\u5b9a\u7684templateId\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        TemplateEntity template = this.templateService.findById(templateId);
        Validate.notNull((Object)template, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u6a21\u677f\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        if (templateEvents == null || templateEvents.isEmpty()) {
            return Sets.newHashSet();
        }
        LinkedHashSet<TemplateEventEntity> newTemplateEvents = new LinkedHashSet<TemplateEventEntity>();
        for (TemplateEventEntity templateEvent : templateEvents) {
            TemplateEventEntity newTemplateEvent = new TemplateEventEntity();
            newTemplateEvent.setAttributeName(templateEvent.getAttributeName());
            newTemplateEvent.setControllerId(templateEvent.getControllerId());
            newTemplateEvent.setControllerType(templateEvent.getControllerType());
            newTemplateEvent.setCreateTime(new Date());
            newTemplateEvent.setEventDesc(templateEvent.getEventDesc());
            newTemplateEvent.setEventId(templateEvent.getEventId());
            newTemplateEvent.setEventType(templateEvent.getEventType());
            newTemplateEvent.setOnEvent(templateEvent.getOnEvent());
            newTemplateEvent.setServiceName(templateEvent.getServiceName());
            newTemplateEvent.setServiceParams(templateEvent.getServiceParams());
            newTemplateEvent.setTemplate(template);
            newTemplateEvents.add(newTemplateEvent);
            this.saveFile(newTemplateEvent, templateId);
        }
        this.templateEventRepository.saveAll(newTemplateEvents);
        return newTemplateEvents;
    }

    @Override
    @Transactional
    public void deleteByTemplateId(String templateId) {
        if (StringUtils.isBlank((CharSequence)templateId)) {
            return;
        }
        this.templateEventRepository.deleteByTemplateId(templateId);
    }

    @Override
    public TemplateEventEntity findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        TemplateEventEntity event = this.templateEventRepository.findDetailById(id);
        this.readFile(event);
        return event;
    }

    @Override
    public List<TemplateEventEntity> findByTemplateId(String templateId) {
        if (StringUtils.isBlank((CharSequence)templateId)) {
            return Lists.newArrayList();
        }
        List<TemplateEventEntity> events = this.templateEventRepository.findByTemplateId(templateId);
        this.readFiles(events);
        return events;
    }

    @Override
    public Set<TemplateEventEntity> findDetailsByTemplateId(String templateId) {
        if (StringUtils.isBlank((CharSequence)templateId)) {
            return Sets.newHashSet();
        }
        Set<TemplateEventEntity> events = this.templateEventRepository.findDetailsByTemplateId(templateId);
        this.readFiles(events);
        return events;
    }

    private void saveFile(TemplateEventEntity event, String templateId) {
        if (event == null) {
            return;
        }
        String relativePath = StringUtils.join((Object[])new String[]{SCRIPT_PATH, "/", RegExUtils.replaceAll((String)templateId, (String)"-", (String)""), "/"});
        Validate.notBlank((CharSequence)event.getOnEvent(), (String)"\u4e8b\u4ef6\u540d:%s , %s\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u68c0\u67e5!", (Object[])new Object[]{event.getOnEvent(), "\u63a7\u4ef6\u4e8b\u4ef6\u540d"});
        Validate.notBlank((CharSequence)event.getControllerId(), (String)"\u4e8b\u4ef6\u540d:%s , %s\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u68c0\u67e5!", (Object[])new Object[]{event.getOnEvent(), "\u63a7\u4ef6controllerid\u7f16\u53f7"});
        byte[] fileContext = event.getJavascriptDesc().getBytes(Charset.forName("utf-8"));
        String fileRename = StringUtils.join((Object[])new String[]{event.getOnEvent(), ".txt"});
        String controllerId = RegExUtils.replaceAll((String)event.getControllerId(), (String)"-", (String)"");
        this.nebulaFileService.saveFile(relativePath + controllerId, fileRename, fileRename, fileContext);
        event.setFileName(fileRename);
        event.setRelativePath(relativePath + controllerId);
    }

    private void deleteFile(TemplateEventEntity event, String templateId) {
        if (event == null) {
            return;
        }
        String relativePath = StringUtils.join((Object[])new String[]{SCRIPT_PATH, "/", RegExUtils.replaceAll((String)templateId, (String)"-", (String)""), "/"});
        Validate.notBlank((CharSequence)event.getOnEvent(), (String)"\u4e8b\u4ef6\u540d:%s , %s\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{event.getOnEvent(), "\u63a7\u4ef6\u4e8b\u4ef6\u540d"});
        Validate.notBlank((CharSequence)event.getControllerId(), (String)"\u4e8b\u4ef6\u540d:%s , %s\u4e0d\u80fd\u4e3a\u7a7a,\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{event.getOnEvent(), "\u63a7\u4ef6controllerid\u7f16\u53f7"});
        String fileRename = StringUtils.join((Object[])new String[]{event.getOnEvent(), ".txt"});
        String controllerId = RegExUtils.replaceAll((String)event.getControllerId(), (String)"-", (String)"");
        this.nebulaFileService.deleteFile(relativePath + controllerId, fileRename, fileRename);
    }

    private void readFile(TemplateEventEntity event) {
        byte[] contexts;
        if (event == null) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)event.getRelativePath()) && StringUtils.isNotBlank((CharSequence)event.getFileName()) && (contexts = this.nebulaFileService.readFileContent(event.getRelativePath(), event.getFileName())) != null) {
            event.setJavascriptDesc(new String(contexts, Charset.forName("utf-8")));
        }
    }

    private void readFiles(Collection<TemplateEventEntity> events) {
        if (CollectionUtils.isEmpty(events)) {
            return;
        }
        for (TemplateEventEntity e : events) {
            this.readFile(e);
        }
    }
}

